# - Try to find LibCheck
# Once done this will define
#  LIBCHECK_FOUND - System has LibCheck
#  LIBCHECK_INCLUDE_DIRS - The LibCheck include directories
#  LIBCHECK_LIBRARIES - The libraries needed to use LibCheck
#  LIBCHECK_DEFINITIONS - Compiler switches required for using LibCheck

FIND_PACKAGE(PkgConfig)
INCLUDE(FindPkgConfig)
PKG_CHECK_MODULES(PC_CHECK libcheck)
PKG_CHECK_MODULES(PC_CHECK check)
SET(LIBCHECK_DEFINITIONS ${PC_LIBCHECK_CFLAGS_OTHER})
FIND_PATH(LIBCHECK_INCLUDE_DIR check.h
  HINTS ${PC_LIBCHECK_INCLUDEDIR} ${PC_LIBCHECK_INCLUDE_DIRS})

FIND_LIBRARY(LIBCHECK_LIBRARY NAMES check libcheck
  HINTS ${PC_LIBCHECK_LIBDIR} ${PC_LIBCHECK_LIBRARY_DIRS})


INCLUDE(FindPackageHandleStandardArgs)
# handle the QUIETLY and REQUIRED arguments and set LIBCHECK_FOUND to TRUE
# if all listed variables are TRUE
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LibCheck DEFAULT_MSG
                                  LIBCHECK_LIBRARY LIBCHECK_INCLUDE_DIR)
if(LIBCHECK_FOUND)
  SET(LIBCHECK_LDFLAGS ${PC_CHECK_LIBRARIES} ${PC_LIBCHECK_LIBRARIES})
  SET(LIBCHECK_LIBRARIES ${LIBCHECK_LIBRARY})
  SET(LIBCHECK_INCLUDE_DIRS ${LIBCHECK_INCLUDE_DIR})
endif(LIBCHECK_FOUND)
MARK_AS_ADVANCED(LIBCHECK_INCLUDE_DIR LIBCHECK_LIBRARY)
