// Font generated by stb_font_inl_generator.c (4/1 bpp)
//
// Following instructions show how to use the only included font, whatever it is, in
// a generic way so you can replace it with any other font by changing the include.
// To use multiple fonts, replace STB_SOMEFONT_* below with STB_FONT_arial_13_latin_ext_*,
// and separately install each font. Note that the CREATE function call has a
// totally different name; it's just 'stb_font_arial_13_latin_ext'.
//
/* // Example usage:

static stb_fontchar fontdata[STB_SOMEFONT_NUM_CHARS];

static void init(void)
{
    // optionally replace both STB_SOMEFONT_BITMAP_HEIGHT with STB_SOMEFONT_BITMAP_HEIGHT_POW2
    static unsigned char fontpixels[STB_SOMEFONT_BITMAP_HEIGHT][STB_SOMEFONT_BITMAP_WIDTH];
    STB_SOMEFONT_CREATE(fontdata, fontpixels, STB_SOMEFONT_BITMAP_HEIGHT);
    ... create texture ...
    // for best results rendering 1:1 pixels texels, use nearest-neighbor sampling
    // if allowed to scale up, use bilerp
}

// This function positions characters on integer coordinates, and assumes 1:1 texels to pixels
// Appropriate if nearest-neighbor sampling is used
static void draw_string_integer(int x, int y, char *str) // draw with top-left point x,y
{
    ... use texture ...
    ... turn on alpha blending and gamma-correct alpha blending ...
    glBegin(GL_QUADS);
    while (*str) {
        int char_codepoint = *str++;
        stb_fontchar *cd = &fontdata[char_codepoint - STB_SOMEFONT_FIRST_CHAR];
        glTexCoord2f(cd->s0, cd->t0); glVertex2i(x + cd->x0, y + cd->y0);
        glTexCoord2f(cd->s1, cd->t0); glVertex2i(x + cd->x1, y + cd->y0);
        glTexCoord2f(cd->s1, cd->t1); glVertex2i(x + cd->x1, y + cd->y1);
        glTexCoord2f(cd->s0, cd->t1); glVertex2i(x + cd->x0, y + cd->y1);
        // if bilerping, in D3D9 you'll need a half-pixel offset here for 1:1 to behave correct
        x += cd->advance_int;
    }
    glEnd();
}

// This function positions characters on float coordinates, and doesn't require 1:1 texels to pixels
// Appropriate if bilinear filtering is used
static void draw_string_float(float x, float y, char *str) // draw with top-left point x,y
{
    ... use texture ...
    ... turn on alpha blending and gamma-correct alpha blending ...
    glBegin(GL_QUADS);
    while (*str) {
        int char_codepoint = *str++;
        stb_fontchar *cd = &fontdata[char_codepoint - STB_SOMEFONT_FIRST_CHAR];
        glTexCoord2f(cd->s0f, cd->t0f); glVertex2f(x + cd->x0f, y + cd->y0f);
        glTexCoord2f(cd->s1f, cd->t0f); glVertex2f(x + cd->x1f, y + cd->y0f);
        glTexCoord2f(cd->s1f, cd->t1f); glVertex2f(x + cd->x1f, y + cd->y1f);
        glTexCoord2f(cd->s0f, cd->t1f); glVertex2f(x + cd->x0f, y + cd->y1f);
        // if bilerping, in D3D9 you'll need a half-pixel offset here for 1:1 to behave correct
        x += cd->advance;
    }
    glEnd();
}
*/

#ifndef STB_FONTCHAR__TYPEDEF
#define STB_FONTCHAR__TYPEDEF
typedef struct
{
    // coordinates if using integer positioning
    float s0,t0,s1,t1;
    signed short x0,y0,x1,y1;
    int   advance_int;
    // coordinates if using floating positioning
    float s0f,t0f,s1f,t1f;
    float x0f,y0f,x1f,y1f;
    float advance;
} stb_fontchar;
#endif

#define STB_FONT_arial_13_latin_ext_BITMAP_WIDTH         256
#define STB_FONT_arial_13_latin_ext_BITMAP_HEIGHT        120
#define STB_FONT_arial_13_latin_ext_BITMAP_HEIGHT_POW2   128

#define STB_FONT_arial_13_latin_ext_FIRST_CHAR            32
#define STB_FONT_arial_13_latin_ext_NUM_CHARS            560

#define STB_FONT_arial_13_latin_ext_LINE_SPACING           8

static unsigned int stb__arial_13_latin_ext_pixels[]={
    0x2aaaaa60,0x14c01502,0x132014c0,0x02a00d88,0x99814544,0x0a802a00,
    0x2aa20150,0x22a20001,0x15280002,0x00a206a0,0x44033008,0x0019800a,
    0x15400660,0x00cca0a8,0x2e345035,0x983ccfcc,0x00b3a206,0x5c03803d,
    0x406aa202,0x1ba881ed,0x2ea20d10,0x2a207701,0x0b395039,0x3ef016f4,
    0x4c176e00,0x2207981e,0xde981edd,0xd00b9b01,0x4076e203,0x83eb8069,
    0x80eab459,0x0f340eda,0x3089407c,0x09884541,0x98312c98,0x540ae202,
    0x54413318,0x998c5429,0x150a6a20,0x99882663,0x0998c542,0x504c422a,
    0x54c04c22,0xb80e4402,0x22015303,0x111101a8,0x7100aa60,0x07b6fa03,
    0x05b006e2,0x4164d022,0xfcb41bba,0x87881f06,0x4790f13c,0x0dedcee8,
    0x079004dc,0x5d4790f1,0x8f21e249,0x21e249ba,0x8926ea3c,0x90f13c87,
    0x88f21e27,0x440edcec,0x5c0edcec,0x2ee6f442,0x03b73b22,0x644b9bd9,
    0x6440edce,0x3660edce,0x3b2219b8,0xefe80edc,0x4d3b8f21,0x76e75c2b,
    0x03e079a1,0x1e2790f1,0x3743e8f2,0x0bf101c4,0x100790f1,0xf100790f,
    0x0f100790,0x4f21e279,0x0f63c878,0x35c3d8d7,0x3d87d0b2,0x34cd70f6,
    0x1ae1ecbb,0x3a66b87b,0x35c3d839,0x43a69878,0x20f88ea6,0x3e079a5b,
    0x89e43c40,0x41f13c87,0x37b21f9d,0x40ebb81f,0x4b33c878,0x2790f14a,
    0x43c52a59,0x8a54b33c,0x90f13c87,0x4cf21e27,0x1f31e80f,0xf116a3d0,
    0x7407cc10,0xf9ad4771,0x01f31e80,0x31f7543d,0x5983d01f,0x134b33d0,
    0x4005fc5b,0x0f103e07,0x4f21e279,0x99ecb25a,0x323a12e4,0x99e43c43,
    0x643c52a5,0x78a54b33,0xa54b33c8,0x0f13c878,0x4f21e279,0x1aa7b06a,
    0x2d45a9ec,0xb9ec1aa0,0xd83556a4,0x10f60d53,0x6c1aa9b9,0xcbb82543,
    0x261d89a2,0x81e03dfd,0x23c8780f,0x2eb53c87,0xeca88ba3,0x7869acc4,
    0x254b33c8,0xa966790f,0x2ccf21e4,0xf1e43c95,0x9e43c790,0x1a65d069,
    0x34c39174,0x89741a60,0x0d35d88e,0x2e834cba,0x26d37133,0x03c85d06,
    0x0ee68dd1,0x6cd2f544,0x81f01f07,0x25d03e2e,0x43e24bf8,0x644a9be9,
    0x07c2faad,0x4952ccba,0x2599740f,0x25d03e4a,0x40f92a59,0x45d03e2e,
    0x1f89740f,0x41f887c4,0xf88ee0f8,0x41f8a540,0x3376a0f8,0x0f883f14,
    0x50f883f1,0x3e29771d,0x07607c41,0x457344d8,0x44d0f839,0xa9360501,
    0x0fa9360f,0x726cc3b6,0x2abe2ec9,0xf526c5ca,0x364d9a21,0xb3443ea4,
    0x21f526c9,0x24d93668,0xfa9360fa,0x20fa9360,0xb89b31db,0x3b89b31d,
    0x21e886e4,0x449b31db,0x31db8ee1,0xb31db89b,0x20defc89,0xd09b31db,
    0xc9a0ec01,0x26a87e22,0x407412a6,0x441effd8,0x3661effd,0x7444eefc,
    0x116a6bdd,0x77fec41f,0x125e76c1,0xed83dffb,0x3ff624bc,0x25e76c1e,
    0x883dffb1,0x6c41effd,0xeeb81eff,0x9ddd704e,0xeec83d30,0x4eeeb82e,
    0x5c0ebbe8,0xdd704eee,0x5c0e209d,0x2e544eee,0xd5685c98,0x0effe981,
    0x0070199a,0x01001001,0x7905b008,0x01000020,0x40000800,0x00800800,
    0x98010008,0x50020001,0x08004015,0x98040080,0x5015100a,0x00a00066,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x28800000,0x88040551,0x9818440a,
    0x01aaaa82,0x1442aaa6,0x898260a0,0x03335019,0x00c40054,0x030880cc,
    0x02a0a0a6,0x102100a2,0x20d54665,0x4ccc0528,0x801a9801,0x55550131,
    0x01515055,0x2aa601a8,0xf9a4c180,0x2e6c1204,0xbd10f362,0x76667c45,
    0x3b7fea0e,0x3c40b30d,0x075571e4,0x2201d1d1,0x00ab805f,0x2cd88074,
    0x1e26bcc8,0x4133a0bb,0xaa445dda,0x9b907d72,0x403a3a20,0x1ecabdd8,
    0x3e2172e0,0xda84cccc,0x4076cc05,0x2c1edceb,0x824c0d30,0x110100a9,
    0x23d87882,0x263b9ffd,0x790f1015,0x22222a00,0x00ebb809,0x4c04ca65,
    0x2098280b,0xd9e2370e,0x50555104,0x07700130,0x15c40193,0x1d8823b0,
    0x0f103510,0xa802b260,0x707c41bb,0x4d66398b,0x80edea86,0x5cdec868,
    0x8789dc79,0x2e7ffa2d,0x83b7ba63,0x4793c878,0x0790f13b,0x0f10791d,
    0x6e6f4479,0xb8f21e25,0x04dbc41e,0x44bb9bd1,0x2eb33c87,0xcde88ee3,
    0x6e76445d,0xeec9640e,0x764458cc,0x01e20edc,0x207b73ae,0x7c2fcbdd,
    0x2b33400b,0x5e474469,0xb34c6883,0xf10e9a6b,0xfa89d999,0x43e63b9f,
    0x4f21e25b,0x43c43a69,0x869acc3c,0x0fa3c878,0x4f21e27b,0x3e24ead9,
    0xd87d02fd,0x26790f13,0x7d1dc775,0xd70f63d8,0x4be27968,0x89ae1ec6,
    0x223eeeef,0x87b16e0f,0x1efecc69,0x1a6b31d8,0x468812b3,0x99e96a3b,
    0x176abe25,0xd31dcec4,0x8f21e344,0x21e2599e,0x7d56e43c,0x89e43c42,
    0x321e2087,0x45362773,0x3c40f9cf,0x2790f104,0x89dc7759,0x203e6087,
    0xe83e911e,0x7407ccb0,0x13333f11,0x0f100bf8,0x42f54402,0x31a6b32c,
    0x1a20271b,0x9772d497,0x41363c45,0x99a63b9d,0xb8ba0746,0x321e22cb,
    0x2e5557c3,0x2d4f21e2,0x44f21e20,0xb9e2d13e,0x1e202d46,0x23baccf2,
    0x6a80b53b,0x9a2ea7b0,0x83547178,0xb300f13d,0x4c6987bf,0x1f073099,
    0x1a6b32c8,0x220ee73e,0x2ec47446,0x44788dd1,0x23b9d81f,0x4c8970f9,
    0x86e883ea,0x116a3c87,0x33c8781f,0x4790f00d,0x8f12cdd8,0x1e01a64d,
    0x23baccf2,0x6980d33b,0x87d625d0,0x1a60e8dd,0x20078974,0x89a65ea8,
    0x43f12fee,0x2b30e86a,0x0ddfa869,0x36a1a613,0x2226c4cd,0xb9d86b87,
    0x037bba63,0xb05dff91,0x22e81f09,0x07c3c82d,0x2a07c4ba,0x705d03e4,
    0x5f11e21f,0x7c9503e2,0x77599740,0x540f89dc,0x0f883f14,0x3eb7aa3a,
    0x83f1088c,0xffff10f8,0x3e0e61ff,0x98b603e0,0x2780effe,0x1910d359,
    0x188b54a8,0xc803b0ee,0x98ee7601,0x6c073005,0x03ea4d81,0x549b0320,
    0x7443720f,0x20fa9361,0x03220f24,0xb0f44372,0x1e407d49,0xe886e477,
    0x26cc76e1,0x235403a6,0x409b31db,0xd50fc429,0x07a60eb8,0xd99d40b2,
    0x82a89f33,0xbe81ffd8,0x80b930eb,0x2e7605c9,0x6cc01663,0x4417260b,
    0x7001effd,0x77fec479,0x42eeec81,0x641effd8,0x3d981ebd,0x885ddd90,
    0xea81effd,0xeec87d71,0x4eeeb82e,0xd959bb30,0x9ddd7019,0x260bd980,
    0xea80effe,0x6b882eff,0x55114cb0,0x55400008,0x33002a20,0x22198980,
    0x51066002,0x50001001,0x40000201,0x4c02a600,0x40100001,0x0006aa1a,
    0x35530008,0x4c001001,0x44000002,0x00003101,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00a80000,
    0x80cc030c,0x01411028,0x8144260a,0x40000028,0x2a600aa8,0x82980a80,
    0x54400028,0x07775400,0x05100288,0x330144c4,0x54005100,0x02002800,
    0x02a00000,0x3bb500ee,0x67440f40,0x881e2583,0x0599e44f,0x204d8091,
    0xf97bb06a,0x5dcde885,0x4c15c0f4,0x403cad85,0x260a05cd,0x79005b00,
    0x3a01ee80,0x7002d800,0x025c01d9,0x9e80f776,0x20ae202d,0x02611459,
    0x5cc02ae2,0x5418440a,0xff881e23,0x002ccf21,0x3100bb88,0x746987b0,
    0x303d1ec3,0x4454b303,0x41519888,0x3c4a21a9,0x801a81e4,0x4c22500b,
    0x35577510,0x2aaab2a0,0x50135302,0x1a880982,0x20055440,0x1e22983c,
    0xf97bb0f2,0x1edceb85,0xf10742cc,0x79357c40,0x59875566,0x85f97bb0,
    0x0f15cdec,0x74087882,0x32e6f5c1,0x43e2354b,0x4b8bea3c,0xf10790f1,
    0x885f880b,0xcc89e44f,0xdea84ecc,0xf103ccce,0x3c89f10b,0x7c405f88,
    0x4c2fc405,0xd8f21e25,0x41f134c3,0x23c2cc5b,0xa6de2078,0x41d3b33c,
    0x34c3d859,0x469aecd3,0x00b50999,0x4bb3443d,0x45d26c59,0x2d97325a,
    0x770790f1,0x075dc01d,0x03c87fe2,0x975d01d5,0x103aee00,0x5c1e43ff,
    0x3aee00eb,0x303aee00,0x89e43c4b,0x00bf8107,0x788d3166,0x64fc5e20,
    0x5987ff33,0x8ee083c4,0x7744d35a,0x3d00d32f,0x2ccb51dc,0xf116e7e2,
    0x221f3c74,0xc8e83c87,0x10f23a03,0x4c1e4d5f,0x0976a81f,0xf10f23a0,
    0x4741e4d5,0x0f23a03c,0x2cc3c8e8,0x1a6790f1,0x7ecc1333,0x3445983d,
    0x2a7881e2,0x1f3d33ce,0x331a62cc,0x25a92e13,0x1f12d80f,0x4b87a4a8,
    0xea85996a,0xb598e80e,0x3c878d13,0xb3069acc,0x536f11a6,0xe817443c,
    0x07dddf72,0x2f11a6b3,0x3598794d,0x834d660d,0x4598d359,0x44d33c87,
    0xea882fee,0x223c2cc5,0x7fb1e207,0x8b32dd66,0x4bfba269,0x2e5d88e8,
    0xdc87a60e,0x10f43d10,0x2ccbb11d,0x775902e8,0x81f0eeee,0x7d56e42e,
    0x2faadc82,0x1e4fc5e2,0x557cc136,0xc80999dc,0x5e22faad,0x6e43c9f8,
    0xadc82faa,0xaadc82fa,0x81f1662f,0x4b603e2e,0x1660f839,0xffff8836,
    0x27f11e27,0x42ccfa59,0x36a2d80f,0x7ff544cd,0x2eeec82e,0x3376a0f4,
    0x816c1664,0x39b30dca,0xf03ea4d8,0x5f0b9555,0x53c4b955,0xb02e479d,
    0xf009b99b,0x3c4b9555,0xaaf879d5,0xaaaf85ca,0xcaaaf85c,0x549b1665,
    0xe983ae0f,0x23543f11,0x5903a859,0x39101c80,0x3075c14c,0x03b8623d,
    0x905a8059,0xc98ee188,0x1ba02d80,0xdffb10dd,0x07c45a83,0xf10f88b5,
    0x01d53fd8,0xa80971a6,0x47887c45,0xf116a3fd,0x83e22d41,0x5987c45a,
    0x40f7fec4,0x4c2effea,0x3660effe,0x0d910b03,0x4d982e4c,0x3faa0f66,
    0x75df42ef,0x5406a880,0x3a1ae81e,0x07aa0ebb,0x644d80b6,0x82d80405,
    0x4f20b63c,0xfd9fc478,0x87b6ffff,0x6c7ffffb,0x88f13c82,0x8f20b63f,
    0x0b63c82d,0x0102ccf2,0x02980000,0x40151022,0x26066019,0x02aa0001,
    0x02a00544,0x02a60544,0x00000035,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x50080300,0x08406601,
    0x80000618,0x98530888,0x05100a81,0x25103118,0x22014402,0x20061100,
    0x14005401,0x405fff10,0x1528098a,0xfff90198,0x0cc02a50,0x2a500a60,
    0x200a8a80,0x20fc098a,0x6cc86dd9,0xbc81dd98,0x7c1dd985,0x25de41e8,
    0x7443b762,0x0d9907a0,0xdca8133a,0xb807bb00,0xd882dc03,0x07e1e43c,
    0x025c03b8,0xdb5006a2,0x03a176e0,0x6dc144c4,0x403bd304,0x826dc01e,
    0x2f5405db,0x09815064,0xbba826a6,0x540b82cb,0x2a62aaaa,0x15dddd41,
    0x0b82e054,0x8a822351,0x02a01330,0x2a04e5d4,0x7550cc10,0x22020559,
    0x1abcaa88,0x50ab2aaa,0xc8855595,0x2e00edce,0x01503201,0x55324dd4,
    0x222a5579,0x2aa19888,0xcaa881ac,0x2b2aa1ab,0x55795501,0x644f8874,
    0x99f10743,0x441d0999,0x744ccccf,0x33333e20,0xd0740e84,0xc8781661,
    0xf885f883,0x1aa3fdcc,0x333e21f1,0x6775c4cc,0x333226a0,0x999f14ec,
    0x6667c499,0x1ae1ec4c,0x41d02fc4,0x99700078,0x11aa799f,0x3333e21f,
    0x333220ee,0x999f14ec,0x667c41dd,0x7c43a4cc,0x41d0f21f,0x441d0078,
    0x1e20e807,0xe83a0740,0x21e02b30,0x40ebb83c,0x9b0f4478,0x880f1174,
    0xa82b8ee6,0x7880f10e,0x0f407cc0,0x0e8075dc,0x2a5981e2,0x24d80f84,
    0x0f61e22e,0xb0f10ea8,0x43a03c47,0xd0f26af8,0x0e803c41,0x883a01e2,
    0x0e81d007,0x7f674c3a,0x3a0f21e1,0x643c43c8,0x116e7e24,0x9a24a80f,
    0xf10fcc3b,0x35407880,0x3c8e83d8,0x303c41d0,0x407c254b,0x3c45b9f8,
    0x21f9816c,0x1e22d878,0xa6de21d0,0xdf10743c,0x41d07ddd,0x43eeeef8,
    0x3bbbe20e,0x0740e83e,0x25c3e61d,0x87ffffff,0x8788d359,0x2077545a,
    0x23eeeef8,0x23c9e24b,0x777c42e8,0x3bbe23ee,0x741a63ee,0xd069acc2,
    0x4b303c41,0xd500f84a,0xcccf881d,0x885d104e,0x444ecccf,0x3a3eeeef,
    0x327e2f10,0x33f10743,0x441d0133,0x7409999f,0x26667e20,0xd0740e80,
    0x1e4a9a61,0xf55b90f2,0x42dc3c45,0x999f882e,0x2dc3a209,0x7c426c99,
    0x3e209999,0x3e209999,0x37207c41,0x20e82faa,0x4a966078,0x20ba00f8,
    0x205daaf8,0xdaaf884d,0x9999f885,0xd53c43a0,0x1e20e879,0x00f10740,
    0xe803c41d,0x261d0740,0x3c8792a5,0x12e5557c,0x05b0790f,0xbdd500f1,
    0x105ca641,0xb807880f,0x5f09b31d,0x41d0b955,0x4d9a2078,0x20b600f8,
    0x2e426c78,0x2226c788,0x47887407,0xf10743fd,0x07883a00,0x401e20e8,
    0x21d0740e,0xc8792a59,0x21f116a3,0x6c07d478,0x40007882,0xf100ea88,
    0xd7007880,0x88b509dd,0x0f10740f,0xf84bced8,0x1e20b600,0x807543f1,
    0xf10fc478,0x88f10e80,0xff10743f,0x0e81ffff,0x3fffffe2,0xfff883a0,
    0x20740fff,0x52cc3a0e,0x5b1e43c9,0x3ffe2790,0x105b01df,0x01ffffff,
    0xfffffd80,0xffffff16,0x3ffffe21,0x16c0100f,0xf883a1e4,0xf8007fff,
    0x1e20b600,0xffffd9ae,0x4d70f16f,0x0ffffff8,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x054054c4,0x04c0a266,0x840a2000,0x54308800,0x4414c280,0x0198a830,
    0x81f76c01,0x18000a8a,0x9943ddd1,0x0203301a,0xa881a9a8,0x22000400,
    0x03088182,0x4c554402,0xeeb82aaa,0x4000c405,0x42540dca,0x2cb41de8,
    0x741623d4,0x22eed44c,0x07479b06,0xb01571e2,0x40ee9879,0x1500ceda,
    0x5996b6a0,0x3932c12a,0x2fe6e7c1,0xde8877a6,0x0747444e,0xb307afa2,
    0x87983db9,0x6c0ae5ae,0x3fb3663c,0x37b33a61,0x55544ccd,0xedc982aa,
    0x540ddb31,0x3100983c,0x83102af0,0x01888868,0x074081e0,0x0c0311e2,
    0x773440a8,0x0420bf10,0x5884a966,0x5d0fe074,0x495044c4,0x54044444,
    0x70f98795,0x1b498309,0x0f981016,0x5f51e497,0x33333e20,0x0f992a04,
    0x444deec8,0x6fdc4ede,0x3ee17f25,0xf717f65d,0x2952ccbb,0x4a9666fc,
    0x4b37881d,0x47f7b24a,0x3aa4ede8,0xebb86ccc,0x26952cc0,0xd0aa12a5,
    0x8a640f81,0x37a24ede,0x06775c0b,0xd303b3e2,0x19db5254,0x502bad62,
    0xa9a619db,0x440be1a5,0x4deec807,0x4d9a61a6,0x734c9254,0x5734c3c5,
    0x95cd31a2,0x4c792a59,0x220752a5,0x49a54b37,0x5492552e,0x8e81999d,
    0x2952cc3c,0x03612a59,0x55a8781d,0x87e4c249,0xfd10ee68,0x8a54b303,
    0x8adb8ee6,0x99dcd105,0x6c3c56a6,0x01e24eee,0x0b326cd3,0x3a225c97,
    0x7812e0bd,0x47f904b8,0x254b304b,0x752a598f,0x2a59bc40,0x453b2a24,
    0x43a20bde,0x469acc4a,0xb3452a59,0x781d0b09,0x17bd14a8,0x92a3d254,
    0x3ae7a268,0x54a9664a,0x2e0d999d,0x9d50dda9,0x5a9a6d99,0x1337d0f1,
    0x1f7777c4,0x0b325c97,0xc9825497,0xf044950f,0x68844950,0x96611254,
    0x54b31e4a,0x5a2131d4,0x5f4d2a59,0x07e4c4a9,0xdc81bdb5,0xa9662faa,
    0x312f3b24,0xb8781d09,0xdb07e4c2,0x4f125c9d,0x598ff65a,0x4cced52a,
    0x751b5881,0x4c66676a,0x221e96a6,0x333f102f,0x49525c13,0x13669859,
    0x0e88f495,0x87443c59,0x0e88d12c,0x24d9a259,0x3a9b3447,0x9a2b55a8,
    0xaaec974d,0x7c1207a4,0x9a25caaa,0x1b85504d,0x3a23c0e8,0x320f4950,
    0x25b87442,0x309f70e8,0x4a874419,0x44ead1c8,0x92a0950e,0x205f90dc,
    0x9b34c078,0xcdeb83a8,0x544eed84,0x543ec4ee,0x2a3744ee,0x5e76c4ee,
    0x79db1f64,0x3ff623a9,0x452f3b61,0x3b66bdde,0x5435d04e,0x9db07c45,
    0x58f6a097,0xdf1781d0,0x444eed85,0x0deea85b,0x0f4ef75c,0xbdb50baa,
    0x372e5881,0x2037b6a0,0x67fe43d9,0xf11ffffc,0x899bd700,0x000000fb,
    0x00000000,0x00000000,0x42980002,0x0003c82d,0x00e80435,0x000c4000,
    0x0006a000,0x20001026,0x7c400019,0x000fffff,0x00000151,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x2a600000,0x30513100,
    0x0540cc05,0x44c40988,0x14c02102,0x00540660,0x941882a2,0x30503100,
    0x10a18131,0x051310a5,0x540cc053,0x26620200,0x98829809,0x53010828,
    0x80540cc0,0x289880a9,0x513102a0,0xfcde8854,0x4449ba85,0x80e882de,
    0x0edeb859,0x32e12726,0x02de885d,0x8825c03a,0x4a8edcec,0x66e4275c,
    0x7790f10e,0xbb093687,0x4449b987,0x701d02de,0xc8bbf707,0x09b83eee,
    0x32e24dd4,0x416f445d,0xc85a80e8,0x2de80ebd,0x8b7a0b30,0x04c8991f,
    0x04404220,0x0ee78810,0x22201002,0x03006008,0x451b50f2,0x92c45ab9,
    0x26f21e25,0x441d5621,0x22220202,0x260c0100,0x400e8ae6,0x80802038,
    0x01880988,0x41643e0a,0x44022018,0x79808fc0,0x4b34a966,0x9a54b34a,
    0xb32d52a5,0x2e06775c,0x775c0cee,0x06775c0c,0x1f033bae,0xfeda89d0,
    0x43c47a02,0x3bbb61dc,0x3f7b21ef,0xa833b6a1,0x3b6a0ced,0x433b6a0c,
    0x02a7e04b,0xec87f7b2,0x3f7b21fd,0xc87f7b21,0x37b21fde,0x21a2d11f,
    0x7dc0ceeb,0xf4a9665d,0xdddddd53,0x34a9661f,0x2a59a54b,0x4ba54b34,
    0x477345a2,0x2688ee68,0x23b9a23b,0x0698ee68,0x5c87447b,0x21e25fa8,
    0x98d2b83c,0x773452e4,0x4d13b9a2,0xa9dcd13b,0x5e7cc224,0x34b9262e,
    0x2e49a5c9,0x49a5c934,0x29724d2e,0x26889768,0x32b9a63b,0xe98ea54b,
    0x26799999,0x952cd2a5,0x4b34a966,0xab44974a,0x224a9a24,0x2a6892a6,
    0x224a9a24,0x51741a66,0x4c8834c9,0x5b10f21e,0x654413d3,0xd999d54e,
    0x55b333aa,0x9d56ccce,0x643a2d99,0x5445a822,0x3b2a24ec,0x893b2a24,
    0x32a24eca,0x53b2a24e,0x2547d168,0x59825cd1,0x40f86d2a,0x34a9665a,
    0x2a59a54b,0x4aa54b34,0x4f125d66,0x24b9e24b,0x27892e78,0x1f89e24b,
    0x4c9707c4,0x3e698226,0x3bf61740,0x37d31eee,0x26676a95,0x23333b51,
    0xb51999da,0x77543333,0x26688224,0x7d34a9be,0x26fa6953,0x9537d34a,
    0x4d2a6fa6,0x4d14a9be,0x3c4973d8,0x25984495,0x986e4b4a,0x14d9a23e,
    0x3668a6cd,0xe8a6cd14,0x5c3a2790,0x12dc3a25,0x0e896e1d,0x5b8744b7,
    0x44d98edc,0x2688f269,0x0fa9363c,0x25c2bac4,0xa543a2bb,0x3a2950e8,
    0x543a2950,0xc9a225c4,0x975d92e4,0x5764baec,0xb25d764b,0xd15d92eb,
    0x87452a51,0x9643a25b,0x320d3668,0xced83fef,0x92f3b64b,0x3b64bced,
    0x13b6a4bc,0xea81bdd5,0x6f7540de,0x206f7540,0xeb80deea,0x9db504ee,
    0x20ceeb81,0x981effd8,0xdde88394,0x837b6a6b,0x36a0deda,0x37b6a0de,
    0x3ae1ae20,0x377a20be,0xd7bbd16b,0x45af77a2,0xbd16bdde,0x377a2d7b,
    0x3bb6d16b,0x5037baa0,0xbced89dd,0x000103f4,0x00000000,0x00000000,
    0x00000100,0x01088020,0x00000004,0x04000300,0x01004010,0x00001004,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x19800000,0x00101440,0x06062553,0x54c0a2a2,
    0x402aa200,0x18802018,0x20601510,0x03100009,0x20510153,0x28054c02,
    0x0554c098,0xa8803530,0x20614401,0x00000009,0x00981a80,0x41e400e8,
    0xe881fdec,0x2a0dedce,0x16f40ecd,0x217737a2,0x642fcbdd,0xbdd30ece,
    0x0ecdc81d,0xd98baf6e,0x6f642c45,0x6cc9505c,0x82cc5b9b,0xb9bd980d,
    0x71e43c45,0xe883db9d,0x6440edce,0xd100edce,0x88b11766,0xcdec9666,
    0x7c1dc794,0xb1165540,0x28021080,0xd09724c1,0x43a26e87,0x1f40c43a,
    0x34c3d8f6,0x0f9a5cd1,0x4793c4b7,0x2c44930e,0x2ecd3076,0x2eab34a8,
    0x20566599,0x554ecc2b,0x321e2598,0x22dc1f13,0x0f635c3e,0x445a20d7,
    0x99a206c5,0x69a6cd35,0x74c0603a,0x6f6c0760,0x6cc5efce,0x32a20eed,
    0x3b07c44e,0x20a32a3f,0x0f10ceda,0x2a083c41,0xd134d664,0x3e25b1f8,
    0x83a96200,0xeec96a3b,0x9177194d,0x3b7a6371,0xc8c8910e,0x1e23759a,
    0x300bf8f2,0x3e61f01f,0x26881e80,0x9e20ae58,0xd25c9759,0x461e0b33,
    0x9260754a,0x91d8ee6c,0x2a6fa61f,0x36592d44,0x23d9dd73,0x02d4ee68,
    0x213331a6,0x334db268,0x2e5ffa8d,0x229104df,0x9ad49705,0x985ad366,
    0x696e1f33,0x734bbcac,0xd98f21e2,0xd82d43df,0x20f60d52,0x824d2268,
    0x52556678,0x54165dc9,0x589dd986,0x67765440,0x2aed15dc,0x22ec972d,
    0xb974775a,0x667552a6,0x6980d36c,0xeb8bfba2,0x2e1f36ce,0x53227a24,
    0x0d801cc8,0x6c4744f3,0x95a5c975,0x26994c4c,0x59587278,0xc878a619,
    0x2a5ea883,0x41a65d06,0x5886882e,0x47e23b97,0x9361d15b,0x00e986e8,
    0xe98f30d8,0x0999cb9b,0x443a93d3,0x7c46bdde,0x2d43e24b,0x26676ad3,
    0x24a81f11,0xb302d80f,0xb837bba6,0x802d9a64,0xda8db12b,0xa54974cd,
    0x195bd99b,0x8ea699a6,0x19588c9b,0x1ccba07c,0x4c0f887c,0xf883f10f,
    0x321a6130,0x77c4b211,0x37baa5de,0x007426c4,0x5c6d895c,0x3e3b9ba4,
    0x0e210d15,0x126cc3b6,0x87452e1d,0x7443724a,0x1e983ae1,0x059964d1,
    0x3d34b9a2,0x3afa4980,0x699dc311,0x7086c536,0x23b8fcc7,0xb8876258,
    0x21f526c3,0xb91aa1f8,0xdb89dd33,0xaa549b31,0x88f21d45,0x6c4a8016,
    0x81f10e81,0x887afa49,0xdeebaede,0x807bbb60,0xf9b30ce8,0xbdb309dd,
    0x206f6d41,0xea82eeec,0x6f5c2eff,0xdb701664,0x3bb3761b,0x3aaa2c47,
    0xb83aefa1,0x37224cde,0x7674c2dc,0x37222c0c,0xffd882dc,0x77ff4c1e,
    0xddeeeb80,0x227775c0,0x1621ffd8,0x01a239d9,0x705c9a54,0x45887d7d,
    0x20001eaa,0x10044001,0x00000000,0x000a2000,0x08044040,0x00000aa8,
    0x80000800,0x4c100000,0x13000101,0x00a09998,0x200a88c4,0x100880a8,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x505100a2,0xdd501355,0x8145441d,0x0a20a81a,
    0x55540288,0x10142aaa,0x41514135,0x088c2899,0x55553082,0x8280a255,
    0x22f75c09,0x05106eea,0x5502a054,0x80420135,0x2000a80a,0x89986eea,
    0x528854c1,0x33144028,0x22cc0598,0x03fdccf8,0x220b7601,0x1e22cc0e,
    0x37aa0598,0x1e23ccce,0x4f12cd98,0x9077a21e,0x8f6f44b9,0x93ccfccb,
    0x790f079f,0x3a200020,0x34c9703c,0x0ff733e2,0x0970dbb3,0x03d81d97,
    0x10f74402,0x11eec17f,0x1a23c80f,0x22cc0871,0xd90fc478,0x101883fb,
    0x37881103,0x5d740b30,0xd981e204,0x2064f10a,0xf0001018,0x6c19ea81,
    0x0efeeeef,0x2cc33b6a,0x40308895,0x47885b0e,0x010081f8,0x20220446,
    0x0880ceeb,0x220c434c,0x020bcccf,0x1f6df402,0x5c3c43b3,0xd9a5c934,
    0xb9b31edc,0x89bb663d,0x505983cf,0x078812ed,0x20cf1166,0x80e86ed9,
    0xe981f00e,0x321e0eec,0xb33b9a23,0x4d71ea54,0x434ed40e,0x9b34b878,
    0x3bbaa3db,0xdd50742f,0x3b9a25fd,0x4cbfbbaa,0x57c45985,0xd03a6caa,
    0x99e27d01,0x4333f21f,0x53b2a25a,0x3e6970f9,0x303e6970,0x1276605f,
    0x3bbbee5d,0x261d9e23,0x1f303c45,0x503a03a0,0x87cc57f5,0x3ffffe3b,
    0x3333aa3f,0x3ba54b36,0x988d11db,0x67e41bee,0x43e6b50c,0x0e84c84b,
    0xd1254990,0x98599320,0xe87c3c45,0xf0f40740,0x867e62f4,0x9537d34b,
    0x4d34a9a6,0x0fd0d34a,0x5f3146cc,0x41333b95,0x45982a78,0xe81a6078,
    0x7d540e80,0x24a9a62b,0x276a3c87,0xa54b3199,0x87559d59,0x4c4cedca,
    0x34d2e19f,0x1d05b895,0x224b8b70,0x42cc5b87,0x9e23c459,0x0740740e,
    0x21e22d4f,0x9aec973c,0x952cd2a5,0x981ea166,0x4dccdd85,0x45981e20,
    0xe8166078,0x81f00e80,0xc8792a59,0x8a543a23,0x9cae9366,0x76e541dc,
    0x9e43c44c,0x0ea92a59,0x40ea81d0,0xea8b70e8,0x22cc2cc0,0x23edccf8,
    0x0740740e,0x51e22ccf,0x2f77a21d,0x59a54b36,0x3c42cd2a,0x5c698b30,
    0x5981e204,0x40b303c4,0x1f00e80e,0x8792a598,0x06f6d43c,0x764979db,
    0xb5310dd2,0x75478833,0xe9a54b30,0x0e983a00,0x4c1bdd50,0x5985980e,
    0x740d57c4,0xf0740740,0x3ffe22cc,0x598081df,0x2952cd2a,0xffff8859,
    0xb87b1667,0x3e27ffff,0x11667fff,0x2ccfffff,0x201d01d0,0x4952cc0f,
    0x00003c87,0x981361f3,0xbffff105,0x36952cc3,0x0743eeee,0x007ddddb,
    0x4cfbbbb6,0x03c45985,0x0001d03a,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x2a500000,0x3102a0a0,
    0x2a014280,0x5542aaaa,0x206a1aaa,0x026aaa29,0x8944260a,0x12884402,
    0x1a882a05,0x23555551,0x2aa1980a,0x0530009a,0xaaa980a8,0x2aaaa2aa,
    0x21980a81,0x82809aaa,0x05441509,0x42a0a651,0x31199998,0x10103333,
    0x391b5ddd,0xdc8bb1e2,0x225c81ec,0x3333e207,0x66667c4c,0x2df0bf12,
    0x41fdccf8,0x26b33c87,0xa44ba205,0x6741d059,0x9d999911,0x221f11aa,
    0x7c4fcccf,0x207af361,0xfccb85f8,0x999f13cc,0x6c1e41dd,0x7fb99f12,
    0x64f227c4,0x14b8bea3,0xdd53545d,0x88402ddd,0x88004ede,0x54d31367,
    0x0f12f544,0x103c03c4,0x8b74c1df,0x321e25c7,0x54166b33,0x815982ee,
    0x1d501e0e,0x3c45d26c,0x9a6183e2,0x00ebb85a,0x7b0f103e,0x789e234c,
    0x1ff88f44,0xb992d4f2,0xd11f316c,0x1008f401,0x20e8492a,0x826de20e,
    0x59e896a0,0x807881e2,0xc8efe207,0x43c8f16b,0x26b33c87,0x362a1d55,
    0x3b3a6b32,0x3bf61d1f,0x7c41f980,0x223c45b9,0xd0b5000f,0x207c0791,
    0x0f42d878,0xa643c497,0x44f26af8,0x40f9e3a7,0x92e02edc,0x2f7a2100,
    0x883a0e80,0x74402fdf,0x78966761,0x3bbbbe20,0x12f777c3,0x8b4f4b3f,
    0xff86eeef,0x2b33ffff,0x2d80e9d9,0xa5c3e6b3,0x17441e0e,0x7c40eea8,
    0x5005dbaa,0x0d35981d,0x333e207c,0x3a4b84ec,0x456a1e20,0x8e8f29b7,
    0x20d13b59,0x083e205e,0x40fc9810,0xcf883a0e,0x45d100f9,0x03c4b33b,
    0x813333f1,0x5e21999f,0xf169ba8e,0x878b9333,0x3fe6b33c,0x4d665b03,
    0x0f0752a6,0x105d0136,0x0303799f,0x55b901d1,0xf103e05f,0x5e20bb55,
    0xadc3c459,0x4793f178,0x77773bac,0x2e03fd50,0x49508044,0x41d0741e,
    0x3a61ae78,0xb7ffff42,0x201e2078,0x65dde207,0x788f1699,0x3599e43c,
    0x25b01f3d,0xea54b359,0x201721e0,0xf807882d,0xaaf82cc1,0x881f05ca,
    0xcad826c7,0x89e43c42,0xca8f3aa7,0x8839b30d,0x83d06b9f,0x2776c100,
    0x3c41d074,0x401e8936,0x7881e259,0x45e20780,0x71e2d36e,0xb33c878d,
    0x96c2dd66,0xea54b359,0x001d51e0,0x700f105b,0x45a80881,0x440f80f8,
    0x6540fc47,0x87d47886,0x3a1fec78,0xb1ec3746,0x33330f09,0x07400333,
    0x3e23c41d,0x0dffff72,0x7fffc4b3,0x3ffffe27,0x27881e0f,0x3fe2d33e,
    0x643c1dff,0x3e966b33,0x4b35996c,0x363c1d4a,0xd86fffff,0x82807882,
    0x3c82d85a,0x5c3c40f8,0xff109d06,0x23c43bff,0x3226c3f8,0x8be22e45,
    0x00000069,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x02010801,0x00102008,0x00804100,
    0x80000102,0x00100049,0x00222202,0x00004002,0x400b9815,0x7064c028,
    0x4450580e,0x09353731,0x20cc3315,0x206a1819,0x33bae081,0x0776ecc0,
    0xdec8bbf7,0x27bbae1f,0xa9662ded,0x33bae3cc,0x33b6a1e8,0x3f3b7b60,
    0x94a9665e,0x51261dc5,0x6ec47a2d,0xb12ec9ee,0x3baa3db9,0x4ddb31fe,
    0xf874d71d,0x743aab30,0x3ae0fe20,0x2a09301d,0x255642dd,0x7d199068,
    0x2217def4,0x4eeea1d5,0x29b14bca,0x59532caa,0x0ee688f8,0x34c3f23b,
    0x34b92657,0x268fee1d,0x44a72a59,0x3442b2e6,0x26c92677,0x9a54b33b,
    0x776d43a5,0x88b6f25d,0x4562bb0f,0x4970970f,0xed9dc0f9,0x9d982688,
    0x6ab83a0e,0x6543b660,0x19d34ccc,0x44763a20,0x640ccfcc,0xe877343f,
    0x191c82c9,0x1d324456,0x5170bb22,0x2ed13449,0x440972da,0x44954eca,
    0xb32eccdf,0x449516d4,0x3333aa1f,0x33bb2a26,0x254b35dc,0x54c4b31d,
    0x117a219d,0x9a2f164d,0x1a62d44a,0x1d55f566,0x0742ff98,0x3ae20aed,
    0x4aaaaa64,0x23a02ed8,0x55d7511d,0x9344ee88,0x6c2c9e85,0x48962ae1,
    0x42ad8ea3,0xd33c4972,0x12543a93,0x52a6fa61,0x266be24a,0x2254b309,
    0x3b51e24b,0x26fa6333,0xb30999cb,0x05977254,0x88dd1093,0x4b178b25,
    0xb303a649,0x372727a0,0x41d3d301,0x89a2950e,0x0b500bec,0x55713b22,
    0xc9ec1a09,0x87fbdd14,0x37b268d9,0xa4419713,0x22001dc9,0x15f8b70e,
    0x72c8744d,0x70e8aec9,0x0f88749f,0xb70e889b,0x2e950e88,0xd13b9ba4,
    0x20dd126c,0x24b9e828,0xb178b258,0x980e8a4c,0x1ba5d905,0x3a5bacc1,
    0x88029800,0x1ce0b800,0x22102090,0x31505089,0x00000003,0x3606f754,
    0x77541eee,0x9af77a24,0xeed9eeea,0x425e7ec3,0xda80deea,0x5dbd10de,
    0x76c1bdd7,0x2e2744bc,0x4976ffff,0xf164b12e,0xdfb49962,0x541667dd,
    0x30f89b0f,0x000e96cb,0x00000000,0x00000000,0x00000000,0x00080003,
    0x00000000,0x00000000,0x00000000,0x20000000,0x3bba60a9,0x211310ee,
    0x20eeeee9,0x44620428,0xc8800542,0x192ccccc,0x4c4c6eea,0x55554411,
    0x000001aa,0x00000000,0x00000000,0x00000000,0x00000000,0x93730000,
    0x50e88888,0x44444779,0x4591ce40,0x3254764b,0x443759fb,0x17088888,
    0x555c6ee6,0x555541f2,0x000001aa,0x00000000,0x00000000,0x00000000,
    0x00000000,0xd9910000,0x77950d80,0x88aaaaa2,0x4a9aa293,0x5cc4c084,
    0x000000cd,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x4ce40000,0x99885c06,0x19999911,0x20a885d4,0x00000018,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x40000000,0x00004ac9,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
    0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,
};

static signed short stb__arial_13_latin_ext_x[560]={ 0,1,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,1,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,
-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,-1,
1,0,0,0,0,0,0,0,0,-1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,-1,-1,-1,-1,
-1,-1,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-1,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,0,0,-1,0,0,0,0,0,0,
-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,1,1,1,
1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,0,-1,-1,0,
0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,-1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1, };
static signed short stb__arial_13_latin_ext_y[560]={ 10,1,1,1,0,1,1,1,1,1,1,3,8,6,
8,1,1,1,1,1,1,1,1,1,1,1,3,3,3,4,3,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,11,1,3,1,3,1,3,1,3,1,1,
1,1,1,3,3,3,3,3,3,3,1,3,3,3,3,3,3,1,1,1,4,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,10,3,1,1,3,1,
1,1,1,1,1,4,4,6,1,0,1,3,1,1,1,3,1,5,9,1,1,4,1,1,1,3,-1,-1,-1,-1,
-1,-1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,-1,-1,-1,-1,-1,-1,3,1,-1,-1,-1,-1,-1,1,1,1,1,
1,1,1,1,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,1,1,1,1,1,1,1,
0,2,-1,1,1,3,-1,1,-1,1,-1,1,-1,1,-1,1,1,1,0,2,-1,1,-1,1,1,3,-1,1,-1,1,
-1,1,-1,1,1,1,-1,-1,1,1,-1,1,0,2,-1,1,1,1,-1,3,1,1,-1,1,1,1,3,-1,-1,1,
1,1,1,1,1,1,1,-1,1,1,3,-1,1,1,1,3,0,2,-1,1,-1,1,1,3,-1,1,1,3,-1,1,
-1,1,-1,1,1,3,-1,1,1,1,-1,1,1,1,-1,1,0,2,-1,1,-1,1,-1,1,1,3,-1,1,-1,1,
-1,-1,1,-1,1,-1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,1,2,2,2,
2,2,2,2,2,2,2,2,2,2,1,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,3,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,-1,1,-1,1,-1,
1,-1,1,-1,0,-1,-1,-1,-1,-1,-1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,-2,-1,-1,1,-1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2, };
static unsigned short stb__arial_13_latin_ext_w[560]={ 0,2,4,7,6,10,8,2,4,4,5,7,3,4,
2,4,6,4,6,6,6,7,6,6,6,6,2,3,7,7,7,6,12,9,8,8,8,8,7,9,8,2,5,8,
7,9,8,9,8,9,9,8,7,8,8,11,8,8,7,4,4,3,6,8,3,6,6,6,6,6,4,6,6,2,
3,6,2,9,6,7,7,6,5,6,4,6,6,9,6,6,6,4,1,4,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,2,6,7,7,8,
1,6,4,9,5,6,7,4,9,8,4,6,4,4,3,6,7,2,4,3,4,6,10,10,10,7,9,9,9,9,
9,9,12,8,8,8,8,8,3,3,5,4,9,8,9,9,9,9,9,6,9,8,8,8,8,8,8,7,6,6,
6,6,6,6,10,6,6,6,6,6,3,3,5,4,7,6,7,7,7,7,7,6,7,6,6,6,6,6,7,6,
9,6,9,6,10,8,8,6,8,6,8,6,8,6,8,8,9,7,8,6,8,6,8,6,8,6,8,6,9,6,
9,6,9,6,9,6,8,6,9,6,5,5,5,5,5,5,4,4,2,2,7,5,7,5,8,6,6,7,3,7,
4,7,4,7,4,7,3,8,6,8,6,8,6,8,8,6,9,7,9,7,9,7,12,11,9,5,9,5,9,5,
8,6,8,6,8,6,8,6,7,4,7,5,7,4,8,6,8,6,8,6,8,6,8,6,8,8,11,9,8,6,
8,7,6,7,6,7,6,4,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,10,8,7,7,7,7,7,7,7,7,7,7,7,7,7,10,8,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,9,6,5,5,9,
7,8,6,8,6,8,6,8,6,8,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,9,6,12,10,9,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7, };
static unsigned short stb__arial_13_latin_ext_h[560]={ 0,9,4,10,12,10,10,4,12,12,5,6,4,2,
2,10,10,9,9,10,9,10,10,9,10,10,7,9,6,4,6,9,12,9,9,10,9,9,9,10,9,9,10,9,
9,9,9,10,9,10,9,10,9,10,9,9,9,9,9,12,10,12,6,2,3,8,10,8,10,8,9,10,9,9,
12,9,9,7,7,8,10,10,7,8,10,8,7,7,7,10,7,12,12,12,3,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,10,12,10,6,9,
12,12,2,10,5,6,4,2,10,2,4,7,5,5,3,10,12,2,4,5,5,6,10,10,10,10,11,11,11,11,
11,11,9,12,11,11,11,11,11,11,11,11,9,11,12,12,12,12,12,6,10,12,12,12,12,11,9,10,10,10,
10,10,10,10,8,10,10,10,10,10,9,9,9,9,10,9,10,10,10,10,10,6,8,10,10,10,10,12,12,12,
10,9,11,10,12,10,12,10,12,10,12,10,12,10,11,10,9,10,10,9,11,10,11,10,12,10,11,10,12,12,
12,12,12,12,12,12,11,11,9,9,11,9,10,8,11,9,12,12,11,7,10,12,12,12,12,12,7,11,11,12,
12,9,9,9,9,9,9,11,9,12,10,11,9,9,10,10,11,9,12,10,12,10,10,8,11,9,12,10,11,9,
12,10,12,10,12,10,12,10,13,13,11,10,9,10,12,10,11,9,12,10,12,10,12,10,12,10,11,9,11,12,
11,11,9,11,9,11,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,8,8,12,8,8,8,
8,8,8,8,8,8,8,8,8,8,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,10,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,11,10,11,9,12,
10,12,10,12,11,12,12,12,12,12,12,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,12,12,11,10,12,10,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8, };
static unsigned short stb__arial_13_latin_ext_s[560]={ 255,253,174,123,205,61,38,197,35,251,246,
197,252,228,238,251,39,92,15,105,22,173,39,228,87,72,147,141,182,179,167,
145,191,152,64,53,189,37,46,62,73,107,197,6,29,54,198,187,132,177,170,
168,162,159,180,207,219,123,115,5,144,168,160,241,200,24,137,17,120,61,110,
113,100,97,1,85,82,107,117,1,79,221,131,243,177,79,86,137,100,228,124,
154,237,239,208,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,255,253,10,
94,212,165,253,128,233,127,160,220,166,228,149,216,187,93,227,241,204,214,49,
225,192,237,232,190,102,203,243,235,152,162,202,221,231,241,64,96,9,18,140,
169,184,188,134,164,174,125,212,195,185,168,134,205,29,1,14,23,116,227,237,
223,216,209,202,195,188,181,68,166,159,152,145,138,250,246,198,1,97,184,78,
70,62,54,46,175,9,32,25,18,11,230,57,74,225,24,208,204,90,20,110,
239,144,163,159,151,172,138,218,122,14,108,99,141,155,72,236,54,214,218,113,
46,232,178,10,25,69,79,86,110,199,192,131,124,178,110,1,250,149,104,105,
64,122,157,189,162,17,29,135,57,150,53,251,40,117,90,85,77,59,51,10,
212,38,48,47,172,31,1,7,79,27,211,204,245,181,30,86,31,85,45,39,
116,103,98,20,131,244,16,242,23,223,211,6,1,68,145,116,158,153,170,143,
148,119,182,101,197,81,235,65,242,131,155,76,32,122,181,191,1,204,95,219,
226,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,1,235,235,222,
235,235,235,235,235,235,235,235,235,235,235,235,235,86,52,235,235,235,235,235,
235,235,235,235,235,235,235,235,112,43,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,37,131,
47,231,144,231,125,246,107,61,91,84,75,68,59,100,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,49,42,189,1,32,12,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,235,
235,235,235,235,235,235,235,235,235, };
static unsigned short stb__arial_13_latin_ext_t[560]={ 1,64,113,64,1,53,53,113,28,15,106,
106,106,113,113,52,64,96,96,64,96,64,75,96,75,75,106,96,106,113,106,
96,15,96,96,75,96,96,96,75,96,96,75,96,96,96,96,75,96,75,96,
75,96,75,96,96,96,96,96,15,75,15,106,113,113,106,75,106,75,106,96,
75,96,96,15,96,96,106,106,106,75,75,106,96,52,106,106,106,106,75,106,
1,1,1,113,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,1,40,15,
75,106,86,1,15,113,75,113,106,113,113,75,113,113,106,106,106,113,75,15,
113,113,106,106,106,75,75,75,75,28,28,28,28,28,28,86,28,41,41,40,
40,40,40,40,40,86,40,1,1,1,1,1,106,75,28,1,1,1,40,86,
64,64,64,64,64,64,64,106,64,64,64,64,64,86,86,86,96,64,86,64,
64,64,64,64,106,106,64,64,64,64,1,15,15,52,86,40,52,15,75,15,
64,15,52,1,52,15,52,40,52,86,53,53,86,40,53,40,53,15,52,41,
75,15,1,28,15,28,28,28,28,40,40,86,86,40,86,53,96,40,86,28,
28,40,106,52,15,15,28,15,28,106,41,28,28,28,86,86,86,86,86,86,
28,86,28,53,28,86,86,53,53,41,86,15,40,15,53,53,106,41,86,15,
53,41,86,28,52,1,53,15,53,15,52,1,1,41,52,86,52,15,52,28,
86,15,52,15,52,15,52,15,52,28,86,41,15,28,28,86,41,86,41,86,
86,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,64,96,96,1,
96,96,96,96,96,96,96,96,96,96,96,96,96,64,106,96,96,96,96,96,
96,96,96,96,96,96,96,96,64,106,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,41,64,
41,86,1,64,1,64,1,41,1,1,1,1,1,1,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,1,1,28,75,1,75,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96, };
static unsigned short stb__arial_13_latin_ext_a[560]={ 52,52,66,104,104,166,124,36,
62,62,72,109,52,62,52,52,104,104,104,104,104,104,104,104,
104,104,52,52,109,109,109,104,189,124,124,134,134,124,114,145,
134,52,93,124,104,155,134,145,124,145,134,124,114,134,124,176,
124,124,114,52,52,52,87,104,62,104,104,93,104,104,52,104,
104,41,41,93,41,155,104,104,104,104,62,93,52,104,93,134,
93,93,93,62,48,62,109,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,52,62,104,104,104,104,48,104,
62,137,69,104,109,62,137,103,74,102,62,62,62,107,100,52,
62,62,68,104,155,155,155,114,124,124,124,124,124,124,186,134,
124,124,124,124,52,52,52,52,134,134,145,145,145,145,145,109,
145,134,134,134,134,124,124,114,104,104,104,104,104,104,166,93,
104,104,104,104,52,52,52,52,104,104,104,104,104,104,104,102,
114,104,104,104,104,93,104,93,124,104,124,104,124,104,134,93,
134,93,134,93,134,93,134,114,134,104,124,104,124,104,124,104,
124,104,124,104,145,104,145,104,145,104,145,104,134,104,134,104,
52,52,52,52,52,52,52,41,52,52,137,83,93,41,124,93,
93,104,41,104,41,104,54,104,62,104,41,134,104,134,104,134,
104,112,135,104,145,104,145,104,145,104,186,176,134,62,134,62,
134,62,124,93,124,93,124,93,124,93,114,52,114,70,114,52,
134,104,134,104,134,104,134,104,134,104,134,104,176,134,124,93,
124,114,93,114,93,114,93,41,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,104,140,140,140,140,140,
140,140,140,140,140,140,140,140,160,122,140,140,140,140,140,140,
140,140,140,140,140,140,140,159,125,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,124,104,52,41,145,104,134,104,134,104,134,
104,134,104,134,104,140,140,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,140,124,104,186,166,145,114,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,140,
140,140,140,140,140,140,140,140, };

// Call this function with
//    font: NULL or array length
//    data: NULL or specified size
//    height: STB_FONT_arial_13_latin_ext_BITMAP_HEIGHT or STB_FONT_arial_13_latin_ext_BITMAP_HEIGHT_POW2
//    return value: spacing between lines
static void stb_font_arial_13_latin_ext(stb_fontchar font[STB_FONT_arial_13_latin_ext_NUM_CHARS],
                unsigned char data[STB_FONT_arial_13_latin_ext_BITMAP_HEIGHT][STB_FONT_arial_13_latin_ext_BITMAP_WIDTH],
                int height)
{
    int i,j;
    if (data != 0) {
        unsigned int *bits = stb__arial_13_latin_ext_pixels;
        unsigned int bitpack = *bits++, numbits = 32;
        for (i=0; i < STB_FONT_arial_13_latin_ext_BITMAP_WIDTH*height; ++i)
            data[0][i] = 0;  // zero entire bitmap
        for (j=1; j < STB_FONT_arial_13_latin_ext_BITMAP_HEIGHT-1; ++j) {
            for (i=1; i < STB_FONT_arial_13_latin_ext_BITMAP_WIDTH-1; ++i) {
                unsigned int value;
                if (numbits==0) bitpack = *bits++, numbits=32;
                value = bitpack & 1;
                bitpack >>= 1, --numbits;
                if (value) {
                    if (numbits < 3) bitpack = *bits++, numbits = 32;
                    data[j][i] = (bitpack & 7) * 0x20 + 0x1f;
                    bitpack >>= 3, numbits -= 3;
                } else {
                    data[j][i] = 0;
                }
            }
        }
    }

    // build font description
    if (font != 0) {
        float recip_width = 1.0f / STB_FONT_arial_13_latin_ext_BITMAP_WIDTH;
        float recip_height = 1.0f / height;
        for (i=0; i < STB_FONT_arial_13_latin_ext_NUM_CHARS; ++i) {
            // pad characters so they bilerp from empty space around each character
            font[i].s0 = (stb__arial_13_latin_ext_s[i]) * recip_width;
            font[i].t0 = (stb__arial_13_latin_ext_t[i]) * recip_height;
            font[i].s1 = (stb__arial_13_latin_ext_s[i] + stb__arial_13_latin_ext_w[i]) * recip_width;
            font[i].t1 = (stb__arial_13_latin_ext_t[i] + stb__arial_13_latin_ext_h[i]) * recip_height;
            font[i].x0 = stb__arial_13_latin_ext_x[i];
            font[i].y0 = stb__arial_13_latin_ext_y[i];
            font[i].x1 = stb__arial_13_latin_ext_x[i] + stb__arial_13_latin_ext_w[i];
            font[i].y1 = stb__arial_13_latin_ext_y[i] + stb__arial_13_latin_ext_h[i];
            font[i].advance_int = (stb__arial_13_latin_ext_a[i]+8)>>4;
            font[i].s0f = (stb__arial_13_latin_ext_s[i] - 0.5f) * recip_width;
            font[i].t0f = (stb__arial_13_latin_ext_t[i] - 0.5f) * recip_height;
            font[i].s1f = (stb__arial_13_latin_ext_s[i] + stb__arial_13_latin_ext_w[i] + 0.5f) * recip_width;
            font[i].t1f = (stb__arial_13_latin_ext_t[i] + stb__arial_13_latin_ext_h[i] + 0.5f) * recip_height;
            font[i].x0f = stb__arial_13_latin_ext_x[i] - 0.5f;
            font[i].y0f = stb__arial_13_latin_ext_y[i] - 0.5f;
            font[i].x1f = stb__arial_13_latin_ext_x[i] + stb__arial_13_latin_ext_w[i] + 0.5f;
            font[i].y1f = stb__arial_13_latin_ext_y[i] + stb__arial_13_latin_ext_h[i] + 0.5f;
            font[i].advance = stb__arial_13_latin_ext_a[i]/16.0f;
        }
    }
}

#ifndef STB_SOMEFONT_CREATE
#define STB_SOMEFONT_CREATE              stb_font_arial_13_latin_ext
#define STB_SOMEFONT_BITMAP_WIDTH        STB_FONT_arial_13_latin_ext_BITMAP_WIDTH
#define STB_SOMEFONT_BITMAP_HEIGHT       STB_FONT_arial_13_latin_ext_BITMAP_HEIGHT
#define STB_SOMEFONT_BITMAP_HEIGHT_POW2  STB_FONT_arial_13_latin_ext_BITMAP_HEIGHT_POW2
#define STB_SOMEFONT_FIRST_CHAR          STB_FONT_arial_13_latin_ext_FIRST_CHAR
#define STB_SOMEFONT_NUM_CHARS           STB_FONT_arial_13_latin_ext_NUM_CHARS
#define STB_SOMEFONT_LINE_SPACING        STB_FONT_arial_13_latin_ext_LINE_SPACING
#endif

