#ifndef QFITSHEADERVIEW_H
#define QFITSHEADERVIEW_H

#include <QPushButton>
#include <QString>
#include <QLineEdit>
#include <QLabel>
#include <QTextEdit>
#include <QDialog>


class QFitsMainWindow;
class Fits;

class QFitsHeaderContent : public QTextEdit {
    Q_OBJECT
public:
    QFitsHeaderContent(QWidget *parent);
protected:
    void mouseMoveEvent(QMouseEvent *);
};

class QFitsHeaderView : public QDialog {
    Q_OBJECT
//----- Functions -----
public:
    QFitsHeaderView(QWidget*);
    ~QFitsHeaderView() {}

    virtual void showUp(Fits*);

protected:
    void resizeEvent(QResizeEvent *);
    void keyPressEvent(QKeyEvent *);

//----- Slots -----
protected slots:
    void dosearch(const QString &);
    void dosearchagain();
    void fontchanged();
private slots:
    void editWCS();

//----- Signals -----
//----- Members -----
protected:
//    QFitsMainWindow     *myParent;
    QFitsHeaderContent  *content;
    QPushButton         *closeButton;
    QLineEdit           *searchTerm;
    QLabel              *searchLabel;
    QPushButton         *searchAgain,
                        *editWCSButton;
    QString             oldfont;
    int                 oldfontsize;
};

class QFitsHeaderViewExt : public QFitsHeaderView {
    Q_OBJECT
//----- Functions -----
public:
    QFitsHeaderViewExt(QWidget*);
    ~QFitsHeaderViewExt() {}

    void showUp(Fits*);
//----- Slots -----
//----- Signals -----
//----- Members -----
};

#endif /* QFITSHEADERVIEW_H */
