// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace Microsoft.EntityFrameworkCore;

/// <summary>
///     The runtime behavior of warnings generated by Entity Framework
/// </summary>
/// <remarks>
///     See <see href="https://aka.ms/efcore-docs-diagnostics">Logging, events, and diagnostics</see> for more information and examples.
/// </remarks>
public enum WarningBehavior
{
    /// <summary>
    ///     A warning is logged.
    /// </summary>
    Log,

    /// <summary>
    ///     No action is taken.
    /// </summary>
    Ignore,

    /// <summary>
    ///     An exception is thrown.
    /// </summary>
    Throw
}
