#ifndef RPCSOCKETLISTENER_H
#define RPCSOCKETLISTENER_H


namespace rpc {
	
class Socket;
	
/**
	@author Rikard Bjorklind <olof@linux.nu>
*/
class SocketListener{
public:
	virtual ~SocketListener() {}
	virtual void onRead(Socket*) = 0;
//	virtual void onWrite(Socket*) = 0;
	//! Called as soon as a connection is established. Do not do anything important in this method, especially dont do anything with the socket emitting it!
	virtual void onConnect(Socket*) = 0;
	virtual void onDisconnect(Socket*) = 0;
	virtual void onIncoming(Socket*) {} // not pure since we only use it for servers.

};

}

#endif
