#ifndef _LOG_H
#define _LOG_H 1

// Functions for common logging to file and syslog.

#include <string>

enum LogLevel {
	INFO,
	WARNING,
	ERROR,
};

void add_log_destination_file(const std::string &filename);
void add_log_destination_console();
void add_log_destination_syslog();

void start_logging();
void shut_down_logging();

void log(LogLevel log_level, const char *fmt, ...);
void log_perror(const char *msg);

#endif  // !defined(_LOG_H)
