/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef __DDRPHY_NAO_REG_H__
#define __DDRPHY_NAO_REG_H__

/* ----------------- Register Definitions ------------------- */
#define MISC_STA_EXTLB0					0x00000000
	#define MISC_STA_EXTLB0_STA_EXTLB_DONE		GENMASK(31, 0)
#define MISC_STA_EXTLB1					0x00000004
	#define MISC_STA_EXTLB1_STA_EXTLB_FAIL		GENMASK(31, 0)
#define MISC_STA_EXTLB2					0x00000008
	#define MISC_STA_EXTLB2_STA_EXTLB_DBG_INFO	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO0				0x00000080
	#define MISC_DQ_RXDLY_TRRO0_DVS_RKX_BX_SW_LAG_CNT_OUT_B0	GENMASK(7, 0)
	#define MISC_DQ_RXDLY_TRRO0_DVS_RKX_BX_SW_LEAD_CNT_OUT_B0	GENMASK(15, 8)
	#define MISC_DQ_RXDLY_TRRO0_DVS_RKX_BX_SW_LAG_CNT_OUT_B1	GENMASK(23, 16)
	#define MISC_DQ_RXDLY_TRRO0_DVS_RKX_BX_SW_LEAD_CNT_OUT_B1	GENMASK(31, 24)
#define MISC_DQ_RXDLY_TRRO1				0x00000084
	#define MISC_DQ_RXDLY_TRRO1_DVS_RKX_BX_SW_LAG_CNT_OUT_B2	GENMASK(7, 0)
	#define MISC_DQ_RXDLY_TRRO1_DVS_RKX_BX_SW_LEAD_CNT_OUT_B2	GENMASK(15, 8)
	#define MISC_DQ_RXDLY_TRRO1_DVS_RKX_BX_SW_LAG_CNT_OUT_B3	GENMASK(23, 16)
	#define MISC_DQ_RXDLY_TRRO1_DVS_RKX_BX_SW_LEAD_CNT_OUT_B3	GENMASK(31, 24)
#define MISC_DQ_RXDLY_TRRO2				0x00000088
	#define MISC_DQ_RXDLY_TRRO2_DVS_RKX_BX_SW_LAG_CNT_OUT_B4	GENMASK(7, 0)
	#define MISC_DQ_RXDLY_TRRO2_DVS_RKX_BX_SW_LEAD_CNT_OUT_B4	GENMASK(15, 8)
	#define MISC_DQ_RXDLY_TRRO2_DVS_RKX_BX_SW_LAG_CNT_OUT_B5	GENMASK(23, 16)
	#define MISC_DQ_RXDLY_TRRO2_DVS_RKX_BX_SW_LEAD_CNT_OUT_B5	GENMASK(31, 24)
#define MISC_DQ_RXDLY_TRRO3				0x0000008c
	#define MISC_DQ_RXDLY_TRRO3_DVS_RKX_BX_SW_LAG_CNT_OUT_B6	GENMASK(7, 0)
	#define MISC_DQ_RXDLY_TRRO3_DVS_RKX_BX_SW_LEAD_CNT_OUT_B6	GENMASK(15, 8)
	#define MISC_DQ_RXDLY_TRRO3_DVS_RKX_BX_SW_LAG_CNT_OUT_B7	GENMASK(23, 16)
	#define MISC_DQ_RXDLY_TRRO3_DVS_RKX_BX_SW_LEAD_CNT_OUT_B7	GENMASK(31, 24)
#define MISC_DQ_RXDLY_TRRO4				0x00000090
	#define MISC_DQ_RXDLY_TRRO4_DVS_RKX_BX_LEAD_LAG_CNT_OUT_B0	GENMASK(7, 0)
	#define MISC_DQ_RXDLY_TRRO4_DVS_RKX_BX_LEAD_LAG_CNT_OUT_B1	GENMASK(15, 8)
	#define MISC_DQ_RXDLY_TRRO4_DVS_RKX_BX_LEAD_LAG_CNT_OUT_B2	GENMASK(23, 16)
	#define MISC_DQ_RXDLY_TRRO4_DVS_RKX_BX_LEAD_LAG_CNT_OUT_B3	GENMASK(31, 24)
#define MISC_DQ_RXDLY_TRRO5				0x00000094
	#define MISC_DQ_RXDLY_TRRO5_DVS_RKX_BX_LEAD_LAG_CNT_OUT_B4	GENMASK(7, 0)
	#define MISC_DQ_RXDLY_TRRO5_DVS_RKX_BX_LEAD_LAG_CNT_OUT_B5	GENMASK(15, 8)
	#define MISC_DQ_RXDLY_TRRO5_DVS_RKX_BX_LEAD_LAG_CNT_OUT_B6	GENMASK(23, 16)
	#define MISC_DQ_RXDLY_TRRO5_DVS_RKX_BX_LEAD_LAG_CNT_OUT_B7	GENMASK(31, 24)
#define MISC_DQ_RXDLY_TRRO6				0x00000098
	#define MISC_DQ_RXDLY_TRRO6_DVS_RKX_BX_SW_LAG_CNT_OUT_DQM0	GENMASK(7, 0)
	#define MISC_DQ_RXDLY_TRRO6_DVS_RKX_BX_SW_LEAD_CNT_OUT_DQM0	GENMASK(15, 8)
	#define MISC_DQ_RXDLY_TRRO6_DVS_RKX_BX_LEAD_LAG_CNT_OUT_DQM0	GENMASK(31, 24)
#define MISC_DQ_RXDLY_TRRO7				0x0000009c
	#define MISC_DQ_RXDLY_TRRO7_DVS_RK0_B0_SW_UP_DONE	BIT(0)
	#define MISC_DQ_RXDLY_TRRO7_DVS_RK0_B1_SW_UP_DONE	BIT(4)
	#define MISC_DQ_RXDLY_TRRO7_DVS_RK1_B0_SW_UP_DONE	BIT(8)
	#define MISC_DQ_RXDLY_TRRO7_DVS_RK1_B1_SW_UP_DONE	BIT(12)
	#define MISC_DQ_RXDLY_TRRO7_DVS_RK2_B0_SW_UP_DONE	BIT(16)
	#define MISC_DQ_RXDLY_TRRO7_DVS_RK2_B1_SW_UP_DONE	BIT(20)
#define MISC_DQ_RXDLY_TRRO8				0x000000a0
	#define MISC_DQ_RXDLY_TRRO8_DVS_RKX_BX_TH_CNT_OUT_B0	GENMASK(8, 0)
	#define MISC_DQ_RXDLY_TRRO8_DVS_RKX_BX_TH_CNT_OUT_B1	GENMASK(24, 16)
#define MISC_DQ_RXDLY_TRRO9				0x000000a4
	#define MISC_DQ_RXDLY_TRRO9_DVS_RKX_BX_TH_CNT_OUT_B2	GENMASK(8, 0)
	#define MISC_DQ_RXDLY_TRRO9_DVS_RKX_BX_TH_CNT_OUT_B3	GENMASK(24, 16)
#define MISC_DQ_RXDLY_TRRO10				0x000000a8
	#define MISC_DQ_RXDLY_TRRO10_DVS_RKX_BX_TH_CNT_OUT_B4	GENMASK(8, 0)
	#define MISC_DQ_RXDLY_TRRO10_DVS_RKX_BX_TH_CNT_OUT_B5	GENMASK(24, 16)
#define MISC_DQ_RXDLY_TRRO11				0x000000ac
	#define MISC_DQ_RXDLY_TRRO11_DVS_RKX_BX_TH_CNT_OUT_B6	GENMASK(8, 0)
	#define MISC_DQ_RXDLY_TRRO11_DVS_RKX_BX_TH_CNT_OUT_B7	GENMASK(24, 16)
#define MISC_DQ_RXDLY_TRRO12				0x000000b0
	#define MISC_DQ_RXDLY_TRRO12_DVS_RKX_BX_TH_CNT_OUT_DQM0	GENMASK(8, 0)
#define MISC_DQ_RXDLY_TRRO13				0x000000b4
	#define MISC_DQ_RXDLY_TRRO13_DA_RK0_DQX_B0_R_DLY	GENMASK(5, 0)
	#define MISC_DQ_RXDLY_TRRO13_DA_RK0_DQS0_R_DLY	GENMASK(14, 8)
	#define MISC_DQ_RXDLY_TRRO13_DA_RK0_DQX_B1_R_DLY	GENMASK(21, 16)
	#define MISC_DQ_RXDLY_TRRO13_DA_RK0_DQS1_R_DLY	GENMASK(30, 24)
#define MISC_DQ_RXDLY_TRRO14				0x000000b8
	#define MISC_DQ_RXDLY_TRRO14_DA_RK1_DQX_B0_R_DLY	GENMASK(5, 0)
	#define MISC_DQ_RXDLY_TRRO14_DA_RK1_DQS0_R_DLY	GENMASK(14, 8)
	#define MISC_DQ_RXDLY_TRRO14_DA_RK1_DQX_B1_R_DLY	GENMASK(21, 16)
	#define MISC_DQ_RXDLY_TRRO14_DA_RK1_DQS1_R_DLY	GENMASK(30, 24)
#define MISC_DQ_RXDLY_TRRO15				0x000000bc
	#define MISC_DQ_RXDLY_TRRO15_DA_RK2_DQX_B0_R_DLY	GENMASK(5, 0)
	#define MISC_DQ_RXDLY_TRRO15_DA_RK2_DQS0_R_DLY	GENMASK(14, 8)
	#define MISC_DQ_RXDLY_TRRO15_DA_RK2_DQX_B1_R_DLY	GENMASK(21, 16)
	#define MISC_DQ_RXDLY_TRRO15_DA_RK2_DQS1_R_DLY	GENMASK(30, 24)
#define MISC_DQ_RXDLY_TRRO16				0x000000c0
	#define MISC_DQ_RXDLY_TRRO16_DVS_RXDLY_STS_ERR_CNT_ALL	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO17				0x000000c4
	#define MISC_DQ_RXDLY_TRRO17_DVS_RXDLY_STS_ERR_CNT_ALL_47_32	GENMASK(15, 0)
	#define MISC_DQ_RXDLY_TRRO17_PBYTE_LEADLAG_STUCK_B0	BIT(16)
	#define MISC_DQ_RXDLY_TRRO17_PBYTE_LEADLAG_STUCK_B1	BIT(24)
#define MISC_DQ_RXDLY_TRRO18				0x000000c8
	#define MISC_DQ_RXDLY_TRRO18_RXDLY_DBG_MON_VALID	BIT(0)
	#define MISC_DQ_RXDLY_TRRO18_RXDLY_RK0_FAIL_LAT	BIT(1)
	#define MISC_DQ_RXDLY_TRRO18_RXDLY_RK1_FAIL_LAT	BIT(2)
	#define MISC_DQ_RXDLY_TRRO18_RXDLY_RK2_FAIL_LAT	BIT(3)
	#define MISC_DQ_RXDLY_TRRO18_DFS_SHU_GP_FAIL_LAT	GENMASK(5, 4)
#define MISC_DQ_RXDLY_TRRO19				0x000000cc
	#define MISC_DQ_RXDLY_TRRO19_RESERVED_0X00C	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO20				0x000000d0
	#define MISC_DQ_RXDLY_TRRO20_RESERVED_0X0D0	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO21				0x000000d4
	#define MISC_DQ_RXDLY_TRRO21_RESERVED_0X0D4	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO22				0x000000d8
	#define MISC_DQ_RXDLY_TRRO22_RESERVED_0X0D8	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO23				0x000000dc
	#define MISC_DQ_RXDLY_TRRO23_RESERVED_0X0DC	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO24				0x000000e0
	#define MISC_DQ_RXDLY_TRRO24_RESERVED_0X0E0	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO25				0x000000e4
	#define MISC_DQ_RXDLY_TRRO25_RESERVED_0X0E4	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO26				0x000000e8
	#define MISC_DQ_RXDLY_TRRO26_RESERVED_0X0E8	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO27				0x000000ec
	#define MISC_DQ_RXDLY_TRRO27_RESERVED_0X0EC	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO28				0x000000f0
	#define MISC_DQ_RXDLY_TRRO28_RESERVED_0X0F0	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO29				0x000000f4
	#define MISC_DQ_RXDLY_TRRO29_RESERVED_0X0F4	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO30				0x000000f8
	#define MISC_DQ_RXDLY_TRRO30_RESERVED_0X0F8	GENMASK(31, 0)
#define MISC_DQ_RXDLY_TRRO31				0x000000fc
	#define MISC_DQ_RXDLY_TRRO31_RESERVED_0X0FC	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO0				0x00000100
	#define MISC_CA_RXDLY_TRRO0_DVS_RKX_CA_SW_LAG_CNT_OUT_CA0	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO0_DVS_RKX_CA_SW_LEAD_CNT_OUT_CA0	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO0_DVS_RKX_CA_SW_LAG_CNT_OUT_CA1	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO0_DVS_RKX_CA_SW_LEAD_CNT_OUT_CA1	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO1				0x00000104
	#define MISC_CA_RXDLY_TRRO1_DVS_RKX_CA_SW_LAG_CNT_OUT_CA2	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO1_DVS_RKX_CA_SW_LEAD_CNT_OUT_CA2	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO1_DVS_RKX_CA_SW_LAG_CNT_OUT_CA3	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO1_DVS_RKX_CA_SW_LEAD_CNT_OUT_CA3	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO2				0x00000108
	#define MISC_CA_RXDLY_TRRO2_DVS_RKX_CA_SW_LAG_CNT_OUT_CA4	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO2_DVS_RKX_CA_SW_LEAD_CNT_OUT_CA4	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO2_DVS_RKX_CA_SW_LAG_CNT_OUT_CA5	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO2_DVS_RKX_CA_SW_LEAD_CNT_OUT_CA5	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO3				0x0000010c
	#define MISC_CA_RXDLY_TRRO3_DVS_RKX_CA_SW_LAG_CNT_OUT_CKE0	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO3_DVS_RKX_CA_SW_LEAD_CNT_OUT_CKE0	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO3_DVS_RKX_CA_SW_LAG_CNT_OUT_CKE1	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO3_DVS_RKX_CA_SW_LEAD_CNT_OUT_CKE1	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO4				0x00000110
	#define MISC_CA_RXDLY_TRRO4_DVS_RKX_CA_SW_LAG_CNT_OUT_CKE2	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO4_DVS_RKX_CA_SW_LEAD_CNT_OUT_CKE2	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO4_DVS_RKX_CA_SW_LAG_CNT_OUT_CS0	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO4_DVS_RKX_CA_SW_LEAD_CNT_OUT_CS0	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO5				0x00000114
	#define MISC_CA_RXDLY_TRRO5_DVS_RKX_CA_SW_LAG_CNT_OUT_CS1	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO5_DVS_RKX_CA_SW_LEAD_CNT_OUT_CS1	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO5_DVS_RKX_CA_SW_LAG_CNT_OUT_CS2	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO5_DVS_RKX_CA_SW_LEAD_CNT_OUT_CS2	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO6				0x00000118
	#define MISC_CA_RXDLY_TRRO6_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CA0	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO6_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CA1	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO6_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CA2	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO6_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CA3	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO7				0x0000011c
	#define MISC_CA_RXDLY_TRRO7_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CA4	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO7_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CA5	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO7_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CKE0	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO7_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CKE1	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO8				0x00000120
	#define MISC_CA_RXDLY_TRRO8_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CKE2	GENMASK(7, 0)
	#define MISC_CA_RXDLY_TRRO8_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CS0	GENMASK(15, 8)
	#define MISC_CA_RXDLY_TRRO8_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CS1	GENMASK(23, 16)
	#define MISC_CA_RXDLY_TRRO8_DVS_RKX_CA_LEAD_LAG_CNT_OUT_CS2	GENMASK(31, 24)
#define MISC_CA_RXDLY_TRRO9				0x00000124
	#define MISC_CA_RXDLY_TRRO9_DVS_RK0_CA_SW_UP_DONE	BIT(0)
	#define MISC_CA_RXDLY_TRRO9_DVS_RK1_CA_SW_UP_DONE	BIT(8)
	#define MISC_CA_RXDLY_TRRO9_DVS_RK2_CA_SW_UP_DONE	BIT(16)
#define MISC_CA_RXDLY_TRRO10				0x00000128
	#define MISC_CA_RXDLY_TRRO10_DVS_RKX_CA_TH_CNT_OUT_CA0	GENMASK(8, 0)
	#define MISC_CA_RXDLY_TRRO10_DVS_RKX_CA_TH_CNT_OUT_CA1	GENMASK(24, 16)
#define MISC_CA_RXDLY_TRRO11				0x0000012c
	#define MISC_CA_RXDLY_TRRO11_DVS_RKX_CA_TH_CNT_OUT_CA2	GENMASK(8, 0)
	#define MISC_CA_RXDLY_TRRO11_DVS_RKX_CA_TH_CNT_OUT_CA3	GENMASK(24, 16)
#define MISC_CA_RXDLY_TRRO12				0x00000130
	#define MISC_CA_RXDLY_TRRO12_DVS_RKX_CA_TH_CNT_OUT_CA4	GENMASK(8, 0)
	#define MISC_CA_RXDLY_TRRO12_DVS_RKX_CA_TH_CNT_OUT_CA5	GENMASK(24, 16)
#define MISC_CA_RXDLY_TRRO13				0x00000134
	#define MISC_CA_RXDLY_TRRO13_DVS_RKX_CA_TH_CNT_OUT_CKE0	GENMASK(8, 0)
	#define MISC_CA_RXDLY_TRRO13_DVS_RKX_CA_TH_CNT_OUT_CKE1	GENMASK(24, 16)
#define MISC_CA_RXDLY_TRRO14				0x00000138
	#define MISC_CA_RXDLY_TRRO14_DVS_RKX_CA_TH_CNT_OUT_CKE2	GENMASK(8, 0)
	#define MISC_CA_RXDLY_TRRO14_DVS_RKX_CA_TH_CNT_OUT_CS0	GENMASK(24, 16)
#define MISC_CA_RXDLY_TRRO15				0x0000013c
	#define MISC_CA_RXDLY_TRRO15_DVS_RKX_CA_TH_CNT_OUT_CS1	GENMASK(8, 0)
	#define MISC_CA_RXDLY_TRRO15_DVS_RKX_CA_TH_CNT_OUT_CS2	GENMASK(24, 16)
#define MISC_CA_RXDLY_TRRO16				0x00000140
	#define MISC_CA_RXDLY_TRRO16_DA_RK0_CAX_CA_R_DLY	GENMASK(5, 0)
	#define MISC_CA_RXDLY_TRRO16_DA_RK0_CLK_R_DLY	GENMASK(15, 8)
#define MISC_CA_RXDLY_TRRO17				0x00000144
	#define MISC_CA_RXDLY_TRRO17_DA_RK1_CAX_CA_R_DLY	GENMASK(5, 0)
	#define MISC_CA_RXDLY_TRRO17_DA_RK1_CLK_R_DLY	GENMASK(15, 8)
#define MISC_CA_RXDLY_TRRO18				0x00000148
	#define MISC_CA_RXDLY_TRRO18_DA_RK2_CAX_CA_R_DLY	GENMASK(5, 0)
	#define MISC_CA_RXDLY_TRRO18_DA_RK2_CLK_R_DLY	GENMASK(15, 8)
#define MISC_CA_RXDLY_TRRO19				0x0000014c
	#define MISC_CA_RXDLY_TRRO19_DVS_RXDLY_STS_ERR_CNT_ALL_CA	GENMASK(23, 0)
	#define MISC_CA_RXDLY_TRRO19_PBYTE_LEADLAG_STUCK_CA	BIT(24)
#define MISC_CA_RXDLY_TRRO20				0x00000150
	#define MISC_CA_RXDLY_TRRO20_RESERVED_0X150	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO21				0x00000154
	#define MISC_CA_RXDLY_TRRO21_RESERVED_0X154	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO22				0x00000158
	#define MISC_CA_RXDLY_TRRO22_RESERVED_0X158	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO23				0x0000015c
	#define MISC_CA_RXDLY_TRRO23_RESERVED_0X15C	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO24				0x00000160
	#define MISC_CA_RXDLY_TRRO24_RESERVED_0X160	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO25				0x00000164
	#define MISC_CA_RXDLY_TRRO25_RESERVED_0X164	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO26				0x00000168
	#define MISC_CA_RXDLY_TRRO26_RESERVED_0X168	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO27				0x0000016c
	#define MISC_CA_RXDLY_TRRO27_RESERVED_0X16C	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO28				0x00000170
	#define MISC_CA_RXDLY_TRRO28_RESERVED_0X170	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO29				0x00000174
	#define MISC_CA_RXDLY_TRRO29_RESERVED_0X174	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO30				0x00000178
	#define MISC_CA_RXDLY_TRRO30_RESERVED_0X178	GENMASK(31, 0)
#define MISC_CA_RXDLY_TRRO31				0x0000017c
	#define MISC_CA_RXDLY_TRRO31_RESERVED_0X17C	GENMASK(31, 0)
#define MISC_DQO1					0x00000180
	#define MISC_DQO1_DQO1_RO			GENMASK(31, 0)
#define MISC_CAO1					0x00000184
	#define MISC_CAO1_RA0_O1			BIT(0)
	#define MISC_CAO1_RA1_O1			BIT(1)
	#define MISC_CAO1_RA2_O1			BIT(2)
	#define MISC_CAO1_RA3_O1			BIT(3)
	#define MISC_CAO1_RA4_O1			BIT(4)
	#define MISC_CAO1_RA5_O1			BIT(5)
	#define MISC_CAO1_RA6_O1			BIT(6)
	#define MISC_CAO1_RA7_O1			BIT(7)
	#define MISC_CAO1_RA8_O1			BIT(8)
	#define MISC_CAO1_RA9_O1			BIT(9)
	#define MISC_CAO1_CKEO1_RO			BIT(10)
	#define MISC_CAO1_CKE1O1_RO			BIT(11)
	#define MISC_CAO1_CKE2O1_RO			BIT(12)
	#define MISC_CAO1_CSO1_RO			BIT(13)
	#define MISC_CAO1_CS1O1_RO			BIT(14)
	#define MISC_CAO1_CS2O1_RO			BIT(15)
	#define MISC_CAO1_RESETO1_RO			BIT(16)
	#define MISC_CAO1_DQM0O1_RO			BIT(24)
	#define MISC_CAO1_DQM1O1_RO			BIT(25)
	#define MISC_CAO1_DQM2O1_RO			BIT(26)
	#define MISC_CAO1_DQM3O1_RO			BIT(27)
#define MISC_AD_RX_DQ_O1				0x00000188
	#define MISC_AD_RX_DQ_O1_AD_RX_ARDQ_O1_B0	GENMASK(7, 0)
	#define MISC_AD_RX_DQ_O1_AD_RX_ARDQ_O1_B0_BIT2	BIT(2)//[2:2]    //francis added
	#define MISC_AD_RX_DQ_O1_AD_RX_ARDQM0_O1_B0	BIT(8)
	#define MISC_AD_RX_DQ_O1_AD_RX_ARDQ_O1_B1	GENMASK(23, 16)
	#define MISC_AD_RX_DQ_O1_AD_RX_ARDQM0_O1_B1	BIT(24)
	#define MISC_AD_RX_DQ_O1_AD_RX_ARDQ_O1_B1_BIT2	BIT(18)//[18:18]    //francis added
#define MISC_AD_RX_CMD_O1				0x0000018c
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA0_O1	BIT(0)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA1_O1	BIT(1)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA2_O1	BIT(2)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA3_O1	BIT(3)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA4_O1	BIT(4)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA5_O1	BIT(5)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA6_O1	BIT(6)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA7_O1	BIT(7)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA8_O1	BIT(8)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCA9_O1	BIT(9)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCKE0_O1	BIT(10)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCKE1_O1	BIT(11)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCKE2_O1	BIT(12)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCS0_O1	BIT(13)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCS1_O1	BIT(14)
	#define MISC_AD_RX_CMD_O1_AD_RX_ARCS2_O1	BIT(15)
#define MISC_PHY_RGS_DQ					0x00000190
	#define MISC_PHY_RGS_DQ_RGS_ARDQ_OFFSET_FLAG_B0	GENMASK(7, 0)
	#define MISC_PHY_RGS_DQ_RGS_ARDQM0_OFFSET_FLAG_B0	BIT(8)
	#define MISC_PHY_RGS_DQ_RGS_RX_ARDQS0_RDY_EYE_B0	BIT(9)
	#define MISC_PHY_RGS_DQ_RGS_ARDQ_OFFSET_FLAG_B1	GENMASK(23, 16)
	#define MISC_PHY_RGS_DQ_RGS_ARDQM0_OFFSET_FLAG_B1	BIT(24)
	#define MISC_PHY_RGS_DQ_RGS_RX_ARDQS0_RDY_EYE_B1	BIT(25)
	#define MISC_PHY_RGS_DQ_DA_RPHYPLLGP_CK_SEL	BIT(31)
#define MISC_PHY_RGS_CMD				0x00000194
	#define MISC_PHY_RGS_CMD_RGS_ARCA0_OFFSET_FLAG	BIT(0)
	#define MISC_PHY_RGS_CMD_RGS_ARCA1_OFFSET_FLAG	BIT(1)
	#define MISC_PHY_RGS_CMD_RGS_ARCA2_OFFSET_FLAG	BIT(2)
	#define MISC_PHY_RGS_CMD_RGS_ARCA3_OFFSET_FLAG	BIT(3)
	#define MISC_PHY_RGS_CMD_RGS_ARCA4_OFFSET_FLAG	BIT(4)
	#define MISC_PHY_RGS_CMD_RGS_ARCA5_OFFSET_FLAG	BIT(5)
	#define MISC_PHY_RGS_CMD_RGS_ARCA6_OFFSET_FLAG	BIT(6)
	#define MISC_PHY_RGS_CMD_RGS_ARCA7_OFFSET_FLAG	BIT(7)
	#define MISC_PHY_RGS_CMD_RGS_ARCA8_OFFSET_FLAG	BIT(8)
	#define MISC_PHY_RGS_CMD_RGS_ARCA9_OFFSET_FLAG	BIT(9)
	#define MISC_PHY_RGS_CMD_RGS_ARCKE0_OFFSET_FLAG	BIT(10)
	#define MISC_PHY_RGS_CMD_RGS_ARCKE1_OFFSET_FLAG	BIT(11)
	#define MISC_PHY_RGS_CMD_RGS_ARCKE2_OFFSET_FLAG	BIT(12)
	#define MISC_PHY_RGS_CMD_RGS_ARCS0_OFFSET_FLAG	BIT(13)
	#define MISC_PHY_RGS_CMD_RGS_ARCS1_OFFSET_FLAG	BIT(14)
	#define MISC_PHY_RGS_CMD_RGS_ARCS2_OFFSET_FLAG	BIT(15)
	#define MISC_PHY_RGS_CMD_RGS_RX_ARCLK_RDY_EYE	BIT(16)
	#define MISC_PHY_RGS_CMD_RGS_RIMPCALOUT		BIT(24)
#define MISC_PHY_RGS_STBEN_B0				0x00000198
	#define MISC_PHY_RGS_STBEN_B0_AD_RX_ARDQ0_STBEN_B0	GENMASK(7, 0)
	#define MISC_PHY_RGS_STBEN_B0_AD_RX_ARDQ4_STBEN_B0	GENMASK(15, 8)
	#define MISC_PHY_RGS_STBEN_B0_AD_RX_ARDQS0_STBEN_LEAD_B0	BIT(16)
	#define MISC_PHY_RGS_STBEN_B0_AD_RX_ARDQS0_STBEN_LAG_B0	BIT(17)
	#define MISC_PHY_RGS_STBEN_B0_AD_ARDLL_PD_EN_B0	BIT(18)
	#define MISC_PHY_RGS_STBEN_B0_AD_ARDLL_MON_B0	GENMASK(31, 24)
#define MISC_PHY_RGS_STBEN_B1				0x0000019c
	#define MISC_PHY_RGS_STBEN_B1_AD_RX_ARDQ0_STBEN_B1	GENMASK(7, 0)
	#define MISC_PHY_RGS_STBEN_B1_AD_RX_ARDQ4_STBEN_B1	GENMASK(15, 8)
	#define MISC_PHY_RGS_STBEN_B1_AD_RX_ARDQS0_STBEN_LEAD_B1	BIT(16)
	#define MISC_PHY_RGS_STBEN_B1_AD_RX_ARDQS0_STBEN_LAG_B1	BIT(17)
	#define MISC_PHY_RGS_STBEN_B1_AD_ARDLL_PD_EN_B1	BIT(18)
	#define MISC_PHY_RGS_STBEN_B1_AD_ARDLL_MON_B1	GENMASK(31, 24)
#define MISC_PHY_RGS_STBEN_CMD				0x000001a0
	#define MISC_PHY_RGS_STBEN_CMD_AD_RX_ARCA0_STBEN	GENMASK(7, 0)
	#define MISC_PHY_RGS_STBEN_CMD_AD_RX_ARCA4_STBEN	GENMASK(15, 8)
	#define MISC_PHY_RGS_STBEN_CMD_AD_RX_ARCLK_STBEN_LEAD	BIT(16)
	#define MISC_PHY_RGS_STBEN_CMD_AD_RX_ARCLK_STBEN_LAG	BIT(17)
	#define MISC_PHY_RGS_STBEN_CMD_AD_ARDLL_PD_EN_CA	BIT(18)
	#define MISC_PHY_RGS_STBEN_CMD_AD_ARDLL_MON_CA	GENMASK(31, 24)
#define MISC_STA_TOGLB0					0x000001a4
	#define MISC_STA_TOGLB0_STA_TOGLB_DONE		GENMASK(31, 0)
#define MISC_STA_TOGLB1					0x000001a8
	#define MISC_STA_TOGLB1_STA_TOGLB_FAIL		GENMASK(31, 0)
#define MISC_STA_TOGLB2					0x000001ac
	#define MISC_STA_TOGLB2_STA_TOGLB_PUHI_TIMEOUT	GENMASK(31, 0)
#define MISC_STA_TOGLB3					0x000001b0
	#define MISC_STA_TOGLB3_STA_TOGLB_PULO_TIMEOUT	GENMASK(31, 0)
#define MISC_FT_STATUS_0				0x000001b4
	#define MISC_FT_STATUS_0_AD_RX_ARDQ_DVS_R_LAG_B1	GENMASK(7, 0)
	#define MISC_FT_STATUS_0_AD_RX_ARDQ_DVS_R_LEAD_B1	GENMASK(15, 8)
	#define MISC_FT_STATUS_0_AD_RX_ARDQ_DVS_R_LAG_B0	GENMASK(23, 16)
	#define MISC_FT_STATUS_0_AD_RX_ARDQ_DVS_R_LEAD_B0	GENMASK(31, 24)
#define MISC_FT_STATUS_1				0x000001b8
	#define MISC_FT_STATUS_1_AD_RX_ARDQ_DVS_F_LAG_B1	GENMASK(7, 0)
	#define MISC_FT_STATUS_1_AD_RX_ARDQ_DVS_F_LEAD_B1	GENMASK(15, 8)
	#define MISC_FT_STATUS_1_AD_RX_ARDQ_DVS_F_LAG_B0	GENMASK(23, 16)
	#define MISC_FT_STATUS_1_AD_RX_ARDQ_DVS_F_LEAD_B0	GENMASK(31, 24)
#define MISC_FT_STATUS_2				0x000001bc
	#define MISC_FT_STATUS_2_AD_RRESETB_O		BIT(0)
#define MISC_FT_STATUS_3				0x000001c0
	#define MISC_FT_STATUS_3_AD_RX_ARCA0_DVS_R_LAG	BIT(0)
	#define MISC_FT_STATUS_3_AD_RX_ARCA1_DVS_R_LAG	BIT(1)
	#define MISC_FT_STATUS_3_AD_RX_ARCA2_DVS_R_LAG	BIT(2)
	#define MISC_FT_STATUS_3_AD_RX_ARCA3_DVS_R_LAG	BIT(3)
	#define MISC_FT_STATUS_3_AD_RX_ARCA4_DVS_R_LAG	BIT(4)
	#define MISC_FT_STATUS_3_AD_RX_ARCA5_DVS_R_LAG	BIT(5)
	#define MISC_FT_STATUS_3_AD_RX_ARCKE0_DVS_R_LAG	BIT(6)
	#define MISC_FT_STATUS_3_AD_RX_ARCKE1_DVS_R_LAG	BIT(7)
	#define MISC_FT_STATUS_3_AD_RX_ARCS0_DVS_R_LAG	BIT(8)
	#define MISC_FT_STATUS_3_AD_RX_ARCS1_DVS_R_LAG	BIT(9)
	#define MISC_FT_STATUS_3_AD_RX_ARCA0_DVS_R_LEAD	BIT(16)
	#define MISC_FT_STATUS_3_AD_RX_ARCA1_DVS_R_LEAD	BIT(17)
	#define MISC_FT_STATUS_3_AD_RX_ARCA2_DVS_R_LEAD	BIT(18)
	#define MISC_FT_STATUS_3_AD_RX_ARCA3_DVS_R_LEAD	BIT(19)
	#define MISC_FT_STATUS_3_AD_RX_ARCA4_DVS_R_LEAD	BIT(20)
	#define MISC_FT_STATUS_3_AD_RX_ARCA5_DVS_R_LEAD	BIT(21)
	#define MISC_FT_STATUS_3_AD_RX_ARCKE0_DVS_R_LEAD	BIT(22)
	#define MISC_FT_STATUS_3_AD_RX_ARCKE1_DVS_R_LEAD	BIT(23)
	#define MISC_FT_STATUS_3_AD_RX_ARCS0_DVS_R_LEAD	BIT(24)
	#define MISC_FT_STATUS_3_AD_RX_ARCS1_DVS_R_LEAD	BIT(25)
#define MISC_FT_STATUS_4				0x000001c4
	#define MISC_FT_STATUS_4_AD_RX_ARCA0_DVS_F_LAG	BIT(0)
	#define MISC_FT_STATUS_4_AD_RX_ARCA1_DVS_F_LAG	BIT(1)
	#define MISC_FT_STATUS_4_AD_RX_ARCA2_DVS_F_LAG	BIT(2)
	#define MISC_FT_STATUS_4_AD_RX_ARCA3_DVS_F_LAG	BIT(3)
	#define MISC_FT_STATUS_4_AD_RX_ARCA4_DVS_F_LAG	BIT(4)
	#define MISC_FT_STATUS_4_AD_RX_ARCA5_DVS_F_LAG	BIT(5)
	#define MISC_FT_STATUS_4_AD_RX_ARCKE0_DVS_F_LAG	BIT(6)
	#define MISC_FT_STATUS_4_AD_RX_ARCKE1_DVS_F_LAG	BIT(7)
	#define MISC_FT_STATUS_4_AD_RX_ARCS0_DVS_F_LAG	BIT(8)
	#define MISC_FT_STATUS_4_AD_RX_ARCS1_DVS_F_LAG	BIT(9)
	#define MISC_FT_STATUS_4_AD_RX_ARCA0_DVS_F_LEAD	BIT(16)
	#define MISC_FT_STATUS_4_AD_RX_ARCA1_DVS_F_LEAD	BIT(17)
	#define MISC_FT_STATUS_4_AD_RX_ARCA2_DVS_F_LEAD	BIT(18)
	#define MISC_FT_STATUS_4_AD_RX_ARCA3_DVS_F_LEAD	BIT(19)
	#define MISC_FT_STATUS_4_AD_RX_ARCA4_DVS_F_LEAD	BIT(20)
	#define MISC_FT_STATUS_4_AD_RX_ARCA5_DVS_F_LEAD	BIT(21)
	#define MISC_FT_STATUS_4_AD_RX_ARCKE0_DVS_F_LEAD	BIT(22)
	#define MISC_FT_STATUS_4_AD_RX_ARCKE1_DVS_F_LEAD	BIT(23)
	#define MISC_FT_STATUS_4_AD_RX_ARCS0_DVS_F_LEAD	BIT(24)
	#define MISC_FT_STATUS_4_AD_RX_ARCS1_DVS_F_LEAD	BIT(25)
#define MISC_STA_EXTLB_DBG0				0x000001c8
	#define MISC_STA_EXTLB_DBG0_STA_EXTLB_DVS_LEAD_0TO1	GENMASK(31, 0)
#define MISC_STA_EXTLB_DBG1				0x000001cc
	#define MISC_STA_EXTLB_DBG1_STA_EXTLB_DVS_LEAD_1TO0	GENMASK(31, 0)
#define MISC_STA_EXTLB_DBG2				0x000001d0
	#define MISC_STA_EXTLB_DBG2_STA_EXTLB_DVS_LAG_0TO1	GENMASK(31, 0)
#define MISC_STA_EXTLB_DBG3				0x000001d4
	#define MISC_STA_EXTLB_DBG3_STA_EXTLB_DVS_LAG_1TO0	GENMASK(31, 0)

#endif /*__DDRPHY_NAO_REG_H__*/
