/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef __DDRPHY_PLL_REG_H__
#define __DDRPHY_PLL_REG_H__

/* ----------------- Register Definitions ------------------- */
#define PLL1						0x00000000
	#define PLL1_RG_RPHYPLL_SDM_SSC_EN		BIT(2)
	#define PLL1_RG_RPHYPLL_EN			BIT(31)
#define PLL2						0x00000004
	#define PLL2_RG_RCLRPLL_SDM_SSC_EN		BIT(2)
	#define PLL2_RG_RCLRPLL_EN			BIT(31)
#define PLL3						0x00000008
	#define PLL3_RG_RPHYPLL_TSTOP_EN		BIT(0)
	#define PLL3_RG_RPHYPLL_TSTOD_EN		BIT(1)
	#define PLL3_RG_RPHYPLL_TSTFM_EN		BIT(2)
	#define PLL3_RG_RPHYPLL_TSTCK_EN		BIT(3)
	#define PLL3_RG_RPHYPLL_TST_EN			BIT(4)
	#define PLL3_RG_RPHYPLL_TSTLVROD_EN		BIT(5)
	#define PLL3_RG_RPHYPLL_TST_SEL			GENMASK(11, 8)
#define PLL4						0x0000000c
	#define PLL4_RG_RPHYPLL_RESETB			BIT(16)
	#define PLL4_RG_RPHYPLL_ATPG_EN			BIT(17)
	#define PLL4_RG_RPHYPLL_MCK8X_SEL		BIT(18)
	#define PLL4_PLL4_RFU				BIT(19)
	#define PLL4_RG_RPHYPLL_SER_MODE		BIT(20)
	#define PLL4_RG_RPHYPLL_AD_MCK8X_EN		BIT(21)
	#define PLL4_RG_RPHYPLL_ADA_MCK8X_EN		BIT(22)
	#define PLL4_RESERVED_0X0C			BIT(24)
#define PLL5						0x00000010
	#define PLL5_RESERVED_0X010			GENMASK(31, 0)
#define PLL6						0x00000014
	#define PLL6_RESERVED_0X014			GENMASK(31, 0)
#define PLL7						0x00000018
	#define PLL7_RESERVED_0X018			GENMASK(31, 0)
#define PLL8						0x0000001c
	#define PLL8_RESERVED_0X01C			GENMASK(31, 0)
#define PLL9						0x00000020
	#define PLL9_RESERVED_0X020			GENMASK(31, 0)
#define PLL10						0x00000024
	#define PLL10_RESERVED_0X024			GENMASK(31, 0)
#define PLL11						0x00000028
	#define PLL11_RESERVED_0X028			GENMASK(31, 0)
#define PLL12						0x0000002c
	#define PLL12_RESERVED_0X02C			GENMASK(31, 0)
#define PLL13						0x00000030
	#define PLL13_RESERVED_0X030			GENMASK(31, 0)
#define PLL14						0x00000034
	#define PLL14_RESERVED_0X034			GENMASK(31, 0)
#define PLL15						0x00000038
	#define PLL15_RESERVED_0X038			GENMASK(31, 0)
#define PLL16						0x0000003c
	#define PLL16_RESERVED_0X03C			GENMASK(31, 0)
#define SHU1_PLL0					0x00000d80
	#define SHU1_PLL0_RG_RPHYPLL_TOP_REV		GENMASK(15, 0)
	#define SHU1_PLL0_RG_RPHYPLL_LOAD_EN		BIT(19)
#define SHU1_PLL1					0x00000d84
	#define SHU1_PLL1_RG_RPHYPLLGP_CK_SEL		BIT(0)
	#define SHU1_PLL1_SHU1_PLL1_RFU			GENMASK(3, 1)
	#define SHU1_PLL1_R_SHU_AUTO_PLL_MUX		BIT(4)
	#define SHU1_PLL1_RESERVED_0XD84		GENMASK(31, 5)
#define SHU1_PLL2					0x00000d88
	#define SHU1_PLL2_RG_RCLRPLL_LOAD_EN		BIT(19)
#define SHU1_PLL3					0x00000d8c
	#define SHU1_PLL3_RESERVED_0XD8C		GENMASK(31, 0)
#define SHU1_PLL4					0x00000d90
	#define SHU1_PLL4_RG_RPHYPLL_RESERVED		GENMASK(15, 0)
	#define SHU1_PLL4_RG_RPHYPLL_FS			GENMASK(19, 18)
	#define SHU1_PLL4_RG_RPHYPLL_BW			GENMASK(22, 20)
	#define SHU1_PLL4_RG_RPHYPLL_ICHP		GENMASK(25, 24)
	#define SHU1_PLL4_RG_RPHYPLL_IBIAS		GENMASK(27, 26)
	#define SHU1_PLL4_RG_RPHYPLL_BLP		BIT(29)
	#define SHU1_PLL4_RG_RPHYPLL_BR			BIT(30)
	#define SHU1_PLL4_RG_RPHYPLL_BP			BIT(31)
#define SHU1_PLL5					0x00000d94
	#define SHU1_PLL5_RG_RPHYPLL_SDM_FRA_EN		BIT(0)
	#define SHU1_PLL5_RG_RPHYPLL_SDM_PCW_CHG	BIT(1)
	#define SHU1_PLL5_RG_RPHYPLL_SDM_PCW		GENMASK(31, 16)
#define SHU1_PLL6					0x00000d98
	#define SHU1_PLL6_RG_RCLRPLL_RESERVED		GENMASK(15, 0)
	#define SHU1_PLL6_RG_RCLRPLL_FS			GENMASK(19, 18)
	#define SHU1_PLL6_RG_RCLRPLL_BW			GENMASK(22, 20)
	#define SHU1_PLL6_RG_RCLRPLL_ICHP		GENMASK(25, 24)
	#define SHU1_PLL6_RG_RCLRPLL_IBIAS		GENMASK(27, 26)
	#define SHU1_PLL6_RG_RCLRPLL_BLP		BIT(29)
	#define SHU1_PLL6_RG_RCLRPLL_BR			BIT(30)
	#define SHU1_PLL6_RG_RCLRPLL_BP			BIT(31)
#define SHU1_PLL7					0x00000d9c
	#define SHU1_PLL7_RG_RCLRPLL_SDM_FRA_EN		BIT(0)
	#define SHU1_PLL7_RG_RCLRPLL_SDM_PCW_CHG	BIT(1)
	#define SHU1_PLL7_RG_RCLRPLL_SDM_PCW		GENMASK(31, 16)
#define SHU1_PLL8					0x00000da0
	#define SHU1_PLL8_RG_RPHYPLL_POSDIV		GENMASK(2, 0)
	#define SHU1_PLL8_RG_RPHYPLL_PREDIV		GENMASK(19, 18)
#define SHU1_PLL9					0x00000da4
	#define SHU1_PLL9_RG_RPHYPLL_RST_DLY		GENMASK(9, 8)
	#define SHU1_PLL9_RG_RPHYPLL_LVROD_EN		BIT(12)
	#define SHU1_PLL9_RG_RPHYPLL_MONREF_EN		BIT(13)
	#define SHU1_PLL9_RG_RPHYPLL_MONVC_EN		GENMASK(15, 14)
	#define SHU1_PLL9_RG_RPHYPLL_MONCK_EN		BIT(16)
#define SHU1_PLL10					0x00000da8
	#define SHU1_PLL10_RG_RCLRPLL_POSDIV		GENMASK(2, 0)
	#define SHU1_PLL10_RG_RCLRPLL_PREDIV		GENMASK(19, 18)
#define SHU1_PLL11					0x00000dac
	#define SHU1_PLL11_RG_RCLRPLL_RST_DLY		GENMASK(9, 8)
	#define SHU1_PLL11_RG_RCLRPLL_LVROD_EN		BIT(12)
	#define SHU1_PLL11_RG_RCLRPLL_MONREF_EN		BIT(13)
	#define SHU1_PLL11_RG_RCLRPLL_MONVC_EN		GENMASK(15, 14)
	#define SHU1_PLL11_RG_RCLRPLL_MONCK_EN		BIT(16)
#define SHU1_PLL12					0x00000db0
	#define SHU1_PLL12_RG_RCLRPLL_EXT_PODIV		GENMASK(5, 0)
	#define SHU1_PLL12_RG_RCLRPLL_BYPASS		BIT(6)
	#define SHU1_PLL12_RG_RCLRPLL_EXTPODIV_EN	BIT(7)
	#define SHU1_PLL12_RG_RCLRPLL_EXT_FBDIV		GENMASK(13, 8)
	#define SHU1_PLL12_RG_RCLRPLL_EXTFBDIV_EN	BIT(15)
	#define SHU1_PLL12_RG_RPHYPLL_EXT_FBDIV		GENMASK(21, 16)
	#define SHU1_PLL12_RG_RPHYPLL_EXTFBDIV_EN	BIT(22)
#define SHU1_PLL13					0x00000db4
	#define SHU1_PLL13_RG_RCLRPLL_FB_DL		GENMASK(5, 0)
	#define SHU1_PLL13_RG_RCLRPLL_REF_DL		GENMASK(13, 8)
	#define SHU1_PLL13_RG_RPHYPLL_FB_DL		GENMASK(21, 16)
	#define SHU1_PLL13_RG_RPHYPLL_REF_DL		GENMASK(29, 24)
#define SHU1_PLL14					0x00000db8
	#define SHU1_PLL14_RG_RPHYPLL_SDM_HREN		BIT(0)
	#define SHU1_PLL14_RG_RPHYPLL_SDM_SSC_PH_INIT	BIT(1)
	#define SHU1_PLL14_RG_RPHYPLL_SDM_SSC_PRD	GENMASK(31, 16)
#define SHU1_PLL15					0x00000dbc
	#define SHU1_PLL15_RG_RPHYPLL_SDM_SSC_DELTA	GENMASK(15, 0)
	#define SHU1_PLL15_RG_RPHYPLL_SDM_SSC_DELTA1	GENMASK(31, 16)
#define SHU1_PLL20					0x00000dd0
	#define SHU1_PLL20_RG_RCLRPLL_SDM_HREN		BIT(0)
	#define SHU1_PLL20_RG_RCLRPLL_SDM_SSC_PH_INIT	BIT(1)
	#define SHU1_PLL20_RG_RCLRPLL_SDM_SSC_PRD	GENMASK(31, 16)
#define SHU1_PLL21					0x00000dd4
	#define SHU1_PLL21_RG_RCLRPLL_SDM_SSC_DELTA	GENMASK(15, 0)
	#define SHU1_PLL21_RG_RCLRPLL_SDM_SSC_DELTA1	GENMASK(31, 16)
#define SHU2_PLL0					0x00001280
	#define SHU2_PLL0_RG_RPHYPLL_TOP_REV		GENMASK(15, 0)
	#define SHU2_PLL0_RG_RPHYPLL_LOAD_EN		BIT(19)
#define SHU2_PLL1					0x00001284
	#define SHU2_PLL1_RG_RPHYPLLGP_CK_SEL		BIT(0)
	#define SHU2_PLL1_SHU2_PLL1_RFU			GENMASK(3, 1)
	#define SHU2_PLL1_R_SHU_AUTO_PLL_MUX		BIT(4)
	#define SHU2_PLL1_RESERVED_0X1284		GENMASK(31, 5)
#define SHU2_PLL2					0x00001288
	#define SHU2_PLL2_RG_RCLRPLL_LOAD_EN		BIT(19)
#define SHU2_PLL3					0x0000128c
	#define SHU2_PLL3_RESERVED_0X128C		GENMASK(31, 0)
#define SHU2_PLL4					0x00001290
	#define SHU2_PLL4_RG_RPHYPLL_RESERVED		GENMASK(15, 0)
	#define SHU2_PLL4_RG_RPHYPLL_FS			GENMASK(19, 18)
	#define SHU2_PLL4_RG_RPHYPLL_BW			GENMASK(22, 20)
	#define SHU2_PLL4_RG_RPHYPLL_ICHP		GENMASK(25, 24)
	#define SHU2_PLL4_RG_RPHYPLL_IBIAS		GENMASK(27, 26)
	#define SHU2_PLL4_RG_RPHYPLL_BLP		BIT(29)
	#define SHU2_PLL4_RG_RPHYPLL_BR			BIT(30)
	#define SHU2_PLL4_RG_RPHYPLL_BP			BIT(31)
#define SHU2_PLL5					0x00001294
	#define SHU2_PLL5_RG_RPHYPLL_SDM_FRA_EN		BIT(0)
	#define SHU2_PLL5_RG_RPHYPLL_SDM_PCW_CHG	BIT(1)
	#define SHU2_PLL5_RG_RPHYPLL_SDM_PCW		GENMASK(31, 16)
#define SHU2_PLL6					0x00001298
	#define SHU2_PLL6_RG_RCLRPLL_RESERVED		GENMASK(15, 0)
	#define SHU2_PLL6_RG_RCLRPLL_FS			GENMASK(19, 18)
	#define SHU2_PLL6_RG_RCLRPLL_BW			GENMASK(22, 20)
	#define SHU2_PLL6_RG_RCLRPLL_ICHP		GENMASK(25, 24)
	#define SHU2_PLL6_RG_RCLRPLL_IBIAS		GENMASK(27, 26)
	#define SHU2_PLL6_RG_RCLRPLL_BLP		BIT(29)
	#define SHU2_PLL6_RG_RCLRPLL_BR			BIT(30)
	#define SHU2_PLL6_RG_RCLRPLL_BP			BIT(31)
#define SHU2_PLL7					0x0000129c
	#define SHU2_PLL7_RG_RCLRPLL_SDM_FRA_EN		BIT(0)
	#define SHU2_PLL7_RG_RCLRPLL_SDM_PCW_CHG	BIT(1)
	#define SHU2_PLL7_RG_RCLRPLL_SDM_PCW		GENMASK(31, 16)
#define SHU2_PLL8					0x000012a0
	#define SHU2_PLL8_RG_RPHYPLL_POSDIV		GENMASK(2, 0)
	#define SHU2_PLL8_RG_RPHYPLL_PREDIV		GENMASK(19, 18)
#define SHU2_PLL9					0x000012a4
	#define SHU2_PLL9_RG_RPHYPLL_RST_DLY		GENMASK(9, 8)
	#define SHU2_PLL9_RG_RPHYPLL_LVROD_EN		BIT(12)
	#define SHU2_PLL9_RG_RPHYPLL_MONREF_EN		BIT(13)
	#define SHU2_PLL9_RG_RPHYPLL_MONVC_EN		GENMASK(15, 14)
	#define SHU2_PLL9_RG_RPHYPLL_MONCK_EN		BIT(16)
#define SHU2_PLL10					0x000012a8
	#define SHU2_PLL10_RG_RCLRPLL_POSDIV		GENMASK(2, 0)
	#define SHU2_PLL10_RG_RCLRPLL_PREDIV		GENMASK(19, 18)
#define SHU2_PLL11					0x000012ac
	#define SHU2_PLL11_RG_RCLRPLL_RST_DLY		GENMASK(9, 8)
	#define SHU2_PLL11_RG_RCLRPLL_LVROD_EN		BIT(12)
	#define SHU2_PLL11_RG_RCLRPLL_MONREF_EN		BIT(13)
	#define SHU2_PLL11_RG_RCLRPLL_MONVC_EN		GENMASK(15, 14)
	#define SHU2_PLL11_RG_RCLRPLL_MONCK_EN		BIT(16)
#define SHU2_PLL12					0x000012b0
	#define SHU2_PLL12_RG_RCLRPLL_EXT_PODIV		GENMASK(5, 0)
	#define SHU2_PLL12_RG_RCLRPLL_BYPASS		BIT(6)
	#define SHU2_PLL12_RG_RCLRPLL_EXTPODIV_EN	BIT(7)
	#define SHU2_PLL12_RG_RCLRPLL_EXT_FBDIV		GENMASK(13, 8)
	#define SHU2_PLL12_RG_RCLRPLL_EXTFBDIV_EN	BIT(15)
	#define SHU2_PLL12_RG_RPHYPLL_EXT_FBDIV		GENMASK(21, 16)
	#define SHU2_PLL12_RG_RPHYPLL_EXTFBDIV_EN	BIT(22)
#define SHU2_PLL13					0x000012b4
	#define SHU2_PLL13_RG_RCLRPLL_FB_DL		GENMASK(5, 0)
	#define SHU2_PLL13_RG_RCLRPLL_REF_DL		GENMASK(13, 8)
	#define SHU2_PLL13_RG_RPHYPLL_FB_DL		GENMASK(21, 16)
	#define SHU2_PLL13_RG_RPHYPLL_REF_DL		GENMASK(29, 24)
#define SHU2_PLL14					0x000012b8
	#define SHU2_PLL14_RG_RPHYPLL_SDM_HREN		BIT(0)
	#define SHU2_PLL14_RG_RPHYPLL_SDM_SSC_PH_INIT	BIT(1)
	#define SHU2_PLL14_RG_RPHYPLL_SDM_SSC_PRD	GENMASK(31, 16)
#define SHU2_PLL15					0x000012bc
	#define SHU2_PLL15_RG_RPHYPLL_SDM_SSC_DELTA	GENMASK(15, 0)
	#define SHU2_PLL15_RG_RPHYPLL_SDM_SSC_DELTA1	GENMASK(31, 16)
#define SHU2_PLL20					0x000012d0
	#define SHU2_PLL20_RG_RCLRPLL_SDM_HREN		BIT(0)
	#define SHU2_PLL20_RG_RCLRPLL_SDM_SSC_PH_INIT	BIT(1)
	#define SHU2_PLL20_RG_RCLRPLL_SDM_SSC_PRD	GENMASK(31, 16)
#define SHU2_PLL21					0x000012d4
	#define SHU2_PLL21_RG_RCLRPLL_SDM_SSC_DELTA	GENMASK(15, 0)
	#define SHU2_PLL21_RG_RCLRPLL_SDM_SSC_DELTA1	GENMASK(31, 16)
#define SHU3_PLL0					0x00001780
	#define SHU3_PLL0_RG_RPHYPLL_TOP_REV		GENMASK(15, 0)
	#define SHU3_PLL0_RG_RPHYPLL_LOAD_EN		BIT(19)
#define SHU3_PLL1					0x00001784
	#define SHU3_PLL1_RG_RPHYPLLGP_CK_SEL		BIT(0)
	#define SHU3_PLL1_SHU3_PLL1_RFU			GENMASK(3, 1)
	#define SHU3_PLL1_R_SHU_AUTO_PLL_MUX		BIT(4)
	#define SHU3_PLL1_RESERVED_0X1784		GENMASK(31, 5)
#define SHU3_PLL2					0x00001788
	#define SHU3_PLL2_RG_RCLRPLL_LOAD_EN		BIT(19)
#define SHU3_PLL3					0x0000178c
	#define SHU3_PLL3_RESERVED_0X178C		GENMASK(31, 0)
#define SHU3_PLL4					0x00001790
	#define SHU3_PLL4_RG_RPHYPLL_RESERVED		GENMASK(15, 0)
	#define SHU3_PLL4_RG_RPHYPLL_FS			GENMASK(19, 18)
	#define SHU3_PLL4_RG_RPHYPLL_BW			GENMASK(22, 20)
	#define SHU3_PLL4_RG_RPHYPLL_ICHP		GENMASK(25, 24)
	#define SHU3_PLL4_RG_RPHYPLL_IBIAS		GENMASK(27, 26)
	#define SHU3_PLL4_RG_RPHYPLL_BLP		BIT(29)
	#define SHU3_PLL4_RG_RPHYPLL_BR			BIT(30)
	#define SHU3_PLL4_RG_RPHYPLL_BP			BIT(31)
#define SHU3_PLL5					0x00001794
	#define SHU3_PLL5_RG_RPHYPLL_SDM_FRA_EN		BIT(0)
	#define SHU3_PLL5_RG_RPHYPLL_SDM_PCW_CHG	BIT(1)
	#define SHU3_PLL5_RG_RPHYPLL_SDM_PCW		GENMASK(31, 16)
#define SHU3_PLL6					0x00001798
	#define SHU3_PLL6_RG_RCLRPLL_RESERVED		GENMASK(15, 0)
	#define SHU3_PLL6_RG_RCLRPLL_FS			GENMASK(19, 18)
	#define SHU3_PLL6_RG_RCLRPLL_BW			GENMASK(22, 20)
	#define SHU3_PLL6_RG_RCLRPLL_ICHP		GENMASK(25, 24)
	#define SHU3_PLL6_RG_RCLRPLL_IBIAS		GENMASK(27, 26)
	#define SHU3_PLL6_RG_RCLRPLL_BLP		BIT(29)
	#define SHU3_PLL6_RG_RCLRPLL_BR			BIT(30)
	#define SHU3_PLL6_RG_RCLRPLL_BP			BIT(31)
#define SHU3_PLL7					0x0000179c
	#define SHU3_PLL7_RG_RCLRPLL_SDM_FRA_EN		BIT(0)
	#define SHU3_PLL7_RG_RCLRPLL_SDM_PCW_CHG	BIT(1)
	#define SHU3_PLL7_RG_RCLRPLL_SDM_PCW		GENMASK(31, 16)
#define SHU3_PLL8					0x000017a0
	#define SHU3_PLL8_RG_RPHYPLL_POSDIV		GENMASK(2, 0)
	#define SHU3_PLL8_RG_RPHYPLL_PREDIV		GENMASK(19, 18)
#define SHU3_PLL9					0x000017a4
	#define SHU3_PLL9_RG_RPHYPLL_RST_DLY		GENMASK(9, 8)
	#define SHU3_PLL9_RG_RPHYPLL_LVROD_EN		BIT(12)
	#define SHU3_PLL9_RG_RPHYPLL_MONREF_EN		BIT(13)
	#define SHU3_PLL9_RG_RPHYPLL_MONVC_EN		GENMASK(15, 14)
	#define SHU3_PLL9_RG_RPHYPLL_MONCK_EN		BIT(16)
#define SHU3_PLL10					0x000017a8
	#define SHU3_PLL10_RG_RCLRPLL_POSDIV		GENMASK(2, 0)
	#define SHU3_PLL10_RG_RCLRPLL_PREDIV		GENMASK(19, 18)
#define SHU3_PLL11					0x000017ac
	#define SHU3_PLL11_RG_RCLRPLL_RST_DLY		GENMASK(9, 8)
	#define SHU3_PLL11_RG_RCLRPLL_LVROD_EN		BIT(12)
	#define SHU3_PLL11_RG_RCLRPLL_MONREF_EN		BIT(13)
	#define SHU3_PLL11_RG_RCLRPLL_MONVC_EN		GENMASK(15, 14)
	#define SHU3_PLL11_RG_RCLRPLL_MONCK_EN		BIT(16)
#define SHU3_PLL12					0x000017b0
	#define SHU3_PLL12_RG_RCLRPLL_EXT_PODIV		GENMASK(5, 0)
	#define SHU3_PLL12_RG_RCLRPLL_BYPASS		BIT(6)
	#define SHU3_PLL12_RG_RCLRPLL_EXTPODIV_EN	BIT(7)
	#define SHU3_PLL12_RG_RCLRPLL_EXT_FBDIV		GENMASK(13, 8)
	#define SHU3_PLL12_RG_RCLRPLL_EXTFBDIV_EN	BIT(15)
	#define SHU3_PLL12_RG_RPHYPLL_EXT_FBDIV		GENMASK(21, 16)
	#define SHU3_PLL12_RG_RPHYPLL_EXTFBDIV_EN	BIT(22)
#define SHU3_PLL13					0x000017b4
	#define SHU3_PLL13_RG_RCLRPLL_FB_DL		GENMASK(5, 0)
	#define SHU3_PLL13_RG_RCLRPLL_REF_DL		GENMASK(13, 8)
	#define SHU3_PLL13_RG_RPHYPLL_FB_DL		GENMASK(21, 16)
	#define SHU3_PLL13_RG_RPHYPLL_REF_DL		GENMASK(29, 24)
#define SHU3_PLL14					0x000017b8
	#define SHU3_PLL14_RG_RPHYPLL_SDM_HREN		BIT(0)
	#define SHU3_PLL14_RG_RPHYPLL_SDM_SSC_PH_INIT	BIT(1)
	#define SHU3_PLL14_RG_RPHYPLL_SDM_SSC_PRD	GENMASK(31, 16)
#define SHU3_PLL15					0x000017bc
	#define SHU3_PLL15_RG_RPHYPLL_SDM_SSC_DELTA	GENMASK(15, 0)
	#define SHU3_PLL15_RG_RPHYPLL_SDM_SSC_DELTA1	GENMASK(31, 16)
#define SHU3_PLL20					0x000017d0
	#define SHU3_PLL20_RG_RCLRPLL_SDM_HREN		BIT(0)
	#define SHU3_PLL20_RG_RCLRPLL_SDM_SSC_PH_INIT	BIT(1)
	#define SHU3_PLL20_RG_RCLRPLL_SDM_SSC_PRD	GENMASK(31, 16)
#define SHU3_PLL21					0x000017d4
	#define SHU3_PLL21_RG_RCLRPLL_SDM_SSC_DELTA	GENMASK(15, 0)
	#define SHU3_PLL21_RG_RCLRPLL_SDM_SSC_DELTA1	GENMASK(31, 16)
#define SHU4_PLL0					0x00001c80
	#define SHU4_PLL0_RG_RPHYPLL_TOP_REV		GENMASK(15, 0)
	#define SHU4_PLL0_RG_RPHYPLL_LOAD_EN		BIT(19)
#define SHU4_PLL1					0x00001c84
	#define SHU4_PLL1_RG_RPHYPLLGP_CK_SEL		BIT(0)
	#define SHU4_PLL1_SHU4_PLL1_RFU			GENMASK(3, 1)
	#define SHU4_PLL1_R_SHU_AUTO_PLL_MUX		BIT(4)
	#define SHU4_PLL1_RESERVED_0X1C84		GENMASK(31, 5)
#define SHU4_PLL2					0x00001c88
	#define SHU4_PLL2_RG_RCLRPLL_LOAD_EN		BIT(19)
#define SHU4_PLL3					0x00001c8c
	#define SHU4_PLL3_RESERVED_0X1C8C		GENMASK(31, 0)
#define SHU4_PLL4					0x00001c90
	#define SHU4_PLL4_RG_RPHYPLL_RESERVED		GENMASK(15, 0)
	#define SHU4_PLL4_RG_RPHYPLL_FS			GENMASK(19, 18)
	#define SHU4_PLL4_RG_RPHYPLL_BW			GENMASK(22, 20)
	#define SHU4_PLL4_RG_RPHYPLL_ICHP		GENMASK(25, 24)
	#define SHU4_PLL4_RG_RPHYPLL_IBIAS		GENMASK(27, 26)
	#define SHU4_PLL4_RG_RPHYPLL_BLP		BIT(29)
	#define SHU4_PLL4_RG_RPHYPLL_BR			BIT(30)
	#define SHU4_PLL4_RG_RPHYPLL_BP			BIT(31)
#define SHU4_PLL5					0x00001c94
	#define SHU4_PLL5_RG_RPHYPLL_SDM_FRA_EN		BIT(0)
	#define SHU4_PLL5_RG_RPHYPLL_SDM_PCW_CHG	BIT(1)
	#define SHU4_PLL5_RG_RPHYPLL_SDM_PCW		GENMASK(31, 16)
#define SHU4_PLL6					0x00001c98
	#define SHU4_PLL6_RG_RCLRPLL_RESERVED		GENMASK(15, 0)
	#define SHU4_PLL6_RG_RCLRPLL_FS			GENMASK(19, 18)
	#define SHU4_PLL6_RG_RCLRPLL_BW			GENMASK(22, 20)
	#define SHU4_PLL6_RG_RCLRPLL_ICHP		GENMASK(25, 24)
	#define SHU4_PLL6_RG_RCLRPLL_IBIAS		GENMASK(27, 26)
	#define SHU4_PLL6_RG_RCLRPLL_BLP		BIT(29)
	#define SHU4_PLL6_RG_RCLRPLL_BR			BIT(30)
	#define SHU4_PLL6_RG_RCLRPLL_BP			BIT(31)
#define SHU4_PLL7					0x00001c9c
	#define SHU4_PLL7_RG_RCLRPLL_SDM_FRA_EN		BIT(0)
	#define SHU4_PLL7_RG_RCLRPLL_SDM_PCW_CHG	BIT(1)
	#define SHU4_PLL7_RG_RCLRPLL_SDM_PCW		GENMASK(31, 16)
#define SHU4_PLL8					0x00001ca0
	#define SHU4_PLL8_RG_RPHYPLL_POSDIV		GENMASK(2, 0)
	#define SHU4_PLL8_RG_RPHYPLL_PREDIV		GENMASK(19, 18)
#define SHU4_PLL9					0x00001ca4
	#define SHU4_PLL9_RG_RPHYPLL_RST_DLY		GENMASK(9, 8)
	#define SHU4_PLL9_RG_RPHYPLL_LVROD_EN		BIT(12)
	#define SHU4_PLL9_RG_RPHYPLL_MONREF_EN		BIT(13)
	#define SHU4_PLL9_RG_RPHYPLL_MONVC_EN		GENMASK(15, 14)
	#define SHU4_PLL9_RG_RPHYPLL_MONCK_EN		BIT(16)
#define SHU4_PLL10					0x00001ca8
	#define SHU4_PLL10_RG_RCLRPLL_POSDIV		GENMASK(2, 0)
	#define SHU4_PLL10_RG_RCLRPLL_PREDIV		GENMASK(19, 18)
#define SHU4_PLL11					0x00001cac
	#define SHU4_PLL11_RG_RCLRPLL_RST_DLY		GENMASK(9, 8)
	#define SHU4_PLL11_RG_RCLRPLL_LVROD_EN		BIT(12)
	#define SHU4_PLL11_RG_RCLRPLL_MONREF_EN		BIT(13)
	#define SHU4_PLL11_RG_RCLRPLL_MONVC_EN		GENMASK(15, 14)
	#define SHU4_PLL11_RG_RCLRPLL_MONCK_EN		BIT(16)
#define SHU4_PLL12					0x00001cb0
	#define SHU4_PLL12_RG_RCLRPLL_EXT_PODIV		GENMASK(5, 0)
	#define SHU4_PLL12_RG_RCLRPLL_BYPASS		BIT(6)
	#define SHU4_PLL12_RG_RCLRPLL_EXTPODIV_EN	BIT(7)
	#define SHU4_PLL12_RG_RCLRPLL_EXT_FBDIV		GENMASK(13, 8)
	#define SHU4_PLL12_RG_RCLRPLL_EXTFBDIV_EN	BIT(15)
	#define SHU4_PLL12_RG_RPHYPLL_EXT_FBDIV		GENMASK(21, 16)
	#define SHU4_PLL12_RG_RPHYPLL_EXTFBDIV_EN	BIT(22)
#define SHU4_PLL13					0x00001cb4
	#define SHU4_PLL13_RG_RCLRPLL_FB_DL		GENMASK(5, 0)
	#define SHU4_PLL13_RG_RCLRPLL_REF_DL		GENMASK(13, 8)
	#define SHU4_PLL13_RG_RPHYPLL_FB_DL		GENMASK(21, 16)
	#define SHU4_PLL13_RG_RPHYPLL_REF_DL		GENMASK(29, 24)
#define SHU4_PLL14					0x00001cb8
	#define SHU4_PLL14_RG_RPHYPLL_SDM_HREN		BIT(0)
	#define SHU4_PLL14_RG_RPHYPLL_SDM_SSC_PH_INIT	BIT(1)
	#define SHU4_PLL14_RG_RPHYPLL_SDM_SSC_PRD	GENMASK(31, 16)
#define SHU4_PLL15					0x00001cbc
	#define SHU4_PLL15_RG_RPHYPLL_SDM_SSC_DELTA	GENMASK(15, 0)
	#define SHU4_PLL15_RG_RPHYPLL_SDM_SSC_DELTA1	GENMASK(31, 16)
#define SHU4_PLL20					0x00001cd0
	#define SHU4_PLL20_RG_RCLRPLL_SDM_HREN		BIT(0)
	#define SHU4_PLL20_RG_RCLRPLL_SDM_SSC_PH_INIT	BIT(1)
	#define SHU4_PLL20_RG_RCLRPLL_SDM_SSC_PRD	GENMASK(31, 16)
#define SHU4_PLL21					0x00001cd4
	#define SHU4_PLL21_RG_RCLRPLL_SDM_SSC_DELTA	GENMASK(15, 0)
	#define SHU4_PLL21_RG_RCLRPLL_SDM_SSC_DELTA1	GENMASK(31, 16)

#endif /*__DDRPHY_PLL_REG_H__*/
