#ifndef GLOBALIZATION_H
#define GLOBALIZATION_H

#include <QtCore>
#include <QLocale>

#include "../cplugin.h"

class Globalization: public CPlugin {
    Q_OBJECT
    enum GlobalizationError {
        UNKNOWN_ERROR = 0,
        FORMATTING_ERROR = 1,
        PARSING_ERROR = 2,
        PATTERN_ERROR = 3
    };

    enum Selector {
        SELECTOR_DATE = 0,
        SELECTOR_TIME = 1,
        SELECTOR_ALL = 2
    };

    enum Format {
        FORMAT_SHORT = 0,
        FORMAT_MEDIUM = 1,
        FORMAT_LONG = 2,
        FORMAT_FULL = 3
    };

    enum {
        REQUEST_DAY_NAMES = 0,
        REQUEST_MONTH_NAMES = 1
    };

    enum NumberType {
        DECIMAL,
        PERCENT,
        CURRENCY
    };

public:
    explicit Globalization(Cordova *cordova);

    virtual const QString fullName() override {
        return Globalization::fullID();
    }

    virtual const QString shortName() override {
        return "Globalization";
    }

    static const QString fullID() {
        return "com.cordova.Globalization";
    }

public slots:
    void getPreferredLanguage(int scId, int ecId, QVariantMap p_options);
    void isDayLightSavingsTime(int scId, int ecId, QVariantMap p_options);
    void getFirstDayOfWeek(int scId, int ecId, QVariantMap p_options);
    void dateToString(int scId, int ecId, QVariantMap p_options);
    void stringToDate(int scId, int ecId, QVariantMap p_options);
    void getDateNames(int scId, int ecId, QVariantMap p_options);
    void numberToString(int scId, int ecId, QVariantMap p_options);
    void stringToNumber(int scId, int ecId, int type, QString string);
    void getNumberPattern(int scId, int ecId, int type);
    void getDatePattern(int scId, int ecId, int formatLength, int selector);

private:
    friend QLocale::FormatType translateFormat(Globalization::Format formatLength);
    template<class T> friend QString format(T number, Globalization::NumberType type);
};

#endif // GLOBALIZATION_H
