# CiviCRM 5.32.0

Released December 2, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Display public title and description on profiles and unsubscribe/subscribe
  forms as appropriate if set
  ([18645](https://github.com/civicrm/civicrm-core/pull/18645))**

  Starts to make use of the new front end title and description fields on
  unsubscribe, subscribe and user dashboard pages.

- **Allow custom fields of type Autocomplete-Select to be multivalued
  ([18449](https://github.com/civicrm/civicrm-core/pull/18449))**

  Adds support for multi-select for auto-complete custom fields.

- **Add more columns for Activity Report (Work towards
  [dev/core#2104](https://lab.civicrm.org/dev/core/-/issues/2104):
  [18827](https://github.com/civicrm/civicrm-core/pull/18827) and
  [18840](https://github.com/civicrm/civicrm-core/pull/18840))**

  Improves the Activity Report by adding columns for:
    - Birth Date of the target contact
    - Gender of the target contact

- **More accurate language around social media sharing
  ([18743](https://github.com/civicrm/civicrm-core/pull/18743))**

  Improves user experience by clarifying language around social media sharing.

- **Adds performance improvement when browsing the report logs
  ([18851](https://github.com/civicrm/civicrm-core/pull/18851))**

  Improves performance when browsing the logs.

- **Clean up search actions in core to make them available from search builder
  (Work Towards [dev/core#2066](https://lab.civicrm.org/dev/core/-/issues/2066):
  [18773](https://github.com/civicrm/civicrm-core/pull/18773),
  [18783](https://github.com/civicrm/civicrm-core/pull/18783),
  [18768](https://github.com/civicrm/civicrm-core/pull/18768) and
  [18767](https://github.com/civicrm/civicrm-core/pull/18767))**

  Preliminary cleanup of code to move towards making search actions available
  from search builder.

- **Search Kit: Lotsa new features
  ([18876](https://github.com/civicrm/civicrm-core/pull/18876))**

  Integrates Search Kit/Afform. Adds a standalone page for viewing search kit
  displays. Adds first search kit display type "table". Adds search kit display
  entity and UI. Adds CRUD form for managing saved search kit searches.

- **Search Kit: Add links to search admin and improve links in displays
  ([18909](https://github.com/civicrm/civicrm-core/pull/18909))**

  Improves links in search kit results.

- **Search Kit: Bind parameters to URL
  ([#18976](https://github.com/civicrm/civicrm-core/pull/18976))**

- **Search Kit: Add "List" display. Fix other bugs.
  ([#18999](https://github.com/civicrm/civicrm-core/pull/18999))**

- **Search Kit: Improve options in "List" search display
  ([19031](https://github.com/civicrm/civicrm-core/pull/19031/files))**

- **SavedSearch - Add name and label columns
  ([18809](https://github.com/civicrm/civicrm-core/pull/18809))**

  Adds 2 database columns: `name` and `label` for the SavedSearch entity. This
  is needed by the new Search Kit extension.

- **Add entity paths to schema & APIv4
  ([18887](https://github.com/civicrm/civicrm-core/pull/18887))**

  Adds metadata to some entities (hopefully more will be added in the
  future) for the paths at which they can be created/updated/viewed/deleted. The
  metadata is accessed via the DAO, and exposed to APIv4.

- **Use standard names for entity paths and add a few more paths
  ([18915](https://github.com/civicrm/civicrm-core/pull/18915))**

  Standardizes entity paths.

- **APIv4 - Add `$result->single()` helper
  ([18871](https://github.com/civicrm/civicrm-core/pull/18871))**

  Improves developer-experience when using APIv4 by adding a helper function to
  retrieve just one result.

- **Update CRM_Utils_Constant::value to support env variables
  ([18806](https://github.com/civicrm/civicrm-core/pull/18806))**

  Extends the ability to set a variable using env to any variable accessed via
  CRM_Utils_Constant::value.

- **Angular Loader: Allow modules to specify permissions to add client-side
  ([18754](https://github.com/civicrm/civicrm-core/pull/18754))**

  Makes it possible for angular modules to define permissions.

- **AngularLoader: Support 'settingsFactory' callbacks in angular modules.
  ([18731](https://github.com/civicrm/civicrm-core/pull/18731))**

  Allows Angular modules with complex/expensive data to provide it with a
  callback, which will only be invoked if the module is actively loaded on the
  page.

### CiviContribute

- **Use of <th> tags for labels on Contribution Amounts tab gives them unique
  styling
  ([dev/user-interface#34](https://lab.civicrm.org/dev/user-interface/-/issues/34):
  [18850](https://github.com/civicrm/civicrm-core/pull/18850))**

  Makes the look and feel when configuring Contribution Forms more consistent.

- **[Meta] Does CiviCRM have a single defined application HTTP entry point which
  routes all requests?
  (Work Towards [dev/cloud-native#16](https://lab.civicrm.org/dev/cloud-native/-/issues/16):
  [17969](https://github.com/civicrm/civicrm-core/pull/17969))**

  Migrates the Contribution Page widget extern url to use the normal CMS routing
  mechanism.

- **Add UI metadata for payment_processor_id on financialTrxn
  ([18917](https://github.com/civicrm/civicrm-core/pull/18917))**

  Improve metadata for `financialTrxn`.

### CiviMail

- **OAuth2 Client ([dev/core#2141](https://lab.civicrm.org/dev/core/-/issues/2141):
  [18902](https://github.com/civicrm/civicrm-core/pull/18902),
  [18914](https://github.com/civicrm/civicrm-core/pull/18914),
  [18885](https://github.com/civicrm/civicrm-core/pull/18885),
  [18908](https://github.com/civicrm/civicrm-core/pull/18908),
  [18943](https://github.com/civicrm/civicrm-core/pull/18943),
  [18955](https://github.com/civicrm/civicrm-core/pull/18955),
  [18951](https://github.com/civicrm/civicrm-core/pull/18951), and
  [19001](https://github.com/civicrm/civicrm-core/pull/19001))**

  Adds a new hook `hook_civicrm_alterMailStore` which can be used to add or
  modify a driver. Adds a hidden `oauth-client` extension for connecting to
  OAuth2-based-web-services. Adds a UI to "Add Mail Account". Adds two
  libraries: "league/oauth2-client" and "league/oauth2-google".

- **MailSettings - Add button+API for testing a connection
  ([18911](https://github.com/civicrm/civicrm-core/pull/18911))**

  Adds a button (and API action) to the Edit Mail Account form to test the
  connection.

- **Add postProcess hook to MessageTemplates
  ([18807](https://github.com/civicrm/civicrm-core/pull/18807))**

  Makes it so extension developers can use the 'postProcess' hook to access
  'MessageTemplates'.

### WordPress Integration

- **MySQL socket while using CiviCRM installer
  ([dev/wordpress#35](https://lab.civicrm.org/dev/wordpress/-/issues/35):
  [18913](https://github.com/civicrm/civicrm-core/pull/18913))**

  Ensures `civicrm-setup` can handle database connections with unix sockets.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Fix main contact uf url on merge screen
  ([18742](https://github.com/civicrm/civicrm-core/pull/18742))**

  Ensures the UF url of the main contact on the merge screen points to the
  correct user.

- **Fix sendconfirmation api to override receipt params
  ([18789](https://github.com/civicrm/civicrm-core/pull/18789))**

  Ensures params in `sendconfirmation` API take precedence over receipt params.

- **"Non-static method CRM_Contact_Page_AJAX::pdfFormat() should not be called
  statically" when changing the page format on print/merge document
  ([dev/core#2110](https://lab.civicrm.org/dev/core/-/issues/2110):
  [18726](https://github.com/civicrm/civicrm-core/pull/18726))**

  Fixes notices when generating PDFs.

- **updated italian provinces
  ([18859](https://github.com/civicrm/civicrm-core/pull/18859))**

  Ensures that the right abbreviations are used for Italian provinces.

- **APIv4 Activity::update() causes target contacts and assignees to be deleted
  ([dev/core#1428](https://lab.civicrm.org/dev/core/-/issues/1428):
  [18720](https://github.com/civicrm/civicrm-core/pull/18720))**

  Adds a test.

- **APIv4 - Fix type coersion of non-string input
  ([18860](https://github.com/civicrm/civicrm-core/pull/18860))**

  Fixes APIv4 to not accidentally change non-string input to string.

- **Participant Calculate/Fees: fix ts usage, simplify wording
  ([18874](https://github.com/civicrm/civicrm-core/pull/18874))**

  Fixes an incorrect use of ts, which assumes how strings can be concatenated.
  It also makes it difficult to use Word Replacements.

- **Cancel first contribution associated to membership, cancels the membership
  ([dev/core#927](https://lab.civicrm.org/dev/core/-/issues/927):
  [18814](https://github.com/civicrm/civicrm-core/pull/18814),
  [18812](https://github.com/civicrm/civicrm-core/pull/18812),
  [18853](https://github.com/civicrm/civicrm-core/pull/18853),
  [18786](https://github.com/civicrm/civicrm-core/pull/18786),
  [18881](https://github.com/civicrm/civicrm-core/pull/18881),
  [18813](https://github.com/civicrm/civicrm-core/pull/18813) and
  [18784](https://github.com/civicrm/civicrm-core/pull/18784))**

- **When default changed for an alphanumeric multi-select custom field
  defaulting breaks for that field on backend
  forms.([dev/core#2139](https://lab.civicrm.org/dev/core/-/issues/2139):
  [18907](https://github.com/civicrm/civicrm-core/pull/18907))**

- **Long cyrillic names give error Data too long for column sort_name when
  saving a contact
  ([dev/core#2146](https://lab.civicrm.org/dev/core/-/issues/2146):
  [18862](https://github.com/civicrm/civicrm-core/pull/18862))**

- **Incorrect use of quotes and escape and ts in CRM_Core_DAO::copyValues
  ([dev/core#2148](https://lab.civicrm.org/dev/core/-/issues/2148):
  [18864](https://github.com/civicrm/civicrm-core/pull/18864))**

- **CiviCRM reCAPTCHA Util not validating user tokens on form submission
  ([dev/core#2150](https://lab.civicrm.org/dev/core/-/issues/2150):
  [18872](https://github.com/civicrm/civicrm-core/pull/18872) and
  [311](https://github.com/civicrm/civicrm-packages/pull/311))**

- **Fix the Test Result (1 failure / -190)
  E2E.Core.PrevNextTest.testDeleteByCacheKey recurring test issue
  ([dev/core#2029](https://lab.civicrm.org/dev/core/-/issues/2029):
  [18846](https://github.com/civicrm/civicrm-core/pull/18846))**

- **Merge - ensure location entities remaining on deleted contacts have
  is_primary integrity
  ([dev/core#2047](https://lab.civicrm.org/dev/core/-/issues/2047):
  [18555](https://github.com/civicrm/civicrm-core/pull/18555))**

- **Eliminate unused query on CRM_Core_BAO_CustomQuery::_construct
  ([dev/core#2079](https://lab.civicrm.org/dev/core/-/issues/2079):
  [18668](https://github.com/civicrm/civicrm-core/pull/18668))**

- **get log date from tables available in query with data instead of last table
  ([18868](https://github.com/civicrm/civicrm-core/pull/18868))**

- **Search ext: Fix validation and saving on search admin screen
  ([18919](https://github.com/civicrm/civicrm-core/pull/18919))**

- **CRM_Core_Error::formatFooException - Don't bomb on 'Error'
  ([18910](https://github.com/civicrm/civicrm-core/pull/18910))**

- **ClassLoader - Fix autoloading of `API_Exception`
  ([18870](https://github.com/civicrm/civicrm-core/pull/18870))**

- **SavedSearch: add UI_name index to upgrade script
  ([18811](https://github.com/civicrm/civicrm-core/pull/18811))**

- **Fix pluralize function for words like 'display'
  ([18778](https://github.com/civicrm/civicrm-core/pull/18778))**

- **class.api.php: In remote api calls, allow referer and useragent to be set.
  ([18400](https://github.com/civicrm/civicrm-core/pull/18400))**

- **Typo in call to fixSchemaDifferencesForAll
  ([18762](https://github.com/civicrm/civicrm-core/pull/18762))**

- **Rationalise date formatting
  ([18805](https://github.com/civicrm/civicrm-core/pull/18805))**

- **Fix filter for users who have permission "view deleted contacts"
  ([19088](https://github.com/civicrm/civicrm-core/pull/19088))**


### CiviCampaign

- **Fix campaign_id handling for batch entry
  ([18792](https://github.com/civicrm/civicrm-core/pull/18792))**

  Fixes a bug whereby `campaign_id` is not updated on batch entry if it has been
  added to the profile.

### CiviCase

- **Merging contacts removes case roles
  ([dev/core#2152](https://lab.civicrm.org/dev/core/-/issues/2152):
  [18884](https://github.com/civicrm/civicrm-core/pull/18884))**

- **Fix deprecation notice
  ([dev/core#2205](https://lab.civicrm.org/dev/core/-/issues/2205): [#19018](https://github.com/civicrm/civicrm-core/pull/19018))**

### CiviContribute

- **finish 'this round' of completeOrder cleanup
  ([dev/financial#152](https://lab.civicrm.org/dev/financial/-/issues/152):
  [18631](https://github.com/civicrm/civicrm-core/pull/18631),
  [18734](https://github.com/civicrm/civicrm-core/pull/18734),
  [18732](https://github.com/civicrm/civicrm-core/pull/18732),
  [18733](https://github.com/civicrm/civicrm-core/pull/18733),
  [18728](https://github.com/civicrm/civicrm-core/pull/18728),
  [18629](https://github.com/civicrm/civicrm-core/pull/18629),
  [18835](https://github.com/civicrm/civicrm-core/pull/18835),
  [18730](https://github.com/civicrm/civicrm-core/pull/18730),
  [18729](https://github.com/civicrm/civicrm-core/pull/18729).
  [18737](https://github.com/civicrm/civicrm-core/pull/18737),
  [18735](https://github.com/civicrm/civicrm-core/pull/18735),
  [18744](https://github.com/civicrm/civicrm-core/pull/18744),
  [18736](https://github.com/civicrm/civicrm-core/pull/18736) and
  [18815](https://github.com/civicrm/civicrm-core/pull/18815))**

  Cleans up how `completeOrder` deals with `payment_processor_id` (solely as an
  input param).

- **Thank-you letter incorrect contribution currency
  ([dev/financial#111](https://lab.civicrm.org/dev/financial/-/issues/111):
  [18714](https://github.com/civicrm/civicrm-core/pull/18714) and
  [18715](https://github.com/civicrm/civicrm-core/pull/18715))**

  Ensures that when a contribution is made using a currency other than the
  default currency, the contribution tokens: {contribution.total_amount}
  {contribution.fee_amount} {contribution.net_amount} correctly display the
  currency.

- **PayPal payment processor uses deprecated methods, breaking functionality
  (Work Towards [dev/core#2034](https://lab.civicrm.org/dev/core/-/issues/2034):
  [18540](https://github.com/civicrm/civicrm-core/pull/18540))**

  Fixes the PayPal standard cancel url.

- **Declare support for cancelRecurring in manual processor
  ([18804](https://github.com/civicrm/civicrm-core/pull/18804))**

  Ensure that when no processor id is present the cancel form is loaded (as
  opposed to the enable-disable form).

- **Refund status not set correctly when cancelled_payment_id is set
  ([dev/financial#156](https://lab.civicrm.org/dev/financial/-/issues/156):
  [18930](https://github.com/civicrm/civicrm-core/pull/18930))**

- **Contribution confirmation page should not display the name of payment
  processor type ([17568](https://github.com/civicrm/civicrm-core/pull/17568))**

- **PCP 'Your Message' should use WYSIWYG
  ([18411](https://github.com/civicrm/civicrm-core/pull/18411))**

- **Fix fatal error on "Edit Contribution" form
  ([19091](https://github.com/civicrm/civicrm-core/pull/19091))**

- **Fix product form such that it is possible to unselec duration unit, frequency unit
  ([dev/drupal#148](https://lab.civicrm.org/dev/drupal/-/issues/148): [19084](https://github.com/civicrm/civicrm-core/pull/19084))**


### CiviEvent

- **.ical files not populating correctly for sites with ACL's configured for
  events ([dev/core#1879](https://lab.civicrm.org/dev/core/-/issues/1879):
  [18712](https://github.com/civicrm/civicrm-core/pull/18712))**

### CiviMail

- **Set id after save for the mailing component in the postProcess
  ([18808](https://github.com/civicrm/civicrm-core/pull/18808))**

- **"Notice: Undefined index: domain" when deleting a mail account
  ([dev/core#2166](https://lab.civicrm.org/dev/core/-/issues/2166):
  [18927](https://github.com/civicrm/civicrm-core/pull/18927))**

- **crmMailing - Only load Angular settings if they're needed
  ([18749](https://github.com/civicrm/civicrm-core/pull/18749))**

- **Error when changing "Location Type"
  ([dev/core#2228](https://lab.civicrm.org/dev/core/-/issues/2228): [19092](https://github.com/civicrm/civicrm-core/pull/19092))**

### CiviSMS

- **Error in the selected phone to send an SMS when the Mobile type label is
  modified ([dev/core#2138](https://lab.civicrm.org/dev/core/-/issues/2138):
  [18842](https://github.com/civicrm/civicrm-core/pull/18842))**

- **Show only Active SMS provider List on Mass SMS form
  ([18867](https://github.com/civicrm/civicrm-core/pull/18867))**

### Backdrop Integration

- **Override sessionStart function and use backdrop functions as appropriate
  (related to
  [backdrop#116](https://github.com/civicrm/civicrm-backdrop/issues/116):
  [18745](https://github.com/civicrm/civicrm-core/pull/18745))**

  Overrides the backdrop Session start function in DrupalBase.php to use the
  backdrop specific functions

- **Resolve #110 Sync repo with CiviCRM-Drupal repo
  ([115](https://github.com/civicrm/civicrm-backdrop/pull/115))**

### Drupal Integration

- **Do not manually construct the site path during Drupal8+ setup
  ([dev/core#2140](https://lab.civicrm.org/dev/core/-/issues/2140):
  [18843](https://github.com/civicrm/civicrm-core/pull/18843))**

- **D8 Install checks run via Drupal Status Report - gives misleading warnings.
  ([dev/drupal#137](https://lab.civicrm.org/dev/drupal/-/issues/137):
  [18581](https://github.com/civicrm/civicrm-core/pull/18581))**

### Joomla Integration

- **[Joomla 4.0] CiviCRM cannot be installed on Joomla 4.0 alpha
  ([dev/joomla#14](https://lab.civicrm.org/dev/joomla/-/issues/14):
  [52](https://github.com/civicrm/civicrm-joomla/pull/52))**

### Wordpress Integration

- **Protect against undefined index query in heartbeat callback
  ([220](https://github.com/civicrm/civicrm-wordpress/pull/220))**

## <a name="misc"></a>Miscellany

- **_Composer Patches_: Update to v1.7.0. Support Composer v2. ([#18940](https://github.com/civicrm/civicrm-core/pull/18940))**

- **Schema handler fixes
  ([18932](https://github.com/civicrm/civicrm-core/pull/18932))**

- **[cq] Do not pass by reference where avoidable
  ([dev/core#2043](https://lab.civicrm.org/dev/core/-/issues/2043):
  [18802](https://github.com/civicrm/civicrm-core/pull/18802))**

- **Move financialACLs to a core extension (Work Towards
  [dev/core#2115](https://lab.civicrm.org/dev/core/-/issues/2115):
  [18738](https://github.com/civicrm/civicrm-core/pull/18738) and
  [18740](https://github.com/civicrm/civicrm-core/pull/18740))**

- **Move call to update related pledges on contribution cancel to extension
  ([18894](https://github.com/civicrm/civicrm-core/pull/18894))**

- **Move filtering of unpermitted options for reports/ search select to
  financialacl extension
  ([18849](https://github.com/civicrm/civicrm-core/pull/18849))**

- **Move CRM_Member_BAO_MembershipType::getPermissionedMembershipTypes to
  financial acl extension
  ([18848](https://github.com/civicrm/civicrm-core/pull/18848))**

- **Replace BAO calls with api calls in test class
  ([18798](https://github.com/civicrm/civicrm-core/pull/18798))**

- **Switch to calling api
  ([18797](https://github.com/civicrm/civicrm-core/pull/18797))**

- **Switch to calling the api
  ([18796](https://github.com/civicrm/civicrm-core/pull/18796))**

- **Extract setNextUrl
  ([18750](https://github.com/civicrm/civicrm-core/pull/18750))**

- **Deprecate hook_civicrm_crudLink
  ([18888](https://github.com/civicrm/civicrm-core/pull/18888))**

- **Fix extension generated DAO files to pass civilint
  ([18879](https://github.com/civicrm/civicrm-core/pull/18879))**

- **Hack away at false negative test fails
  ([18892](https://github.com/civicrm/civicrm-core/pull/18892))**

- **Search Kit - Fix search action button
  ([19055](https://github.com/civicrm/civicrm-core/pull/19055))**

- **Release Notes: Add 5.32.0
  ([#18958](https://github.com/civicrm/civicrm-core/pull/18958), [#18945](https://github.com/civicrm/civicrm-core/pull/18945))**

- **Release Notes: Add 5.31.1
  ([#19029](https://github.com/civicrm/civicrm-core/pull/19029))**

- **Remove always-true IF
  ([18803](https://github.com/civicrm/civicrm-core/pull/18803))**

- **Remove always true if
  ([18801](https://github.com/civicrm/civicrm-core/pull/18801))**

- **Remove always-true & otherwise silly if
  ([18883](https://github.com/civicrm/civicrm-core/pull/18883))**

- **Remove IPN reference to _relatedObjects, deprecate property
  ([18895](https://github.com/civicrm/civicrm-core/pull/18895))**

- **Remove deprecated code
  ([18903](https://github.com/civicrm/civicrm-core/pull/18903))**

- **Remove a few lines of deprecated code
  ([18826](https://github.com/civicrm/civicrm-core/pull/18826))**

- **Remove instances of variable variables
  ([18791](https://github.com/civicrm/civicrm-core/pull/18791))**

- **Remove meaningless legacy code
  ([18856](https://github.com/civicrm/civicrm-core/pull/18856))**

- **Refactor entityParams in Order.Create API so it is easier to
  understand/modify
  ([18306](https://github.com/civicrm/civicrm-core/pull/18306))**

- **[REF] Minor simplification - don't use a variable for table name
  ([18651](https://github.com/civicrm/civicrm-core/pull/18651))**

- **[REF] Remove silly if
  ([18897](https://github.com/civicrm/civicrm-core/pull/18897))**

- **[Ref] Move sending the email back out of the recur function
  ([18852](https://github.com/civicrm/civicrm-core/pull/18852))**

- **[Ref] Use direct version of participant id
  ([18882](https://github.com/civicrm/civicrm-core/pull/18882))**

- **[Ref] Simplify params
  ([18896](https://github.com/civicrm/civicrm-core/pull/18896))**

- **[REF] Simplify use of shared code.
  ([18900](https://github.com/civicrm/civicrm-core/pull/18900))**

- **[REF] Minor extraction
  ([18829](https://github.com/civicrm/civicrm-core/pull/18829))**

- **[REF] Determine values where they are needed rather than passing them
  around (in tested function)
  ([18837](https://github.com/civicrm/civicrm-core/pull/18837))**

- **[REF] Include contributioncancelactions extension in dismaker and reg…
  ([18825](https://github.com/civicrm/civicrm-core/pull/18825))**

- **[REF] Extract handling for loading contribution recur object.
  ([18746](https://github.com/civicrm/civicrm-core/pull/18746))**

- **[REF] Replace long if block with early return
  ([18747](https://github.com/civicrm/civicrm-core/pull/18747))**

- **[REF] Upgrade DomPDF to v0.8.6
  ([18688](https://github.com/civicrm/civicrm-core/pull/18688))**

- **[REF]  Separate export form classes out & simplify task handling
  ([18589](https://github.com/civicrm/civicrm-core/pull/18589))**

- **[REF] Search ext: Reorganize code into modules
  ([18775](https://github.com/civicrm/civicrm-core/pull/18775))**

- **[Ref] Minor code extraction
  ([18739](https://github.com/civicrm/civicrm-core/pull/18739))**

- **[Test] - Fix some tests to call API not BAO
  ([18795](https://github.com/civicrm/civicrm-core/pull/18795))**

- **[Test] Ensure all APIv4 entities have basic info
  ([18727](https://github.com/civicrm/civicrm-core/pull/18727))**

- **Test for event#43
  ([18761](https://github.com/civicrm/civicrm-core/pull/18761))**

- **Add test for recurring links and clean up method of retrieving recurring
  ([18790](https://github.com/civicrm/civicrm-core/pull/18790))**

- **unit test for #18306 - order create api test for contribution
  ([18785](https://github.com/civicrm/civicrm-core/pull/18785))**

- **(NFC) Update cache/integration-tests
  ([19076](https://github.com/civicrm/civicrm-core/pull/19076))**

- **(NFC) Fix typo in Money valueFormat depretation warning
  ([18886](https://github.com/civicrm/civicrm-core/pull/18886))**

- **(NFC) Make assertions in PrevNextTest more skimmable
  ([dev/core#2029](https://lab.civicrm.org/dev/core/-/issues/2029):
  [18822](https://github.com/civicrm/civicrm-core/pull/18822))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; Agileware - Francis Whittle, Justin
Freeman, Pengyi Zhang; Andrew Thompson; Christian Wach; Circle Interactive -
Pradeep Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Sunil Pawar, Yashodha Chaku; CiviFirst - John Kirk; CompuCorp -
Debarshi Bhaumik; Coop SymbioTIC - Mathieu Lutfy; Dave D; Diego Muñio; Freeform
Solutions - Herb van den Dool; Fuzion - Jitendra Purohit; iXiam - Luciano
Spiegel, Vangelis Pantazis; JMA Consulting - Monish Deb, Seamus Lee; John
Kingsnorth; Megaphone Technology Consulting - Jon Goldberg; mglaman; MJW
Consulting - Matthew Wire; Nicol Wistreich; PERORA SRL- Samuele Masetto;
Progressive Technology Project - Jamie McClelland; Richard van Oosterhout;
Squiffle Consulting - Aidan Saunders; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Atomic Development - Max Tsero; Australian Greens -
John Twyman; Centarro - Matt Glaman; Fuzion - Luke Stewart; Greenpeace Central
and Eastern Europe - Patrick Figel; JMA Consulting - Joe Murray; jvos;
Lighthouse Consulting and Design - Brian Shaughnessy; Megaphone Technology
Consulting - Jon Goldberg; MJCO - Mikey O'Toole; Semper IT - Karin Gerritsen;
Tadpole Collective - Kevin Cristiano;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
