# CiviCRM 5.2.0

Released June 6, 2018

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| Change the database schema?                                     |   no    |
| Alter the API?                                                  | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| Introduce features?                                             | **yes** |
| Fix bugs?                                                       | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-21753](https://issues.civicrm.org/jira/browse/CRM-21753) Support
  'criteria' in url on batch merge form
  ([11658](https://github.com/civicrm/civicrm-core/pull/11658))**

  A new `criteria` URL parameter for finding duplicate contacts allows you to
  specify API criteria to only search for duplicates among a subset of contacts.

- **Add New API Call To Get All Unique Fields For Given Entity
  ([11990](https://github.com/civicrm/civicrm-core/pull/11990))**

  This adds a new `getunique` API method that will go through the indexes of an
  entity table and return all unique fields (including combination indexes).

- **[CRM-21849](https://issues.civicrm.org/jira/browse/CRM-21849) Add Link To
  Edit Relationship Types
  ([11853](https://github.com/civicrm/civicrm-core/pull/11853))**

  This change adds a settings button next to the Relationship Type field on the
  Edit Relationship screen which allows you to edit relationship types.

- **[dev/core#90](https://lab.civicrm.org/dev/core/issues/90) Apply disabling
  Full Group By to reports
  ([12047](https://github.com/civicrm/civicrm-core/pull/12047),
  [12043](https://github.com/civicrm/civicrm-core/pull/12043))**

  This applies the disabling of ONLY_FULL_GROUP_BY sql mode to reports and on
  specific queries as needed to enable tests to run on MySQL 5.7

- **[dev/core#66](https://lab.civicrm.org/dev/core/issues/66) Standardise
  Address code in Contact summary report & enable links
  ([11993](https://github.com/civicrm/civicrm-core/pull/11993))**

  This change refactors the Address related code as part of a drive to get
  addresses for multiple contacts in one report.  This change adds prefixing
  into the function used to add the columns, an approach taken from the Extended
  Reports extension.

- **[dev/translation#9](https://lab.civicrm.org/dev/translation/issues/9) Create
  API Action to rebuild Multilingual Schema
  ([11967](https://github.com/civicrm/civicrm-core/pull/11967))**

  This change adds an API method called `System.rebuildmultilingualschema` to
  allow users to rebuild the multilingual schema.

- **Add 'addToDeveloperTab' in more places to expose sql in use (permission
  limited) ([11947](https://github.com/civicrm/civicrm-core/pull/11947))**

  The Database Log report includes a number of database queries besides the main
  query.  These populate temporary tables, among other things.  The SQL for
  these ancillary queries is now visible in the Developer tab alongside the main
  query.

- **Fix API template ([11970](https://github.com/civicrm/civicrm-core/pull/11970))**

  This PR fixes structure and style of CiviCRM API explorer to make it look like
  other pages to give unified interface between screens.

### CiviContribute

- **[dev/core#73](https://lab.civicrm.org/dev/core/issues/73) - Add invoice
  number to bookkeeping report
  ([12020](https://github.com/civicrm/civicrm-core/pull/12020))**

  Invoice Number and Invoice Reference are now both available in the bookkeeping
  transactions report. Before this change, only Invoice ID was shown as a column
  in bookkeeping report.

### CiviEvent

- **[CRM-20879](https://issues.civicrm.org/jira/browse/CRM-20879) Extend
  self-service event registration transfer to backend
  ([10695](https://github.com/civicrm/civicrm-core/pull/10695))**

  This change adds links to "Transfer or Cancel" an event registration when
  viewing an event registration for a participant and when viewing a contact's
  event registrations from the event tab on the contact's record.

### CiviMail

- **[dev/core#53](https://lab.civicrm.org/dev/core/issues/53) Add in stats to AB
  tests and add in clickthrough and opened % stats to mailing reports
  ([11957](https://github.com/civicrm/civicrm-core/pull/11957))**

  This change adds Mailing delivery stat percentages to AB tests and also adds
  in new opened and clickthrough rate stats.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[dev/core#98](https://lab.civicrm.org/dev/core/issues/98) Searching by any
  Address fields with location type other than primary throw DB error
  ([12081](https://github.com/civicrm/civicrm-core/pull/12081))**

  This change resolves a database error that would appear in Search Builder when
  a user picks an address field with a location type other than "Primary".

- **[dev/core#91](https://lab.civicrm.org/dev/core/issues/91) Search Builder
  Improvements ([12058](https://github.com/civicrm/civicrm-core/pull/12058))**

   On the Search Builder screen, this change limits the MySQL operators
   available based on the type of field (string, date etc.).

- **[dev/core#75](https://lab.civicrm.org/dev/core/issues/75) - warning message
  after an activity is created
  ([12027](https://github.com/civicrm/civicrm-core/pull/12027))**

- **Translate strings in "Report" UI, et al
  ([12009](https://github.com/civicrm/civicrm-core/pull/12009) and
  [11988](https://github.com/civicrm/civicrm-core/pull/11988))**

  A number of phrases, particularly in reports and CiviGrant, were not wrapped
  in a translation function.

- **Improve input handling in get-cases AJAX API
  ([12017](https://github.com/civicrm/civicrm-core/pull/12017))**

  Changes case type id and status id to be 'CommaSeparatedIntegers' instead of
  'String' to improve input handling in get-cases AJAX API.

- **[CRM-19885](https://issues.civicrm.org/jira/browse/CRM-19885) Scheduled
  Reminders: lack of default form values leads to SQL syntax error
  ([11972](https://github.com/civicrm/civicrm-core/pull/11972))**

  This fixes a regression from CRM-19853 where some fields were changed to text
  input without defining default values. Specifically, the problem involved
  integer fields start_action_offset, repetition_frequency_interval,
  end_frequency_interval, which aren't required fields. Leaving these blank led
  to `NULL` values in the database, which then led to SQL syntax errors.

- **[dev/core#64](https://lab.civicrm.org/dev/core/issues/64) - In custom
  searches, column headings are being ignored
  ([12001](https://github.com/civicrm/civicrm-core/pull/12001))**

  This change fixes a regression where for custom searches--ones that come
  installed with core CiviCRM as well as user-defined ones--the column headings
  defined in the custom search code were being ignored. This issue began in
  CiviCRM 5.0.0.

- **[dev/core#70](https://lab.civicrm.org/dev/core/issues/70) On any custom
  search 'Print selected rows' action doesn't retain columns/values
  ([12010](https://github.com/civicrm/civicrm-core/pull/12010))**

- **[dev/core#48](https://lab.civicrm.org/dev/core/issues/48) Fix PDF Letter
  only generates a single letter when multiple contact IDs are specified
  ([11985](https://github.com/civicrm/civicrm-core/pull/11985))**

  This change fixes a bug where when multiple contact IDs are specified via
  print/merge task the PDFLetterCommon code overwrote them with a single contact
  ID of the logged in user. This means that only a single PDF letter is
  printed/generated. This PR only uses the logged in contact ID if no contact
  IDs have been specified.

- **[dev/core#59](https://lab.civicrm.org/dev/core/issues/59) scheduled reminder
  email validation
  ([11973](https://github.com/civicrm/civicrm-core/pull/11973))**

  This change makes it so that the email address field on the scheduled reminder
  form is validated.  Before this change, a non-email value could be stored in
  the field which would result in a silent failure.

- **[CRM-20598](https://issues.civicrm.org/jira/browse/CRM-20598) Phone ext in
  profile edit messing with address
  ([11978](https://github.com/civicrm/civicrm-core/pull/11978))**

  This change fixes a bug where when using a profile in edit mode with "Phone
  and Extension" on primary field and some primary address fields (street, city,
  country): it works fine the first time the profile is used, but it removes the
  existing address when a user tries to use the profile a second time.

- **AllCoreTables - Generate file every time
  ([11755](https://github.com/civicrm/civicrm-core/pull/11755))**

  The auto-generated file AllCoreTables was not being updated as often as
  necessary, and the freshness checks were almost as expensive as just generating
  the file, if not more, this was causing issues for the Attachment API. This
  change makes it so the file is generated every time.

- **Prevent hard-fail when section header / group by option chosen on logging
  report ([11953](https://github.com/civicrm/civicrm-core/pull/11953))**

- **[CRM-21855](https://issues.civicrm.org/jira/browse/CRM-21855) Editing "A"
  side of relationship copies values to "B" side
  ([11965](https://github.com/civicrm/civicrm-core/pull/11965))**

  When editing a relationship type, values in the "Relationship A to B" column
  were copied to the "Relationship B to A" column.

- **[CRM-21523](https://issues.civicrm.org/jira/browse/CRM-21523) scheduled
  reminders: when using repetition, require frequency intervals
  ([11377](https://github.com/civicrm/civicrm-core/pull/11377))**

- **Move help section outside the container
  ([12031](https://github.com/civicrm/civicrm-core/pull/12031))**

  This moves the help section markup on the Find and Merge Duplicate Contacts
  page to preserve consistency among other screens.

### CiviCase

- **[CRM-21843](https://issues.civicrm.org/jira/browse/CRM-21843) Case
  activities delimiter not working
  ([11961](https://github.com/civicrm/civicrm-core/pull/11961))**

  This change fixes a bug in exporting cases where the last column would contain
  all the activity fields jammed together.

- **Fix select2 value updation for crmAddName Directive
  ([11979](https://github.com/civicrm/civicrm-core/pull/11979))**

  This fixes a bug where the Case Type options selection field was not
  populating properly.

- **[dev/core#54](https://lab.civicrm.org/dev/core/issues/54) - Activity created
  for case role relationship is not assigned to correct contact
  ([11960](https://github.com/civicrm/civicrm-core/pull/11960))**

  This change fixes a bug where if the user added a role for a case. The activity
  created was assigned to the client instead of the relationship contact.

- **[dev/core#137](https://lab.civicrm.org/dev/core/issues/137) Fix Find Deleted
  Cases ([12219](https://github.com/civicrm/civicrm-core/pull/12219))**

  Using the Find Cases search to find deleted cases would result in a fatal
  error.

### CiviContribute

- **Fix contribution detail report to work with FULL GROUP BY mode
  ([11954](https://github.com/civicrm/civicrm-core/pull/11954))**

  This change makes it so the contribution detail report works in both full
  group by and non full group by mode.

- **[dev/core#78](https://lab.civicrm.org/dev/core/issues/78) - Incorrect
  Payment Processor for Recurring Payments
  ([12030](https://github.com/civicrm/civicrm-core/pull/12030))**

  The Authorize.net instant payment notification (IPN) code did not properly
  accommodate multiple Authorize.net payment processor instances and would
  sometimes load the incorrect processor.

- **[dev/core#72](https://lab.civicrm.org/dev/core/issues/72) fix payflow bug
  for amount ([12019](https://github.com/civicrm/civicrm-core/pull/12019))**

  Fixes a bug where PayflowPro throws an error due to more than 4 decimal places
  in the amount.

- **[CRM-19752](https://issues.civicrm.org/jira/browse/CRM-19752) Slow query
  created by financial type acls
  ([11657](https://github.com/civicrm/civicrm-core/pull/11657))**

  This change is to improve financial ACL code that was unnecessarily slowing
  down the contact dashboard on sites where financial ACLs are not enabled.
  Financial ACL joins and conditions are no longer added where financial ACLs
  are not enabled.

- **[dev/financial#11](https://lab.civicrm.org/dev/financial/issues/11) email
  invoice fails with validation error
  ([11971](https://github.com/civicrm/civicrm-core/pull/11971))**

  The "Email Invoice" action would result in an outgoing error message: The mail
  library returned the following error message: Validation failed for: ""NAME"".

- **Fix template for widget
  ([11902](https://github.com/civicrm/civicrm-core/pull/11902))**

  This fixes glitches in the Contribution Widget template so that the button is
  aligned properly under it.

- **Remove usage of deprecated paymentProcessorType function
  ([12039](https://github.com/civicrm/civicrm-core/pull/12039))**

  This cleans up and removes usage of the deprecated
  `CRM_Core_PseudoConstant::paymentProcessorType` function.

### CiviEvent

- **Fix Soft credit personal note ton limit to 255 characters (DB limit).
  ([12056](https://github.com/civicrm/civicrm-core/pull/12056))**

  This change fixes a bug where when a user is donating on a CiviEvent Personal
  Campaign page, checks the "Show my support in public honor roll", and puts a
  message in the "Personal Note" box that is longer than 255 characters.
  Submitting the donation would succeed, but the page threw a fatal error before
  the receipt is sent.

- **[dev/core#60](https://lab.civicrm.org/dev/core/issues/60) Fix for check
  number no longer exposed dev/core/issues/60
  ([12059](https://github.com/civicrm/civicrm-core/pull/12059))**

  This change fixes a bug where the "Check number" was not showing on Pay Later
  event registrations when edited.

- **Fix: Batch update participants with checkboxes fails
  ([12051](https://github.com/civicrm/civicrm-core/pull/12051))**

  This change fixes a bug where when doing a batch update of participants
  including a field that uses checkboxes the batch update fails.

- **[dev/core#65](https://lab.civicrm.org/dev/core/issues/65) Fix issue where
  source for participant could be entered w…
  ([12014](https://github.com/civicrm/civicrm-core/pull/12014))**

  This change fixes a bug where when one attempted to manually add a participant
  to an event using the "Add event registration" tab on their CiviCRM profile, but
  the screen wouldn't save, the page just stays frozen and fails to complete.

- **[dev/core#68](https://lab.civicrm.org/dev/core/issues/68) Fix DB Error on
  'Find Participant' page when MySQL FULL_GROUP_BY_MODE is enabled
  ([12120](https://github.com/civicrm/civicrm-core/pull/12120))**

### CiviMail

- **[dev/mail#13](https://lab.civicrm.org/dev/mail/issues/13) All unsubscribe
  group members are excluded from a mailing with a manually specified
  unsubscribe group (group_type=Base) if the unsubscribe group is a Smart group
  ([12262](https://github.com/civicrm/civicrm-core/pull/12262))**

- **[CRM-21194](https://issues.civicrm.org/jira/browse/CRM-21194) Unique clicks
  in mailing report shows duplicates
  ([10988](https://github.com/civicrm/civicrm-core/pull/10988))**

- **[CRM-21100](https://issues.civicrm.org/jira/browse/CRM-21100) Empty list
  shown in "Send test email to group" dropdown
  ([10898](https://github.com/civicrm/civicrm-core/pull/10898))**

- **[dev/core#86](https://lab.civicrm.org/dev/core/issues/86) Notify admin when
  testing email if CIVICRM_MAIL_LOG_AND_SEND is set
  ([12037](https://github.com/civicrm/civicrm-core/pull/12037) and [204](https://github.com/civicrm/civicrm-packages/pull/204))**

  Now administrators are notified when `CIVICRM_MAIL_LOG_AND_SEND` is set just
  as when `CIVICRM_MAIL_LOG` is set.

### CiviMember

- **Re-Fix Case form task (export/print not working) (replace quick fix with
  proper fix) ([12110](https://github.com/civicrm/civicrm-core/pull/12110))**

  This resolves a problem exporting from Advanced Search, displaying results as
  Memberships, where the export options were for contacts, not memberships.

- **[dev/core#100](https://lab.civicrm.org/dev/core/issues/100) Membership
  Detail report throw DB error
  ([12150](https://github.com/civicrm/civicrm-core/pull/12150))**

  The Membership Detail report would throw a DB error due to the ACL clause
  being applied twice.

### Drupal integration

- **Fix the contact merge form on Drupal 8
  ([11992](https://github.com/civicrm/civicrm-core/pull/11992))**

  This fixes a bug with Drupal 8 integrations where attempting to merge contacts
  which are associated with Drupal users resulted in a fatal error.

- **Drupal8 loadBootStrap: fix user variable
  ([11958](https://github.com/civicrm/civicrm-core/pull/11958))**

  This fixes an error when sending requests to the REST API endpoint because of
  an incorrectly referenced variable.

### WordPress Integration

- **[CRM-21564](https://issues.civicrm.org/jira/browse/CRM-21564) Changing from
  using exec to WP_CLI::Launch
  ([119](https://github.com/civicrm/civicrm-wordpress/pull/119))**

  This change moves from using `exec` to `WP_CLI::Launch` because `exec` does
  not seem to be available on all systems.  It also makes the code more
  consistent for running external processes.

## <a name="misc"></a>Miscellany

- **[CRM-21037](https://issues.civicrm.org/jira/browse/CRM-21037) Add unit tests
  for Activity sendSMS functions
  ([10946](https://github.com/civicrm/civicrm-core/pull/10946))**

- **[CRM-21148](https://issues.civicrm.org/jira/browse/CRM-21148) Refactor
  "getFromTo()" functions
  ([11887](https://github.com/civicrm/civicrm-core/pull/11887))**

- **Fix (unreleased) regression on report pager
  ([12080](https://github.com/civicrm/civicrm-core/pull/12080))**

- **[NFC] FIx indenting in eventFees template
  ([12062](https://github.com/civicrm/civicrm-core/pull/12062))**

- **[NFC] Add metadata to describe personal note field
  ([12046](https://github.com/civicrm/civicrm-core/pull/12046))**

- **(NFC) Update version in header
  ([11999](https://github.com/civicrm/civicrm-core/pull/11999))**

- **[nfc]  Consistently specify whether to clean money when calling from test
  suite ([11959](https://github.com/civicrm/civicrm-core/pull/11959))**

- **(NFC) Update version in header
  ([530](https://github.com/civicrm/civicrm-drupal/pull/530))**

- **(NFC) Fix Warnings When Updating Custom Entities
  ([12033](https://github.com/civicrm/civicrm-core/pull/12033))**

- **(NFC) Update version headers in `xml`, `tests`, `tools`, et al
  ([12029](https://github.com/civicrm/civicrm-core/pull/12029))**

- **5.1 ([12018](https://github.com/civicrm/civicrm-core/pull/12018))**

- **[CRM-20459](https://issues.civicrm.org/jira/browse/CRM-20459) Actively
  deprecate CRM_Core_OptionGroup::getValue
  ([12049](https://github.com/civicrm/civicrm-core/pull/12049))**

- **Rename function enableFullGroupByMode to be reenableFullGroupByMode t…
  ([12064](https://github.com/civicrm/civicrm-core/pull/12064))**

- **Remove unused code in CRM_Contribute_Form_ContributionPage_Amount::formRule
  ([12054](https://github.com/civicrm/civicrm-core/pull/12054))**

- **Add unit test to event batch update (includes function extraction to support
  this) ([12048](https://github.com/civicrm/civicrm-core/pull/12048))**

- **E-notice fix ([11982](https://github.com/civicrm/civicrm-core/pull/11982))**

- **Extract custom data edit template code to shared template
  ([11950](https://github.com/civicrm/civicrm-core/pull/11950))**

- **Simple function extraction on editing Address (within main contact edit)
  ([11900](https://github.com/civicrm/civicrm-core/pull/11900))**

- **Allow KCFinder to send back a json encoded response instead of string…
  ([203](https://github.com/civicrm/civicrm-packages/pull/203))**

- **Mark Accent String Tests as incomplete if on a database that is not utf8
  ([12060](https://github.com/civicrm/civicrm-core/pull/12060))**

- **Add missing case type tests
  ([12023](https://github.com/civicrm/civicrm-core/pull/12023))**

- **Namespace exception in test
  ([11986](https://github.com/civicrm/civicrm-core/pull/11986))**

- **Fix intermittant test bug
  ([11995](https://github.com/civicrm/civicrm-core/pull/11995))**

- **(NFC) Add in 5.1.0 and 5.1.1 mysql upgrade files
  ([12143](https://github.com/civicrm/civicrm-core/pull/12143))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andrew Hunt; Australian Greens - Seamus Lee; CiviCoop - Jaap
Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp -
Debarshi Bhaumik, Michael Devery, Mukesh Ram, René Olivo, Vinu Varshith Sekar;
Coop SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Fuzion - Jitendra Purohit; JMA
Consulting - Monish Deb; Lighthouse Design and Consulting - Brian Shaughnessy;
Megaphone Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
myDropWizard - David Snopek; Progressive Technology Project - Jamie McClelland;
Tom Bloor; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Alexander Ferreras; Chris Burgess; Christian Wach; CiviCoop - Klaas Eikelboom;
Coop SymbioTIC - Stéphane Lussier; Donald Hirst; Fuzion - Peter Davis; GMCVO
Databases - Jon-Man Cheung; JMA Consulting - Joe Murray; Joinery - Allen Shaw;
Left Join Labs - Sean Madsen; Lemniscus - Noah Miller; Nubay Services - David
Tarrant; Pradeep Nayak; Semper IT - Karin Gerritsen; small biz; Tadpole
Collective - Kevin Cristiano; Third Sector Design - Michael McAndrew

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please login to https://chat.civicrm.org/civicrm
and contact `@agh1`.
