{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetTau: TFloatTime;
    procedure SetTau(const Value: TFloatTime);
    function GetTolerance: Single;
    procedure SetTolerance(const Value: Single);
    function GetOrder: Integer;
    procedure SetOrder(const Value: Integer);
  public
    { X3D field "tau". } { }
    property Tau: TFloatTime read GetTau write SetTau;
    { X3D field "tolerance". } { }
    property Tolerance: Single read GetTolerance write SetTolerance;
    { X3D field "order". } { }
    property Order: Integer read GetOrder write SetOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractDamperNode ----------------------------------------------- }

function TAbstractDamperNode.GetTau: TFloatTime;
begin
  Result := FdTau.Value;
end;

procedure TAbstractDamperNode.SetTau(const Value: TFloatTime);
begin
  FdTau.Send(Value);
end;

function TAbstractDamperNode.GetTolerance: Single;
begin
  Result := FdTolerance.Value;
end;

procedure TAbstractDamperNode.SetTolerance(const Value: Single);
begin
  FdTolerance.Send(Value);
end;

function TAbstractDamperNode.GetOrder: Integer;
begin
  Result := FdOrder.Value;
end;

procedure TAbstractDamperNode.SetOrder(const Value: Integer);
begin
  FdOrder.Send(Value);
end;

{$endif read_implementation}
