{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetAntennaLocation: TVector3;
    procedure SetAntennaLocation(const Value: TVector3);
    function GetAntennaPatternLength: Integer;
    procedure SetAntennaPatternLength(const Value: Integer);
    function GetAntennaPatternType: Integer;
    procedure SetAntennaPatternType(const Value: Integer);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetCryptoKeyID: Integer;
    procedure SetCryptoKeyID(const Value: Integer);
    function GetCryptoSystem: Integer;
    procedure SetCryptoSystem(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetFrequency: Integer;
    procedure SetFrequency(const Value: Integer);
    function GetInputSource: Integer;
    procedure SetInputSource(const Value: Integer);
    function GetLengthOfModulationParameters: Integer;
    procedure SetLengthOfModulationParameters(const Value: Integer);
    function GetModulationTypeDetail: Integer;
    procedure SetModulationTypeDetail(const Value: Integer);
    function GetModulationTypeMajor: Integer;
    procedure SetModulationTypeMajor(const Value: Integer);
    function GetModulationTypeSpreadSpectrum: Integer;
    procedure SetModulationTypeSpreadSpectrum(const Value: Integer);
    function GetModulationTypeSystem: Integer;
    procedure SetModulationTypeSystem(const Value: Integer);
    function GetMulticastRelayHost: String;
    procedure SetMulticastRelayHost(const Value: String);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetPower: Single;
    procedure SetPower(const Value: Single);
    function GetRadioEntityTypeCategory: Integer;
    procedure SetRadioEntityTypeCategory(const Value: Integer);
    function GetRadioEntityTypeCountry: Integer;
    procedure SetRadioEntityTypeCountry(const Value: Integer);
    function GetRadioEntityTypeDomain: Integer;
    procedure SetRadioEntityTypeDomain(const Value: Integer);
    function GetRadioEntityTypeKind: Integer;
    procedure SetRadioEntityTypeKind(const Value: Integer);
    function GetRadioEntityTypeNomenclature: Integer;
    procedure SetRadioEntityTypeNomenclature(const Value: Integer);
    function GetRadioEntityTypeNomenclatureVersion: Integer;
    procedure SetRadioEntityTypeNomenclatureVersion(const Value: Integer);
    function GetRadioID: Integer;
    procedure SetRadioID(const Value: Integer);
    function GetReadInterval: Single;
    procedure SetReadInterval(const Value: Single);
    function GetRelativeAntennaLocation: TVector3;
    procedure SetRelativeAntennaLocation(const Value: TVector3);
    function GetRtpHeaderExpected: Boolean;
    procedure SetRtpHeaderExpected(const Value: Boolean);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTransmitFrequencyBandwidth: Single;
    procedure SetTransmitFrequencyBandwidth(const Value: Single);
    function GetTransmitState: Integer;
    procedure SetTransmitState(const Value: Integer);
    function GetWhichGeometry: Integer;
    procedure SetWhichGeometry(const Value: Integer);
    function GetWriteInterval: Single;
    procedure SetWriteInterval(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { X3D field "address". } { }
    property Address: String read GetAddress write SetAddress;
    { X3D field "antennaLocation". } { }
    property AntennaLocation: TVector3 read GetAntennaLocation write SetAntennaLocation;
    { X3D field "antennaPatternLength". } { }
    property AntennaPatternLength: Integer read GetAntennaPatternLength write SetAntennaPatternLength;
    { X3D field "antennaPatternType". } { }
    property AntennaPatternType: Integer read GetAntennaPatternType write SetAntennaPatternType;
    { X3D field "applicationID". } { }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;
    { X3D field "cryptoKeyID". } { }
    property CryptoKeyID: Integer read GetCryptoKeyID write SetCryptoKeyID;
    { X3D field "cryptoSystem". } { }
    property CryptoSystem: Integer read GetCryptoSystem write SetCryptoSystem;
    { X3D field "entityID". } { }
    property EntityID: Integer read GetEntityID write SetEntityID;
    { X3D field "frequency". } { }
    property Frequency: Integer read GetFrequency write SetFrequency;
    { X3D field "inputSource". } { }
    property InputSource: Integer read GetInputSource write SetInputSource;
    { X3D field "lengthOfModulationParameters". } { }
    property LengthOfModulationParameters: Integer read GetLengthOfModulationParameters write SetLengthOfModulationParameters;
    { X3D field "modulationTypeDetail". } { }
    property ModulationTypeDetail: Integer read GetModulationTypeDetail write SetModulationTypeDetail;
    { X3D field "modulationTypeMajor". } { }
    property ModulationTypeMajor: Integer read GetModulationTypeMajor write SetModulationTypeMajor;
    { X3D field "modulationTypeSpreadSpectrum". } { }
    property ModulationTypeSpreadSpectrum: Integer read GetModulationTypeSpreadSpectrum write SetModulationTypeSpreadSpectrum;
    { X3D field "modulationTypeSystem". } { }
    property ModulationTypeSystem: Integer read GetModulationTypeSystem write SetModulationTypeSystem;
    { X3D field "multicastRelayHost". } { }
    property MulticastRelayHost: String read GetMulticastRelayHost write SetMulticastRelayHost;
    { X3D field "multicastRelayPort". } { }
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;
    { X3D field "port". } { }
    property Port: Integer read GetPort write SetPort;
    { X3D field "power". } { }
    property Power: Single read GetPower write SetPower;
    { X3D field "radioEntityTypeCategory". } { }
    property RadioEntityTypeCategory: Integer read GetRadioEntityTypeCategory write SetRadioEntityTypeCategory;
    { X3D field "radioEntityTypeCountry". } { }
    property RadioEntityTypeCountry: Integer read GetRadioEntityTypeCountry write SetRadioEntityTypeCountry;
    { X3D field "radioEntityTypeDomain". } { }
    property RadioEntityTypeDomain: Integer read GetRadioEntityTypeDomain write SetRadioEntityTypeDomain;
    { X3D field "radioEntityTypeKind". } { }
    property RadioEntityTypeKind: Integer read GetRadioEntityTypeKind write SetRadioEntityTypeKind;
    { X3D field "radioEntityTypeNomenclature". } { }
    property RadioEntityTypeNomenclature: Integer read GetRadioEntityTypeNomenclature write SetRadioEntityTypeNomenclature;
    { X3D field "radioEntityTypeNomenclatureVersion". } { }
    property RadioEntityTypeNomenclatureVersion: Integer read GetRadioEntityTypeNomenclatureVersion write SetRadioEntityTypeNomenclatureVersion;
    { X3D field "radioID". } { }
    property RadioID: Integer read GetRadioID write SetRadioID;
    { X3D field "readInterval". } { }
    property ReadInterval: Single read GetReadInterval write SetReadInterval;
    { X3D field "relativeAntennaLocation". } { }
    property RelativeAntennaLocation: TVector3 read GetRelativeAntennaLocation write SetRelativeAntennaLocation;
    { X3D field "rtpHeaderExpected". } { }
    property RtpHeaderExpected: Boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;
    { X3D field "siteID". } { }
    property SiteID: Integer read GetSiteID write SetSiteID;
    { X3D field "transmitFrequencyBandwidth". } { }
    property TransmitFrequencyBandwidth: Single read GetTransmitFrequencyBandwidth write SetTransmitFrequencyBandwidth;
    { X3D field "transmitState". } { }
    property TransmitState: Integer read GetTransmitState write SetTransmitState;
    { X3D field "whichGeometry". } { }
    property WhichGeometry: Integer read GetWhichGeometry write SetWhichGeometry;
    { X3D field "writeInterval". } { }
    property WriteInterval: Single read GetWriteInterval write SetWriteInterval;
    { X3D fields "bboxCenter" and "bboxSize" are get/set as TBox3D. } { }
    property BBox: TBox3D read GetBBox write SetBBox;

{$endif read_interface}

{$ifdef read_implementation}

{ TTransmitterPduNode ----------------------------------------------- }

function TTransmitterPduNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TTransmitterPduNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TTransmitterPduNode.GetAntennaLocation: TVector3;
begin
  Result := FdAntennaLocation.Value;
end;

procedure TTransmitterPduNode.SetAntennaLocation(const Value: TVector3);
begin
  FdAntennaLocation.Send(Value);
end;

function TTransmitterPduNode.GetAntennaPatternLength: Integer;
begin
  Result := FdAntennaPatternLength.Value;
end;

procedure TTransmitterPduNode.SetAntennaPatternLength(const Value: Integer);
begin
  FdAntennaPatternLength.Send(Value);
end;

function TTransmitterPduNode.GetAntennaPatternType: Integer;
begin
  Result := FdAntennaPatternType.Value;
end;

procedure TTransmitterPduNode.SetAntennaPatternType(const Value: Integer);
begin
  FdAntennaPatternType.Send(Value);
end;

function TTransmitterPduNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TTransmitterPduNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

function TTransmitterPduNode.GetCryptoKeyID: Integer;
begin
  Result := FdCryptoKeyID.Value;
end;

procedure TTransmitterPduNode.SetCryptoKeyID(const Value: Integer);
begin
  FdCryptoKeyID.Send(Value);
end;

function TTransmitterPduNode.GetCryptoSystem: Integer;
begin
  Result := FdCryptoSystem.Value;
end;

procedure TTransmitterPduNode.SetCryptoSystem(const Value: Integer);
begin
  FdCryptoSystem.Send(Value);
end;

function TTransmitterPduNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TTransmitterPduNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TTransmitterPduNode.GetFrequency: Integer;
begin
  Result := FdFrequency.Value;
end;

procedure TTransmitterPduNode.SetFrequency(const Value: Integer);
begin
  FdFrequency.Send(Value);
end;

function TTransmitterPduNode.GetInputSource: Integer;
begin
  Result := FdInputSource.Value;
end;

procedure TTransmitterPduNode.SetInputSource(const Value: Integer);
begin
  FdInputSource.Send(Value);
end;

function TTransmitterPduNode.GetLengthOfModulationParameters: Integer;
begin
  Result := FdLengthOfModulationParameters.Value;
end;

procedure TTransmitterPduNode.SetLengthOfModulationParameters(const Value: Integer);
begin
  FdLengthOfModulationParameters.Send(Value);
end;

function TTransmitterPduNode.GetModulationTypeDetail: Integer;
begin
  Result := FdModulationTypeDetail.Value;
end;

procedure TTransmitterPduNode.SetModulationTypeDetail(const Value: Integer);
begin
  FdModulationTypeDetail.Send(Value);
end;

function TTransmitterPduNode.GetModulationTypeMajor: Integer;
begin
  Result := FdModulationTypeMajor.Value;
end;

procedure TTransmitterPduNode.SetModulationTypeMajor(const Value: Integer);
begin
  FdModulationTypeMajor.Send(Value);
end;

function TTransmitterPduNode.GetModulationTypeSpreadSpectrum: Integer;
begin
  Result := FdModulationTypeSpreadSpectrum.Value;
end;

procedure TTransmitterPduNode.SetModulationTypeSpreadSpectrum(const Value: Integer);
begin
  FdModulationTypeSpreadSpectrum.Send(Value);
end;

function TTransmitterPduNode.GetModulationTypeSystem: Integer;
begin
  Result := FdModulationTypeSystem.Value;
end;

procedure TTransmitterPduNode.SetModulationTypeSystem(const Value: Integer);
begin
  FdModulationTypeSystem.Send(Value);
end;

function TTransmitterPduNode.GetMulticastRelayHost: String;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TTransmitterPduNode.SetMulticastRelayHost(const Value: String);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TTransmitterPduNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TTransmitterPduNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TTransmitterPduNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TTransmitterPduNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TTransmitterPduNode.GetPower: Single;
begin
  Result := FdPower.Value;
end;

procedure TTransmitterPduNode.SetPower(const Value: Single);
begin
  FdPower.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeCategory: Integer;
begin
  Result := FdRadioEntityTypeCategory.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeCategory(const Value: Integer);
begin
  FdRadioEntityTypeCategory.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeCountry: Integer;
begin
  Result := FdRadioEntityTypeCountry.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeCountry(const Value: Integer);
begin
  FdRadioEntityTypeCountry.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeDomain: Integer;
begin
  Result := FdRadioEntityTypeDomain.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeDomain(const Value: Integer);
begin
  FdRadioEntityTypeDomain.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeKind: Integer;
begin
  Result := FdRadioEntityTypeKind.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeKind(const Value: Integer);
begin
  FdRadioEntityTypeKind.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeNomenclature: Integer;
begin
  Result := FdRadioEntityTypeNomenclature.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeNomenclature(const Value: Integer);
begin
  FdRadioEntityTypeNomenclature.Send(Value);
end;

function TTransmitterPduNode.GetRadioEntityTypeNomenclatureVersion: Integer;
begin
  Result := FdRadioEntityTypeNomenclatureVersion.Value;
end;

procedure TTransmitterPduNode.SetRadioEntityTypeNomenclatureVersion(const Value: Integer);
begin
  FdRadioEntityTypeNomenclatureVersion.Send(Value);
end;

function TTransmitterPduNode.GetRadioID: Integer;
begin
  Result := FdRadioID.Value;
end;

procedure TTransmitterPduNode.SetRadioID(const Value: Integer);
begin
  FdRadioID.Send(Value);
end;

function TTransmitterPduNode.GetReadInterval: Single;
begin
  Result := FdReadInterval.Value;
end;

procedure TTransmitterPduNode.SetReadInterval(const Value: Single);
begin
  FdReadInterval.Send(Value);
end;

function TTransmitterPduNode.GetRelativeAntennaLocation: TVector3;
begin
  Result := FdRelativeAntennaLocation.Value;
end;

procedure TTransmitterPduNode.SetRelativeAntennaLocation(const Value: TVector3);
begin
  FdRelativeAntennaLocation.Send(Value);
end;

function TTransmitterPduNode.GetRtpHeaderExpected: Boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TTransmitterPduNode.SetRtpHeaderExpected(const Value: Boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

function TTransmitterPduNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TTransmitterPduNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TTransmitterPduNode.GetTransmitFrequencyBandwidth: Single;
begin
  Result := FdTransmitFrequencyBandwidth.Value;
end;

procedure TTransmitterPduNode.SetTransmitFrequencyBandwidth(const Value: Single);
begin
  FdTransmitFrequencyBandwidth.Send(Value);
end;

function TTransmitterPduNode.GetTransmitState: Integer;
begin
  Result := FdTransmitState.Value;
end;

procedure TTransmitterPduNode.SetTransmitState(const Value: Integer);
begin
  FdTransmitState.Send(Value);
end;

function TTransmitterPduNode.GetWhichGeometry: Integer;
begin
  Result := FdWhichGeometry.Value;
end;

procedure TTransmitterPduNode.SetWhichGeometry(const Value: Integer);
begin
  FdWhichGeometry.Send(Value);
end;

function TTransmitterPduNode.GetWriteInterval: Single;
begin
  Result := FdWriteInterval.Value;
end;

procedure TTransmitterPduNode.SetWriteInterval(const Value: Single);
begin
  FdWriteInterval.Send(Value);
end;

function TTransmitterPduNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TTransmitterPduNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

{$endif read_implementation}
