{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetTessellationScale: Single;
    procedure SetTessellationScale(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    { Set X3D field "geometry". } { }
    procedure SetGeometry(const Value: array of TAbstractNurbsSurfaceGeometryNode);
    { X3D field "tessellationScale". } { }
    property TessellationScale: Single read GetTessellationScale write SetTessellationScale;
    { X3D fields "bboxCenter" and "bboxSize" are get/set as TBox3D. } { }
    property BBox: TBox3D read GetBBox write SetBBox;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsSetNode ----------------------------------------------- }

procedure TNurbsSetNode.SetGeometry(const Value: array of TAbstractNurbsSurfaceGeometryNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractNurbsSurfaceGeometryNode));
  FdGeometry.Send(A);
end;

function TNurbsSetNode.GetTessellationScale: Single;
begin
  Result := FdTessellationScale.Value;
end;

procedure TNurbsSetNode.SetTessellationScale(const Value: Single);
begin
  FdTessellationScale.Send(Value);
end;

function TNurbsSetNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TNurbsSetNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

{$endif read_implementation}
