#!/bin/sh
# Sometimes, by the time we get around to packaging cargo, the crates.io
# ecosystem has moved on from the versions that cargo-vendor *would have* used
# when that version of cargo was released. This places a lot of maintenance
# burden on us, since it requires us to keep debcargo-conf always up-to-date.
#
# This script allows us to force cargo-vendor to use old versions of dependency
# crates, that better match our debcargo-conf patches, as well as the versions
# of crates used when a particular version of cargo was actually released.
#
# Example:
# cargo update -p filetime --precise 0.2.12
#

# Drop the "vendored" feature since we patch it out of debcargo
sed -i /vendored/d Cargo.toml

# For cargo 0.58.0 / rustc 1.57.0
cargo update -p tempfile --precise 3.2.0
cargo update -p filetime --precise 0.2.15
cargo update -p regex    --precise 1.5.4
cargo update -p git2     --precise 0.13.23
cargo update -p libgit2-sys --precise 0.12.24+1.3.0
cargo update -p commoncrypto --precise "0.2.0"
cargo update -p commoncrypto-sys --precise "0.2.0"
cargo update -p curl --precise "0.4.39"
cargo update -p curl-sys --precise "0.4.49+curl-7.79.1"
cargo update -p getrandom --precise "0.2.0"
cargo update -p num_cpus --precise "1.13.0"
cargo update -p openssl-sys --precise "0.9.65"
cargo update -p rand --precise "0.8.4"
cargo update -p redox_syscall --precise "0.2.10"
cargo update -p syn --precise "1.0.77"
cargo update -p tar --precise "0.4.37"
cargo update -p tempfile --precise "3.2.0"
