+++
title = "TruncatedSphere"
+++

### TruncatedSphere

A spherical segment, obtained from a spherical ball by two parallel cuts.

<img src="/img/draw/ff/3d/TruncatedSphere.png" width="30%" >
<img src="/img/draw/ff/2d/TruncatedSphere_xy.svg" width="30%">
<img src="/img/draw/ff/2d/TruncatedSphere_xz.svg" width="30%">

#### Constructor

```python
TruncatedSphere(R, H, dh)
```

Parameters:
- R, radius
- H, untruncated height (height before top removal)
- dh, top removal

Constraint:

$ dh < H \le 2R $

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "TruncatedSphere" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Computation involves numerical integration in vertical direction,

$$ F(\mathbf{q})=2\pi \exp\[iq_z(H-R)\]  \int_{R-H}^{R-dh} \text{d}z \space R_z^2 \frac{J_1(q_{||}R_z)}{q_{||}R_z} \exp(iq_z z), $$

with the notation

$$ q_{||} := \sqrt{q_x^2 + q_y^2}, \quad R_z:=\sqrt{R^2-z^2} $$

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V=\dfrac{\pi}{3} \[ 3R(H^2-dh^2) + dh^3 -H^3 \]. $$

#### Related shapes

- [HemiEllipsoid](/ref/sample/particle/ff/hard/hemiellipsoid), top half of ellipsoid.

More general:
- [TruncatedSpheroid](/ref/sample/particle/ff/hard/truncatedspheroid), spheroid truncated from the top and/or the bottom.

More special:
- [Sphere](/ref/sample/particle/ff/hard/sphere), if $H=2R, \space dh=0.$

#### Example

Scattering by uncorrelated, oriented truncated spheres for horizontal incidence. Rotation around $y$ axis:

<img src="/img/auto/ff/TruncatedSphere.png">

Generated by {{% ref-ex "ff/TruncatedSphere.py" %}}.

#### History

Agrees with the IsGISAXS form factor "Sphere" [[manual](/lit/lazzari2006), Eq. 2.32] and "Truncated sphere" [[Renaud 2009](/lit/renaud2009), Eq. 228]. It is *not* "Truncated sphere" of FitGISAXS, which is without top removal [[Babonneau 2013](/lit/babonneau2013)].
