//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/DepthprobeInstrumentEditor.h
//! @brief     Defines class DepthprobeInstrumentEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_DEPTHPROBEINSTRUMENTEDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_DEPTHPROBEINSTRUMENTEDITOR_H

#include "GUI/Model/Device/InstrumentNotifier.h"
#include <QWidget>

class MultiInstrumentNotifier;
class DepthprobeInstrumentItem;

class DepthprobeInstrumentEditor : public QWidget {
    Q_OBJECT

public:
    DepthprobeInstrumentEditor(QWidget* parent, DepthprobeInstrumentItem* item,
                               MultiInstrumentNotifier* ec);

signals:
    void dataChanged();

private:
    InstrumentNotifier m_ec;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_DEPTHPROBEINSTRUMENTEDITOR_H
