//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/FitSessionWidget.h
//! @brief     Defines class FitSessionWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_FIT_FITSESSIONWIDGET_H
#define BORNAGAIN_GUI_VIEW_FIT_FITSESSIONWIDGET_H

#include <QWidget>

class FitParameterWidget;
class FitSessionController;
class JobItem;
class MinimizerSettingsWidget;
class ParameterTuningWidget;
class QTabWidget;
class RunFitControlWidget;

//! Contains all fit settings for given JobItem (fit parameters,
//! minimizer settings). Controlled by FitActivityPanel.

class FitSessionWidget : public QWidget {
    Q_OBJECT
public:
    FitSessionWidget(QWidget* parent = nullptr);
    ~FitSessionWidget();

    void setJobItem(JobItem* jobItem);
    void setModelTuningWidget(ParameterTuningWidget* tuningWidget);
    void setSessionController(FitSessionController* sessionController);

private:
    void onFittingError(const QString& text);

    void applySettings();
    void saveSettings();

    QTabWidget* m_tabWidget;
    RunFitControlWidget* m_controlWidget;
    FitParameterWidget* m_fitParametersWidget;
    MinimizerSettingsWidget* m_minimizerSettingsWidget;
    FitSessionController* m_sessionController;
};

#endif // BORNAGAIN_GUI_VIEW_FIT_FITSESSIONWIDGET_H
