//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Detector/ResolutionFunctionItemCatalog.cpp
//! @brief     Implements class ResolutionFunctionItemCatalog
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Model/Detector/ResolutionFunctionItemCatalog.h"
#include "Base/Util/Assert.h"
#include "GUI/Model/Detector/ResolutionFunctionItems.h"

ResolutionFunctionItem*
ResolutionFunctionItemCatalog::create(Type type, const std::variant<QString, Unit>& unit)
{
    switch (type) {
    case Type::None: {
        auto* p = new ResolutionFunctionNoneItem();
        p->setUnit(unit);
        return p;
    }
    case Type::Gaussian: {
        auto* p = new ResolutionFunction2DGaussianItem();
        p->setUnit(unit);
        return p;
    }
    }
    ASSERT(false);
}

QVector<ResolutionFunctionItemCatalog::Type> ResolutionFunctionItemCatalog::types()
{
    return {Type::None, Type::Gaussian};
}

UiInfo ResolutionFunctionItemCatalog::uiInfo(Type type)
{
    switch (type) {
    case Type::None:
        return {"None", "", ""};
    case Type::Gaussian:
        return {"2D Gaussian", "", ""};
    }
    ASSERT(false);
}

ResolutionFunctionItemCatalog::Type
ResolutionFunctionItemCatalog::type(const ResolutionFunctionItem* item)
{
    if (dynamic_cast<const ResolutionFunctionNoneItem*>(item))
        return Type::None;
    if (dynamic_cast<const ResolutionFunction2DGaussianItem*>(item))
        return Type::Gaussian;

    ASSERT(false);
}
