/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

public class Main {
  public static boolean doThrow = false;

  private Object objectField;
  private int intField;
  private float floatField;
  private long longField;
  private double doubleField;
  private byte byteField;
  private boolean booleanField;
  private char charField;
  private short shortField;

  private volatile Object volatileObjectField;
  private volatile int volatileIntField;
  private volatile float volatileFloatField;
  private volatile long volatileLongField;
  private volatile double volatileDoubleField;
  private volatile byte volatileByteField;
  private volatile boolean volatileBooleanField;
  private volatile char volatileCharField;
  private volatile short volatileShortField;

  public static void $opt$noinline$setObjectField(Main m) {
    if (doThrow) { throw new Error(); }
    m.objectField = null;
  }

  public static void $opt$noinline$setIntField(Main m) {
    if (doThrow) { throw new Error(); }
    m.intField = 0;
  }

  public static void $opt$noinline$setFloatField(Main m) {
    if (doThrow) { throw new Error(); }
    m.floatField = 0;
  }

  public static void $opt$noinline$setLongField(Main m) {
    if (doThrow) { throw new Error(); }
    m.longField = 0;
  }

  public static void $opt$noinline$setDoubleField(Main m) {
    if (doThrow) { throw new Error(); }
    m.doubleField = 0;
  }

  public static void $opt$noinline$setByteField(Main m) {
    if (doThrow) { throw new Error(); }
    m.byteField = 0;
  }

  public static void $opt$noinline$setBooleanField(Main m) {
    if (doThrow) { throw new Error(); }
    m.booleanField = false;
  }

  public static void $opt$noinline$setCharField(Main m) {
    if (doThrow) { throw new Error(); }
    m.charField = 0;
  }

  public static void $opt$noinline$setShortField(Main m) {
    if (doThrow) { throw new Error(); }
    m.shortField = 0;
  }

  public static Object $opt$noinline$getObjectField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.objectField;
  }

  public static int $opt$noinline$getIntField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.intField;
  }

  public static float $opt$noinline$getFloatField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.floatField;
  }

  public static long $opt$noinline$getLongField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.longField;
  }

  public static double $opt$noinline$getDoubleField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.doubleField;
  }

  public static byte $opt$noinline$getByteField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.byteField;
  }

  public static boolean $opt$noinline$getBooleanField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.booleanField;
  }

  public static char $opt$noinline$getCharField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.charField;
  }

  public static short $opt$noinline$getShortField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.shortField;
  }

  public static void $opt$noinline$setVolatileObjectField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileObjectField = null;
  }

  public static void $opt$noinline$setVolatileIntField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileIntField = 0;
  }

  public static void $opt$noinline$setVolatileFloatField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileFloatField = 0;
  }

  public static void $opt$noinline$setVolatileLongField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileLongField = 0;
  }

  public static void $opt$noinline$setVolatileDoubleField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileDoubleField = 0;
  }

  public static void $opt$noinline$setVolatileByteField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileByteField = 0;
  }

  public static void $opt$noinline$setVolatileBooleanField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileBooleanField = false;
  }

  public static void $opt$noinline$setVolatileCharField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileCharField = 0;
  }

  public static void $opt$noinline$setVolatileShortField(Main m) {
    if (doThrow) { throw new Error(); }
    m.volatileShortField = 0;
  }

  public static Object $opt$noinline$getVolatileObjectField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileObjectField;
  }

  public static int $opt$noinline$getVolatileIntField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileIntField;
  }

  public static float $opt$noinline$getVolatileFloatField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileFloatField;
  }

  public static long $opt$noinline$getVolatileLongField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileLongField;
  }

  public static double $opt$noinline$getVolatileDoubleField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileDoubleField;
  }

  public static byte $opt$noinline$getVolatileByteField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileByteField;
  }

  public static boolean $opt$noinline$getVolatileBooleanField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileBooleanField;
  }

  public static char $opt$noinline$getVolatileCharField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileCharField;
  }

  public static short $opt$noinline$getVolatileShortField(Main m) {
    if (doThrow) { throw new Error(); }
    return m.volatileShortField;
  }

  public static void $opt$noinline$setObjectElement(Object[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = null;
  }

  public static void $opt$noinline$setIntElement(int[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = 0;
  }

  public static void $opt$noinline$setFloatElement(float[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = 0;
  }

  public static void $opt$noinline$setLongElement(long[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = 0;
  }

  public static void $opt$noinline$setDoubleElement(double[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = 0;
  }

  public static void $opt$noinline$setByteElement(byte[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = 0;
  }

  public static void $opt$noinline$setBooleanElement(boolean[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = false;
  }

  public static void $opt$noinline$setCharElement(char[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = 0;
  }

  public static void $opt$noinline$setShortElement(short[] a) {
    if (doThrow) { throw new Error(); }
    a[0] = 0;
  }

  public static Object $opt$noinline$getObjectElement(Object[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static int $opt$noinline$getIntElement(int[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static float $opt$noinline$getFloatElement(float[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static long $opt$noinline$getLongElement(long[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static double $opt$noinline$getDoubleElement(double[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static byte $opt$noinline$getByteElement(byte[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static boolean $opt$noinline$getBooleanElement(boolean[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static char $opt$noinline$getCharElement(char[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static short $opt$noinline$getShortElement(short[] a) {
    if (doThrow) { throw new Error(); }
    return a[0];
  }

  public static void main(String[] args) {
    int methodLine = 42;
    int thisLine = 312;
    try {
      $opt$noinline$setObjectField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 2, methodLine, "$opt$noinline$setObjectField");
    }
    try {
      $opt$noinline$setIntField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setIntField");
    }
    try {
      $opt$noinline$setFloatField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setFloatField");
    }
    try {
      $opt$noinline$setLongField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setLongField");
    }
    try {
      $opt$noinline$setDoubleField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setDoubleField");
    }
    try {
      $opt$noinline$setByteField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setByteField");
    }
    try {
      $opt$noinline$setBooleanField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setBooleanField");
    }
    try {
      $opt$noinline$setCharField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setCharField");
    }
    try {
      $opt$noinline$setShortField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setShortField");
    }
    try {
      $opt$noinline$getObjectField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getObjectField");
    }
    try {
      $opt$noinline$getIntField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getIntField");
    }
    try {
      $opt$noinline$getFloatField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getFloatField");
    }
    try {
      $opt$noinline$getLongField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getLongField");
    }
    try {
      $opt$noinline$getDoubleField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getDoubleField");
    }
    try {
      $opt$noinline$getByteField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getByteField");
    }
    try {
      $opt$noinline$getBooleanField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getBooleanField");
    }
    try {
      $opt$noinline$getCharField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getCharField");
    }
    try {
      $opt$noinline$getShortField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getShortField");
    }
    try {
      $opt$noinline$setVolatileObjectField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileObjectField");
    }
    try {
      $opt$noinline$setVolatileIntField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileIntField");
    }
    try {
      $opt$noinline$setVolatileFloatField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileFloatField");
    }
    try {
      $opt$noinline$setVolatileLongField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileLongField");
    }
    try {
      $opt$noinline$setVolatileDoubleField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileDoubleField");
    }
    try {
      $opt$noinline$setVolatileByteField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileByteField");
    }
    try {
      $opt$noinline$setVolatileBooleanField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileBooleanField");
    }
    try {
      $opt$noinline$setVolatileCharField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileCharField");
    }
    try {
      $opt$noinline$setVolatileShortField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setVolatileShortField");
    }
    try {
      $opt$noinline$getVolatileObjectField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileObjectField");
    }
    try {
      $opt$noinline$getVolatileIntField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileIntField");
    }
    try {
      $opt$noinline$getVolatileFloatField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileFloatField");
    }
    try {
      $opt$noinline$getVolatileLongField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileLongField");
    }
    try {
      $opt$noinline$getVolatileDoubleField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileDoubleField");
    }
    try {
      $opt$noinline$getVolatileByteField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileByteField");
    }
    try {
      $opt$noinline$getVolatileBooleanField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileBooleanField");
    }
    try {
      $opt$noinline$getVolatileCharField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileCharField");
    }
    try {
      $opt$noinline$getVolatileShortField(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getVolatileShortField");
    }
    try {
      $opt$noinline$setObjectElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setObjectElement");
    }
    try {
      $opt$noinline$setIntElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setIntElement");
    }
    try {
      $opt$noinline$setFloatElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setFloatElement");
    }
    try {
      $opt$noinline$setLongElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setLongElement");
    }
    try {
      $opt$noinline$setDoubleElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setDoubleElement");
    }
    try {
      $opt$noinline$setByteElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setByteElement");
    }
    try {
      $opt$noinline$setBooleanElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setBooleanElement");
    }
    try {
      $opt$noinline$setCharElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setCharElement");
    }
    try {
      $opt$noinline$setShortElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$setShortElement");
    }
    try {
      $opt$noinline$getObjectElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getObjectElement");
    }
    try {
      $opt$noinline$getIntElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getIntElement");
    }
    try {
      $opt$noinline$getFloatElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getFloatElement");
    }
    try {
      $opt$noinline$getLongElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getLongElement");
    }
    try {
      $opt$noinline$getDoubleElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getDoubleElement");
    }
    try {
      $opt$noinline$getByteElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getByteElement");
    }
    try {
      $opt$noinline$getBooleanElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getBooleanElement");
    }
    try {
      $opt$noinline$getCharElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getCharElement");
    }
    try {
      $opt$noinline$getShortElement(null);
      throw new RuntimeException("Failed to throw NullPointerException.");
    } catch (NullPointerException npe) {
      check(npe, thisLine += 6, methodLine += 5, "$opt$noinline$getShortElement");
    }

    $opt$noinline$testRegisterRetrieval();
  }

  static void $opt$noinline$testRegisterRetrieval() {
    Main[] array = $noinline$PrepareArray();
    int i0 = 0;
    int i1 = 1;
    int i2 = 2;
    int i3 = 3;
    int i4 = 4;
    int i5 = 5;
    int i6 = 6;
    int i7 = 7;
    int i8 = 8;
    int i9 = 9;
    int i10 = 10;
    int i11 = 11;
    int i12 = 12;
    int i13 = 13;
    int i14 = 14;
    int i15 = 15;
    long l0 = 20L;
    long l1 = 21L;
    long l2 = 22L;
    long l3 = 23L;
    long l4 = 24L;
    long l5 = 25L;
    long l6 = 26L;
    long l7 = 27L;
    long l8 = 28L;
    long l9 = 29L;
    long l10 = 30L;
    long l11 = 31L;
    long l12 = 32L;
    long l13 = 33L;
    long l14 = 34L;
    long l15 = 35L;
    float f0 = 40.0f;
    float f1 = 41.0f;
    float f2 = 42.0f;
    float f3 = 43.0f;
    float f4 = 44.0f;
    float f5 = 45.0f;
    float f6 = 46.0f;
    float f7 = 47.0f;
    float f8 = 48.0f;
    float f9 = 49.0f;
    float f10 = 50.0f;
    float f11 = 51.0f;
    float f12 = 52.0f;
    float f13 = 53.0f;
    float f14 = 54.0f;
    float f15 = 55.0f;
    double d0 = 60.0;
    double d1 = 61.0;
    double d2 = 62.0;
    double d3 = 63.0;
    double d4 = 64.0;
    double d5 = 65.0;
    double d6 = 66.0;
    double d7 = 67.0;
    double d8 = 68.0;
    double d9 = 69.0;
    double d10 = 70.0;
    double d11 = 71.0;
    double d12 = 72.0;
    double d13 = 73.0;
    double d14 = 74.0;
    double d15 = 75.0;
    int addInt = -1;
    long addLong = -2L;
    float addFloat = -3.0f;
    double addDouble = -4.0;
    Main m = null;
    int i = 0;
    try {
      for (i = 0; i < array.length; ++i) {
        m = array[i];
        // We have 16 ints, 16 longs, 16 floats, 16 doubles and a few helper variables here,
        // none of them anonymous. Hopefully, all available physical registers will be allocated
        // to these variables, so that when `m.intField` throws NPE during the third iteration,
        // we will fully test retrieval of values from all physical registers.
        addInt = m.intField;
        addLong = m.longField;
        addFloat = m.floatField;
        addDouble = m.doubleField;
        i0 += i1;
        i1 += i2;
        i2 += i3;
        i3 += i4;
        i4 += i5;
        i5 += i6;
        i6 += i7;
        i7 += i8;
        i8 += i9;
        i9 += i10;
        i10 += i11;
        i11 += i12;
        i12 += i13;
        i13 += i14;
        i14 += i15;
        i15 += addInt;
        l0 += l1;
        l1 += l2;
        l2 += l3;
        l3 += l4;
        l4 += l5;
        l5 += l6;
        l6 += l7;
        l7 += l8;
        l8 += l9;
        l9 += l10;
        l10 += l11;
        l11 += l12;
        l12 += l13;
        l13 += l14;
        l14 += l15;
        l15 += addLong;
        f0 += f1;
        f1 += f2;
        f2 += f3;
        f3 += f4;
        f4 += f5;
        f5 += f6;
        f6 += f7;
        f7 += f8;
        f8 += f9;
        f9 += f10;
        f10 += f11;
        f11 += f12;
        f12 += f13;
        f13 += f14;
        f14 += f15;
        f15 += addFloat;
        d0 += d1;
        d1 += d2;
        d2 += d3;
        d3 += d4;
        d4 += d5;
        d5 += d6;
        d6 += d7;
        d7 += d8;
        d8 += d9;
        d9 += d10;
        d10 += d11;
        d11 += d12;
        d12 += d13;
        d13 += d14;
        d14 += d15;
        d15 += addDouble;
      }
    } catch (NullPointerException npe) {
      System.out.println("i0=" + i0);
      System.out.println("i1=" + i1);
      System.out.println("i2=" + i2);
      System.out.println("i3=" + i3);
      System.out.println("i4=" + i4);
      System.out.println("i5=" + i5);
      System.out.println("i6=" + i6);
      System.out.println("i7=" + i7);
      System.out.println("i8=" + i8);
      System.out.println("i9=" + i9);
      System.out.println("i10=" + i10);
      System.out.println("i11=" + i11);
      System.out.println("i12=" + i12);
      System.out.println("i13=" + i13);
      System.out.println("i14=" + i14);
      System.out.println("i15=" + i15);
      System.out.println("l0=" + l0);
      System.out.println("l1=" + l1);
      System.out.println("l2=" + l2);
      System.out.println("l3=" + l3);
      System.out.println("l4=" + l4);
      System.out.println("l5=" + l5);
      System.out.println("l6=" + l6);
      System.out.println("l7=" + l7);
      System.out.println("l8=" + l8);
      System.out.println("l9=" + l9);
      System.out.println("l10=" + l10);
      System.out.println("l11=" + l11);
      System.out.println("l12=" + l12);
      System.out.println("l13=" + l13);
      System.out.println("l14=" + l14);
      System.out.println("l15=" + l15);
      System.out.println("f0=" + f0);
      System.out.println("f1=" + f1);
      System.out.println("f2=" + f2);
      System.out.println("f3=" + f3);
      System.out.println("f4=" + f4);
      System.out.println("f5=" + f5);
      System.out.println("f6=" + f6);
      System.out.println("f7=" + f7);
      System.out.println("f8=" + f8);
      System.out.println("f9=" + f9);
      System.out.println("f10=" + f10);
      System.out.println("f11=" + f11);
      System.out.println("f12=" + f12);
      System.out.println("f13=" + f13);
      System.out.println("f14=" + f14);
      System.out.println("f15=" + f15);
      System.out.println("d0=" + d0);
      System.out.println("d1=" + d1);
      System.out.println("d2=" + d2);
      System.out.println("d3=" + d3);
      System.out.println("d4=" + d4);
      System.out.println("d5=" + d5);
      System.out.println("d6=" + d6);
      System.out.println("d7=" + d7);
      System.out.println("d8=" + d8);
      System.out.println("d9=" + d9);
      System.out.println("d10=" + d10);
      System.out.println("d11=" + d11);
      System.out.println("d12=" + d12);
      System.out.println("d13=" + d13);
      System.out.println("d14=" + d14);
      System.out.println("d15=" + d15);
      System.out.println("addInt=" + addInt);
      System.out.println("addLong=" + addLong);
      System.out.println("addFloat=" + addFloat);
      System.out.println("addDouble=" + addDouble);
      System.out.println("m=" + m);
      System.out.println("i=" + i);
    }
  }

  static Main[] $noinline$PrepareArray() {
    if (doThrow) { throw new Error(); }
    Main[] array = new Main[] { new Main(), new Main(), null, new Main() };
    array[1].intField = 42;
    array[1].longField = 111L;
    array[1].floatField = 0.5f;
    array[1].doubleField = 0.125;
    return array;
  }

  static void check(NullPointerException npe, int mainLine, int methodLine, String methodName) {
    System.out.println(methodName);
    StackTraceElement[] trace = npe.getStackTrace();
    checkElement(trace[0], "Main", methodName, "Main.java", methodLine);
    checkElement(trace[1], "Main", "main", "Main.java", mainLine);
  }

  static void checkElement(StackTraceElement element,
                           String declaringClass, String methodName,
                           String fileName, int lineNumber) {
    assertEquals(declaringClass, element.getClassName());
    assertEquals(methodName, element.getMethodName());
    assertEquals(fileName, element.getFileName());
    assertEquals(lineNumber, element.getLineNumber());
  }

  static void assertEquals(Object expected, Object actual) {
    if (!expected.equals(actual)) {
      String msg = "Expected \"" + expected + "\" but got \"" + actual + "\"";
      throw new AssertionError(msg);
    }
  }

  static void assertEquals(int expected, int actual) {
    if (expected != actual) {
      throw new AssertionError("Expected " + expected + " got " + actual);
    }
  }

}
