!!****h* BigDFT/lazy_30
!! NAME
!!   lazy_30
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 30)
!!
!! SOURCE
!!
integer, parameter :: m=32
real(dp), dimension(-m:m) :: ch = (/ &
     0._dp, 0._dp, 0._dp, &
     2.78364831185484718e-10_dp,0._dp,-8.6705490009997277e-9_dp,0._dp, &
     1.31098700895115883e-7_dp,0._dp,-1.28248729136526407e-6_dp,0._dp, &
     9.13008809805271326e-6_dp,0._dp,-0.000050455750015554468_dp,0._dp, &
     0.000225566882422478798_dp,0._dp,-0.00083996810502084962_dp,0._dp, &
     0.0026652834101623113_dp,0._dp,-0.00734972091893243418_dp,0._dp, &
     0.0179659844685015058_dp,0._dp,-0.039898484988490357_dp,0._dp, &
     0.0837868184758297496_dp,0._dp,-0.18261229667809048_dp,0._dp,0.626099302896310217_dp, &
     1._dp,0.626099302896310217_dp,0._dp,-0.18261229667809048_dp,0._dp, &
     0.0837868184758297496_dp,0._dp,-0.039898484988490357_dp,0._dp, &
     0.0179659844685015058_dp,0._dp,-0.00734972091893243418_dp,0._dp, &
     0.0026652834101623113_dp,0._dp,-0.00083996810502084962_dp,0._dp, &
     0.000225566882422478798_dp,0._dp,-0.000050455750015554468_dp,0._dp, &
     9.13008809805271326e-6_dp,0._dp,-1.28248729136526407e-6_dp,0._dp, &
     1.31098700895115883e-7_dp,0._dp,-8.6705490009997277e-9_dp,0._dp, &
     2.78364831185484718e-10_dp, &
     0._dp, 0._dp, 0._dp   /)
real(dp), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1._dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

