/* Copyright (C) 2014 Wildfire Games.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "precompiled.h"

#include "lib/sysdep/sysdep.h"
#include "lib/sysdep/os/unix/unix_executable_pathname.h"

static bool getPathFromProc(char* buffer, size_t length)
{
	int pos = readlink("/proc/self/exe", buffer, length-1);
	if (pos <= 0)
		return false;

	buffer[pos] = '\0';

	char* endOfPath = strrchr(buffer, '/');
	if (endOfPath == NULL)
		return false;

	++endOfPath;
	*endOfPath = '\0';

	return true;
}

OsPath sys_ExecutablePathname()
{
	// Check /proc for the path
	char pathBuffer[PATH_MAX];
	if (getPathFromProc(pathBuffer, sizeof(pathBuffer)))
		return pathBuffer;

	return unix_ExecutablePathname();
}
