#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Defender's Quest
# send your bug reports to contact@dotslashplay.it
###

script_version=20230629.1

GAME_ID='defenders-quest'
GAME_NAME='Defenderʼs Quest: Valley of the Forgotten'

ARCHIVE_BASE_0='defender_s_quest_en_dx_2_2_6_21273.sh'
ARCHIVE_BASE_0_MD5='32b2dbbdcd8cfd697e15002ad9f62710'
ARCHIVE_BASE_0_SIZE='500000'
ARCHIVE_BASE_0_VERSION='2.2.6-gog21273'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/defenders_quest'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_FILES='
zlib.dso
regexp.dso
std.dso
lime.ndll
steamwrap.ndll
libsteam_api.so'
CONTENT_GAME_BIN_FILES='
crashdumper
flixel
manifest
DefendersQuest
LevelEditor
steam_appid.txt'
CONTENT_GAME_DATA_FILES='
assets'

APP_MAIN_EXE='DefendersQuest'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
