#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Year of Springs
# send your bug reports to contact@dotslashplay.it
###

script_version=20230405.1

GAME_ID='a-year-of-springs'
GAME_NAME='A Year of Springs'

ARCHIVE_BASE_0='a_year_of_springs_1_05_60321.sh'
ARCHIVE_BASE_0_MD5='683044c44f06061a84490c2a02b5303b'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='260000'
ARCHIVE_BASE_0_VERSION='1.05-gog60321'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/a_year_of_springs'

CONTENT_PATH_DEFAULT='data/noarch/game/ayearofsprings-market'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib/py2-linux-x86_64"
CONTENT_LIBS_BIN_FILES='
librenpython.so'
CONTENT_GAME_BIN_FILES='
lib/py2-linux-x86_64/ayearofsprings
lib/py2-linux-x86_64/python
lib/py2-linux-x86_64/pythonw
lib/py2-linux-x86_64/zsync
lib/py2-linux-x86_64/zsyncmake'
CONTENT_GAME_DATA_FILES='
game
renpy
lib/python2.7
ayearofsprings.py'

APP_MAIN_EXE='lib/py2-linux-x86_64/ayearofsprings'
APP_MAIN_ICON='../../support/icon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libGL.so.1
libm.so.6
libpthread.so.0
libutil.so.1'

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
