/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef BIOS_COMMON_H_
#define BIOS_COMMON_H_

#include <stdint.h>
#include <Common.h>
#include <SMBIOS.h>

/*
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __linux__
#include <ctype.h>
#include <sys/io.h>
#endif
*/

const unsigned int CMOS_SIZE = 4*0x80;
const unsigned int CMOS_MAX_SIZE = 4096;

#define IO_READ  1
#define IO_WRITE 2
#define IO_RDWR  (IO_READ | IO_WRITE)

#define PORT_CMOS_0 0x70
#define PORT_CMOS_1 0x71
#define PORT_CMOS_2 0x72
#define PORT_CMOS_3 0x73
#define PORT_CMOS_4 0x74
#define PORT_CMOS_5 0x75
#define PORT_CMOS_6 0x76
#define PORT_CMOS_7 0x77

#define DEFAULT          0
#define ACER             1
#define AMI              2
#define AWARD            3
#define COMPAQ           4
#define DTK              5
#define IBM              6
#define PACKARD_BELL     7
#define PHOENIX          8
#define GATEWAY_PHOENIX  9
#define SAMSUNG         10
#define SONY            11
#define TOSHIBA         12
#define ZENITH_AMI      13

typedef struct _bios_information
{
	BYTE type;                  // 0
	BYTE length;                // Varies
	WORD handle;                // Varies
	BYTE vendor;                // STRING
	BYTE bios_version;          // STRING
	WORD bios_starting;         // Varies
	BYTE bios_release_date;     // STRING
	BYTE bios_rom_size;         // Varies
	QWORD bios_characteristics; // Bit Field
}bios_information;

int CF_loadCMOS(uint8_t *cmos, const int cmos_size, string& errorMessage);

int SMBIOS_getBIOSInformation(vector<bios_information>& bios,vector< vector<string> >& dmi_strings,string& errorMessage);

int CF_getBIOSManufacturer(const string& manufacturer);

#endif /*BIOS_COMMON_H_*/
