/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.language.ast;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.rewrite.INodeWriter;
import org.eclipse.cdt.core.dom.rewrite.IScribe;
import org.eclipse.cdt.core.dom.rewrite.IWritableNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.MacroExpansionHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class KernelCallExpression
extends CPPASTFunctionCallExpression
implements IWritableNode,
INodeWriter {
    private final IASTInitializerClause[] fArguments;
    private final IASTExpression functionName;
    private final IASTInitializerClause[] launchParameters;

    public KernelCallExpression(IASTExpression functionName, IASTInitializerClause[] launchArgs, IASTInitializerClause[] args) {
        super(functionName, args);
        this.functionName = functionName;
        this.assertNotFrozen();
        if (launchArgs == null) {
            this.launchParameters = IASTExpression.EMPTY_EXPRESSION_ARRAY;
        } else {
            this.launchParameters = launchArgs;
            IASTInitializerClause[] iASTInitializerClauseArray = launchArgs;
            int n = launchArgs.length;
            int n2 = 0;
            while (n2 < n) {
                IASTInitializerClause arg = iASTInitializerClauseArray[n2];
                arg.setParent((IASTNode)this);
                arg.setPropertyInParent(ARGUMENT);
                ++n2;
            }
        }
        this.fArguments = args != null ? args : IASTExpression.EMPTY_EXPRESSION_ARRAY;
    }

    public boolean accept(ASTVisitor action) {
        IASTInitializerClause arg;
        IASTImplicitName[] implicits;
        if (action.shouldVisitExpressions) {
            switch (action.visit((IASTExpression)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.functionName != null && !this.functionName.accept(action)) {
            return false;
        }
        IASTImplicitName[] iASTImplicitNameArray = implicits = action.shouldVisitImplicitNames ? this.getImplicitNames() : null;
        if (implicits != null && implicits.length > 0 && !implicits[0].accept(action)) {
            return false;
        }
        IASTInitializerClause[] iASTInitializerClauseArray = this.launchParameters;
        int n = this.launchParameters.length;
        int n2 = 0;
        while (n2 < n) {
            arg = iASTInitializerClauseArray[n2];
            if (!arg.accept(action)) {
                return false;
            }
            ++n2;
        }
        iASTInitializerClauseArray = this.fArguments;
        n = this.fArguments.length;
        n2 = 0;
        while (n2 < n) {
            arg = iASTInitializerClauseArray[n2];
            if (!arg.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (implicits != null && implicits.length > 0 && !implicits[1].accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave((IASTExpression)this) != 2;
    }

    public IASTInitializerClause[] getLaunchParameters() {
        return this.launchParameters;
    }

    public INodeWriter getWriter() {
        return this;
    }

    public void write(IWritableNode node, IScribe scribe, ASTWriterVisitor writerVisitor, NodeCommentMap commentMap, MacroExpansionHandler macroHandler) {
        KernelCallExpression kernelCall = (KernelCallExpression)node;
        kernelCall.getFunctionNameExpression().accept((ASTVisitor)writerVisitor);
        scribe.print("<<<");
        this.writeArgumentList(kernelCall.getLaunchParameters(), scribe, (ASTVisitor)writerVisitor);
        scribe.print(">>>");
        scribe.print('(');
        this.writeArgumentList(kernelCall.getArguments(), scribe, (ASTVisitor)writerVisitor);
        scribe.print(')');
    }

    private void writeArgumentList(IASTInitializerClause[] args, IScribe scribe, ASTVisitor visitor) {
        boolean needComma = false;
        IASTInitializerClause[] iASTInitializerClauseArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            if (needComma) {
                scribe.print(", ");
            }
            arg.accept(visitor);
            needComma = true;
            ++n2;
        }
    }
}

