/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.IReconcilingParticipant;
import org.eclipse.cdt.make.internal.ui.editor.MakefileContentOutlinePage;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class MakefileReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private MakefileContentOutlinePage fOutliner;
    private IReconcilingParticipant fMakefileReconcilingParticipant;

    public MakefileReconcilingStrategy(MakefileEditor editor) {
        this.fOutliner = editor.getOutlinePage();
        this.fEditor = editor;
        this.fManager = MakeUIPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = MakeUIPlugin.getDefault().getMakefileDocumentProvider();
        if (this.fEditor instanceof IReconcilingParticipant) {
            this.fMakefileReconcilingParticipant = (IReconcilingParticipant)this.fEditor;
        }
    }

    public void setDocument(IDocument document) {
    }

    public void reconcile(IRegion region) {
        this.reconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion region) {
        assert (false) : "This is a non-incremental reconciler";
    }

    private void reconcile() {
        block6: {
            try {
                IMakefile makefile = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
                if (makefile == null) break block6;
                String content = this.fDocumentProvider.getDocument((Object)this.fEditor.getEditorInput()).get();
                StringReader reader = new StringReader(content);
                try {
                    makefile.parse(makefile.getFileURI(), (Reader)reader);
                }
                catch (IOException iOException) {}
                this.fOutliner.update();
            }
            finally {
                if (this.fMakefileReconcilingParticipant != null) {
                    this.fMakefileReconcilingParticipant.reconciled();
                }
            }
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void initialReconcile() {
    }
}

