/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.internal.toolkit.BundledToolkit;
import com.nvidia.common.internal.toolkit.CommandLineToolkit;
import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.internal.toolkit.LocallyInstalledToolkits;
import com.nvidia.common.internal.toolkit.ToolkitOnPath;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.toolkit.IToolkitRegistry;
import com.nvidia.common.toolkit.ToolkitVersion;
import com.nvidia.common.util.CoreUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public final class ToolkitManager
extends AbstractPreferenceInitializer
implements IToolkitManager {
    private static final String TOOLKITS_PREFERENCE = "cuda.toolkits";
    private static final String PREF_DEFAULT_TOOLKIT = "cuda.toolkits.default";
    private IToolkitRegistry registry = null;
    private static final IToolkitLookup[] toolkitLookups = new IToolkitLookup[]{new CommandLineToolkit(), new BundledToolkit(), new ToolkitOnPath(), new LocallyInstalledToolkits()};
    private final Collection<ICudaToolkit> toolkits = new LinkedHashSet<ICudaToolkit>();

    private static String getToolkitPathPreferenceName(int id) {
        return String.format("%s.%d.path", TOOLKITS_PREFERENCE, id);
    }

    @Override
    public ICudaToolkit editToolkit(String id) {
        if (this.registry != null && this.registry.ownsToolkit(id)) {
            return this.registry.editToolkit(id);
        }
        return null;
    }

    @Override
    public ICudaToolkit getDefaultToolkit() {
        int i;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String string = store.getString(ToolkitManager.getToolkitPathPreferenceName(i = store.getInt(PREF_DEFAULT_TOOLKIT)));
        if (string != null && new File(string).isDirectory()) {
            String label = null;
            ToolkitVersion[] toolkitVersionArray = ToolkitVersion.supportedToolkits;
            int n = ToolkitVersion.supportedToolkits.length;
            int n2 = 0;
            while (n2 < n) {
                ToolkitVersion tk = toolkitVersionArray[n2];
                if (tk.defaultBinPath.equals(string) || tk.defaultMacBinPath.equals(string)) {
                    label = tk.label;
                }
                ++n2;
            }
            return new CudaToolkit(null, (IPath)new Path(string), label);
        }
        return null;
    }

    public IToolkitRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public ICudaToolkit getToolkit(String id) throws CoreException {
        if (CoreUtil.isNullOrEmpty(id)) {
            return this.getDefaultToolkit();
        }
        if (this.registry != null) {
            return this.registry.getToolkit(id);
        }
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.registry != null ? this.registry.isInitialized() : true;
    }

    private synchronized Collection<ICudaToolkit> getLocalToolkits() {
        if (this.toolkits.size() > 0) {
            return this.toolkits;
        }
        IToolkitLookup[] iToolkitLookupArray = toolkitLookups;
        int n = toolkitLookups.length;
        int n2 = 0;
        while (n2 < n) {
            IToolkitLookup lookup = iToolkitLookupArray[n2];
            ICudaToolkit[] discovered = lookup.discover();
            if (discovered != null) {
                List<ICudaToolkit> discoveredList = Arrays.asList(discovered);
                this.toolkits.removeAll(discoveredList);
                this.toolkits.addAll(discoveredList);
            }
            ++n2;
        }
        return this.toolkits;
    }

    @Override
    public ICudaToolkit[] getAvailableToolkits() {
        Collection<ICudaToolkit> toolkits = this.getLocalToolkits();
        return toolkits.toArray(new ICudaToolkit[toolkits.size()]);
    }

    @Override
    public ICudaToolkit getToolkitByName(String name) {
        for (ICudaToolkit tk : this.getLocalToolkits()) {
            if (!CoreUtil.equals(tk.getName(), name)) continue;
            return tk;
        }
        return this.getDefaultToolkit();
    }

    public void initializeDefaultPreferences() {
        Collection<ICudaToolkit> toolkits = this.getLocalToolkits();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (!toolkits.isEmpty()) {
            int i = 1;
            store.setDefault(PREF_DEFAULT_TOOLKIT, 1);
            for (ICudaToolkit toolkit : toolkits) {
                String preferenceName = ToolkitManager.getToolkitPathPreferenceName(i++);
                IPath tkBinPath = Path.fromOSString((String)toolkit.getBinDirectory());
                store.setDefault(preferenceName, tkBinPath.toPortableString());
            }
        }
    }

    public void setRegistry(IToolkitRegistry registry) {
        this.registry = registry;
    }
}

