/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaThreadColumns;
import com.nvidia.cuda.ide.debug.util.IMultiColumnVMNode;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ICellModifier;

public final class MultiColumnCellModifier
implements ICellModifier {
    private final ICellModifier delegate;
    private final ICudaThreadColumns columns;
    private final IMultiColumnVMNode node;

    public MultiColumnCellModifier(ICellModifier delegate, ICudaThreadColumns columns, IMultiColumnVMNode node) {
        this.delegate = delegate;
        this.columns = columns;
        this.node = node;
    }

    public boolean canModify(Object element, String property) {
        Object el = this.getElementFromDifferentThread(element, property);
        if (el != null) {
            return this.delegate.canModify(element, "org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE");
        }
        return this.delegate.canModify(element, property);
    }

    private Object getElementFromDifferentThread(Object element, String property) {
        if (!(element instanceof IDMVMContext)) {
            return null;
        }
        IDMContext ctx = ((IDMVMContext)element).getDMContext();
        IFocusDMContext focus = this.columns.getColumnFocus(property);
        if (focus == null) {
            return null;
        }
        if (focus.equals(DMContexts.getAncestorOfType((IDMContext)ctx, IFocusDMContext.class))) {
            return element;
        }
        try {
            return this.adopt(ctx, focus);
        }
        catch (InterruptedException e) {
            Activator.log(e);
            return null;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CoreException && ((CoreException)cause).getStatus().getSeverity() == 1) {
                return null;
            }
            Activator.log(e);
            return null;
        }
    }

    private Object adopt(final IDMContext ctx, final IFocusDMContext focus) throws InterruptedException, ExecutionException {
        Query<IDMContext[]> adoptionQuery = new Query<IDMContext[]>(){

            protected void execute(DataRequestMonitor<IDMContext[]> rm) {
                focus.getExpressionContexts(new IDMContext[]{ctx}, rm);
            }
        };
        DsfSession.getSession((String)focus.getSessionId()).getExecutor().execute((Runnable)adoptionQuery);
        IDMContext[] ctxs = (IDMContext[])adoptionQuery.get();
        return ctxs != null && ctxs.length == 1 ? this.node.createVMContext(ctxs[0]) : null;
    }

    public Object getValue(Object element, String property) {
        Object el = this.getElementFromDifferentThread(element, property);
        if (el != null) {
            return this.delegate.getValue(el, "org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE");
        }
        return this.delegate.getValue(element, property);
    }

    public void modify(Object element, String property, Object value) {
        Object el = this.getElementFromDifferentThread(element, property);
        if (el != null) {
            this.delegate.modify(el, "org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE", value);
        } else {
            this.delegate.modify(element, property, value);
        }
    }
}

