/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.CConfigurationStatus;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.MultiItemsHolder;
import org.eclipse.cdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.cdt.ui.newui.CDTUIListComparator;
import org.eclipse.cdt.ui.newui.ConfigMultiSelectionDialog;
import org.eclipse.cdt.ui.newui.ICPropertyProvider2;
import org.eclipse.cdt.ui.newui.ICPropertyTab;
import org.eclipse.cdt.ui.newui.IConfigManager;
import org.eclipse.cdt.ui.newui.ManageConfigSelector;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public abstract class AbstractPage
extends PropertyPage
implements IPreferencePageContainer,
ICPropertyProvider2 {
    private static ICResourceDescription resd = null;
    private static ICConfigurationDescription[] cfgDescs = null;
    private static ICConfigurationDescription lastSelectedCfg = null;
    private static ICConfigurationDescription[] multiCfgs = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.cPropertyTab";
    private static final String ELEMENT_NAME = "tab";
    private static final String CLASS_NAME = "class";
    private static final String PARENT_NAME = "parent";
    private static final String IMAGE_NAME = "icon";
    private static final String TIP_NAME = "tooltip";
    private static final String TEXT_NAME = "name";
    private static final String WEIGHT_NAME = "weight";
    private static final String HELPID_NAME = "helpId";
    private static final Object NOT_NULL = new Object();
    public static final String EMPTY_STR = "";
    private static final int SAVE_MODE_OK = 1;
    private static final int SAVE_MODE_APPLY = 2;
    private static final int SAVE_MODE_APPLYOK = 3;
    private static final String PREF_ASK_REINDEX = "askReindex";
    private Map<URL, Image> loadedIcons = new HashMap<URL, Image>();
    private static Map<Class<? extends AbstractPage>, Class<? extends ICPropertyTab>> recentTabs = new HashMap<Class<? extends AbstractPage>, Class<? extends ICPropertyTab>>();
    private final Image IMG_WARN = CDTSharedImages.getImage("icons/obj16/warning_obj.gif");
    private Combo configSelector;
    private Button manageButton;
    private Button excludeFromBuildCheck;
    private Label errIcon;
    private Text errMessage;
    private Composite errPane;
    private Composite parentComposite;
    protected boolean noContentOnPage = false;
    protected boolean displayedConfig = false;
    protected IResource internalElement = null;
    protected boolean isProject = false;
    protected boolean isFolder = false;
    protected boolean isFile = false;
    protected TabFolder folder;
    protected ArrayList<InternalTab> itabs = new ArrayList();
    protected ICPropertyTab currentTab;
    private static boolean isNewOpening = true;

    public AbstractPage() {
        if (CDTPropertyManager.getPagesCount() == 0) {
            cfgDescs = null;
            lastSelectedCfg = null;
            multiCfgs = null;
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        String s = null;
        if (!this.checkElement()) {
            s = Messages.AbstractPage_0;
        } else {
            if (!this.isApplicable()) {
                return null;
            }
            if (!this.isCDTProject(this.getProject())) {
                s = Messages.AbstractPage_2;
            }
        }
        if (s == null) {
            this.contentForCDT(composite);
            return composite;
        }
        Label label = new Label(composite, 16384);
        label.setText(s);
        label.setFont(composite.getFont());
        this.noContentOnPage = true;
        this.noDefaultAndApplyButton();
        return composite;
    }

    protected void contentForCDT(Composite composite) {
        if (this.showsConfig()) {
            Group configGroup = ControlFactory.createGroup(composite, EMPTY_STR, 1);
            GridData gd = new GridData(256);
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 150;
            configGroup.setLayoutData((Object)gd);
            configGroup.setLayout((Layout)new GridLayout(3, false));
            Label configLabel = new Label((Composite)configGroup, 0);
            configLabel.setText(Messages.AbstractPage_6);
            configLabel.setLayoutData((Object)new GridData(1));
            this.configSelector = new Combo((Composite)configGroup, 12);
            this.configSelector.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    AbstractPage.this.handleConfigSelection();
                }
            });
            gd = new GridData(1808);
            this.configSelector.setLayoutData((Object)gd);
            if (!CDTPrefUtil.getBool("properties.manage.config.disable")) {
                this.manageButton = new Button((Composite)configGroup, 8);
                this.manageButton.setText(Messages.AbstractPage_12);
                gd = new GridData(3);
                gd.minimumWidth = 150;
                this.manageButton.setLayoutData((Object)gd);
                this.manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IProject[] obs = new IProject[]{AbstractPage.this.getProject()};
                        IConfigManager cm = ManageConfigSelector.getManager(obs);
                        if (cm != null && cm.manage(obs, false)) {
                            cfgDescs = null;
                            AbstractPage.this.populateConfigurations();
                        }
                    }
                });
            } else {
                new Label((Composite)configGroup, 0).setLayoutData((Object)new GridData(3));
            }
            this.errPane = new Composite((Composite)configGroup, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.errPane.setLayoutData((Object)gd);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            this.errPane.setLayout((Layout)gl);
            this.errIcon = new Label(this.errPane, 16384);
            this.errIcon.setLayoutData((Object)new GridData(1));
            this.errIcon.setImage(this.IMG_WARN);
            this.errMessage = new Text(this.errPane, 16392);
            this.errMessage.setLayoutData((Object)new GridData(768));
            if (this.isForFolder() || this.isForFile()) {
                this.excludeFromBuildCheck = new Button((Composite)configGroup, 32);
                this.excludeFromBuildCheck.setText(Messages.AbstractPage_7);
                gd = new GridData(768);
                gd.horizontalSpan = 3;
                this.excludeFromBuildCheck.setLayoutData((Object)gd);
                this.excludeFromBuildCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ICResourceDescription rcDescription = AbstractPage.this.getResDesc();
                        rcDescription.setExcluded(AbstractPage.this.excludeFromBuildCheck.getSelection());
                        if (AbstractPage.this.currentTab instanceof AbstractCPropertyTab) {
                            ((AbstractCPropertyTab)AbstractPage.this.currentTab).updateData(rcDescription);
                        }
                    }
                });
            }
        }
        this.populateConfigurations();
        if (this.excludeFromBuildCheck != null) {
            this.excludeFromBuildCheck.setSelection(this.getResDesc().isExcluded());
        }
        this.createWidgets(composite);
    }

    public void createWidgets(Composite c) {
        this.parentComposite = new Composite(c, 0);
        GridData gd = new GridData(1808);
        this.parentComposite.setLayoutData((Object)gd);
        gd.widthHint = 600;
        this.itabs.clear();
        if (!this.isSingle()) {
            this.parentComposite.setLayout((Layout)new FillLayout());
            this.folder = new TabFolder(this.parentComposite, 0);
        }
        this.loadExtensionsSynchronized(this.parentComposite);
        if (this.folder != null) {
            this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (AbstractPage.this.folder.getSelection().length > 0) {
                        AbstractPage.this.updateSelectedTab();
                    }
                }
            });
            if (this.folder.getItemCount() > 0) {
                int selectedTab = 0;
                Class<? extends ICPropertyTab> recentTab = recentTabs.get(this.getClass());
                if (recentTab != null) {
                    TabItem[] tabs = this.folder.getItems();
                    int i = 0;
                    while (i < tabs.length) {
                        TabItem control = tabs[i];
                        if (recentTab.isInstance(control.getData())) {
                            selectedTab = i;
                            break;
                        }
                        ++i;
                    }
                }
                this.folder.setSelection(selectedTab);
                this.updateSelectedTab();
            }
        }
    }

    private void updateSelectedTab() {
        ICPropertyTab newTab = (ICPropertyTab)this.folder.getSelection()[0].getData();
        if (newTab != null && this.currentTab != newTab) {
            recentTabs.put(this.getClass(), newTab.getClass());
            if (this.currentTab != null) {
                this.currentTab.handleTabEvent(5, null);
            }
            this.currentTab = newTab;
            this.currentTab.handleTabEvent(5, NOT_NULL);
        }
    }

    @Override
    public IProject getProject() {
        IAdaptable element = this.getElement();
        if (element != null) {
            if (element instanceof IFile || element instanceof IProject || element instanceof IFolder) {
                IResource f = (IResource)element;
                return f.getProject();
            }
            if (element instanceof ICProject) {
                return ((ICProject)element).getProject();
            }
        }
        return null;
    }

    private void handleConfigSelection() {
        if (this.configSelector.getItemCount() == 0) {
            return;
        }
        int selectionIndex = this.configSelector.getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        if (cfgDescs == null || cfgDescs.length == 0) {
            return;
        }
        if (selectionIndex >= cfgDescs.length) {
            if (selectionIndex == cfgDescs.length) {
                multiCfgs = cfgDescs;
            } else {
                boolean enterMultiCfgsDialog;
                boolean bl = enterMultiCfgsDialog = multiCfgs == null || multiCfgs == cfgDescs || !AbstractPage.areCfgsStillThere(multiCfgs);
                if (enterMultiCfgsDialog) {
                    ICConfigurationDescription[] mcfgs = ConfigMultiSelectionDialog.select(cfgDescs, this.parentComposite.getShell());
                    if (mcfgs == null || mcfgs.length == 0) {
                        int cfgIndex = -1;
                        cfgIndex = multiCfgs == cfgDescs ? cfgDescs.length : AbstractPage.getCfgIndex(lastSelectedCfg);
                        this.configSelector.select(cfgIndex);
                        return;
                    }
                    multiCfgs = mcfgs;
                }
            }
            lastSelectedCfg = null;
            this.cfgChanged(MultiItemsHolder.createCDescription((ICConfigurationDescription[])multiCfgs));
            return;
        }
        multiCfgs = null;
        String id1 = this.getResDesc() == null ? null : this.getResDesc().getId();
        lastSelectedCfg = cfgDescs[selectionIndex];
        String id2 = lastSelectedCfg.getId();
        if (id2 != null && !id2.equals(id1)) {
            this.cfgChanged(lastSelectedCfg);
        }
    }

    private static int getCfgIndex(ICConfigurationDescription cfgd) {
        int index = 0;
        int i = 0;
        while (i < cfgDescs.length) {
            if (cfgd != null) {
                if (cfgd.getId().equals(cfgDescs[i].getId())) {
                    return i;
                }
            } else if (cfgDescs[i].isActive()) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    private static int getActiveCfgIndex() {
        return AbstractPage.getCfgIndex(null);
    }

    private static boolean areCfgsStillThere(ICConfigurationDescription[] cfgs) {
        if (cfgs == null || cfgDescs == null) {
            return false;
        }
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription multiCfg = iCConfigurationDescriptionArray[n2];
            boolean foundOne = false;
            ICConfigurationDescription[] iCConfigurationDescriptionArray2 = cfgDescs;
            int n3 = cfgDescs.length;
            int n4 = 0;
            while (n4 < n3) {
                ICConfigurationDescription cfgDesc = iCConfigurationDescriptionArray2[n4];
                if (multiCfg.getId().equals(cfgDesc.getId())) {
                    foundOne = true;
                    break;
                }
                ++n4;
            }
            if (!foundOne) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean performCancel() {
        if (!this.noContentOnPage && this.displayedConfig) {
            this.forEach(2);
        }
        CDTPropertyManager.performCancel(this);
        return true;
    }

    public void performDefaults() {
        if (!this.noContentOnPage && this.displayedConfig) {
            this.forEach(3);
        }
    }

    public void performApply() {
        this.performSave(2);
    }

    public boolean performOk() {
        File f = CUIPlugin.getDefault().getStateLocation().append("apply_mode").toFile();
        if (f.exists()) {
            return this.performSave(3);
        }
        return this.performSave(1);
    }

    private ICConfigurationDescription findCfg(ICProjectDescription prj, ICConfigurationDescription cfg) {
        String id = cfg.getId();
        ICConfigurationDescription c = prj.getConfigurationById(id);
        if (c == null) {
            try {
                c = prj.createConfiguration(id, cfg.getName(), cfg);
                c.setDescription(cfg.getDescription());
            }
            catch (CoreException coreException) {}
        }
        if (c == null) {
            MessageBox mb = new MessageBox(this.getShell());
            mb.setMessage(Messages.AbstractPage_3);
            mb.open();
        }
        return c;
    }

    private boolean performSave(int mode) {
        final int finalMode = mode;
        if (this.noContentOnPage || !this.displayedConfig) {
            return true;
        }
        if ((mode == 1 || mode == 3) && CDTPropertyManager.isSaveDone()) {
            return true;
        }
        final boolean needs = mode != 1;
        final ICProjectDescription local_prjd = needs ? CoreModel.getDefault().getProjectDescription(this.getProject()) : null;
        ICResourceDescription lc = null;
        if (needs) {
            if (this.isMultiCfg()) {
                ICResourceDescription[] rds = (ICResourceDescription[])((ICMultiItemsHolder)resd).getItems();
                int i = 0;
                while (i < rds.length) {
                    ICConfigurationDescription c = local_prjd.getConfigurationById(rds[i].getConfiguration().getId());
                    rds[i] = this.getResDesc(c);
                    ++i;
                }
                lc = MultiItemsHolder.createRDescription((ICResourceDescription[])rds);
            } else {
                ICConfigurationDescription c = this.findCfg(local_prjd, resd.getConfiguration());
                if (c == null) {
                    return false;
                }
                lc = this.getResDesc(c);
            }
        }
        final ICResourceDescription local_cfgd = lc;
        boolean rebuildIndex = this.isIndexerAffected();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            private void sendOK() {
                int j = 0;
                while (j < CDTPropertyManager.getPagesCount()) {
                    Object p = CDTPropertyManager.getPage(j);
                    if (p != null && p instanceof AbstractPage) {
                        AbstractPage ap = (AbstractPage)p;
                        if (ap.displayedConfig) {
                            ap.forEach(0, null);
                        }
                    }
                    ++j;
                }
            }

            public void run(IProgressMonitor monitor) {
                switch (finalMode) {
                    case 3: {
                        ICConfigurationDescription[] olds;
                        this.sendOK();
                        ICConfigurationDescription[] iCConfigurationDescriptionArray = olds = CDTPropertyManager.getProjectDescription(AbstractPage.this, AbstractPage.this.getProject()).getConfigurations();
                        int n = olds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICConfigurationDescription old = iCConfigurationDescriptionArray[n2];
                            resd = AbstractPage.this.getResDesc(old);
                            ICResourceDescription r = AbstractPage.this.getResDesc(local_prjd.getConfigurationById(old.getId()));
                            int j = 0;
                            while (j < CDTPropertyManager.getPagesCount()) {
                                Object p = CDTPropertyManager.getPage(j);
                                if (p != null && p instanceof AbstractPage) {
                                    AbstractPage ap = (AbstractPage)p;
                                    if (ap.displayedConfig) {
                                        ap.forEach(4, resd);
                                        ap.forEach(1, r);
                                    }
                                }
                                ++j;
                            }
                            ++n2;
                        }
                        break;
                    }
                    case 2: {
                        AbstractPage.this.forEach(1, local_cfgd);
                        break;
                    }
                    case 1: {
                        this.sendOK();
                    }
                }
                try {
                    if (needs) {
                        CoreModel.getDefault().setProjectDescription(AbstractPage.this.getProject(), local_prjd);
                    } else {
                        CDTPropertyManager.performOk(AbstractPage.this);
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.logError(String.valueOf(Messages.AbstractPage_11) + e.getLocalizedMessage());
                }
                AbstractPage.updateViews(AbstractPage.this.internalElement);
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IRunnableWithProgress)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            CUIPlugin.errorDialog(this.getShell(), Messages.AbstractPage_8, Messages.AbstractPage_9, e1, true);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (rebuildIndex) {
            this.rebuildIndex();
        }
        return true;
    }

    private boolean isIndexerAffected() {
        ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(this.getProject(), false);
        if (desc == null || desc.isCdtProjectCreating()) {
            return false;
        }
        for (InternalTab tab : this.itabs) {
            ICPropertyTab tabtab;
            if (tab == null || !((tabtab = tab.tab) instanceof AbstractCPropertyTab) || !((AbstractCPropertyTab)tabtab).isIndexerAffected()) continue;
            return true;
        }
        return false;
    }

    private void rebuildIndex() {
        Shell shell = this.getShell();
        String title = this.getTitle();
        String msg = Messages.AbstractPage_rebuildIndex_question;
        int result = OptionalMessageDialog.open(PREF_ASK_REINDEX, shell, title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (result == 1025) {
            result = OptionalMessageDialog.getDialogDetail(PREF_ASK_REINDEX);
        } else if (result != -1) {
            OptionalMessageDialog.setDialogDetail(PREF_ASK_REINDEX, result);
        }
        if (result == 0) {
            IProject project = this.getProject();
            CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().create(project));
        }
    }

    private void populateConfigurations() {
        IProject prj = this.getProject();
        if (prj == null) {
            return;
        }
        if (cfgDescs == null) {
            ICProjectDescription pDesc = CDTPropertyManager.getProjectDescription(this, prj);
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescs = pDesc == null ? null : pDesc.getConfigurations();
            if (cfgDescs == null || cfgDescs.length == 0) {
                return;
            }
            Arrays.sort(cfgDescs, CDTListComparator.getInstance());
        } else {
            if (cfgDescs.length == 0) {
                return;
            }
            CDTPropertyManager.getProjectDescription(this, prj);
        }
        if (this.configSelector == null) {
            lastSelectedCfg = cfgDescs[AbstractPage.getActiveCfgIndex()];
            this.cfgChanged(lastSelectedCfg);
            return;
        }
        this.configSelector.removeAll();
        int i = 0;
        while (i < cfgDescs.length) {
            String name = cfgDescs[i].getName();
            if (cfgDescs[i].isActive()) {
                name = String.valueOf(name) + "  " + Messages.AbstractPage_16;
            }
            this.configSelector.add(name);
            ++i;
        }
        int cfgIndex = AbstractPage.getCfgIndex(lastSelectedCfg);
        if (cfgDescs.length > 1) {
            this.configSelector.add(Messages.AbstractPage_4);
            if (multiCfgs == cfgDescs) {
                cfgIndex = cfgDescs.length;
            }
        }
        if (cfgDescs.length > 2) {
            this.configSelector.add(Messages.AbstractPage_5);
            if (multiCfgs != null && multiCfgs != cfgDescs) {
                cfgIndex = cfgDescs.length + 1;
            }
        }
        if (cfgIndex < 0) {
            cfgIndex = AbstractPage.getActiveCfgIndex();
        }
        this.configSelector.select(cfgIndex);
        this.handleConfigSelection();
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    @Override
    public void updateContainer() {
    }

    public boolean isValid() {
        this.updateContainer();
        return super.isValid();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.handleResize(true);
            this.displayedConfig = true;
            if (this.excludeFromBuildCheck != null && resd != null) {
                this.excludeFromBuildCheck.setSelection(resd.isExcluded());
            }
            this.populateConfigurations();
        }
        if (this.itabs.size() < 1) {
            return;
        }
        if (this.currentTab == null && this.folder.getItemCount() > 0) {
            Object ob = this.folder.getItem(0).getData();
            this.currentTab = (ICPropertyTab)ob;
        }
        if (this.currentTab != null) {
            this.currentTab.handleTabEvent(5, visible ? NOT_NULL : null);
        }
    }

    protected void handleResize(boolean visible) {
        int saveMode;
        if (visible && !isNewOpening) {
            return;
        }
        if (visible) {
            isNewOpening = false;
        }
        if ((saveMode = CDTPrefUtil.getInt("properties.save.position")) == 2) {
            return;
        }
        if (this.internalElement == null && !this.checkElement()) {
            return;
        }
        IProject prj = this.getProject();
        if (prj == null) {
            return;
        }
        QualifiedName WIDTH = new QualifiedName(prj.getName(), ".property.page.width");
        QualifiedName HEIGHT = new QualifiedName(prj.getName(), ".property.page.height");
        QualifiedName XKEY = new QualifiedName(prj.getName(), ".property.page.x");
        QualifiedName YKEY = new QualifiedName(prj.getName(), ".property.page.y");
        Rectangle r = this.getShell().getBounds();
        try {
            if (visible) {
                String w = prj.getPersistentProperty(WIDTH);
                String h = prj.getPersistentProperty(HEIGHT);
                if (w != null) {
                    r.width = Integer.parseInt(w);
                }
                if (h != null) {
                    r.height = Integer.parseInt(h);
                }
                if (saveMode == 3) {
                    String x = prj.getPersistentProperty(XKEY);
                    String y = prj.getPersistentProperty(YKEY);
                    if (x != null) {
                        r.x = Integer.parseInt(x);
                    }
                    if (y != null) {
                        r.y = Integer.parseInt(y);
                    }
                }
                this.getShell().setBounds(r);
            } else {
                prj.setPersistentProperty(WIDTH, String.valueOf(r.width));
                prj.setPersistentProperty(HEIGHT, String.valueOf(r.height));
                prj.setPersistentProperty(XKEY, String.valueOf(r.x));
                prj.setPersistentProperty(YKEY, String.valueOf(r.y));
            }
        }
        catch (CoreException coreException) {}
    }

    public IPreferenceStore getPreferenceStore() {
        return CUIPlugin.getDefault().getPreferenceStore();
    }

    @Override
    @Deprecated
    public Preferences getPreferences() {
        return CUIPlugin.getDefault().getPluginPreferences();
    }

    @Override
    public void enableConfigSelection(boolean enable) {
        if (this.configSelector != null) {
            this.configSelector.setEnabled(enable);
        }
        if (this.manageButton != null) {
            this.manageButton.setEnabled(enable);
        }
    }

    @Override
    public ICConfigurationDescription[] getCfgsReadOnly(IProject p) {
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(p, false);
        if (prjd != null) {
            return prjd.getConfigurations();
        }
        return null;
    }

    @Override
    public ICConfigurationDescription[] getCfgsEditable() {
        return cfgDescs;
    }

    public static boolean isCDTPrj(IProject p) {
        ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(p, false);
        if (prjd == null) {
            return false;
        }
        ICConfigurationDescription[] cfgs = prjd.getConfigurations();
        return cfgs != null && cfgs.length > 0;
    }

    @Override
    public boolean isCDTProject(IProject p) {
        return AbstractPage.isCDTPrj(p);
    }

    @Override
    public ICResourceDescription getResDesc() {
        if (resd == null) {
            if (cfgDescs == null) {
                this.populateConfigurations();
            }
            if (lastSelectedCfg != null) {
                resd = this.getResDesc(lastSelectedCfg);
            }
        }
        return resd;
    }

    @Override
    public ICResourceDescription getResDesc(ICConfigurationDescription cf) {
        IAdaptable ad = this.getElement();
        if (this.isForProject()) {
            return cf.getRootFolderDescription();
        }
        Object out = null;
        IResource res = (IResource)ad;
        IPath p = res.getProjectRelativePath();
        if (this.isForFolder() || this.isForFile()) {
            if (cf instanceof ICMultiItemsHolder) {
                out = cf.getResourceDescription(p, this.isForFolder());
            } else {
                out = cf.getResourceDescription(p, false);
                if (!p.equals((Object)out.getPath())) {
                    try {
                        out = this.isForFolder() ? cf.createFolderDescription(p, (ICFolderDescription)out) : cf.createFileDescription(p, out);
                    }
                    catch (CoreException e) {
                        System.out.println(String.valueOf(Messages.AbstractPage_10) + p.toOSString() + "\n" + e.getLocalizedMessage());
                    }
                }
            }
        }
        return out;
    }

    protected void cfgChanged(ICConfigurationDescription _cfgd) {
        CConfigurationStatus st = _cfgd.getConfigurationStatus();
        if (st.getCode() == 4) {
            st = _cfgd.getConfigurationData().getStatus();
        }
        if (this.errPane != null && this.errMessage != null) {
            if (st.isOK()) {
                this.errPane.setVisible(false);
            } else {
                this.errMessage.setText(st.getMessage());
                this.errPane.setVisible(true);
            }
        }
        resd = this.getResDesc(_cfgd);
        if (this.excludeFromBuildCheck != null) {
            this.excludeFromBuildCheck.setEnabled(resd.canExclude(!resd.isExcluded()));
            this.excludeFromBuildCheck.setSelection(resd.isExcluded());
        }
        int x = CDTPropertyManager.getPagesCount();
        int i = 0;
        while (i < x) {
            Object p = CDTPropertyManager.getPage(i);
            if (p != null && p instanceof AbstractPage) {
                AbstractPage ap = (AbstractPage)p;
                if (ap.displayedConfig) {
                    ap.forEach(4, this.getResDesc());
                }
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.displayedConfig) {
            this.forEach(6);
        }
        for (Image img : this.loadedIcons.values()) {
            img.dispose();
        }
        this.loadedIcons.clear();
        if (!isNewOpening) {
            this.handleResize(false);
        }
        isNewOpening = true;
        CDTPropertyManager.remove(this);
        if (CDTPropertyManager.getPagesCount() == 0) {
            resd = null;
            cfgDescs = null;
        }
    }

    protected abstract boolean isSingle();

    protected boolean showsConfig() {
        return true;
    }

    protected void forEach(int m) {
        this.forEach(m, null);
    }

    protected void forEach(int m, Object pars) {
        for (InternalTab tab : this.itabs) {
            if (tab == null) continue;
            tab.tab.handleTabEvent(m, pars);
        }
    }

    public static String getWeight(IConfigurationElement e) {
        String s = e.getAttribute(WEIGHT_NAME);
        return s == null ? EMPTY_STR : s;
    }

    private synchronized void loadExtensionsSynchronized(Composite parent) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return;
        }
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            elements.addAll(Arrays.asList(ext.getConfigurationElements()));
            ++n2;
        }
        Collections.sort(elements, CDTUIListComparator.getInstance());
        for (IConfigurationElement element : elements) {
            if (element.getName().equals(ELEMENT_NAME)) {
                if (!this.loadTab(element, parent)) continue;
                return;
            }
            System.out.println(String.valueOf(Messages.AbstractPage_13) + element.getName());
        }
    }

    private boolean loadTab(IConfigurationElement element, Composite parent) {
        Image _img;
        if (!this.getClass().getName().equals(element.getAttribute(PARENT_NAME))) {
            return false;
        }
        ICPropertyTab page = null;
        try {
            page = (ICPropertyTab)element.createExecutableExtension(CLASS_NAME);
        }
        catch (CoreException e) {
            System.out.println(String.valueOf(Messages.AbstractPage_14) + e.getLocalizedMessage());
            return false;
        }
        if (page == null) {
            return false;
        }
        String helpId = element.getAttribute(HELPID_NAME);
        if (helpId != null && helpId.length() > 0 && page instanceof AbstractCPropertyTab) {
            ((AbstractCPropertyTab)page).setHelpContextId(helpId);
        }
        if ((_img = this.getIcon(element)) != null) {
            page.handleTabEvent(7, _img);
        }
        if (this.isSingle()) {
            page.createControls(parent, this);
            InternalTab itab = new InternalTab(parent, EMPTY_STR, null, page, null);
            this.itabs.add(itab);
            this.currentTab = page;
            return true;
        }
        String _name = element.getAttribute(TEXT_NAME);
        String _tip = element.getAttribute(TIP_NAME);
        Composite _comp = new Composite((Composite)this.folder, 0);
        page.createControls(_comp, this);
        InternalTab itab = new InternalTab(_comp, _name, _img, page, _tip);
        itab.createOn(this.folder);
        this.itabs.add(itab);
        return false;
    }

    private Image getIcon(IConfigurationElement config) {
        ImageDescriptor idesc = null;
        URL url = null;
        try {
            String iconName = config.getAttribute(IMAGE_NAME);
            if (iconName != null) {
                URL pluginInstallUrl = Platform.getBundle((String)config.getDeclaringExtension().getContributor().getName()).getEntry("/");
                url = new URL(pluginInstallUrl, iconName);
                if (this.loadedIcons.containsKey(url)) {
                    return this.loadedIcons.get(url);
                }
                idesc = ImageDescriptor.createFromURL((URL)url);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        if (idesc == null) {
            return null;
        }
        Image img = idesc.createImage();
        this.loadedIcons.put(url, img);
        return img;
    }

    @Override
    public void informAll(int code, Object data) {
        int i = 0;
        while (i < CDTPropertyManager.getPagesCount()) {
            Object p = CDTPropertyManager.getPage(i);
            if (p != null && p instanceof AbstractPage) {
                AbstractPage ap = (AbstractPage)p;
                ap.forEach(code, data);
            }
            ++i;
        }
    }

    @Override
    public void informPages(int code, Object data) {
        int i = 0;
        while (i < CDTPropertyManager.getPagesCount()) {
            Object p = CDTPropertyManager.getPage(i);
            if (p != null && p instanceof AbstractPage) {
                AbstractPage ap = (AbstractPage)p;
                ap.handleMessage(code, data);
            }
            ++i;
        }
    }

    @Override
    public void handleMessage(int code, Object data) {
        switch (code) {
            case 101: {
                if (this.folder == null) {
                    if (this.itabs == null || this.itabs.size() == 0) {
                        return;
                    }
                    ICPropertyTab t = this.itabs.get((int)0).tab;
                    if (!t.canBeVisible()) {
                        t.handleTabEvent(5, null);
                    }
                    return;
                }
                boolean willAdd = false;
                TabItem[] ts = this.folder.getItems();
                int x = this.folder.getSelectionIndex();
                String currHeader = x == -1 ? null : ts[x].getText();
                int i = 0;
                while (i < this.itabs.size()) {
                    InternalTab itab = this.itabs.get(i);
                    TabItem ti = null;
                    TabItem[] tabItemArray = ts;
                    int n = ts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TabItem element2 = tabItemArray[n2];
                        if (!element2.isDisposed() && element2.getData() == itab.tab) {
                            ti = element2;
                            break;
                        }
                        ++n2;
                    }
                    if (itab.tab.canBeVisible()) {
                        if (ti == null) {
                            willAdd = true;
                            break;
                        }
                    } else if (ti != null) {
                        ti.dispose();
                    }
                    ++i;
                }
                if (!willAdd) break;
                int j = 0;
                while (j < ts.length) {
                    if (ts[j] != null && !ts[j].isDisposed()) {
                        ts[j].dispose();
                    }
                    ++j;
                }
                TabItem ti = null;
                int i2 = 0;
                while (i2 < this.itabs.size()) {
                    InternalTab itab = this.itabs.get(i2);
                    if (itab.tab.canBeVisible()) {
                        TabItem currTI = itab.createOn(this.folder);
                        if (currHeader != null && currHeader.equals(itab.text)) {
                            ti = currTI;
                        }
                    }
                    ++i2;
                }
                if (ti == null) break;
                this.folder.setSelection(ti);
            }
        }
    }

    protected boolean checkElement() {
        IAdaptable el = super.getElement();
        this.internalElement = el instanceof ICElement ? ((ICElement)el).getResource() : (el instanceof IResource ? (IResource)el : (IResource)el.getAdapter(IResource.class));
        if (this.internalElement == null) {
            return false;
        }
        this.isProject = this.internalElement instanceof IProject;
        this.isFolder = this.internalElement instanceof IFolder;
        this.isFile = this.internalElement instanceof IFile;
        return true;
    }

    @Override
    public IAdaptable getElement() {
        if (this.internalElement == null && !this.checkElement()) {
            throw new NullPointerException(Messages.AbstractPage_15);
        }
        return this.internalElement;
    }

    @Override
    public boolean isForProject() {
        return this.isProject;
    }

    @Override
    public boolean isForFolder() {
        return this.isFolder;
    }

    @Override
    public boolean isForFile() {
        return this.isFile;
    }

    @Override
    public boolean isForPrefs() {
        return false;
    }

    @Override
    public boolean isMultiCfg() {
        return resd instanceof ICMultiItemsHolder;
    }

    public boolean isApplicable() {
        if (this.internalElement == null && !this.checkElement()) {
            return false;
        }
        if (this.isForFile()) {
            return true;
        }
        return true;
    }

    public static void updateViews(IResource res) {
        IViewReference[] refs;
        if (res == null) {
            return;
        }
        IViewReference[] iViewReferenceArray = refs = CUIPlugin.getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            IWorkbenchPart part = ref.getPart(false);
            if (part != null && part instanceof IPropertyChangeListener) {
                ((IPropertyChangeListener)part).propertyChange(new PropertyChangeEvent((Object)res, "org.eclipse.cdt.ui.editor.CUChildren", null, null));
            }
            ++n2;
        }
    }

    public void resize() {
        Shell sh = this.parentComposite.getShell();
        Point p0 = sh.getLocation();
        Point p1 = sh.computeSize(-1, -1, true);
        Rectangle r = sh.getDisplay().getClientArea();
        p1.x = Math.min(p1.x, r.width - p0.x);
        p1.y = Math.min(p1.y, r.height - p0.y);
        sh.setSize(p1);
    }

    @Override
    public Button getAButton() {
        return this.getApplyButton();
    }

    @Override
    public Button getDButton() {
        return this.getDefaultsButton();
    }

    public void performHelp() {
        String s;
        if (this.currentTab != null && this.currentTab instanceof AbstractCPropertyTab && (s = ((AbstractCPropertyTab)this.currentTab).getHelpContextId()) != null && s.length() > 0) {
            IContext context = HelpSystem.getContext((String)s);
            if (context != null) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
            } else {
                PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
            }
        }
    }

    @Override
    public ICPropertyTab getSelectedTab() {
        return this.currentTab;
    }

    protected class InternalTab {
        Composite comp;
        String text;
        String tip;
        Image image;
        ICPropertyTab tab;

        InternalTab(Composite _comp, String _text, Image _image, ICPropertyTab _tab, String _tip) {
            this.comp = _comp;
            this.text = _text;
            this.image = _image;
            this.tab = _tab;
            this.tip = _tip;
        }

        public TabItem createOn(TabFolder f) {
            if (this.tab.canBeVisible()) {
                TabItem ti = new TabItem(f, 0);
                ti.setText(this.text);
                if (this.tip != null) {
                    ti.setToolTipText(this.tip);
                }
                if (this.image != null) {
                    ti.setImage(this.image);
                }
                ti.setControl((Control)this.comp);
                ti.setData((Object)this.tab);
                return ti;
            }
            return null;
        }
    }
}

