/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIVar {
    String name = "";
    String type = "";
    String exp = "";
    int numchild;

    public MIVar(String n, int num, String t) {
        this.name = n;
        this.numchild = num;
        this.type = t;
    }

    public MIVar(MITuple tuple) {
        this.parse(tuple);
    }

    public String getVarName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getNumChild() {
        return this.numchild;
    }

    public String getExp() {
        return this.exp;
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("numchild")) {
                try {
                    this.numchild = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("name")) {
                this.name = str;
            } else if (var.equals("type")) {
                this.type = str;
            } else if (var.equals("exp")) {
                this.exp = str;
            }
            ++i;
        }
    }
}

