#include <stdio.h>

unsigned long long data[32] = {
   0x0000000000000000ull, 0x0000000000000000ull,
   0xffffffffffffffffull, 0xffffffffffffffffull,
   0x0000000080000000ull, 0x8000000000000000ull,
   0x8000800080008000ull, 0x7fff7fff7fff7fffull,
   0x8080808080808080ull, 0x8080808080808080ull,
   0x7070707070707070ull, 0x7070707070707070ull,
   0x7f7f7f7f7f7f7f7full, 0x7f7f7f7f7f7f7f7full,
   0x0706050403020100ull, 0x0f0e0d0c0b0a0908ull,
   0x77665544332211ffull, 0xeeddccbbaa998877ull,
   0x0000000000000001ull, 0x00000000000001ffull,
   0x0000000000000001ull, 0x00000000000000ffull,
   0xffffffffffffffffull, 0x0000000000000000ull,
   0x0000000100000001ull, 0x0000000100000001ull,
   0x1234567890abcdefull, 0xfedbca9876543210ull,
   0x0403020114131211ull, 0x2423222134333231ull,
   0x8483828194939291ull, 0xa4a3a2a1b4b3b2b1ull,
};

unsigned int data32[64] = {
   0x00000000, 0x00540076, 0x00000540, 0x000000f0,
   0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
   0x80000000, 0x00054000, 0x86500034, 0x00076000,
   0x80008000, 0x7fff7fff, 0x80008043, 0x7fff7fff,
   0x8080fd80, 0x80ab8080, 0x808080df, 0x80808080,
   0x70707070, 0x70707070, 0x70707070, 0x70707070,
   0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f, 0x7f7f7f7f,
   0x03020100, 0x0b0a0908, 0x03020100, 0x0b0a0908,
   0x332211ff, 0xaa998877, 0x332211ff, 0xaa998877,
   0x00000001, 0x000001ff, 0x00000001, 0x000001ff,
   0x0000000c, 0x000000ff, 0x000000cd, 0x000000ff,
   0xffffffff, 0x00000650, 0xffffffff, 0x00034000,
   0x00000001, 0x67000001, 0x00300001, 0x00070001,
   0x90abcdef, 0x76543210, 0x90abcdef, 0x76543210,
   0x14131211, 0x34333231, 0x14131211, 0x34333231,
   0x94939291, 0xb4b3b2b1, 0x94939291, 0xb4b3b2b1,
};

unsigned long long out[2];

#define TEST_3R(instruction, offset1, offset2, WD, WS, WT)             \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset1"($t0)\n\t"                               \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset1"($t0)\n\t"                               \
      "ld.d $"#WT", "#offset2"($t0)\n\t"                               \
      instruction" $"#WD", $"#WS", $"#WT"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", $"#WT" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx  "#WT": "            \
          "%016llx%016llx\n", out[1], out[0], data[offset1 / 8 + 1],   \
          data[offset1 / 8], data[offset2 / 8 + 1], data[offset2 / 8]);\
}

//32bit only
#define TEST_3IR(instruction, offset1, offset2, WD, WS, RT)            \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset1"($t0)\n\t"                               \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset1"($t0)\n\t"                               \
      "move $t0, %1\n\t"                                               \
      "lw $"#RT", "#offset2"($t0)\n\t"                                 \
      instruction" $"#WD", $"#WS"[$"#RT"]\n\t"                         \
      "move $t0, %2\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (data32), "r" (out)                            \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS"[$"#RT"] "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx  "#RT": "            \
          "%08x\n", out[1], out[0], data[offset1 / 8 + 1],             \
          data[offset1 / 8], data32[offset2 / 4]);                     \
}

#define TEST_ELM(instruction, offset, WD, WS, n)                       \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS"["#n"]\n\t"                           \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS"["#n"] "#WD":"                    \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

#define TEST_I8(instruction, offset, WD, WS, imm)                      \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS", "#imm"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", "#imm" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

#define TEST_INSVE(instruction, offset, WD, WS, n)                     \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD"["#n"], $"#WS"[0]\n\t"                        \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD"["#n"], $"#WS"[0] "#WD":"                 \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

int main(int argc, char **argv) {
#if defined(__mips_msa)
   TEST_3R("ilvev.b",   0,  48, w0,  w28, w14);
   TEST_3R("ilvev.b",   8,  80, w1,  w30, w29);
   TEST_3R("ilvev.b",  16,  56, w2,  w12, w15);
   TEST_3R("ilvev.b",  24, 136, w3,  w31, w17);
   TEST_3R("ilvev.b",  32,  88, w4,  w2,  w9);
   TEST_3R("ilvev.b",  40,  96, w5,  w26, w29);
   TEST_3R("ilvev.b",  48, 208, w6,  w12, w23);
   TEST_3R("ilvev.b",  56,  72, w7,  w7,  w7);
   TEST_3R("ilvev.b",  64,  88, w8,  w16, w11);
   TEST_3R("ilvev.b",  72,  16, w9,  w2,  w16);
   TEST_3R("ilvev.b",  80,   8, w10, w30, w31);
   TEST_3R("ilvev.b",  88, 168, w11, w26, w13);
   TEST_3R("ilvev.b",  96,  16, w12, w24, w11);
   TEST_3R("ilvev.b", 104, 184, w13, w4,  w26);
   TEST_3R("ilvev.b", 112, 136, w14, w4,  w14);
   TEST_3R("ilvev.b", 120, 176, w15, w7,  w6);
   TEST_3R("ilvev.b", 128,  32, w16, w21, w0);
   TEST_3R("ilvev.b", 136, 232, w17, w12, w9);
   TEST_3R("ilvev.b", 144, 144, w18, w25, w27);
   TEST_3R("ilvev.b", 152,  40, w19, w27, w11);
   TEST_3R("ilvev.b", 160, 168, w20, w25, w10);
   TEST_3R("ilvev.b", 168,  96, w21, w19, w24);
   TEST_3R("ilvev.b", 176, 224, w22, w11, w3);
   TEST_3R("ilvev.b", 184, 176, w23, w16, w29);
   TEST_3R("ilvev.b", 192,  40, w24, w20, w20);
   TEST_3R("ilvev.b", 200,  88, w25, w11, w26);
   TEST_3R("ilvev.b", 208, 104, w26, w0,  w14);
   TEST_3R("ilvev.b", 216, 104, w27, w7,  w24);
   TEST_3R("ilvev.b", 224, 224, w28, w28, w0);
   TEST_3R("ilvev.b", 232, 216, w29, w22, w7);
   TEST_3R("ilvev.b", 240,  64, w30, w2,  w3);
   TEST_3R("ilvev.b",  64,  48, w31, w12, w26);
   TEST_3R("ilvev.h",   0,  56, w0,  w5,  w7);
   TEST_3R("ilvev.h",   8, 104, w1,  w21, w4);
   TEST_3R("ilvev.h",  16,   8, w2,  w9,  w12);
   TEST_3R("ilvev.h",  24, 112, w3,  w9,  w30);
   TEST_3R("ilvev.h",  32, 168, w4,  w21, w5);
   TEST_3R("ilvev.h",  40,  48, w5,  w17, w1);
   TEST_3R("ilvev.h",  48, 200, w6,  w13, w14);
   TEST_3R("ilvev.h",  56, 112, w7,  w7,  w7);
   TEST_3R("ilvev.h",  64,  72, w8,  w20, w22);
   TEST_3R("ilvev.h",  72,  16, w9,  w14, w26);
   TEST_3R("ilvev.h",  80, 184, w10, w20, w2);
   TEST_3R("ilvev.h",  88,  56, w11, w9,  w6);
   TEST_3R("ilvev.h",  96,  72, w12, w19, w22);
   TEST_3R("ilvev.h", 104,  64, w13, w29, w20);
   TEST_3R("ilvev.h", 112, 136, w14, w18, w14);
   TEST_3R("ilvev.h", 120,  32, w15, w3,  w31);
   TEST_3R("ilvev.h", 128,  48, w16, w11, w12);
   TEST_3R("ilvev.h", 136,   0, w17, w20, w28);
   TEST_3R("ilvev.h", 144,  96, w18, w10, w25);
   TEST_3R("ilvev.h", 152, 120, w19, w5,  w10);
   TEST_3R("ilvev.h", 160,   0, w20, w7,  w21);
   TEST_3R("ilvev.h", 168, 112, w21, w13, w31);
   TEST_3R("ilvev.h", 176, 152, w22, w0,  w19);
   TEST_3R("ilvev.h", 184, 176, w23, w28, w16);
   TEST_3R("ilvev.h", 192, 144, w24, w16, w16);
   TEST_3R("ilvev.h", 200,   0, w25, w10, w19);
   TEST_3R("ilvev.h", 208, 160, w26, w9,  w23);
   TEST_3R("ilvev.h", 216, 144, w27, w21, w9);
   TEST_3R("ilvev.h", 224, 120, w28, w28, w17);
   TEST_3R("ilvev.h", 232,  96, w29, w16, w11);
   TEST_3R("ilvev.h", 240, 104, w30, w21, w13);
   TEST_3R("ilvev.h",   8,  40, w31, w10, w0);
   TEST_3R("ilvev.w",   0,  72, w0,  w5,  w10);
   TEST_3R("ilvev.w",   8,  48, w1,  w6,  w13);
   TEST_3R("ilvev.w",  16, 232, w2,  w22, w15);
   TEST_3R("ilvev.w",  24, 160, w3,  w9,  w21);
   TEST_3R("ilvev.w",  32,  24, w4,  w0,  w6);
   TEST_3R("ilvev.w",  40,  56, w5,  w9,  w12);
   TEST_3R("ilvev.w",  48, 208, w6,  w25, w28);
   TEST_3R("ilvev.w",  56, 232, w7,  w7,  w7);
   TEST_3R("ilvev.w",  64,  88, w8,  w17, w11);
   TEST_3R("ilvev.w",  72,  56, w9,  w13, w22);
   TEST_3R("ilvev.w",  80,  16, w10, w22, w0);
   TEST_3R("ilvev.w",  88, 128, w11, w0,  w29);
   TEST_3R("ilvev.w",  96,  48, w12, w7,  w10);
   TEST_3R("ilvev.w", 104,  48, w13, w29, w25);
   TEST_3R("ilvev.w", 112, 216, w14, w7,  w14);
   TEST_3R("ilvev.w", 120, 192, w15, w5,  w7);
   TEST_3R("ilvev.w", 128, 192, w16, w31, w17);
   TEST_3R("ilvev.w", 136, 128, w17, w10, w29);
   TEST_3R("ilvev.w", 144, 136, w18, w7,  w14);
   TEST_3R("ilvev.w", 152,  32, w19, w18, w27);
   TEST_3R("ilvev.w", 160,  48, w20, w29, w18);
   TEST_3R("ilvev.w", 168, 136, w21, w14, w18);
   TEST_3R("ilvev.w", 176,  24, w22, w0,  w25);
   TEST_3R("ilvev.w", 184,  80, w23, w4,  w3);
   TEST_3R("ilvev.w", 192, 176, w24, w30, w30);
   TEST_3R("ilvev.w", 200,   0, w25, w9,  w5);
   TEST_3R("ilvev.w", 208,  72, w26, w8,  w22);
   TEST_3R("ilvev.w", 216,  96, w27, w18, w0);
   TEST_3R("ilvev.w", 224, 168, w28, w28, w19);
   TEST_3R("ilvev.w", 232, 200, w29, w21, w0);
   TEST_3R("ilvev.w", 240,  56, w30, w16, w2);
   TEST_3R("ilvev.w", 128, 144, w31, w2,  w5);
   TEST_3R("ilvev.d",   0, 184, w0,  w4,  w6);
   TEST_3R("ilvev.d",   8, 192, w1,  w14, w10);
   TEST_3R("ilvev.d",  16, 224, w2,  w17, w14);
   TEST_3R("ilvev.d",  24, 232, w3,  w23, w9);
   TEST_3R("ilvev.d",  32, 160, w4,  w31, w19);
   TEST_3R("ilvev.d",  40, 112, w5,  w0,  w26);
   TEST_3R("ilvev.d",  48, 208, w6,  w8,  w15);
   TEST_3R("ilvev.d",  56, 192, w7,  w7,  w7);
   TEST_3R("ilvev.d",  64, 120, w8,  w31, w7);
   TEST_3R("ilvev.d",  72,  32, w9,  w2,  w12);
   TEST_3R("ilvev.d",  80, 160, w10, w23, w17);
   TEST_3R("ilvev.d",  88, 224, w11, w5,  w31);
   TEST_3R("ilvev.d",  96, 232, w12, w11, w16);
   TEST_3R("ilvev.d", 104,  48, w13, w14, w19);
   TEST_3R("ilvev.d", 112, 136, w14, w23, w14);
   TEST_3R("ilvev.d", 120,  80, w15, w20, w23);
   TEST_3R("ilvev.d", 128, 120, w16, w6,  w23);
   TEST_3R("ilvev.d", 136, 232, w17, w11, w31);
   TEST_3R("ilvev.d", 144,  88, w18, w16, w1);
   TEST_3R("ilvev.d", 152, 168, w19, w23, w28);
   TEST_3R("ilvev.d", 160,  32, w20, w4,  w28);
   TEST_3R("ilvev.d", 168, 112, w21, w3,  w24);
   TEST_3R("ilvev.d", 176, 144, w22, w19, w3);
   TEST_3R("ilvev.d", 184, 160, w23, w18, w17);
   TEST_3R("ilvev.d", 192, 104, w24, w7,  w7);
   TEST_3R("ilvev.d", 200, 112, w25, w20, w28);
   TEST_3R("ilvev.d", 208, 176, w26, w5,  w2);
   TEST_3R("ilvev.d", 216,   0, w27, w16, w13);
   TEST_3R("ilvev.d", 224, 104, w28, w28, w10);
   TEST_3R("ilvev.d", 232, 208, w29, w23, w4);
   TEST_3R("ilvev.d", 240, 232, w30, w19, w31);
   TEST_3R("ilvev.d", 128, 120, w31, w16, w18);
   TEST_3R("ilvl.b",   0, 232, w0,  w5,  w24);
   TEST_3R("ilvl.b",   8, 224, w1,  w1,  w28);
   TEST_3R("ilvl.b",  16, 216, w2,  w7,  w17);
   TEST_3R("ilvl.b",  24,  24, w3,  w7,  w22);
   TEST_3R("ilvl.b",  32, 120, w4,  w30, w7);
   TEST_3R("ilvl.b",  40, 232, w5,  w20, w17);
   TEST_3R("ilvl.b",  48,   0, w6,  w12, w6);
   TEST_3R("ilvl.b",  56, 144, w7,  w28, w31);
   TEST_3R("ilvl.b",  64,  64, w8,  w21, w15);
   TEST_3R("ilvl.b",  72, 192, w9,  w2,  w17);
   TEST_3R("ilvl.b",  80,  56, w10, w10, w10);
   TEST_3R("ilvl.b",  88, 176, w11, w30, w9);
   TEST_3R("ilvl.b",  96,  32, w12, w28, w6);
   TEST_3R("ilvl.b", 104,  32, w13, w4,  w4);
   TEST_3R("ilvl.b", 112,  56, w14, w29, w11);
   TEST_3R("ilvl.b", 120, 208, w15, w27, w10);
   TEST_3R("ilvl.b", 128,   0, w16, w6,  w30);
   TEST_3R("ilvl.b", 136,   8, w17, w14, w10);
   TEST_3R("ilvl.b", 144,  32, w18, w11, w10);
   TEST_3R("ilvl.b", 152,  96, w19, w0,  w25);
   TEST_3R("ilvl.b", 160,  40, w20, w2,  w28);
   TEST_3R("ilvl.b", 168,  32, w21, w6,  w5);
   TEST_3R("ilvl.b", 176,  32, w22, w16, w6);
   TEST_3R("ilvl.b", 184, 112, w23, w22, w8);
   TEST_3R("ilvl.b", 192, 160, w24, w13, w5);
   TEST_3R("ilvl.b", 200, 104, w25, w26, w1);
   TEST_3R("ilvl.b", 208,  72, w26, w15, w7);
   TEST_3R("ilvl.b", 216,  80, w27, w21, w22);
   TEST_3R("ilvl.b", 224, 136, w28, w16, w1);
   TEST_3R("ilvl.b", 232, 168, w29, w1,  w9);
   TEST_3R("ilvl.b", 240,  80, w30, w3,  w5);
   TEST_3R("ilvl.b", 224, 216, w31, w10, w7);
   TEST_3R("ilvl.h",   0,  40, w0,  w10, w16);
   TEST_3R("ilvl.h",   8, 184, w1,  w1,  w17);
   TEST_3R("ilvl.h",  16,   0, w2,  w30, w4);
   TEST_3R("ilvl.h",  24, 144, w3,  w31, w0);
   TEST_3R("ilvl.h",  32,  56, w4,  w6,  w27);
   TEST_3R("ilvl.h",  40, 216, w5,  w28, w1);
   TEST_3R("ilvl.h",  48,  96, w6,  w29, w6);
   TEST_3R("ilvl.h",  56,  40, w7,  w13, w30);
   TEST_3R("ilvl.h",  64, 136, w8,  w5,  w2);
   TEST_3R("ilvl.h",  72, 104, w9,  w6,  w12);
   TEST_3R("ilvl.h",  80,  40, w10, w10, w10);
   TEST_3R("ilvl.h",  88, 200, w11, w6,  w25);
   TEST_3R("ilvl.h",  96, 104, w12, w22, w17);
   TEST_3R("ilvl.h", 104, 216, w13, w19, w19);
   TEST_3R("ilvl.h", 112, 128, w14, w10, w17);
   TEST_3R("ilvl.h", 120, 128, w15, w10, w12);
   TEST_3R("ilvl.h", 128, 136, w16, w11, w24);
   TEST_3R("ilvl.h", 136, 104, w17, w27, w5);
   TEST_3R("ilvl.h", 144,  24, w18, w21, w11);
   TEST_3R("ilvl.h", 152,  40, w19, w17, w27);
   TEST_3R("ilvl.h", 160,   0, w20, w31, w1);
   TEST_3R("ilvl.h", 168,   0, w21, w24, w23);
   TEST_3R("ilvl.h", 176,  96, w22, w2,  w10);
   TEST_3R("ilvl.h", 184,  32, w23, w16, w21);
   TEST_3R("ilvl.h", 192,  40, w24, w30, w6);
   TEST_3R("ilvl.h", 200, 168, w25, w8,  w18);
   TEST_3R("ilvl.h", 208,  72, w26, w19, w11);
   TEST_3R("ilvl.h", 216,  48, w27, w15, w16);
   TEST_3R("ilvl.h", 224, 192, w28, w4,  w27);
   TEST_3R("ilvl.h", 232, 192, w29, w23, w13);
   TEST_3R("ilvl.h", 240, 112, w30, w19, w12);
   TEST_3R("ilvl.h",  88, 152, w31, w8,  w4);
   TEST_3R("ilvl.w",   0, 192, w0,  w6,  w22);
   TEST_3R("ilvl.w",   8,  56, w1,  w1,  w22);
   TEST_3R("ilvl.w",  16,  64, w2,  w9,  w21);
   TEST_3R("ilvl.w",  24,   0, w3,  w29, w14);
   TEST_3R("ilvl.w",  32, 176, w4,  w14, w8);
   TEST_3R("ilvl.w",  40,  32, w5,  w31, w15);
   TEST_3R("ilvl.w",  48, 144, w6,  w26, w6);
   TEST_3R("ilvl.w",  56,  40, w7,  w27, w25);
   TEST_3R("ilvl.w",  64,  16, w8,  w20, w13);
   TEST_3R("ilvl.w",  72,  24, w9,  w24, w6);
   TEST_3R("ilvl.w",  80, 136, w10, w10, w10);
   TEST_3R("ilvl.w",  88,  48, w11, w21, w25);
   TEST_3R("ilvl.w",  96, 184, w12, w10, w24);
   TEST_3R("ilvl.w", 104,  16, w13, w14, w14);
   TEST_3R("ilvl.w", 112,  40, w14, w25, w28);
   TEST_3R("ilvl.w", 120, 232, w15, w25, w27);
   TEST_3R("ilvl.w", 128, 144, w16, w29, w22);
   TEST_3R("ilvl.w", 136, 120, w17, w24, w29);
   TEST_3R("ilvl.w", 144,  88, w18, w7,  w17);
   TEST_3R("ilvl.w", 152, 208, w19, w31, w10);
   TEST_3R("ilvl.w", 160, 112, w20, w5,  w9);
   TEST_3R("ilvl.w", 168, 184, w21, w17, w30);
   TEST_3R("ilvl.w", 176, 192, w22, w6,  w9);
   TEST_3R("ilvl.w", 184,  48, w23, w30, w17);
   TEST_3R("ilvl.w", 192, 232, w24, w4,  w10);
   TEST_3R("ilvl.w", 200, 232, w25, w18, w3);
   TEST_3R("ilvl.w", 208, 208, w26, w15, w0);
   TEST_3R("ilvl.w", 216,  40, w27, w19, w24);
   TEST_3R("ilvl.w", 224,  64, w28, w16, w0);
   TEST_3R("ilvl.w", 232,  56, w29, w26, w31);
   TEST_3R("ilvl.w", 240,  80, w30, w29, w4);
   TEST_3R("ilvl.w",  56, 144, w31, w14, w21);
   TEST_3R("ilvl.d",   0, 120, w0,  w27, w26);
   TEST_3R("ilvl.d",   8,  72, w1,  w1,  w25);
   TEST_3R("ilvl.d",  16,   0, w2,  w16, w29);
   TEST_3R("ilvl.d",  24,  56, w3,  w16, w15);
   TEST_3R("ilvl.d",  32, 136, w4,  w11, w31);
   TEST_3R("ilvl.d",  40,  80, w5,  w28, w18);
   TEST_3R("ilvl.d",  48, 208, w6,  w10, w6);
   TEST_3R("ilvl.d",  56, 120, w7,  w17, w10);
   TEST_3R("ilvl.d",  64,   8, w8,  w16, w20);
   TEST_3R("ilvl.d",  72, 120, w9,  w20, w7);
   TEST_3R("ilvl.d",  80, 104, w10, w10, w10);
   TEST_3R("ilvl.d",  88, 208, w11, w25, w1);
   TEST_3R("ilvl.d",  96,  56, w12, w19, w14);
   TEST_3R("ilvl.d", 104, 216, w13, w31, w31);
   TEST_3R("ilvl.d", 112,  24, w14, w28, w20);
   TEST_3R("ilvl.d", 120, 184, w15, w12, w13);
   TEST_3R("ilvl.d", 128, 192, w16, w11, w5);
   TEST_3R("ilvl.d", 136,   0, w17, w29, w22);
   TEST_3R("ilvl.d", 144, 232, w18, w0,  w7);
   TEST_3R("ilvl.d", 152, 152, w19, w30, w23);
   TEST_3R("ilvl.d", 160, 160, w20, w24, w12);
   TEST_3R("ilvl.d", 168, 192, w21, w1,  w22);
   TEST_3R("ilvl.d", 176,  48, w22, w2,  w27);
   TEST_3R("ilvl.d", 184,  96, w23, w16, w26);
   TEST_3R("ilvl.d", 192,  16, w24, w15, w23);
   TEST_3R("ilvl.d", 200,   0, w25, w30, w3);
   TEST_3R("ilvl.d", 208, 232, w26, w24, w14);
   TEST_3R("ilvl.d", 216,  64, w27, w14, w11);
   TEST_3R("ilvl.d", 224, 176, w28, w15, w12);
   TEST_3R("ilvl.d", 232,  24, w29, w26, w10);
   TEST_3R("ilvl.d", 240, 152, w30, w25, w2);
   TEST_3R("ilvl.d",  48,  32, w31, w0,  w3);
   TEST_3R("ilvod.b",   0,  80, w0,  w7,  w6);
   TEST_3R("ilvod.b",   8, 208, w1,  w30, w13);
   TEST_3R("ilvod.b",  16,  56, w2,  w1,  w28);
   TEST_3R("ilvod.b",  24,   8, w3,  w27, w11);
   TEST_3R("ilvod.b",  32, 208, w4,  w11, w26);
   TEST_3R("ilvod.b",  40, 192, w5,  w5,  w5);
   TEST_3R("ilvod.b",  48, 224, w6,  w20, w16);
   TEST_3R("ilvod.b",  56, 136, w7,  w13, w19);
   TEST_3R("ilvod.b",  64,  40, w8,  w14, w22);
   TEST_3R("ilvod.b",  72,  24, w9,  w14, w28);
   TEST_3R("ilvod.b",  80, 144, w10, w2,  w18);
   TEST_3R("ilvod.b",  88, 184, w11, w9,  w23);
   TEST_3R("ilvod.b",  96, 216, w12, w12, w22);
   TEST_3R("ilvod.b", 104, 152, w13, w16, w24);
   TEST_3R("ilvod.b", 112, 112, w14, w31, w19);
   TEST_3R("ilvod.b", 120, 216, w15, w25, w30);
   TEST_3R("ilvod.b", 128, 224, w16, w0,  w17);
   TEST_3R("ilvod.b", 136,  64, w17, w18, w30);
   TEST_3R("ilvod.b", 144, 168, w18, w30, w12);
   TEST_3R("ilvod.b", 152,   0, w19, w28, w27);
   TEST_3R("ilvod.b", 160, 216, w20, w6,  w20);
   TEST_3R("ilvod.b", 168, 208, w21, w8,  w23);
   TEST_3R("ilvod.b", 176,  96, w22, w31, w31);
   TEST_3R("ilvod.b", 184,  80, w23, w29, w27);
   TEST_3R("ilvod.b", 192, 128, w24, w21, w19);
   TEST_3R("ilvod.b", 200, 184, w25, w8,  w22);
   TEST_3R("ilvod.b", 208, 216, w26, w6,  w19);
   TEST_3R("ilvod.b", 216, 200, w27, w6,  w4);
   TEST_3R("ilvod.b", 224,  32, w28, w24, w2);
   TEST_3R("ilvod.b", 232,  72, w29, w23, w15);
   TEST_3R("ilvod.b", 240, 192, w30, w19, w10);
   TEST_3R("ilvod.b", 208, 120, w31, w25, w7);
   TEST_3R("ilvod.h",   0,  64, w0,  w14, w26);
   TEST_3R("ilvod.h",   8,  24, w1,  w11, w21);
   TEST_3R("ilvod.h",  16, 160, w2,  w0,  w8);
   TEST_3R("ilvod.h",  24, 104, w3,  w8,  w30);
   TEST_3R("ilvod.h",  32,  88, w4,  w14, w17);
   TEST_3R("ilvod.h",  40,  96, w5,  w5,  w5);
   TEST_3R("ilvod.h",  48,  72, w6,  w21, w29);
   TEST_3R("ilvod.h",  56, 128, w7,  w23, w31);
   TEST_3R("ilvod.h",  64,  48, w8,  w6,  w28);
   TEST_3R("ilvod.h",  72, 112, w9,  w16, w14);
   TEST_3R("ilvod.h",  80,  80, w10, w24, w9);
   TEST_3R("ilvod.h",  88,  16, w11, w6,  w3);
   TEST_3R("ilvod.h",  96,   8, w12, w12, w17);
   TEST_3R("ilvod.h", 104, 144, w13, w2,  w17);
   TEST_3R("ilvod.h", 112,  88, w14, w3,  w25);
   TEST_3R("ilvod.h", 120,  56, w15, w18, w7);
   TEST_3R("ilvod.h", 128, 216, w16, w27, w4);
   TEST_3R("ilvod.h", 136,  56, w17, w8,  w27);
   TEST_3R("ilvod.h", 144,  88, w18, w12, w2);
   TEST_3R("ilvod.h", 152, 192, w19, w3,  w18);
   TEST_3R("ilvod.h", 160, 120, w20, w19, w20);
   TEST_3R("ilvod.h", 168,   0, w21, w0,  w19);
   TEST_3R("ilvod.h", 176, 168, w22, w3,  w3);
   TEST_3R("ilvod.h", 184,  88, w23, w1,  w27);
   TEST_3R("ilvod.h", 192,  56, w24, w18, w27);
   TEST_3R("ilvod.h", 200,   0, w25, w11, w1);
   TEST_3R("ilvod.h", 208,  56, w26, w8,  w17);
   TEST_3R("ilvod.h", 216,  80, w27, w12, w31);
   TEST_3R("ilvod.h", 224,   0, w28, w8,  w12);
   TEST_3R("ilvod.h", 232,  80, w29, w10, w21);
   TEST_3R("ilvod.h", 240, 152, w30, w28, w12);
   TEST_3R("ilvod.h",  16,  56, w31, w7,  w13);
   TEST_3R("ilvod.w",   0, 184, w0,  w16, w23);
   TEST_3R("ilvod.w",   8,  56, w1,  w12, w2);
   TEST_3R("ilvod.w",  16,  80, w2,  w7,  w17);
   TEST_3R("ilvod.w",  24, 200, w3,  w1,  w18);
   TEST_3R("ilvod.w",  32,  16, w4,  w9,  w3);
   TEST_3R("ilvod.w",  40, 224, w5,  w5,  w5);
   TEST_3R("ilvod.w",  48,  72, w6,  w2,  w14);
   TEST_3R("ilvod.w",  56, 216, w7,  w14, w17);
   TEST_3R("ilvod.w",  64,   0, w8,  w3,  w23);
   TEST_3R("ilvod.w",  72, 152, w9,  w16, w17);
   TEST_3R("ilvod.w",  80, 176, w10, w29, w31);
   TEST_3R("ilvod.w",  88, 120, w11, w13, w22);
   TEST_3R("ilvod.w",  96, 200, w12, w12, w25);
   TEST_3R("ilvod.w", 104, 200, w13, w7,  w1);
   TEST_3R("ilvod.w", 112, 216, w14, w30, w2);
   TEST_3R("ilvod.w", 120,  40, w15, w8,  w11);
   TEST_3R("ilvod.w", 128,  32, w16, w31, w1);
   TEST_3R("ilvod.w", 136, 224, w17, w13, w31);
   TEST_3R("ilvod.w", 144,   0, w18, w30, w7);
   TEST_3R("ilvod.w", 152, 144, w19, w22, w12);
   TEST_3R("ilvod.w", 160,  96, w20, w7,  w20);
   TEST_3R("ilvod.w", 168,  40, w21, w0,  w6);
   TEST_3R("ilvod.w", 176, 120, w22, w14, w14);
   TEST_3R("ilvod.w", 184, 192, w23, w22, w7);
   TEST_3R("ilvod.w", 192, 152, w24, w30, w8);
   TEST_3R("ilvod.w", 200,   8, w25, w28, w10);
   TEST_3R("ilvod.w", 208, 168, w26, w4,  w22);
   TEST_3R("ilvod.w", 216, 200, w27, w4,  w23);
   TEST_3R("ilvod.w", 224, 184, w28, w17, w23);
   TEST_3R("ilvod.w", 232,  56, w29, w16, w30);
   TEST_3R("ilvod.w", 240,  80, w30, w6,  w10);
   TEST_3R("ilvod.w", 160, 192, w31, w13, w2);
   TEST_3R("ilvod.d",   0,  48, w0,  w28, w16);
   TEST_3R("ilvod.d",   8,   0, w1,  w19, w23);
   TEST_3R("ilvod.d",  16,  32, w2,  w17, w0);
   TEST_3R("ilvod.d",  24, 152, w3,  w13, w10);
   TEST_3R("ilvod.d",  32,  80, w4,  w18, w0);
   TEST_3R("ilvod.d",  40, 192, w5,  w5,  w5);
   TEST_3R("ilvod.d",  48, 192, w6,  w24, w17);
   TEST_3R("ilvod.d",  56, 144, w7,  w15, w28);
   TEST_3R("ilvod.d",  64, 104, w8,  w13, w26);
   TEST_3R("ilvod.d",  72, 152, w9,  w24, w27);
   TEST_3R("ilvod.d",  80,  72, w10, w26, w29);
   TEST_3R("ilvod.d",  88, 120, w11, w22, w13);
   TEST_3R("ilvod.d",  96, 224, w12, w12, w9);
   TEST_3R("ilvod.d", 104, 224, w13, w21, w26);
   TEST_3R("ilvod.d", 112, 168, w14, w25, w8);
   TEST_3R("ilvod.d", 120, 208, w15, w23, w26);
   TEST_3R("ilvod.d", 128,  72, w16, w14, w8);
   TEST_3R("ilvod.d", 136, 232, w17, w23, w27);
   TEST_3R("ilvod.d", 144, 104, w18, w4,  w21);
   TEST_3R("ilvod.d", 152,  16, w19, w28, w17);
   TEST_3R("ilvod.d", 160, 152, w20, w22, w20);
   TEST_3R("ilvod.d", 168,  72, w21, w22, w13);
   TEST_3R("ilvod.d", 176,  16, w22, w6,  w6);
   TEST_3R("ilvod.d", 184, 192, w23, w1,  w27);
   TEST_3R("ilvod.d", 192, 216, w24, w6,  w20);
   TEST_3R("ilvod.d", 200,  32, w25, w21, w11);
   TEST_3R("ilvod.d", 208, 160, w26, w5,  w25);
   TEST_3R("ilvod.d", 216,   8, w27, w13, w24);
   TEST_3R("ilvod.d", 224,   8, w28, w4,  w20);
   TEST_3R("ilvod.d", 232, 176, w29, w9,  w22);
   TEST_3R("ilvod.d", 240, 136, w30, w26, w13);
   TEST_3R("ilvod.d",  48, 104, w31, w9,  w4);
   TEST_3R("ilvr.b",   0, 200, w0,  w16, w12);
   TEST_3R("ilvr.b",   8, 200, w1,  w9,  w4);
   TEST_3R("ilvr.b",  16, 232, w2,  w7,  w29);
   TEST_3R("ilvr.b",  24,   8, w3,  w20, w21);
   TEST_3R("ilvr.b",  32, 128, w4,  w25, w9);
   TEST_3R("ilvr.b",  40, 224, w5,  w2,  w2);
   TEST_3R("ilvr.b",  48, 224, w6,  w25, w6);
   TEST_3R("ilvr.b",  56,  16, w7,  w13, w3);
   TEST_3R("ilvr.b",  64,  72, w8,  w11, w12);
   TEST_3R("ilvr.b",  72, 176, w9,  w21, w12);
   TEST_3R("ilvr.b",  80, 120, w10, w10, w10);
   TEST_3R("ilvr.b",  88, 192, w11, w28, w13);
   TEST_3R("ilvr.b",  96, 112, w12, w6,  w15);
   TEST_3R("ilvr.b", 104,  32, w13, w2,  w22);
   TEST_3R("ilvr.b", 112,  24, w14, w2,  w10);
   TEST_3R("ilvr.b", 120, 144, w15, w28, w3);
   TEST_3R("ilvr.b", 128, 128, w16, w31, w5);
   TEST_3R("ilvr.b", 136, 176, w17, w25, w13);
   TEST_3R("ilvr.b", 144,  72, w18, w0,  w16);
   TEST_3R("ilvr.b", 152, 144, w19, w11, w29);
   TEST_3R("ilvr.b", 160,  80, w20, w0,  w9);
   TEST_3R("ilvr.b", 168,  48, w21, w26, w5);
   TEST_3R("ilvr.b", 176, 144, w22, w13, w11);
   TEST_3R("ilvr.b", 184, 184, w23, w4,  w14);
   TEST_3R("ilvr.b", 192,  96, w24, w16, w4);
   TEST_3R("ilvr.b", 200,   0, w25, w12, w7);
   TEST_3R("ilvr.b", 208,   8, w26, w11, w13);
   TEST_3R("ilvr.b", 216,  56, w27, w4,  w26);
   TEST_3R("ilvr.b", 224, 136, w28, w4,  w10);
   TEST_3R("ilvr.b", 232, 152, w29, w15, w7);
   TEST_3R("ilvr.b", 240, 112, w30, w15, w16);
   TEST_3R("ilvr.b", 168, 112, w31, w31, w9);
   TEST_3R("ilvr.h",   0, 184, w0,  w22, w1);
   TEST_3R("ilvr.h",   8, 128, w1,  w26, w15);
   TEST_3R("ilvr.h",  16,   8, w2,  w18, w31);
   TEST_3R("ilvr.h",  24,   0, w3,  w20, w11);
   TEST_3R("ilvr.h",  32, 152, w4,  w8,  w23);
   TEST_3R("ilvr.h",  40, 104, w5,  w3,  w3);
   TEST_3R("ilvr.h",  48, 112, w6,  w8,  w6);
   TEST_3R("ilvr.h",  56,   8, w7,  w0,  w19);
   TEST_3R("ilvr.h",  64, 160, w8,  w15, w26);
   TEST_3R("ilvr.h",  72,  40, w9,  w31, w11);
   TEST_3R("ilvr.h",  80,   8, w10, w10, w10);
   TEST_3R("ilvr.h",  88,  88, w11, w1,  w4);
   TEST_3R("ilvr.h",  96, 216, w12, w2,  w0);
   TEST_3R("ilvr.h", 104, 168, w13, w18, w22);
   TEST_3R("ilvr.h", 112,  96, w14, w17, w16);
   TEST_3R("ilvr.h", 120,  24, w15, w29, w18);
   TEST_3R("ilvr.h", 128, 200, w16, w20, w0);
   TEST_3R("ilvr.h", 136,  72, w17, w15, w9);
   TEST_3R("ilvr.h", 144, 192, w18, w15, w28);
   TEST_3R("ilvr.h", 152, 120, w19, w31, w22);
   TEST_3R("ilvr.h", 160,  32, w20, w30, w1);
   TEST_3R("ilvr.h", 168, 120, w21, w6,  w2);
   TEST_3R("ilvr.h", 176, 200, w22, w5,  w27);
   TEST_3R("ilvr.h", 184, 168, w23, w18, w11);
   TEST_3R("ilvr.h", 192, 208, w24, w2,  w11);
   TEST_3R("ilvr.h", 200, 120, w25, w20, w19);
   TEST_3R("ilvr.h", 208,   8, w26, w21, w31);
   TEST_3R("ilvr.h", 216, 136, w27, w30, w24);
   TEST_3R("ilvr.h", 224,  16, w28, w1,  w23);
   TEST_3R("ilvr.h", 232, 208, w29, w13, w21);
   TEST_3R("ilvr.h", 240,   0, w30, w4,  w28);
   TEST_3R("ilvr.h", 168,  40, w31, w31, w1);
   TEST_3R("ilvr.w",   0, 120, w0,  w16, w12);
   TEST_3R("ilvr.w",   8, 224, w1,  w25, w15);
   TEST_3R("ilvr.w",  16, 120, w2,  w30, w3);
   TEST_3R("ilvr.w",  24,   0, w3,  w24, w9);
   TEST_3R("ilvr.w",  32,  80, w4,  w22, w25);
   TEST_3R("ilvr.w",  40, 208, w5,  w17, w17);
   TEST_3R("ilvr.w",  48,  48, w6,  w18, w6);
   TEST_3R("ilvr.w",  56, 208, w7,  w19, w22);
   TEST_3R("ilvr.w",  64, 224, w8,  w7,  w21);
   TEST_3R("ilvr.w",  72, 208, w9,  w1,  w16);
   TEST_3R("ilvr.w",  80,  80, w10, w10, w10);
   TEST_3R("ilvr.w",  88, 232, w11, w28, w16);
   TEST_3R("ilvr.w",  96, 232, w12, w11, w6);
   TEST_3R("ilvr.w", 104, 224, w13, w15, w16);
   TEST_3R("ilvr.w", 112, 224, w14, w7,  w25);
   TEST_3R("ilvr.w", 120, 200, w15, w30, w27);
   TEST_3R("ilvr.w", 128, 168, w16, w3,  w12);
   TEST_3R("ilvr.w", 136, 224, w17, w22, w19);
   TEST_3R("ilvr.w", 144,  40, w18, w12, w21);
   TEST_3R("ilvr.w", 152,   8, w19, w2,  w25);
   TEST_3R("ilvr.w", 160, 200, w20, w18, w30);
   TEST_3R("ilvr.w", 168,  72, w21, w14, w7);
   TEST_3R("ilvr.w", 176, 136, w22, w20, w16);
   TEST_3R("ilvr.w", 184,  80, w23, w5,  w17);
   TEST_3R("ilvr.w", 192, 200, w24, w30, w19);
   TEST_3R("ilvr.w", 200,  40, w25, w28, w14);
   TEST_3R("ilvr.w", 208,  88, w26, w0,  w27);
   TEST_3R("ilvr.w", 216, 184, w27, w22, w14);
   TEST_3R("ilvr.w", 224, 104, w28, w2,  w3);
   TEST_3R("ilvr.w", 232,  40, w29, w4,  w22);
   TEST_3R("ilvr.w", 240, 184, w30, w0,  w5);
   TEST_3R("ilvr.w", 168, 120, w31, w31, w7);
   TEST_3R("ilvr.d",   0, 112, w0,  w23, w8);
   TEST_3R("ilvr.d",   8, 224, w1,  w8,  w24);
   TEST_3R("ilvr.d",  16,  24, w2,  w27, w7);
   TEST_3R("ilvr.d",  24,   8, w3,  w10, w4);
   TEST_3R("ilvr.d",  32,  48, w4,  w5,  w16);
   TEST_3R("ilvr.d",  40, 136, w5,  w19, w19);
   TEST_3R("ilvr.d",  48, 192, w6,  w22, w6);
   TEST_3R("ilvr.d",  56, 176, w7,  w24, w26);
   TEST_3R("ilvr.d",  64, 216, w8,  w28, w17);
   TEST_3R("ilvr.d",  72, 160, w9,  w29, w22);
   TEST_3R("ilvr.d",  80,  96, w10, w10, w10);
   TEST_3R("ilvr.d",  88,   8, w11, w21, w28);
   TEST_3R("ilvr.d",  96, 224, w12, w23, w4);
   TEST_3R("ilvr.d", 104,  40, w13, w24, w0);
   TEST_3R("ilvr.d", 112,  16, w14, w22, w10);
   TEST_3R("ilvr.d", 120, 144, w15, w19, w17);
   TEST_3R("ilvr.d", 128,  40, w16, w2,  w29);
   TEST_3R("ilvr.d", 136, 216, w17, w9,  w23);
   TEST_3R("ilvr.d", 144,  72, w18, w5,  w8);
   TEST_3R("ilvr.d", 152,   0, w19, w2,  w30);
   TEST_3R("ilvr.d", 160,  80, w20, w7,  w19);
   TEST_3R("ilvr.d", 168,  40, w21, w3,  w16);
   TEST_3R("ilvr.d", 176, 224, w22, w7,  w6);
   TEST_3R("ilvr.d", 184,  72, w23, w7,  w2);
   TEST_3R("ilvr.d", 192, 176, w24, w17, w3);
   TEST_3R("ilvr.d", 200,  80, w25, w0,  w20);
   TEST_3R("ilvr.d", 208, 144, w26, w2,  w4);
   TEST_3R("ilvr.d", 216,  80, w27, w13, w28);
   TEST_3R("ilvr.d", 224,  32, w28, w19, w4);
   TEST_3R("ilvr.d", 232,  32, w29, w21, w3);
   TEST_3R("ilvr.d", 240, 232, w30, w28, w22);
   TEST_3R("ilvr.d", 224,  40, w31, w31, w7);
   TEST_3R("pckev.b",   0, 136, w0,  w29, w18);
   TEST_3R("pckev.b",   8, 224, w1,  w0,  w6);
   TEST_3R("pckev.b",  16,   8, w2,  w3,  w11);
   TEST_3R("pckev.b",  24, 224, w3,  w30, w24);
   TEST_3R("pckev.b",  32, 200, w4,  w5,  w11);
   TEST_3R("pckev.b",  40, 152, w5,  w6,  w1);
   TEST_3R("pckev.b",  48, 192, w6,  w26, w29);
   TEST_3R("pckev.b",  56,  88, w7,  w20, w29);
   TEST_3R("pckev.b",  64,  48, w8,  w13, w4);
   TEST_3R("pckev.b",  72,  16, w9,  w29, w18);
   TEST_3R("pckev.b",  80, 232, w10, w26, w18);
   TEST_3R("pckev.b",  88,  64, w11, w24, w19);
   TEST_3R("pckev.b",  96, 200, w12, w29, w22);
   TEST_3R("pckev.b", 104,  96, w13, w13, w13);
   TEST_3R("pckev.b", 112,  32, w14, w20, w14);
   TEST_3R("pckev.b", 120,  40, w15, w12, w12);
   TEST_3R("pckev.b", 128, 160, w16, w16, w15);
   TEST_3R("pckev.b", 136, 192, w17, w31, w16);
   TEST_3R("pckev.b", 144, 144, w18, w25, w13);
   TEST_3R("pckev.b", 152, 112, w19, w14, w10);
   TEST_3R("pckev.b", 160,  40, w20, w27, w14);
   TEST_3R("pckev.b", 168,  56, w21, w25, w1);
   TEST_3R("pckev.b", 176, 168, w22, w19, w9);
   TEST_3R("pckev.b", 184,  24, w23, w6,  w9);
   TEST_3R("pckev.b", 192, 232, w24, w28, w20);
   TEST_3R("pckev.b", 200, 200, w25, w16, w23);
   TEST_3R("pckev.b", 208, 128, w26, w9,  w6);
   TEST_3R("pckev.b", 216,  80, w27, w9,  w22);
   TEST_3R("pckev.b", 224, 104, w28, w2,  w4);
   TEST_3R("pckev.b", 232,  88, w29, w16, w14);
   TEST_3R("pckev.b", 240,   0, w30, w12, w29);
   TEST_3R("pckev.b", 120, 176, w31, w5,  w30);
   TEST_3R("pckev.h",   0, 160, w0,  w17, w12);
   TEST_3R("pckev.h",   8,  56, w1,  w24, w21);
   TEST_3R("pckev.h",  16,  56, w2,  w20, w9);
   TEST_3R("pckev.h",  24,  16, w3,  w5,  w1);
   TEST_3R("pckev.h",  32,  16, w4,  w14, w7);
   TEST_3R("pckev.h",  40, 216, w5,  w23, w30);
   TEST_3R("pckev.h",  48,  80, w6,  w26, w2);
   TEST_3R("pckev.h",  56,  48, w7,  w10, w16);
   TEST_3R("pckev.h",  64,  48, w8,  w22, w13);
   TEST_3R("pckev.h",  72, 232, w9,  w27, w11);
   TEST_3R("pckev.h",  80, 208, w10, w20, w29);
   TEST_3R("pckev.h",  88, 184, w11, w24, w21);
   TEST_3R("pckev.h",  96, 224, w12, w4,  w9);
   TEST_3R("pckev.h", 104,  48, w13, w13, w13);
   TEST_3R("pckev.h", 112,  64, w14, w5,  w14);
   TEST_3R("pckev.h", 120, 104, w15, w29, w29);
   TEST_3R("pckev.h", 128, 208, w16, w16, w30);
   TEST_3R("pckev.h", 136,  40, w17, w11, w25);
   TEST_3R("pckev.h", 144, 136, w18, w13, w15);
   TEST_3R("pckev.h", 152, 200, w19, w29, w17);
   TEST_3R("pckev.h", 160, 104, w20, w11, w6);
   TEST_3R("pckev.h", 168, 232, w21, w22, w31);
   TEST_3R("pckev.h", 176, 160, w22, w19, w5);
   TEST_3R("pckev.h", 184, 152, w23, w8,  w0);
   TEST_3R("pckev.h", 192, 200, w24, w18, w4);
   TEST_3R("pckev.h", 200, 144, w25, w0,  w10);
   TEST_3R("pckev.h", 208, 112, w26, w29, w23);
   TEST_3R("pckev.h", 216,  56, w27, w18, w2);
   TEST_3R("pckev.h", 224, 200, w28, w0,  w15);
   TEST_3R("pckev.h", 232, 152, w29, w25, w12);
   TEST_3R("pckev.h", 240, 144, w30, w9,  w23);
   TEST_3R("pckev.h", 160, 128, w31, w20, w14);
   TEST_3R("pckev.w",   0,  88, w0,  w1,  w21);
   TEST_3R("pckev.w",   8,   0, w1,  w10, w21);
   TEST_3R("pckev.w",  16, 208, w2,  w28, w25);
   TEST_3R("pckev.w",  24, 104, w3,  w28, w19);
   TEST_3R("pckev.w",  32,  24, w4,  w26, w3);
   TEST_3R("pckev.w",  40, 104, w5,  w28, w12);
   TEST_3R("pckev.w",  48,  80, w6,  w11, w5);
   TEST_3R("pckev.w",  56, 136, w7,  w24, w15);
   TEST_3R("pckev.w",  64,  64, w8,  w15, w0);
   TEST_3R("pckev.w",  72, 224, w9,  w29, w16);
   TEST_3R("pckev.w",  80,  80, w10, w31, w5);
   TEST_3R("pckev.w",  88,  80, w11, w9,  w26);
   TEST_3R("pckev.w",  96, 160, w12, w5,  w19);
   TEST_3R("pckev.w", 104, 176, w13, w13, w13);
   TEST_3R("pckev.w", 112,  24, w14, w23, w14);
   TEST_3R("pckev.w", 120,  96, w15, w27, w27);
   TEST_3R("pckev.w", 128, 176, w16, w16, w28);
   TEST_3R("pckev.w", 136, 160, w17, w14, w9);
   TEST_3R("pckev.w", 144,   8, w18, w25, w14);
   TEST_3R("pckev.w", 152,  24, w19, w17, w30);
   TEST_3R("pckev.w", 160,  88, w20, w1,  w30);
   TEST_3R("pckev.w", 168,  80, w21, w30, w14);
   TEST_3R("pckev.w", 176, 160, w22, w29, w19);
   TEST_3R("pckev.w", 184, 112, w23, w6,  w13);
   TEST_3R("pckev.w", 192, 152, w24, w11, w0);
   TEST_3R("pckev.w", 200,  48, w25, w13, w23);
   TEST_3R("pckev.w", 208,  48, w26, w8,  w9);
   TEST_3R("pckev.w", 216, 184, w27, w16, w23);
   TEST_3R("pckev.w", 224,  72, w28, w4,  w16);
   TEST_3R("pckev.w", 232,  88, w29, w30, w2);
   TEST_3R("pckev.w", 240, 128, w30, w7,  w3);
   TEST_3R("pckev.w",  48, 208, w31, w19, w1);
   TEST_3R("pckev.d",   0,  80, w0,  w31, w24);
   TEST_3R("pckev.d",   8,  96, w1,  w5,  w30);
   TEST_3R("pckev.d",  16,  56, w2,  w6,  w12);
   TEST_3R("pckev.d",  24,  48, w3,  w29, w20);
   TEST_3R("pckev.d",  32,  96, w4,  w6,  w24);
   TEST_3R("pckev.d",  40, 232, w5,  w29, w26);
   TEST_3R("pckev.d",  48, 112, w6,  w0,  w24);
   TEST_3R("pckev.d",  56, 224, w7,  w26, w31);
   TEST_3R("pckev.d",  64,  32, w8,  w17, w18);
   TEST_3R("pckev.d",  72, 208, w9,  w23, w7);
   TEST_3R("pckev.d",  80, 152, w10, w15, w30);
   TEST_3R("pckev.d",  88,   8, w11, w21, w29);
   TEST_3R("pckev.d",  96, 184, w12, w27, w9);
   TEST_3R("pckev.d", 104, 136, w13, w13, w13);
   TEST_3R("pckev.d", 112, 232, w14, w29, w14);
   TEST_3R("pckev.d", 120,  16, w15, w31, w31);
   TEST_3R("pckev.d", 128, 120, w16, w16, w5);
   TEST_3R("pckev.d", 136, 120, w17, w26, w31);
   TEST_3R("pckev.d", 144, 104, w18, w27, w24);
   TEST_3R("pckev.d", 152,  88, w19, w21, w23);
   TEST_3R("pckev.d", 160,   0, w20, w6,  w10);
   TEST_3R("pckev.d", 168, 208, w21, w29, w17);
   TEST_3R("pckev.d", 176, 120, w22, w13, w16);
   TEST_3R("pckev.d", 184, 136, w23, w2,  w13);
   TEST_3R("pckev.d", 192,  80, w24, w29, w22);
   TEST_3R("pckev.d", 200, 184, w25, w21, w20);
   TEST_3R("pckev.d", 208, 160, w26, w20, w9);
   TEST_3R("pckev.d", 216,  96, w27, w17, w4);
   TEST_3R("pckev.d", 224,  88, w28, w27, w31);
   TEST_3R("pckev.d", 232,  16, w29, w22, w20);
   TEST_3R("pckev.d", 240,  88, w30, w3,  w26);
   TEST_3R("pckev.d",  72, 136, w31, w5,  w24);
   TEST_3R("pckod.b",   0, 192, w0,  w27, w2);
   TEST_3R("pckod.b",   8, 232, w1,  w18, w2);
   TEST_3R("pckod.b",  16, 136, w2,  w6,  w17);
   TEST_3R("pckod.b",  24, 168, w3,  w15, w5);
   TEST_3R("pckod.b",  32,  88, w4,  w19, w25);
   TEST_3R("pckod.b",  40, 176, w5,  w5,  w5);
   TEST_3R("pckod.b",  48, 128, w6,  w4,  w16);
   TEST_3R("pckod.b",  56, 208, w7,  w20, w20);
   TEST_3R("pckod.b",  64, 216, w8,  w20, w25);
   TEST_3R("pckod.b",  72,   0, w9,  w19, w9);
   TEST_3R("pckod.b",  80,  72, w10, w30, w1);
   TEST_3R("pckod.b",  88, 160, w11, w5,  w29);
   TEST_3R("pckod.b",  96,  80, w12, w9,  w15);
   TEST_3R("pckod.b", 104, 176, w13, w2,  w21);
   TEST_3R("pckod.b", 112, 208, w14, w14, w16);
   TEST_3R("pckod.b", 120,  96, w15, w25, w24);
   TEST_3R("pckod.b", 128,  24, w16, w10, w23);
   TEST_3R("pckod.b", 136,  16, w17, w30, w14);
   TEST_3R("pckod.b", 144, 232, w18, w19, w8);
   TEST_3R("pckod.b", 152, 136, w19, w6,  w28);
   TEST_3R("pckod.b", 160,  88, w20, w7,  w26);
   TEST_3R("pckod.b", 168,   0, w21, w4,  w26);
   TEST_3R("pckod.b", 176, 136, w22, w19, w29);
   TEST_3R("pckod.b", 184, 168, w23, w8,  w17);
   TEST_3R("pckod.b", 192,   8, w24, w13, w10);
   TEST_3R("pckod.b", 200, 176, w25, w5,  w29);
   TEST_3R("pckod.b", 208, 200, w26, w15, w20);
   TEST_3R("pckod.b", 216,  56, w27, w0,  w18);
   TEST_3R("pckod.b", 224, 208, w28, w18, w5);
   TEST_3R("pckod.b", 232, 192, w29, w11, w17);
   TEST_3R("pckod.b", 240,  48, w30, w19, w11);
   TEST_3R("pckod.b", 120, 168, w31, w23, w6);
   TEST_3R("pckod.h",   0, 144, w0,  w3,  w5);
   TEST_3R("pckod.h",   8,  32, w1,  w20, w15);
   TEST_3R("pckod.h",  16,   0, w2,  w30, w8);
   TEST_3R("pckod.h",  24, 128, w3,  w27, w12);
   TEST_3R("pckod.h",  32,  64, w4,  w15, w10);
   TEST_3R("pckod.h",  40, 128, w5,  w5,  w5);
   TEST_3R("pckod.h",  48,  80, w6,  w22, w8);
   TEST_3R("pckod.h",  56, 192, w7,  w11, w11);
   TEST_3R("pckod.h",  64, 152, w8,  w19, w28);
   TEST_3R("pckod.h",  72,  16, w9,  w6,  w9);
   TEST_3R("pckod.h",  80,  24, w10, w0,  w29);
   TEST_3R("pckod.h",  88, 128, w11, w12, w8);
   TEST_3R("pckod.h",  96, 144, w12, w17, w28);
   TEST_3R("pckod.h", 104,  48, w13, w0,  w28);
   TEST_3R("pckod.h", 112, 208, w14, w14, w8);
   TEST_3R("pckod.h", 120, 208, w15, w30, w20);
   TEST_3R("pckod.h", 128, 152, w16, w14, w30);
   TEST_3R("pckod.h", 136,  48, w17, w16, w21);
   TEST_3R("pckod.h", 144,   8, w18, w23, w0);
   TEST_3R("pckod.h", 152,  32, w19, w10, w28);
   TEST_3R("pckod.h", 160, 112, w20, w16, w3);
   TEST_3R("pckod.h", 168,   0, w21, w14, w17);
   TEST_3R("pckod.h", 176, 160, w22, w1,  w3);
   TEST_3R("pckod.h", 184, 120, w23, w6,  w3);
   TEST_3R("pckod.h", 192, 208, w24, w9,  w12);
   TEST_3R("pckod.h", 200,  56, w25, w7,  w0);
   TEST_3R("pckod.h", 208, 208, w26, w21, w31);
   TEST_3R("pckod.h", 216,  24, w27, w5,  w20);
   TEST_3R("pckod.h", 224, 144, w28, w29, w20);
   TEST_3R("pckod.h", 232, 184, w29, w7,  w16);
   TEST_3R("pckod.h", 240,  56, w30, w24, w19);
   TEST_3R("pckod.h", 216,  64, w31, w6,  w4);
   TEST_3R("pckod.w",   0,   8, w0,  w6,  w5);
   TEST_3R("pckod.w",   8,   8, w1,  w12, w9);
   TEST_3R("pckod.w",  16,  40, w2,  w21, w15);
   TEST_3R("pckod.w",  24,  96, w3,  w21, w23);
   TEST_3R("pckod.w",  32, 224, w4,  w20, w11);
   TEST_3R("pckod.w",  40,  40, w5,  w5,  w5);
   TEST_3R("pckod.w",  48, 160, w6,  w20, w28);
   TEST_3R("pckod.w",  56,  56, w7,  w28, w28);
   TEST_3R("pckod.w",  64, 144, w8,  w0,  w20);
   TEST_3R("pckod.w",  72, 104, w9,  w16, w9);
   TEST_3R("pckod.w",  80, 192, w10, w4,  w18);
   TEST_3R("pckod.w",  88, 208, w11, w10, w23);
   TEST_3R("pckod.w",  96, 224, w12, w22, w0);
   TEST_3R("pckod.w", 104,  80, w13, w11, w21);
   TEST_3R("pckod.w", 112, 216, w14, w14, w8);
   TEST_3R("pckod.w", 120, 136, w15, w9,  w26);
   TEST_3R("pckod.w", 128,  56, w16, w21, w17);
   TEST_3R("pckod.w", 136,  80, w17, w9,  w6);
   TEST_3R("pckod.w", 144, 144, w18, w1,  w2);
   TEST_3R("pckod.w", 152, 160, w19, w1,  w22);
   TEST_3R("pckod.w", 160, 112, w20, w17, w16);
   TEST_3R("pckod.w", 168, 224, w21, w3,  w6);
   TEST_3R("pckod.w", 176, 224, w22, w27, w12);
   TEST_3R("pckod.w", 184, 192, w23, w27, w15);
   TEST_3R("pckod.w", 192,  72, w24, w17, w2);
   TEST_3R("pckod.w", 200,  48, w25, w28, w11);
   TEST_3R("pckod.w", 208, 128, w26, w27, w0);
   TEST_3R("pckod.w", 216, 152, w27, w3,  w10);
   TEST_3R("pckod.w", 224, 104, w28, w8,  w11);
   TEST_3R("pckod.w", 232, 176, w29, w25, w12);
   TEST_3R("pckod.w", 240, 104, w30, w10, w3);
   TEST_3R("pckod.w", 184, 200, w31, w1,  w10);
   TEST_3R("pckod.d",   0, 160, w0,  w22, w24);
   TEST_3R("pckod.d",   8, 192, w1,  w24, w9);
   TEST_3R("pckod.d",  16,  16, w2,  w5,  w19);
   TEST_3R("pckod.d",  24,  24, w3,  w0,  w19);
   TEST_3R("pckod.d",  32, 168, w4,  w29, w23);
   TEST_3R("pckod.d",  40,  72, w5,  w5,  w5);
   TEST_3R("pckod.d",  48,  48, w6,  w20, w5);
   TEST_3R("pckod.d",  56, 232, w7,  w8,  w8);
   TEST_3R("pckod.d",  64, 104, w8,  w19, w11);
   TEST_3R("pckod.d",  72,  64, w9,  w20, w9);
   TEST_3R("pckod.d",  80, 152, w10, w14, w17);
   TEST_3R("pckod.d",  88, 192, w11, w4,  w9);
   TEST_3R("pckod.d",  96, 152, w12, w28, w18);
   TEST_3R("pckod.d", 104,   8, w13, w30, w23);
   TEST_3R("pckod.d", 112, 144, w14, w14, w4);
   TEST_3R("pckod.d", 120, 232, w15, w31, w27);
   TEST_3R("pckod.d", 128, 176, w16, w22, w7);
   TEST_3R("pckod.d", 136, 232, w17, w11, w12);
   TEST_3R("pckod.d", 144, 216, w18, w19, w27);
   TEST_3R("pckod.d", 152, 224, w19, w30, w10);
   TEST_3R("pckod.d", 160, 184, w20, w24, w18);
   TEST_3R("pckod.d", 168,  16, w21, w28, w27);
   TEST_3R("pckod.d", 176,  40, w22, w24, w13);
   TEST_3R("pckod.d", 184, 160, w23, w22, w4);
   TEST_3R("pckod.d", 192, 160, w24, w26, w28);
   TEST_3R("pckod.d", 200, 176, w25, w23, w16);
   TEST_3R("pckod.d", 208,  88, w26, w31, w21);
   TEST_3R("pckod.d", 216, 216, w27, w11, w15);
   TEST_3R("pckod.d", 224,  80, w28, w7,  w12);
   TEST_3R("pckod.d", 232,  80, w29, w0,  w9);
   TEST_3R("pckod.d", 240, 216, w30, w0,  w5);
   TEST_3R("pckod.d", 232, 152, w31, w16, w29);
   TEST_3IR("sld.b",   0,  64, w0,  w1,  t2);
   TEST_3IR("sld.b",   8,  16, w1,  w17, t2);
   TEST_3IR("sld.b",  16,  96, w2,  w6,  t1);
   TEST_3IR("sld.b",  24,  80, w3,  w21, t3);
   TEST_3IR("sld.b",  32,  96, w4,  w17, zero);
   TEST_3IR("sld.b",  40, 128, w5,  w15, zero);
   TEST_3IR("sld.b",  48,  64, w6,  w31, zero);
   TEST_3IR("sld.b",  56, 224, w7,  w10, t1);
   TEST_3IR("sld.b",  64,  64, w8,  w3,  t2);
   TEST_3IR("sld.b",  72, 224, w9,  w1,  zero);
   TEST_3IR("sld.b",  80, 208, w10, w26, t2);
   TEST_3IR("sld.b",  88,  96, w11, w23, t3);
   TEST_3IR("sld.b",  96, 240, w12, w30, t1);
   TEST_3IR("sld.b", 104, 128, w13, w19, t1);
   TEST_3IR("sld.b", 112, 208, w14, w14, t1);
   TEST_3IR("sld.b", 120, 128, w15, w24, t1);
   TEST_3IR("sld.b", 128,  96, w16, w5,  t1);
   TEST_3IR("sld.b", 136, 224, w17, w11, t1);
   TEST_3IR("sld.b", 144, 208, w18, w9,  t1);
   TEST_3IR("sld.b", 152,  64, w19, w27, t2);
   TEST_3IR("sld.b", 160, 240, w20, w25, zero);
   TEST_3IR("sld.b", 168, 240, w21, w30, zero);
   TEST_3IR("sld.b", 176, 208, w22, w26, t3);
   TEST_3IR("sld.b", 184,  16, w23, w7,  t2);
   TEST_3IR("sld.b", 192, 208, w24, w19, zero);
   TEST_3IR("sld.b", 200,  64, w25, w12, zero);
   TEST_3IR("sld.b", 208, 128, w26, w17, t2);
   TEST_3IR("sld.b", 216,  80, w27, w2,  t1);
   TEST_3IR("sld.b", 224,  96, w28, w17, t3);
   TEST_3IR("sld.b", 232, 224, w29, w29, t1);
   TEST_3IR("sld.b", 240, 240, w30, w26, t1);
   TEST_3IR("sld.b",  32, 240, w31, w19, t1);
   TEST_3IR("sld.h",   0, 128, w0,  w9,  t2);
   TEST_3IR("sld.h",   8,  96, w1,  w13, t3);
   TEST_3IR("sld.h",  16, 224, w2,  w7,  t3);
   TEST_3IR("sld.h",  24,  80, w3,  w27, t1);
   TEST_3IR("sld.h",  32,  96, w4,  w28, t2);
   TEST_3IR("sld.h",  40, 128, w5,  w7,  t2);
   TEST_3IR("sld.h",  48,  96, w6,  w9,  t3);
   TEST_3IR("sld.h",  56, 208, w7,  w12, t1);
   TEST_3IR("sld.h",  64,  64, w8,  w17, zero);
   TEST_3IR("sld.h",  72,  96, w9,  w18, t3);
   TEST_3IR("sld.h",  80, 240, w10, w28, t1);
   TEST_3IR("sld.h",  88,  80, w11, w9,  zero);
   TEST_3IR("sld.h",  96,  16, w12, w16, zero);
   TEST_3IR("sld.h", 104,  64, w13, w12, t1);
   TEST_3IR("sld.h", 112,  16, w14, w14, t3);
   TEST_3IR("sld.h", 120, 240, w15, w19, t2);
   TEST_3IR("sld.h", 128, 128, w16, w26, zero);
   TEST_3IR("sld.h", 136, 240, w17, w3,  t3);
   TEST_3IR("sld.h", 144, 208, w18, w15, zero);
   TEST_3IR("sld.h", 152, 224, w19, w0,  t1);
   TEST_3IR("sld.h", 160,  64, w20, w19, zero);
   TEST_3IR("sld.h", 168,  16, w21, w15, t2);
   TEST_3IR("sld.h", 176,  80, w22, w24, t2);
   TEST_3IR("sld.h", 184,  80, w23, w8,  t2);
   TEST_3IR("sld.h", 192, 208, w24, w20, t3);
   TEST_3IR("sld.h", 200,  96, w25, w29, t1);
   TEST_3IR("sld.h", 208,  16, w26, w12, t1);
   TEST_3IR("sld.h", 216, 128, w27, w24, t1);
   TEST_3IR("sld.h", 224, 128, w28, w0,  zero);
   TEST_3IR("sld.h", 232, 208, w29, w29, t1);
   TEST_3IR("sld.h", 240,  96, w30, w25, t1);
   TEST_3IR("sld.h",  72, 128, w31, w12, t2);
   TEST_3IR("sld.w",   0,  80, w0,  w12, t3);
   TEST_3IR("sld.w",   8,  64, w1,  w14, t3);
   TEST_3IR("sld.w",  16, 208, w2,  w16, t2);
   TEST_3IR("sld.w",  24,  64, w3,  w27, t2);
   TEST_3IR("sld.w",  32,  80, w4,  w1,  t2);
   TEST_3IR("sld.w",  40,  80, w5,  w10, t2);
   TEST_3IR("sld.w",  48, 240, w6,  w2,  t3);
   TEST_3IR("sld.w",  56,  80, w7,  w27, zero);
   TEST_3IR("sld.w",  64, 224, w8,  w7,  t2);
   TEST_3IR("sld.w",  72,  80, w9,  w2,  t2);
   TEST_3IR("sld.w",  80,  16, w10, w21, t1);
   TEST_3IR("sld.w",  88,  16, w11, w17, t2);
   TEST_3IR("sld.w",  96, 224, w12, w1,  t2);
   TEST_3IR("sld.w", 104,  80, w13, w14, t1);
   TEST_3IR("sld.w", 112, 240, w14, w14, zero);
   TEST_3IR("sld.w", 120, 208, w15, w19, t1);
   TEST_3IR("sld.w", 128, 240, w16, w9,  t3);
   TEST_3IR("sld.w", 136,  96, w17, w28, t2);
   TEST_3IR("sld.w", 144,  80, w18, w25, zero);
   TEST_3IR("sld.w", 152, 208, w19, w7,  t2);
   TEST_3IR("sld.w", 160,  80, w20, w2,  zero);
   TEST_3IR("sld.w", 168,  96, w21, w15, zero);
   TEST_3IR("sld.w", 176,  96, w22, w21, zero);
   TEST_3IR("sld.w", 184, 208, w23, w27, t2);
   TEST_3IR("sld.w", 192,  16, w24, w20, t2);
   TEST_3IR("sld.w", 200,  96, w25, w7,  t3);
   TEST_3IR("sld.w", 208, 240, w26, w13, zero);
   TEST_3IR("sld.w", 216,  16, w27, w13, t1);
   TEST_3IR("sld.w", 224,  80, w28, w6,  t2);
   TEST_3IR("sld.w", 232, 208, w29, w29, t1);
   TEST_3IR("sld.w", 240, 240, w30, w16, t3);
   TEST_3IR("sld.w", 136, 224, w31, w21, t2);
   TEST_3IR("sld.d",   0, 224, w0,  w21, t3);
   TEST_3IR("sld.d",   8,  80, w1,  w2,  t3);
   TEST_3IR("sld.d",  16, 224, w2,  w28, t2);
   TEST_3IR("sld.d",  24,  80, w3,  w13, t1);
   TEST_3IR("sld.d",  32,  64, w4,  w26, t1);
   TEST_3IR("sld.d",  40,  80, w5,  w7,  t2);
   TEST_3IR("sld.d",  48,  16, w6,  w15, zero);
   TEST_3IR("sld.d",  56,  64, w7,  w26, t2);
   TEST_3IR("sld.d",  64, 224, w8,  w9,  t1);
   TEST_3IR("sld.d",  72, 240, w9,  w19, zero);
   TEST_3IR("sld.d",  80, 224, w10, w9,  t3);
   TEST_3IR("sld.d",  88, 240, w11, w6,  zero);
   TEST_3IR("sld.d",  96, 224, w12, w3,  t2);
   TEST_3IR("sld.d", 104,  96, w13, w16, t1);
   TEST_3IR("sld.d", 112,  80, w14, w14, zero);
   TEST_3IR("sld.d", 120,  80, w15, w0,  t1);
   TEST_3IR("sld.d", 128,  64, w16, w19, t3);
   TEST_3IR("sld.d", 136,  96, w17, w11, zero);
   TEST_3IR("sld.d", 144, 208, w18, w17, t1);
   TEST_3IR("sld.d", 152,  16, w19, w7,  t3);
   TEST_3IR("sld.d", 160,  64, w20, w27, t2);
   TEST_3IR("sld.d", 168, 128, w21, w2,  zero);
   TEST_3IR("sld.d", 176, 128, w22, w9,  zero);
   TEST_3IR("sld.d", 184,  80, w23, w12, t2);
   TEST_3IR("sld.d", 192,  80, w24, w28, t1);
   TEST_3IR("sld.d", 200,  80, w25, w6,  t2);
   TEST_3IR("sld.d", 208, 208, w26, w27, zero);
   TEST_3IR("sld.d", 216,  16, w27, w30, t2);
   TEST_3IR("sld.d", 224,  80, w28, w18, t1);
   TEST_3IR("sld.d", 232, 240, w29, w29, t1);
   TEST_3IR("sld.d", 240,  80, w30, w26, t1);
   TEST_3IR("sld.d",   0, 208, w31, w19, zero);
   TEST_3R("vshf.b",   0, 184, w0,  w6,  w21);
   TEST_3R("vshf.b",   8, 120, w1,  w12, w1);
   TEST_3R("vshf.b",  16,  40, w2,  w7,  w14);
   TEST_3R("vshf.b",  24, 208, w3,  w14, w16);
   TEST_3R("vshf.b",  32,  32, w4,  w6,  w5);
   TEST_3R("vshf.b",  40,  96, w5,  w5,  w0);
   TEST_3R("vshf.b",  48, 176, w6,  w21, w22);
   TEST_3R("vshf.b",  56,  48, w7,  w28, w16);
   TEST_3R("vshf.b",  64,  80, w8,  w15, w3);
   TEST_3R("vshf.b",  72, 152, w9,  w12, w24);
   TEST_3R("vshf.b",  80,  72, w10, w17, w25);
   TEST_3R("vshf.b",  88, 128, w11, w23, w14);
   TEST_3R("vshf.b",  96, 200, w12, w4,  w29);
   TEST_3R("vshf.b", 104,  88, w13, w18, w6);
   TEST_3R("vshf.b", 112,  80, w14, w2,  w10);
   TEST_3R("vshf.b", 120,  16, w15, w7,  w12);
   TEST_3R("vshf.b", 128, 120, w16, w12, w1);
   TEST_3R("vshf.b", 136, 168, w17, w4,  w30);
   TEST_3R("vshf.b", 144, 152, w18, w20, w13);
   TEST_3R("vshf.b", 152, 128, w19, w25, w4);
   TEST_3R("vshf.b", 160,  72, w20, w10, w29);
   TEST_3R("vshf.b", 168, 208, w21, w2,  w11);
   TEST_3R("vshf.b", 176,   0, w22, w22, w22);
   TEST_3R("vshf.b", 184,  88, w23, w8,  w2);
   TEST_3R("vshf.b", 192, 136, w24, w14, w29);
   TEST_3R("vshf.b", 200,  64, w25, w24, w31);
   TEST_3R("vshf.b", 208, 216, w26, w5,  w2);
   TEST_3R("vshf.b", 216, 192, w27, w6,  w26);
   TEST_3R("vshf.b", 224,  80, w28, w4,  w3);
   TEST_3R("vshf.b", 232,  56, w29, w17, w16);
   TEST_3R("vshf.b", 240,  64, w30, w10, w20);
   TEST_3R("vshf.b", 144,  48, w31, w21, w21);
   TEST_3R("vshf.h",   0, 224, w0,  w23, w29);
   TEST_3R("vshf.h",   8,  64, w1,  w29, w1);
   TEST_3R("vshf.h",  16, 176, w2,  w24, w21);
   TEST_3R("vshf.h",  24,   8, w3,  w21, w15);
   TEST_3R("vshf.h",  32,  80, w4,  w21, w16);
   TEST_3R("vshf.h",  40,  40, w5,  w5,  w23);
   TEST_3R("vshf.h",  48, 232, w6,  w24, w17);
   TEST_3R("vshf.h",  56, 192, w7,  w29, w21);
   TEST_3R("vshf.h",  64, 128, w8,  w14, w5);
   TEST_3R("vshf.h",  72, 200, w9,  w25, w7);
   TEST_3R("vshf.h",  80, 224, w10, w11, w8);
   TEST_3R("vshf.h",  88, 128, w11, w9,  w30);
   TEST_3R("vshf.h",  96, 112, w12, w15, w22);
   TEST_3R("vshf.h", 104,   0, w13, w3,  w12);
   TEST_3R("vshf.h", 112, 192, w14, w16, w1);
   TEST_3R("vshf.h", 120, 112, w15, w2,  w24);
   TEST_3R("vshf.h", 128, 224, w16, w27, w9);
   TEST_3R("vshf.h", 136, 176, w17, w24, w30);
   TEST_3R("vshf.h", 144,  72, w18, w6,  w3);
   TEST_3R("vshf.h", 152, 144, w19, w31, w29);
   TEST_3R("vshf.h", 160, 120, w20, w13, w8);
   TEST_3R("vshf.h", 168,  88, w21, w18, w17);
   TEST_3R("vshf.h", 176, 160, w22, w22, w22);
   TEST_3R("vshf.h", 184,  40, w23, w0,  w16);
   TEST_3R("vshf.h", 192,  48, w24, w4,  w28);
   TEST_3R("vshf.h", 200, 112, w25, w20, w29);
   TEST_3R("vshf.h", 208, 232, w26, w23, w21);
   TEST_3R("vshf.h", 216, 216, w27, w18, w30);
   TEST_3R("vshf.h", 224,  32, w28, w10, w29);
   TEST_3R("vshf.h", 232, 224, w29, w16, w0);
   TEST_3R("vshf.h", 240, 128, w30, w16, w29);
   TEST_3R("vshf.h", 120, 128, w31, w29, w29);
   TEST_3R("vshf.w",   0,  80, w0,  w16, w23);
   TEST_3R("vshf.w",   8, 232, w1,  w4,  w1);
   TEST_3R("vshf.w",  16, 184, w2,  w23, w16);
   TEST_3R("vshf.w",  24,  96, w3,  w19, w1);
   TEST_3R("vshf.w",  32, 176, w4,  w16, w9);
   TEST_3R("vshf.w",  40,   8, w5,  w5,  w4);
   TEST_3R("vshf.w",  48, 112, w6,  w4,  w1);
   TEST_3R("vshf.w",  56,  64, w7,  w1,  w22);
   TEST_3R("vshf.w",  64, 224, w8,  w1,  w23);
   TEST_3R("vshf.w",  72,  80, w9,  w31, w10);
   TEST_3R("vshf.w",  80,  80, w10, w5,  w24);
   TEST_3R("vshf.w",  88,   0, w11, w28, w31);
   TEST_3R("vshf.w",  96,  80, w12, w20, w23);
   TEST_3R("vshf.w", 104, 208, w13, w16, w10);
   TEST_3R("vshf.w", 112,  96, w14, w1,  w27);
   TEST_3R("vshf.w", 120,  80, w15, w8,  w0);
   TEST_3R("vshf.w", 128, 160, w16, w2,  w4);
   TEST_3R("vshf.w", 136, 200, w17, w5,  w12);
   TEST_3R("vshf.w", 144, 184, w18, w7,  w3);
   TEST_3R("vshf.w", 152, 136, w19, w6,  w13);
   TEST_3R("vshf.w", 160,  96, w20, w11, w5);
   TEST_3R("vshf.w", 168, 208, w21, w7,  w5);
   TEST_3R("vshf.w", 176,  72, w22, w22, w22);
   TEST_3R("vshf.w", 184,  56, w23, w28, w12);
   TEST_3R("vshf.w", 192, 136, w24, w6,  w20);
   TEST_3R("vshf.w", 200,  32, w25, w1,  w4);
   TEST_3R("vshf.w", 208,  56, w26, w2,  w25);
   TEST_3R("vshf.w", 216, 184, w27, w6,  w15);
   TEST_3R("vshf.w", 224,  16, w28, w12, w27);
   TEST_3R("vshf.w", 232,  80, w29, w19, w31);
   TEST_3R("vshf.w", 240, 224, w30, w25, w12);
   TEST_3R("vshf.w", 192, 128, w31, w4,  w4);
   TEST_3R("vshf.d",   0, 168, w0,  w11, w23);
   TEST_3R("vshf.d",   8, 128, w1,  w7,  w1);
   TEST_3R("vshf.d",  16, 168, w2,  w23, w20);
   TEST_3R("vshf.d",  24, 168, w3,  w11, w1);
   TEST_3R("vshf.d",  32, 136, w4,  w15, w23);
   TEST_3R("vshf.d",  40,  40, w5,  w5,  w8);
   TEST_3R("vshf.d",  48, 104, w6,  w3,  w23);
   TEST_3R("vshf.d",  56, 128, w7,  w15, w19);
   TEST_3R("vshf.d",  64, 216, w8,  w2,  w18);
   TEST_3R("vshf.d",  72,  72, w9,  w27, w30);
   TEST_3R("vshf.d",  80,  32, w10, w31, w16);
   TEST_3R("vshf.d",  88, 192, w11, w7,  w26);
   TEST_3R("vshf.d",  96,   0, w12, w26, w17);
   TEST_3R("vshf.d", 104,  88, w13, w20, w28);
   TEST_3R("vshf.d", 112,  72, w14, w15, w12);
   TEST_3R("vshf.d", 120, 120, w15, w12, w20);
   TEST_3R("vshf.d", 128, 104, w16, w15, w12);
   TEST_3R("vshf.d", 136,  96, w17, w31, w0);
   TEST_3R("vshf.d", 144, 104, w18, w17, w24);
   TEST_3R("vshf.d", 152, 120, w19, w15, w4);
   TEST_3R("vshf.d", 160,   0, w20, w0,  w7);
   TEST_3R("vshf.d", 168, 160, w21, w15, w26);
   TEST_3R("vshf.d", 176,  80, w22, w22, w22);
   TEST_3R("vshf.d", 184, 152, w23, w0,  w22);
   TEST_3R("vshf.d", 192, 136, w24, w8,  w5);
   TEST_3R("vshf.d", 200, 200, w25, w8,  w17);
   TEST_3R("vshf.d", 208,   8, w26, w23, w0);
   TEST_3R("vshf.d", 216, 168, w27, w19, w31);
   TEST_3R("vshf.d", 224,   8, w28, w19, w1);
   TEST_3R("vshf.d", 232,  40, w29, w11, w30);
   TEST_3R("vshf.d", 240,  24, w30, w16, w26);
   TEST_3R("vshf.d",  32,  96, w31, w4,  w4);
   TEST_ELM("sldi.b",   0, w0,  w17, 3);
   TEST_ELM("sldi.b",   8, w1,  w13, 4);
   TEST_ELM("sldi.b",  16, w2,  w13, 5);
   TEST_ELM("sldi.b",  24, w3,  w23, 6);
   TEST_ELM("sldi.b",  32, w4,  w31, 7);
   TEST_ELM("sldi.b",  40, w5,  w23, 8);
   TEST_ELM("sldi.b",  48, w6,  w9,  9);
   TEST_ELM("sldi.b",  56, w7,  w31, 10);
   TEST_ELM("sldi.b",  64, w8,  w21, 11);
   TEST_ELM("sldi.b",  72, w9,  w29, 12);
   TEST_ELM("sldi.b",  80, w10, w5,  13);
   TEST_ELM("sldi.b",  88, w11, w21, 14);
   TEST_ELM("sldi.b",  96, w12, w26, 15);
   TEST_ELM("sldi.b", 104, w13, w29, 0);
   TEST_ELM("sldi.b", 112, w14, w24, 1);
   TEST_ELM("sldi.b", 120, w15, w18, 2);
   TEST_ELM("sldi.b", 128, w16, w2,  3);
   TEST_ELM("sldi.b", 136, w17, w14, 4);
   TEST_ELM("sldi.b", 144, w18, w18, 5);
   TEST_ELM("sldi.b", 152, w19, w12, 6);
   TEST_ELM("sldi.b", 160, w20, w8,  7);
   TEST_ELM("sldi.b", 168, w21, w11, 8);
   TEST_ELM("sldi.b", 176, w22, w10, 9);
   TEST_ELM("sldi.b", 184, w23, w9,  10);
   TEST_ELM("sldi.b", 192, w24, w31, 11);
   TEST_ELM("sldi.b", 200, w25, w13, 12);
   TEST_ELM("sldi.b", 208, w26, w31, 13);
   TEST_ELM("sldi.b", 216, w27, w14, 14);
   TEST_ELM("sldi.b", 224, w28, w28, 15);
   TEST_ELM("sldi.b", 232, w29, w8,  0);
   TEST_ELM("sldi.b", 240, w30, w15, 1);
   TEST_ELM("sldi.b", 128, w31, w29, 2);
   TEST_ELM("sldi.h",   0, w0,  w25, 3);
   TEST_ELM("sldi.h",   8, w1,  w28, 4);
   TEST_ELM("sldi.h",  16, w2,  w27, 5);
   TEST_ELM("sldi.h",  24, w3,  w6,  6);
   TEST_ELM("sldi.h",  32, w4,  w5,  7);
   TEST_ELM("sldi.h",  40, w5,  w4,  0);
   TEST_ELM("sldi.h",  48, w6,  w26, 1);
   TEST_ELM("sldi.h",  56, w7,  w14, 2);
   TEST_ELM("sldi.h",  64, w8,  w19, 3);
   TEST_ELM("sldi.h",  72, w9,  w18, 4);
   TEST_ELM("sldi.h",  80, w10, w21, 5);
   TEST_ELM("sldi.h",  88, w11, w25, 6);
   TEST_ELM("sldi.h",  96, w12, w13, 7);
   TEST_ELM("sldi.h", 104, w13, w29, 0);
   TEST_ELM("sldi.h", 112, w14, w9,  1);
   TEST_ELM("sldi.h", 120, w15, w10, 2);
   TEST_ELM("sldi.h", 128, w16, w12, 3);
   TEST_ELM("sldi.h", 136, w17, w0,  4);
   TEST_ELM("sldi.h", 144, w18, w18, 5);
   TEST_ELM("sldi.h", 152, w19, w6,  6);
   TEST_ELM("sldi.h", 160, w20, w29, 7);
   TEST_ELM("sldi.h", 168, w21, w11, 0);
   TEST_ELM("sldi.h", 176, w22, w1,  1);
   TEST_ELM("sldi.h", 184, w23, w24, 2);
   TEST_ELM("sldi.h", 192, w24, w8,  3);
   TEST_ELM("sldi.h", 200, w25, w27, 4);
   TEST_ELM("sldi.h", 208, w26, w28, 5);
   TEST_ELM("sldi.h", 216, w27, w12, 6);
   TEST_ELM("sldi.h", 224, w28, w28, 7);
   TEST_ELM("sldi.h", 232, w29, w26, 0);
   TEST_ELM("sldi.h", 240, w30, w19, 1);
   TEST_ELM("sldi.h",  16, w31, w8,  2);
   TEST_ELM("sldi.w",   0, w0,  w20, 3);
   TEST_ELM("sldi.w",   8, w1,  w6,  0);
   TEST_ELM("sldi.w",  16, w2,  w28, 1);
   TEST_ELM("sldi.w",  24, w3,  w10, 2);
   TEST_ELM("sldi.w",  32, w4,  w24, 3);
   TEST_ELM("sldi.w",  40, w5,  w26, 0);
   TEST_ELM("sldi.w",  48, w6,  w1,  1);
   TEST_ELM("sldi.w",  56, w7,  w26, 2);
   TEST_ELM("sldi.w",  64, w8,  w20, 3);
   TEST_ELM("sldi.w",  72, w9,  w18, 0);
   TEST_ELM("sldi.w",  80, w10, w22, 1);
   TEST_ELM("sldi.w",  88, w11, w1,  2);
   TEST_ELM("sldi.w",  96, w12, w14, 3);
   TEST_ELM("sldi.w", 104, w13, w8,  0);
   TEST_ELM("sldi.w", 112, w14, w11, 1);
   TEST_ELM("sldi.w", 120, w15, w17, 2);
   TEST_ELM("sldi.w", 128, w16, w24, 3);
   TEST_ELM("sldi.w", 136, w17, w30, 0);
   TEST_ELM("sldi.w", 144, w18, w18, 1);
   TEST_ELM("sldi.w", 152, w19, w22, 2);
   TEST_ELM("sldi.w", 160, w20, w2,  3);
   TEST_ELM("sldi.w", 168, w21, w9,  0);
   TEST_ELM("sldi.w", 176, w22, w3,  1);
   TEST_ELM("sldi.w", 184, w23, w6,  2);
   TEST_ELM("sldi.w", 192, w24, w26, 3);
   TEST_ELM("sldi.w", 200, w25, w12, 0);
   TEST_ELM("sldi.w", 208, w26, w29, 1);
   TEST_ELM("sldi.w", 216, w27, w2,  2);
   TEST_ELM("sldi.w", 224, w28, w28, 3);
   TEST_ELM("sldi.w", 232, w29, w21, 0);
   TEST_ELM("sldi.w", 240, w30, w5,  1);
   TEST_ELM("sldi.w", 192, w31, w18, 2);
   TEST_ELM("sldi.d",   0, w0,  w4,  1);
   TEST_ELM("sldi.d",   8, w1,  w3,  0);
   TEST_ELM("sldi.d",  16, w2,  w9,  1);
   TEST_ELM("sldi.d",  24, w3,  w7,  0);
   TEST_ELM("sldi.d",  32, w4,  w2,  1);
   TEST_ELM("sldi.d",  40, w5,  w14, 0);
   TEST_ELM("sldi.d",  48, w6,  w26, 1);
   TEST_ELM("sldi.d",  56, w7,  w0,  0);
   TEST_ELM("sldi.d",  64, w8,  w18, 1);
   TEST_ELM("sldi.d",  72, w9,  w12, 0);
   TEST_ELM("sldi.d",  80, w10, w15, 1);
   TEST_ELM("sldi.d",  88, w11, w23, 0);
   TEST_ELM("sldi.d",  96, w12, w9,  1);
   TEST_ELM("sldi.d", 104, w13, w17, 0);
   TEST_ELM("sldi.d", 112, w14, w17, 1);
   TEST_ELM("sldi.d", 120, w15, w30, 0);
   TEST_ELM("sldi.d", 128, w16, w13, 1);
   TEST_ELM("sldi.d", 136, w17, w24, 0);
   TEST_ELM("sldi.d", 144, w18, w18, 1);
   TEST_ELM("sldi.d", 152, w19, w18, 0);
   TEST_ELM("sldi.d", 160, w20, w4,  1);
   TEST_ELM("sldi.d", 168, w21, w2,  0);
   TEST_ELM("sldi.d", 176, w22, w30, 1);
   TEST_ELM("sldi.d", 184, w23, w27, 0);
   TEST_ELM("sldi.d", 192, w24, w0,  1);
   TEST_ELM("sldi.d", 200, w25, w8,  0);
   TEST_ELM("sldi.d", 208, w26, w27, 1);
   TEST_ELM("sldi.d", 216, w27, w28, 0);
   TEST_ELM("sldi.d", 224, w28, w28, 1);
   TEST_ELM("sldi.d", 232, w29, w30, 0);
   TEST_ELM("sldi.d", 240, w30, w15, 1);
   TEST_ELM("sldi.d", 152, w31, w14, 0);
   TEST_I8("shf.b",   0, w0,  w11, 108);
   TEST_I8("shf.b",   8, w1,  w13, 43);
   TEST_I8("shf.b",  16, w2,  w26, 186);
   TEST_I8("shf.b",  24, w3,  w2,  10);
   TEST_I8("shf.b",  32, w4,  w30, 134);
   TEST_I8("shf.b",  40, w5,  w2,  210);
   TEST_I8("shf.b",  48, w6,  w20, 185);
   TEST_I8("shf.b",  56, w7,  w1,  87);
   TEST_I8("shf.b",  64, w8,  w24, 5);
   TEST_I8("shf.b",  72, w9,  w6,  176);
   TEST_I8("shf.b",  80, w10, w13, 9);
   TEST_I8("shf.b",  88, w11, w24, 68);
   TEST_I8("shf.b",  96, w12, w22, 102);
   TEST_I8("shf.b", 104, w13, w28, 163);
   TEST_I8("shf.b", 112, w14, w2,  136);
   TEST_I8("shf.b", 120, w15, w21, 249);
   TEST_I8("shf.b", 128, w16, w28, 121);
   TEST_I8("shf.b", 136, w17, w22, 39);
   TEST_I8("shf.b", 144, w18, w13, 44);
   TEST_I8("shf.b", 152, w19, w4,  62);
   TEST_I8("shf.b", 160, w20, w17, 71);
   TEST_I8("shf.b", 168, w21, w9,  139);
   TEST_I8("shf.b", 176, w22, w31, 242);
   TEST_I8("shf.b", 184, w23, w23, 222);
   TEST_I8("shf.b", 192, w24, w22, 64);
   TEST_I8("shf.b", 200, w25, w29, 182);
   TEST_I8("shf.b", 208, w26, w22, 31);
   TEST_I8("shf.b", 216, w27, w15, 106);
   TEST_I8("shf.b", 224, w28, w22, 78);
   TEST_I8("shf.b", 232, w29, w29, 66);
   TEST_I8("shf.b", 240, w30, w25, 30);
   TEST_I8("shf.b", 152, w31, w23, 55);
   TEST_I8("shf.h",   0, w0,  w12, 10);
   TEST_I8("shf.h",   8, w1,  w11, 252);
   TEST_I8("shf.h",  16, w2,  w6,  83);
   TEST_I8("shf.h",  24, w3,  w5,  208);
   TEST_I8("shf.h",  32, w4,  w11, 71);
   TEST_I8("shf.h",  40, w5,  w14, 54);
   TEST_I8("shf.h",  48, w6,  w7,  77);
   TEST_I8("shf.h",  56, w7,  w13, 143);
   TEST_I8("shf.h",  64, w8,  w7,  201);
   TEST_I8("shf.h",  72, w9,  w14, 204);
   TEST_I8("shf.h",  80, w10, w5,  56);
   TEST_I8("shf.h",  88, w11, w13, 35);
   TEST_I8("shf.h",  96, w12, w24, 42);
   TEST_I8("shf.h", 104, w13, w1,  239);
   TEST_I8("shf.h", 112, w14, w10, 250);
   TEST_I8("shf.h", 120, w15, w10, 175);
   TEST_I8("shf.h", 128, w16, w9,  16);
   TEST_I8("shf.h", 136, w17, w18, 10);
   TEST_I8("shf.h", 144, w18, w2,  211);
   TEST_I8("shf.h", 152, w19, w16, 160);
   TEST_I8("shf.h", 160, w20, w21, 216);
   TEST_I8("shf.h", 168, w21, w3,  252);
   TEST_I8("shf.h", 176, w22, w27, 38);
   TEST_I8("shf.h", 184, w23, w23, 69);
   TEST_I8("shf.h", 192, w24, w21, 173);
   TEST_I8("shf.h", 200, w25, w15, 92);
   TEST_I8("shf.h", 208, w26, w24, 65);
   TEST_I8("shf.h", 216, w27, w9,  116);
   TEST_I8("shf.h", 224, w28, w7,  54);
   TEST_I8("shf.h", 232, w29, w29, 12);
   TEST_I8("shf.h", 240, w30, w9,  239);
   TEST_I8("shf.h", 208, w31, w9,  16);
   TEST_I8("shf.w",   0, w0,  w30, 30);
   TEST_I8("shf.w",   8, w1,  w25, 68);
   TEST_I8("shf.w",  16, w2,  w21, 89);
   TEST_I8("shf.w",  24, w3,  w28, 104);
   TEST_I8("shf.w",  32, w4,  w12, 161);
   TEST_I8("shf.w",  40, w5,  w6,  234);
   TEST_I8("shf.w",  48, w6,  w18, 209);
   TEST_I8("shf.w",  56, w7,  w8,  221);
   TEST_I8("shf.w",  64, w8,  w17, 6);
   TEST_I8("shf.w",  72, w9,  w12, 2);
   TEST_I8("shf.w",  80, w10, w29, 86);
   TEST_I8("shf.w",  88, w11, w27, 125);
   TEST_I8("shf.w",  96, w12, w31, 233);
   TEST_I8("shf.w", 104, w13, w24, 2);
   TEST_I8("shf.w", 112, w14, w0,  119);
   TEST_I8("shf.w", 120, w15, w1,  222);
   TEST_I8("shf.w", 128, w16, w14, 112);
   TEST_I8("shf.w", 136, w17, w24, 216);
   TEST_I8("shf.w", 144, w18, w25, 191);
   TEST_I8("shf.w", 152, w19, w6,  193);
   TEST_I8("shf.w", 160, w20, w3,  98);
   TEST_I8("shf.w", 168, w21, w25, 252);
   TEST_I8("shf.w", 176, w22, w23, 235);
   TEST_I8("shf.w", 184, w23, w23, 115);
   TEST_I8("shf.w", 192, w24, w23, 20);
   TEST_I8("shf.w", 200, w25, w15, 85);
   TEST_I8("shf.w", 208, w26, w13, 129);
   TEST_I8("shf.w", 216, w27, w29, 125);
   TEST_I8("shf.w", 224, w28, w21, 87);
   TEST_I8("shf.w", 232, w29, w29, 62);
   TEST_I8("shf.w", 240, w30, w25, 131);
   TEST_I8("shf.w", 184, w31, w27, 68);
   TEST_3IR("splat.b",   0, 208, w0,  w14, t3);
   TEST_3IR("splat.b",   8, 224, w1,  w0,  t2);
   TEST_3IR("splat.b",  16, 208, w2,  w27, t3);
   TEST_3IR("splat.b",  24,  16, w3,  w22, t1);
   TEST_3IR("splat.b",  32, 240, w4,  w10, zero);
   TEST_3IR("splat.b",  40,  80, w5,  w9,  t3);
   TEST_3IR("splat.b",  48, 208, w6,  w29, t2);
   TEST_3IR("splat.b",  56,  64, w7,  w31, t1);
   TEST_3IR("splat.b",  64, 240, w8,  w13, t1);
   TEST_3IR("splat.b",  72, 224, w9,  w24, zero);
   TEST_3IR("splat.b",  80,  16, w10, w29, zero);
   TEST_3IR("splat.b",  88, 240, w11, w3,  t3);
   TEST_3IR("splat.b",  96, 208, w12, w31, zero);
   TEST_3IR("splat.b", 104,  16, w13, w13, t1);
   TEST_3IR("splat.b", 112,  16, w14, w0,  t2);
   TEST_3IR("splat.b", 120,  64, w15, w24, t3);
   TEST_3IR("splat.b", 128, 224, w16, w3,  t2);
   TEST_3IR("splat.b", 136, 208, w17, w9,  t3);
   TEST_3IR("splat.b", 144, 128, w18, w30, t3);
   TEST_3IR("splat.b", 152,  64, w19, w28, zero);
   TEST_3IR("splat.b", 160,  64, w20, w17, t3);
   TEST_3IR("splat.b", 168, 224, w21, w22, t1);
   TEST_3IR("splat.b", 176, 208, w22, w25, zero);
   TEST_3IR("splat.b", 184, 224, w23, w2,  t2);
   TEST_3IR("splat.b", 192, 224, w24, w24, t2);
   TEST_3IR("splat.b", 200, 240, w25, w22, t2);
   TEST_3IR("splat.b", 208,  96, w26, w12, t1);
   TEST_3IR("splat.b", 216,  80, w27, w11, t2);
   TEST_3IR("splat.b", 224, 224, w28, w10, t3);
   TEST_3IR("splat.b", 232, 240, w29, w26, zero);
   TEST_3IR("splat.b", 240, 208, w30, w9,  t2);
   TEST_3IR("splat.b", 224, 208, w31, w24, t2);
   TEST_3IR("splat.h",   0, 128, w0,  w23, t2);
   TEST_3IR("splat.h",   8, 224, w1,  w5,  zero);
   TEST_3IR("splat.h",  16,  16, w2,  w19, t3);
   TEST_3IR("splat.h",  24, 128, w3,  w10, t1);
   TEST_3IR("splat.h",  32,  16, w4,  w7,  zero);
   TEST_3IR("splat.h",  40,  80, w5,  w26, t2);
   TEST_3IR("splat.h",  48, 208, w6,  w1,  zero);
   TEST_3IR("splat.h",  56, 224, w7,  w9,  zero);
   TEST_3IR("splat.h",  64, 208, w8,  w11, t1);
   TEST_3IR("splat.h",  72,  80, w9,  w4,  t3);
   TEST_3IR("splat.h",  80,  80, w10, w22, t1);
   TEST_3IR("splat.h",  88, 208, w11, w27, t3);
   TEST_3IR("splat.h",  96, 128, w12, w0,  t2);
   TEST_3IR("splat.h", 104,  64, w13, w13, t1);
   TEST_3IR("splat.h", 112, 208, w14, w24, t2);
   TEST_3IR("splat.h", 120,  80, w15, w13, zero);
   TEST_3IR("splat.h", 128,  16, w16, w5,  t2);
   TEST_3IR("splat.h", 136, 208, w17, w8,  t3);
   TEST_3IR("splat.h", 144,  64, w18, w5,  zero);
   TEST_3IR("splat.h", 152,  80, w19, w11, zero);
   TEST_3IR("splat.h", 160,  80, w20, w17, t3);
   TEST_3IR("splat.h", 168, 128, w21, w8,  zero);
   TEST_3IR("splat.h", 176, 128, w22, w3,  t2);
   TEST_3IR("splat.h", 184, 208, w23, w18, t2);
   TEST_3IR("splat.h", 192,  16, w24, w24, t2);
   TEST_3IR("splat.h", 200,  80, w25, w3,  t2);
   TEST_3IR("splat.h", 208,  80, w26, w8,  zero);
   TEST_3IR("splat.h", 216, 240, w27, w16, t3);
   TEST_3IR("splat.h", 224,  16, w28, w21, zero);
   TEST_3IR("splat.h", 232,  80, w29, w1,  zero);
   TEST_3IR("splat.h", 240, 128, w30, w18, zero);
   TEST_3IR("splat.h", 128, 128, w31, w5,  t2);
   TEST_3IR("splat.w",   0, 128, w0,  w6,  t3);
   TEST_3IR("splat.w",   8,  16, w1,  w26, t2);
   TEST_3IR("splat.w",  16,  96, w2,  w12, t2);
   TEST_3IR("splat.w",  24,  96, w3,  w22, zero);
   TEST_3IR("splat.w",  32, 128, w4,  w27, t3);
   TEST_3IR("splat.w",  40, 224, w5,  w26, t1);
   TEST_3IR("splat.w",  48,  80, w6,  w27, t2);
   TEST_3IR("splat.w",  56,  80, w7,  w13, zero);
   TEST_3IR("splat.w",  64, 128, w8,  w17, t2);
   TEST_3IR("splat.w",  72,  80, w9,  w29, zero);
   TEST_3IR("splat.w",  80, 208, w10, w13, zero);
   TEST_3IR("splat.w",  88,  80, w11, w14, t2);
   TEST_3IR("splat.w",  96,  64, w12, w29, t2);
   TEST_3IR("splat.w", 104,  16, w13, w13, t1);
   TEST_3IR("splat.w", 112,  64, w14, w17, t2);
   TEST_3IR("splat.w", 120, 128, w15, w11, zero);
   TEST_3IR("splat.w", 128, 240, w16, w23, t2);
   TEST_3IR("splat.w", 136,  80, w17, w25, t1);
   TEST_3IR("splat.w", 144, 240, w18, w27, t3);
   TEST_3IR("splat.w", 152,  64, w19, w16, t2);
   TEST_3IR("splat.w", 160, 224, w20, w10, t2);
   TEST_3IR("splat.w", 168,  96, w21, w26, t1);
   TEST_3IR("splat.w", 176,  80, w22, w6,  t2);
   TEST_3IR("splat.w", 184, 128, w23, w24, t3);
   TEST_3IR("splat.w", 192,  96, w24, w24, t1);
   TEST_3IR("splat.w", 200, 224, w25, w5,  t3);
   TEST_3IR("splat.w", 208, 224, w26, w17, t3);
   TEST_3IR("splat.w", 216, 240, w27, w24, t2);
   TEST_3IR("splat.w", 224,  80, w28, w29, zero);
   TEST_3IR("splat.w", 232,  80, w29, w20, zero);
   TEST_3IR("splat.w", 240, 128, w30, w6,  t1);
   TEST_3IR("splat.w", 224, 224, w31, w5,  t3);
   TEST_3IR("splat.d",   0, 128, w0,  w27, zero);
   TEST_3IR("splat.d",   8,  64, w1,  w21, t3);
   TEST_3IR("splat.d",  16, 240, w2,  w30, t2);
   TEST_3IR("splat.d",  24,  16, w3,  w9,  zero);
   TEST_3IR("splat.d",  32,  16, w4,  w1,  t2);
   TEST_3IR("splat.d",  40,  16, w5,  w31, t1);
   TEST_3IR("splat.d",  48,  16, w6,  w8,  t2);
   TEST_3IR("splat.d",  56,  64, w7,  w26, zero);
   TEST_3IR("splat.d",  64,  16, w8,  w23, t1);
   TEST_3IR("splat.d",  72,  96, w9,  w13, t3);
   TEST_3IR("splat.d",  80, 240, w10, w31, zero);
   TEST_3IR("splat.d",  88,  80, w11, w14, t2);
   TEST_3IR("splat.d",  96,  64, w12, w29, zero);
   TEST_3IR("splat.d", 104, 240, w13, w13, t1);
   TEST_3IR("splat.d", 112,  64, w14, w25, t2);
   TEST_3IR("splat.d", 120,  80, w15, w8,  t3);
   TEST_3IR("splat.d", 128, 240, w16, w7,  t1);
   TEST_3IR("splat.d", 136,  64, w17, w7,  t1);
   TEST_3IR("splat.d", 144,  80, w18, w23, t3);
   TEST_3IR("splat.d", 152, 240, w19, w24, t2);
   TEST_3IR("splat.d", 160,  96, w20, w9,  zero);
   TEST_3IR("splat.d", 168,  80, w21, w20, t2);
   TEST_3IR("splat.d", 176,  64, w22, w21, t1);
   TEST_3IR("splat.d", 184,  64, w23, w31, t2);
   TEST_3IR("splat.d", 192,  80, w24, w24, t1);
   TEST_3IR("splat.d", 200,  96, w25, w17, t2);
   TEST_3IR("splat.d", 208,  96, w26, w1,  t3);
   TEST_3IR("splat.d", 216, 128, w27, w8,  zero);
   TEST_3IR("splat.d", 224, 224, w28, w0,  t3);
   TEST_3IR("splat.d", 232, 224, w29, w24, t2);
   TEST_3IR("splat.d", 240,  64, w30, w1,  t2);
   TEST_3IR("splat.d",  24,  96, w31, w22, zero);
   TEST_INSVE("insve.b",   0, w0,  w2,  1);
   TEST_INSVE("insve.b",   8, w1,  w24, 2);
   TEST_INSVE("insve.b",  16, w2,  w22, 3);
   TEST_INSVE("insve.b",  24, w3,  w23, 4);
   TEST_INSVE("insve.b",  32, w4,  w2,  5);
   TEST_INSVE("insve.b",  40, w5,  w21, 6);
   TEST_INSVE("insve.b",  48, w6,  w0,  7);
   TEST_INSVE("insve.b",  56, w7,  w1,  8);
   TEST_INSVE("insve.b",  64, w8,  w24, 9);
   TEST_INSVE("insve.b",  72, w9,  w19, 10);
   TEST_INSVE("insve.b",  80, w10, w10, 11);
   TEST_INSVE("insve.b",  88, w11, w12, 12);
   TEST_INSVE("insve.b",  96, w12, w12, 13);
   TEST_INSVE("insve.b", 104, w13, w16, 14);
   TEST_INSVE("insve.b", 112, w14, w7,  15);
   TEST_INSVE("insve.b", 120, w15, w30, 0);
   TEST_INSVE("insve.b", 128, w16, w5,  1);
   TEST_INSVE("insve.b", 136, w17, w26, 2);
   TEST_INSVE("insve.b", 144, w18, w6,  3);
   TEST_INSVE("insve.b", 152, w19, w29, 4);
   TEST_INSVE("insve.b", 160, w20, w17, 5);
   TEST_INSVE("insve.b", 168, w21, w19, 6);
   TEST_INSVE("insve.b", 176, w22, w20, 7);
   TEST_INSVE("insve.b", 184, w23, w20, 8);
   TEST_INSVE("insve.b", 192, w24, w15, 9);
   TEST_INSVE("insve.b", 200, w25, w24, 10);
   TEST_INSVE("insve.b", 208, w26, w7,  11);
   TEST_INSVE("insve.b", 216, w27, w14, 12);
   TEST_INSVE("insve.b", 224, w28, w30, 13);
   TEST_INSVE("insve.b", 232, w29, w18, 14);
   TEST_INSVE("insve.b", 240, w30, w9,  15);
   TEST_INSVE("insve.b", 216, w31, w5,  0);
   TEST_INSVE("insve.h",   0, w0,  w12, 1);
   TEST_INSVE("insve.h",   8, w1,  w24, 2);
   TEST_INSVE("insve.h",  16, w2,  w11, 3);
   TEST_INSVE("insve.h",  24, w3,  w29, 4);
   TEST_INSVE("insve.h",  32, w4,  w29, 5);
   TEST_INSVE("insve.h",  40, w5,  w29, 6);
   TEST_INSVE("insve.h",  48, w6,  w18, 7);
   TEST_INSVE("insve.h",  56, w7,  w30, 0);
   TEST_INSVE("insve.h",  64, w8,  w10, 1);
   TEST_INSVE("insve.h",  72, w9,  w26, 2);
   TEST_INSVE("insve.h",  80, w10, w10, 3);
   TEST_INSVE("insve.h",  88, w11, w17, 4);
   TEST_INSVE("insve.h",  96, w12, w12, 5);
   TEST_INSVE("insve.h", 104, w13, w9,  6);
   TEST_INSVE("insve.h", 112, w14, w3,  7);
   TEST_INSVE("insve.h", 120, w15, w13, 0);
   TEST_INSVE("insve.h", 128, w16, w11, 1);
   TEST_INSVE("insve.h", 136, w17, w24, 2);
   TEST_INSVE("insve.h", 144, w18, w7,  3);
   TEST_INSVE("insve.h", 152, w19, w0,  4);
   TEST_INSVE("insve.h", 160, w20, w27, 5);
   TEST_INSVE("insve.h", 168, w21, w27, 6);
   TEST_INSVE("insve.h", 176, w22, w15, 7);
   TEST_INSVE("insve.h", 184, w23, w8,  0);
   TEST_INSVE("insve.h", 192, w24, w11, 1);
   TEST_INSVE("insve.h", 200, w25, w9,  2);
   TEST_INSVE("insve.h", 208, w26, w7,  3);
   TEST_INSVE("insve.h", 216, w27, w1,  4);
   TEST_INSVE("insve.h", 224, w28, w21, 5);
   TEST_INSVE("insve.h", 232, w29, w25, 6);
   TEST_INSVE("insve.h", 240, w30, w7,  7);
   TEST_INSVE("insve.h",  88, w31, w27, 0);
   TEST_INSVE("insve.w",   0, w0,  w18, 1);
   TEST_INSVE("insve.w",   8, w1,  w29, 2);
   TEST_INSVE("insve.w",  16, w2,  w17, 3);
   TEST_INSVE("insve.w",  24, w3,  w16, 0);
   TEST_INSVE("insve.w",  32, w4,  w16, 1);
   TEST_INSVE("insve.w",  40, w5,  w24, 2);
   TEST_INSVE("insve.w",  48, w6,  w17, 3);
   TEST_INSVE("insve.w",  56, w7,  w31, 0);
   TEST_INSVE("insve.w",  64, w8,  w3,  1);
   TEST_INSVE("insve.w",  72, w9,  w24, 2);
   TEST_INSVE("insve.w",  80, w10, w10, 3);
   TEST_INSVE("insve.w",  88, w11, w17, 0);
   TEST_INSVE("insve.w",  96, w12, w12, 1);
   TEST_INSVE("insve.w", 104, w13, w4,  2);
   TEST_INSVE("insve.w", 112, w14, w5,  3);
   TEST_INSVE("insve.w", 120, w15, w20, 0);
   TEST_INSVE("insve.w", 128, w16, w18, 1);
   TEST_INSVE("insve.w", 136, w17, w14, 2);
   TEST_INSVE("insve.w", 144, w18, w4,  3);
   TEST_INSVE("insve.w", 152, w19, w20, 0);
   TEST_INSVE("insve.w", 160, w20, w22, 1);
   TEST_INSVE("insve.w", 168, w21, w9,  2);
   TEST_INSVE("insve.w", 176, w22, w14, 3);
   TEST_INSVE("insve.w", 184, w23, w14, 0);
   TEST_INSVE("insve.w", 192, w24, w11, 1);
   TEST_INSVE("insve.w", 200, w25, w15, 2);
   TEST_INSVE("insve.w", 208, w26, w10, 3);
   TEST_INSVE("insve.w", 216, w27, w21, 0);
   TEST_INSVE("insve.w", 224, w28, w0,  1);
   TEST_INSVE("insve.w", 232, w29, w13, 2);
   TEST_INSVE("insve.w", 240, w30, w11, 3);
   TEST_INSVE("insve.w",  80, w31, w7,  0);
   TEST_INSVE("insve.d",   0, w0,  w11, 1);
   TEST_INSVE("insve.d",   8, w1,  w24, 0);
   TEST_INSVE("insve.d",  16, w2,  w22, 1);
   TEST_INSVE("insve.d",  24, w3,  w18, 0);
   TEST_INSVE("insve.d",  32, w4,  w22, 1);
   TEST_INSVE("insve.d",  40, w5,  w19, 0);
   TEST_INSVE("insve.d",  48, w6,  w7,  1);
   TEST_INSVE("insve.d",  56, w7,  w10, 0);
   TEST_INSVE("insve.d",  64, w8,  w22, 1);
   TEST_INSVE("insve.d",  72, w9,  w7,  0);
   TEST_INSVE("insve.d",  80, w10, w10, 1);
   TEST_INSVE("insve.d",  88, w11, w21, 0);
   TEST_INSVE("insve.d",  96, w12, w12, 1);
   TEST_INSVE("insve.d", 104, w13, w27, 0);
   TEST_INSVE("insve.d", 112, w14, w3,  1);
   TEST_INSVE("insve.d", 120, w15, w9,  0);
   TEST_INSVE("insve.d", 128, w16, w23, 1);
   TEST_INSVE("insve.d", 136, w17, w6,  0);
   TEST_INSVE("insve.d", 144, w18, w2,  1);
   TEST_INSVE("insve.d", 152, w19, w31, 0);
   TEST_INSVE("insve.d", 160, w20, w11, 1);
   TEST_INSVE("insve.d", 168, w21, w29, 0);
   TEST_INSVE("insve.d", 176, w22, w10, 1);
   TEST_INSVE("insve.d", 184, w23, w0,  0);
   TEST_INSVE("insve.d", 192, w24, w23, 1);
   TEST_INSVE("insve.d", 200, w25, w14, 0);
   TEST_INSVE("insve.d", 208, w26, w22, 1);
   TEST_INSVE("insve.d", 216, w27, w11, 0);
   TEST_INSVE("insve.d", 224, w28, w25, 1);
   TEST_INSVE("insve.d", 232, w29, w20, 0);
   TEST_INSVE("insve.d", 240, w30, w17, 1);
   TEST_INSVE("insve.d",  56, w31, w6,  0);
   TEST_ELM("splati.b",   0, w0,  w31, 8);
   TEST_ELM("splati.b",   8, w1,  w3,  9);
   TEST_ELM("splati.b",  16, w2,  w9,  10);
   TEST_ELM("splati.b",  24, w3,  w15, 11);
   TEST_ELM("splati.b",  32, w4,  w6,  12);
   TEST_ELM("splati.b",  40, w5,  w8,  13);
   TEST_ELM("splati.b",  48, w6,  w5,  14);
   TEST_ELM("splati.b",  56, w7,  w29, 15);
   TEST_ELM("splati.b",  64, w8,  w10, 0);
   TEST_ELM("splati.b",  72, w9,  w26, 1);
   TEST_ELM("splati.b",  80, w10, w22, 2);
   TEST_ELM("splati.b",  88, w11, w9,  3);
   TEST_ELM("splati.b",  96, w12, w3,  4);
   TEST_ELM("splati.b", 104, w13, w17, 5);
   TEST_ELM("splati.b", 112, w14, w14, 6);
   TEST_ELM("splati.b", 120, w15, w31, 7);
   TEST_ELM("splati.b", 128, w16, w25, 8);
   TEST_ELM("splati.b", 136, w17, w11, 9);
   TEST_ELM("splati.b", 144, w18, w7,  10);
   TEST_ELM("splati.b", 152, w19, w0,  11);
   TEST_ELM("splati.b", 160, w20, w1,  12);
   TEST_ELM("splati.b", 168, w21, w10, 13);
   TEST_ELM("splati.b", 176, w22, w22, 14);
   TEST_ELM("splati.b", 184, w23, w8,  15);
   TEST_ELM("splati.b", 192, w24, w20, 0);
   TEST_ELM("splati.b", 200, w25, w21, 1);
   TEST_ELM("splati.b", 208, w26, w11, 2);
   TEST_ELM("splati.b", 216, w27, w20, 3);
   TEST_ELM("splati.b", 224, w28, w16, 4);
   TEST_ELM("splati.b", 232, w29, w31, 5);
   TEST_ELM("splati.b", 240, w30, w13, 6);
   TEST_ELM("splati.b",  40, w31, w9,  7);
   TEST_ELM("splati.h",   0, w0,  w20, 0);
   TEST_ELM("splati.h",   8, w1,  w5,  1);
   TEST_ELM("splati.h",  16, w2,  w15, 2);
   TEST_ELM("splati.h",  24, w3,  w4,  3);
   TEST_ELM("splati.h",  32, w4,  w16, 4);
   TEST_ELM("splati.h",  40, w5,  w16, 5);
   TEST_ELM("splati.h",  48, w6,  w24, 6);
   TEST_ELM("splati.h",  56, w7,  w11, 7);
   TEST_ELM("splati.h",  64, w8,  w9,  0);
   TEST_ELM("splati.h",  72, w9,  w25, 1);
   TEST_ELM("splati.h",  80, w10, w11, 2);
   TEST_ELM("splati.h",  88, w11, w5,  3);
   TEST_ELM("splati.h",  96, w12, w6,  4);
   TEST_ELM("splati.h", 104, w13, w5,  5);
   TEST_ELM("splati.h", 112, w14, w14, 6);
   TEST_ELM("splati.h", 120, w15, w3,  7);
   TEST_ELM("splati.h", 128, w16, w23, 0);
   TEST_ELM("splati.h", 136, w17, w14, 1);
   TEST_ELM("splati.h", 144, w18, w14, 2);
   TEST_ELM("splati.h", 152, w19, w13, 3);
   TEST_ELM("splati.h", 160, w20, w3,  4);
   TEST_ELM("splati.h", 168, w21, w24, 5);
   TEST_ELM("splati.h", 176, w22, w22, 6);
   TEST_ELM("splati.h", 184, w23, w13, 7);
   TEST_ELM("splati.h", 192, w24, w9,  0);
   TEST_ELM("splati.h", 200, w25, w26, 1);
   TEST_ELM("splati.h", 208, w26, w11, 2);
   TEST_ELM("splati.h", 216, w27, w9,  3);
   TEST_ELM("splati.h", 224, w28, w5,  4);
   TEST_ELM("splati.h", 232, w29, w18, 5);
   TEST_ELM("splati.h", 240, w30, w21, 6);
   TEST_ELM("splati.h",  40, w31, w7,  7);
   TEST_ELM("splati.w",   0, w0,  w30, 0);
   TEST_ELM("splati.w",   8, w1,  w26, 1);
   TEST_ELM("splati.w",  16, w2,  w15, 2);
   TEST_ELM("splati.w",  24, w3,  w8,  3);
   TEST_ELM("splati.w",  32, w4,  w14, 0);
   TEST_ELM("splati.w",  40, w5,  w26, 1);
   TEST_ELM("splati.w",  48, w6,  w7,  2);
   TEST_ELM("splati.w",  56, w7,  w17, 3);
   TEST_ELM("splati.w",  64, w8,  w3,  0);
   TEST_ELM("splati.w",  72, w9,  w8,  1);
   TEST_ELM("splati.w",  80, w10, w26, 2);
   TEST_ELM("splati.w",  88, w11, w13, 3);
   TEST_ELM("splati.w",  96, w12, w1,  0);
   TEST_ELM("splati.w", 104, w13, w9,  1);
   TEST_ELM("splati.w", 112, w14, w14, 2);
   TEST_ELM("splati.w", 120, w15, w5,  3);
   TEST_ELM("splati.w", 128, w16, w27, 0);
   TEST_ELM("splati.w", 136, w17, w0,  1);
   TEST_ELM("splati.w", 144, w18, w23, 2);
   TEST_ELM("splati.w", 152, w19, w24, 3);
   TEST_ELM("splati.w", 160, w20, w2,  0);
   TEST_ELM("splati.w", 168, w21, w10, 1);
   TEST_ELM("splati.w", 176, w22, w22, 2);
   TEST_ELM("splati.w", 184, w23, w27, 3);
   TEST_ELM("splati.w", 192, w24, w11, 0);
   TEST_ELM("splati.w", 200, w25, w16, 1);
   TEST_ELM("splati.w", 208, w26, w12, 2);
   TEST_ELM("splati.w", 216, w27, w2,  3);
   TEST_ELM("splati.w", 224, w28, w23, 0);
   TEST_ELM("splati.w", 232, w29, w27, 1);
   TEST_ELM("splati.w", 240, w30, w11, 2);
   TEST_ELM("splati.w",  32, w31, w6,  3);
   TEST_ELM("splati.d",   0, w0,  w21, 0);
   TEST_ELM("splati.d",   8, w1,  w28, 1);
   TEST_ELM("splati.d",  16, w2,  w13, 0);
   TEST_ELM("splati.d",  24, w3,  w26, 1);
   TEST_ELM("splati.d",  32, w4,  w16, 0);
   TEST_ELM("splati.d",  40, w5,  w19, 1);
   TEST_ELM("splati.d",  48, w6,  w27, 0);
   TEST_ELM("splati.d",  56, w7,  w14, 1);
   TEST_ELM("splati.d",  64, w8,  w30, 0);
   TEST_ELM("splati.d",  72, w9,  w17, 1);
   TEST_ELM("splati.d",  80, w10, w0,  0);
   TEST_ELM("splati.d",  88, w11, w0,  1);
   TEST_ELM("splati.d",  96, w12, w6,  0);
   TEST_ELM("splati.d", 104, w13, w14, 1);
   TEST_ELM("splati.d", 112, w14, w14, 0);
   TEST_ELM("splati.d", 120, w15, w9,  1);
   TEST_ELM("splati.d", 128, w16, w31, 0);
   TEST_ELM("splati.d", 136, w17, w5,  1);
   TEST_ELM("splati.d", 144, w18, w19, 0);
   TEST_ELM("splati.d", 152, w19, w14, 1);
   TEST_ELM("splati.d", 160, w20, w25, 0);
   TEST_ELM("splati.d", 168, w21, w14, 1);
   TEST_ELM("splati.d", 176, w22, w22, 0);
   TEST_ELM("splati.d", 184, w23, w16, 1);
   TEST_ELM("splati.d", 192, w24, w1,  0);
   TEST_ELM("splati.d", 200, w25, w9,  1);
   TEST_ELM("splati.d", 208, w26, w13, 0);
   TEST_ELM("splati.d", 216, w27, w1,  1);
   TEST_ELM("splati.d", 224, w28, w11, 0);
   TEST_ELM("splati.d", 232, w29, w21, 1);
   TEST_ELM("splati.d", 240, w30, w4,  0);
   TEST_ELM("splati.d", 232, w31, w3,  1);
#else
   printf("This test requires MSA extension.\n");
#endif
   return 0;
}
