#include <stdlib.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"
#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;
static UnityWebappsService *service = NULL;
  

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  GVariant * interests =
    unity_webapps_context_list_interests(context);

  const gchar * name = unity_webapps_context_get_name (context);
  const gchar * domain = unity_webapps_context_get_domain (context);

  int num = g_variant_n_children(interests);
  int i = 0;
  for (i = 0; i < num; ++i)
    {
      GVariant * s = g_variant_get_child_value(interests, i);
      unity_webapps_service_destroy_interest_for_context(service
                                                         , name, domain
                                                         , g_variant_get_int32(s)
                                                         , TRUE);
    }
  g_variant_unref(interests);
  
  uwa_emit_test_finished ();
}

gint
main (gint argc, gchar **argv)
{
  g_type_init ();

  service = unity_webapps_service_new ();

  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);

  mainloop = g_main_loop_new (NULL, FALSE);

  g_main_loop_run (mainloop);
  
  return 0;  
}
