
#macro that sets OUTPUT as the value of oneof options (if _CL_HAVE_OPTION exists)
MACRO(GET_VARIABLE_VALUE variable printfType result)

	SET ( GET_VARIABLE_VALUE_DEFINITIONS "-DVARIABLENAME=${variable} -DPRINTFTYPE=${printfType}")

	IF ( HAVE_WINDOWS_H )
		SET ( GET_VARIABLE_VALUE_DEFINITIONS "${GET_VARIABLE_VALUE_DEFINITIONS} -DHAVE_WINDOWS_H")
	ENDIF ( HAVE_WINDOWS_H )
    IF ( HAVE_LIMITS_H )
    	SET (GET_VARIABLE_VALUE_DEFINITIONS "${GET_VARIABLE_VALUE_DEFINITIONS} -DHAVE_LIMITS_H")
    ENDIF ( HAVE_LIMITS_H )
    IF ( HAVE_STAT_H )
    	SET (GET_VARIABLE_VALUE_DEFINITIONS "${GET_VARIABLE_VALUE_DEFINITIONS} -DHAVE_STAT_H")
    ENDIF ( HAVE_STAT_H )
    IF ( HAVE_SYS_STAT_H )
    	SET (GET_VARIABLE_VALUE_DEFINITIONS "${GET_VARIABLE_VALUE_DEFINITIONS} -DHAVE_SYS_STAT_H")
    ENDIF ( HAVE_SYS_STAT_H )
    
    CONFIGURE_FILE("${${PROJECT_SOURCE_DIR}}/cmake/MacroGetVariableValue.c.in"
      "${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeTmp/MacroGetVariableValue.c" IMMEDIATE @ONLY)
    
    TRY_COMPILE(HAVE_${VARIABLE}
      ${CMAKE_BINARY_DIR}
      "${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeTmp/CheckTypeSizeC.c"
      COMPILE_DEFINITIONS ${GET_VARIABLE_VALUE_DEFINITIONS}
      OUTPUT_VARIABLE OUTPUT
      COPY_FILE "${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/MacroGetVariablesValue.bin" )


	MESSAGE(FATAL_ERROR stop)
	SET(GET_VARIABLE_VALUE_DEFINITIONS)
ENDMACRO(GET_VARIABLE_VALUE)
