/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include "gconfitem-qml-wrapper.h"
#include "gconfitem.h"

#include <QDebug>

GConfItemQmlWrapper::GConfItemQmlWrapper(QObject *parent) :
    QObject(parent), m_item(NULL)
{
}

GConfItemQmlWrapper::~GConfItemQmlWrapper()
{
    if (m_item != NULL)
        delete m_item;
}

const QString
GConfItemQmlWrapper::getKey() const
{
    if (m_item == NULL)
    {
        qWarning() << "key not set";
        return QString();
    }

    return m_item->key();
}

void
GConfItemQmlWrapper::setKey(const QString &key)
{
    if (m_item != NULL)
    {
        // Changing the key of an item does not make sense,
        // the key is meant to be set only once.
        qWarning() << "cannot change the key";
        return;
    }

    m_item = new GConfItem(key);
    QObject::connect(m_item, SIGNAL(valueChanged()), this, SIGNAL(valueChanged()));
    QObject::connect(m_item, SIGNAL(subtreeChanged(const QString&, const QVariant&)),
                     this, SIGNAL(subtreeChanged()));
}

const QVariant
GConfItemQmlWrapper::getValue() const
{
    if (m_item == NULL)
    {
        qWarning() << "key not set";
        return QVariant();
    }

    return m_item->value();
}

void
GConfItemQmlWrapper::setValue(const QVariant &value)
{
    if (m_item == NULL)
    {
        qWarning() << "key not set";
        return;
    }

    m_item->set(value);
}

const QVariant
GConfItemQmlWrapper::getEntries() const
{
    if (m_item == NULL)
    {
        qWarning() << "key not set";
        return QVariant();
    }

    return QVariant(m_item->listEntries());
}

const QVariant
GConfItemQmlWrapper::getDirs() const
{
    if (m_item == NULL)
    {
        qWarning() << "key not set";
        return QVariant();
    }

    return QVariant(m_item->listDirs());
}

