// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 4
// RUN: %clang_cc1 -triple x86_64-linux-gnu -target-cpu core2 %s -emit-llvm -o - | FileCheck -check-prefixes=X64 %s
// RUN: %clang_cc1 -triple i686-linux-gnu -target-cpu core2 %s -emit-llvm -o - | FileCheck -check-prefixes=X86 %s


// X64-LABEL: define dso_local double @test_double_post_inc(
// X64-SAME: ) #[[ATTR0:[0-9]+]] {
// X64-NEXT:  entry:
// X64-NEXT:    [[TMP0:%.*]] = atomicrmw fadd ptr @test_double_post_inc.n, double 1.000000e+00 seq_cst, align 8
// X64-NEXT:    ret double [[TMP0]]
//
// X86-LABEL: define dso_local double @test_double_post_inc(
// X86-SAME: ) #[[ATTR0:[0-9]+]] {
// X86-NEXT:  entry:
// X86-NEXT:    [[TMP0:%.*]] = atomicrmw fadd ptr @test_double_post_inc.n, double 1.000000e+00 seq_cst, align 8
// X86-NEXT:    ret double [[TMP0]]
//
double test_double_post_inc()
{
    static _Atomic double n;
    return n++;
}

// X64-LABEL: define dso_local double @test_double_post_dc(
// X64-SAME: ) #[[ATTR0]] {
// X64-NEXT:  entry:
// X64-NEXT:    [[TMP0:%.*]] = atomicrmw fsub ptr @test_double_post_dc.n, double 1.000000e+00 seq_cst, align 8
// X64-NEXT:    ret double [[TMP0]]
//
// X86-LABEL: define dso_local double @test_double_post_dc(
// X86-SAME: ) #[[ATTR0]] {
// X86-NEXT:  entry:
// X86-NEXT:    [[TMP0:%.*]] = atomicrmw fsub ptr @test_double_post_dc.n, double 1.000000e+00 seq_cst, align 8
// X86-NEXT:    ret double [[TMP0]]
//
double test_double_post_dc()
{
    static _Atomic double n;
    return n--;
}

// X64-LABEL: define dso_local double @test_double_pre_dc(
// X64-SAME: ) #[[ATTR0]] {
// X64-NEXT:  entry:
// X64-NEXT:    [[TMP0:%.*]] = atomicrmw fsub ptr @test_double_pre_dc.n, double 1.000000e+00 seq_cst, align 8
// X64-NEXT:    [[TMP1:%.*]] = fsub double [[TMP0]], 1.000000e+00
// X64-NEXT:    ret double [[TMP1]]
//
// X86-LABEL: define dso_local double @test_double_pre_dc(
// X86-SAME: ) #[[ATTR0]] {
// X86-NEXT:  entry:
// X86-NEXT:    [[TMP0:%.*]] = atomicrmw fsub ptr @test_double_pre_dc.n, double 1.000000e+00 seq_cst, align 8
// X86-NEXT:    [[TMP1:%.*]] = fsub double [[TMP0]], 1.000000e+00
// X86-NEXT:    ret double [[TMP1]]
//
double test_double_pre_dc()
{
    static _Atomic double n;
    return --n;
}

// X64-LABEL: define dso_local double @test_double_pre_inc(
// X64-SAME: ) #[[ATTR0]] {
// X64-NEXT:  entry:
// X64-NEXT:    [[TMP0:%.*]] = atomicrmw fadd ptr @test_double_pre_inc.n, double 1.000000e+00 seq_cst, align 8
// X64-NEXT:    [[TMP1:%.*]] = fadd double [[TMP0]], 1.000000e+00
// X64-NEXT:    ret double [[TMP1]]
//
// X86-LABEL: define dso_local double @test_double_pre_inc(
// X86-SAME: ) #[[ATTR0]] {
// X86-NEXT:  entry:
// X86-NEXT:    [[TMP0:%.*]] = atomicrmw fadd ptr @test_double_pre_inc.n, double 1.000000e+00 seq_cst, align 8
// X86-NEXT:    [[TMP1:%.*]] = fadd double [[TMP0]], 1.000000e+00
// X86-NEXT:    ret double [[TMP1]]
//
double test_double_pre_inc()
{
    static _Atomic double n;
    return ++n;
}

// X64-LABEL: define dso_local i32 @pr107054(
// X64-SAME: ) #[[ATTR0]] {
// X64-NEXT:  entry:
// X64-NEXT:    [[TMP0:%.*]] = atomicrmw fadd ptr @pr107054.n, double 1.000000e+00 seq_cst, align 8
// X64-NEXT:    [[TMP1:%.*]] = fadd double [[TMP0]], 1.000000e+00
// X64-NEXT:    [[CMP:%.*]] = fcmp oeq double [[TMP1]], 1.000000e+00
// X64-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
// X64-NEXT:    ret i32 [[CONV]]
//
// X86-LABEL: define dso_local i32 @pr107054(
// X86-SAME: ) #[[ATTR0]] {
// X86-NEXT:  entry:
// X86-NEXT:    [[TMP0:%.*]] = atomicrmw fadd ptr @pr107054.n, double 1.000000e+00 seq_cst, align 8
// X86-NEXT:    [[TMP1:%.*]] = fadd double [[TMP0]], 1.000000e+00
// X86-NEXT:    [[CMP:%.*]] = fcmp oeq double [[TMP1]], 1.000000e+00
// X86-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
// X86-NEXT:    ret i32 [[CONV]]
//
int pr107054()
{
    static _Atomic double n;
    return (++n) == 1;
}
