; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux-gnu    -global-isel -verify-machineinstrs < %s -o - | FileCheck %s --check-prefix=ALL

define i32 @test_icmp_eq_i8(i8 %a, i8 %b) {
; ALL-LABEL: test_icmp_eq_i8:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpb %sil, %dil
; ALL-NEXT:    sete %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp eq i8 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_eq_i16(i16 %a, i16 %b) {
; ALL-LABEL: test_icmp_eq_i16:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpw %si, %di
; ALL-NEXT:    sete %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp eq i16 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_eq_i64(i64 %a, i64 %b) {
; ALL-LABEL: test_icmp_eq_i64:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpq %rsi, %rdi
; ALL-NEXT:    sete %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp eq i64 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_eq_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_eq_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    sete %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp eq i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_ne_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_ne_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    setne %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp ne i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_ugt_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_ugt_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    seta %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp ugt i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_uge_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_uge_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    setae %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp uge i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_ult_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_ult_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    setb %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp ult i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_ule_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_ule_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    setbe %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp ule i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_sgt_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_sgt_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    setg %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp sgt i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_sge_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_sge_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    setge %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp sge i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_slt_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_slt_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    setl %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp slt i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

define i32 @test_icmp_sle_i32(i32 %a, i32 %b) {
; ALL-LABEL: test_icmp_sle_i32:
; ALL:       # %bb.0:
; ALL-NEXT:    cmpl %esi, %edi
; ALL-NEXT:    setle %al
; ALL-NEXT:    andl $1, %eax
; ALL-NEXT:    retq
  %r = icmp sle i32 %a, %b
  %res =  zext i1 %r to i32
  ret i32 %res
}

