/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2023 Inochi Amaoto <inochiama@outlook.com>
 */

#ifndef _CLK_SOPHGO_CV1800_H_
#define _CLK_SOPHGO_CV1800_H_

#include <dt-bindings/clock/sophgo,cv1800.h>

#define CV1800_CLK_MAX			(CLK_XTAL_AP + 1)
#define CV1810_CLK_MAX			(CLK_DISP_SRC_VIP + 1)

#define REG_PLL_G2_CTRL			0x800
#define REG_PLL_G2_STATUS		0x804
#define REG_MIPIMPLL_CSR		0x808
#define REG_A0PLL_CSR			0x80C
#define REG_DISPPLL_CSR			0x810
#define REG_CAM0PLL_CSR			0x814
#define REG_CAM1PLL_CSR			0x818
#define REG_PLL_G2_SSC_SYN_CTRL		0x840
#define REG_A0PLL_SSC_SYN_CTRL		0x850
#define REG_A0PLL_SSC_SYN_SET		0x854
#define REG_A0PLL_SSC_SYN_SPAN		0x858
#define REG_A0PLL_SSC_SYN_STEP		0x85C
#define REG_DISPPLL_SSC_SYN_CTRL	0x860
#define REG_DISPPLL_SSC_SYN_SET		0x864
#define REG_DISPPLL_SSC_SYN_SPAN	0x868
#define REG_DISPPLL_SSC_SYN_STEP	0x86C
#define REG_CAM0PLL_SSC_SYN_CTRL	0x870
#define REG_CAM0PLL_SSC_SYN_SET		0x874
#define REG_CAM0PLL_SSC_SYN_SPAN	0x878
#define REG_CAM0PLL_SSC_SYN_STEP	0x87C
#define REG_CAM1PLL_SSC_SYN_CTRL	0x880
#define REG_CAM1PLL_SSC_SYN_SET		0x884
#define REG_CAM1PLL_SSC_SYN_SPAN	0x888
#define REG_CAM1PLL_SSC_SYN_STEP	0x88C
#define REG_APLL_FRAC_DIV_CTRL		0x890
#define REG_APLL_FRAC_DIV_M		0x894
#define REG_APLL_FRAC_DIV_N		0x898
#define REG_MIPIMPLL_CLK_CSR		0x8A0
#define REG_A0PLL_CLK_CSR		0x8A4
#define REG_DISPPLL_CLK_CSR		0x8A8
#define REG_CAM0PLL_CLK_CSR		0x8AC
#define REG_CAM1PLL_CLK_CSR		0x8B0
#define REG_CLK_CAM0_SRC_DIV		0x8C0
#define REG_CLK_CAM1_SRC_DIV		0x8C4

/* top_pll_g6 */
#define REG_PLL_G6_CTRL			0x900
#define REG_PLL_G6_STATUS		0x904
#define REG_MPLL_CSR			0x908
#define REG_TPLL_CSR			0x90C
#define REG_FPLL_CSR			0x910
#define REG_PLL_G6_SSC_SYN_CTRL		0x940
#define REG_DPLL_SSC_SYN_CTRL		0x950
#define REG_DPLL_SSC_SYN_SET		0x954
#define REG_DPLL_SSC_SYN_SPAN		0x958
#define REG_DPLL_SSC_SYN_STEP		0x95C
#define REG_MPLL_SSC_SYN_CTRL		0x960
#define REG_MPLL_SSC_SYN_SET		0x964
#define REG_MPLL_SSC_SYN_SPAN		0x968
#define REG_MPLL_SSC_SYN_STEP		0x96C
#define REG_TPLL_SSC_SYN_CTRL		0x970
#define REG_TPLL_SSC_SYN_SET		0x974
#define REG_TPLL_SSC_SYN_SPAN		0x978
#define REG_TPLL_SSC_SYN_STEP		0x97C

/* clkgen */
#define REG_CLK_EN_0			0x000
#define REG_CLK_EN_1			0x004
#define REG_CLK_EN_2			0x008
#define REG_CLK_EN_3			0x00C
#define REG_CLK_EN_4			0x010
#define REG_CLK_SEL_0			0x020
#define REG_CLK_BYP_0			0x030
#define REG_CLK_BYP_1			0x034

#define REG_DIV_CLK_A53_0		0x040
#define REG_DIV_CLK_A53_1		0x044
#define REG_DIV_CLK_CPU_AXI0		0x048
#define REG_DIV_CLK_CPU_GIC		0x050
#define REG_DIV_CLK_TPU			0x054
#define REG_DIV_CLK_EMMC		0x064
#define REG_DIV_CLK_EMMC_100K		0x06C
#define REG_DIV_CLK_SD0			0x070
#define REG_DIV_CLK_SD0_100K		0x078
#define REG_DIV_CLK_SD1			0x07C
#define REG_DIV_CLK_SD1_100K		0x084
#define REG_DIV_CLK_SPI_NAND		0x088
#define REG_DIV_CLK_ETH0_500M		0x08C
#define REG_DIV_CLK_ETH1_500M		0x090
#define REG_DIV_CLK_GPIO_DB		0x094
#define REG_DIV_CLK_SDMA_AUD0		0x098
#define REG_DIV_CLK_SDMA_AUD1		0x09C
#define REG_DIV_CLK_SDMA_AUD2		0x0A0
#define REG_DIV_CLK_SDMA_AUD3		0x0A4
#define REG_DIV_CLK_CAM0_200		0x0A8
#define REG_DIV_CLK_AXI4		0x0B8
#define REG_DIV_CLK_AXI6		0x0BC
#define REG_DIV_CLK_DSI_ESC		0x0C4
#define REG_DIV_CLK_AXI_VIP		0x0C8
#define REG_DIV_CLK_SRC_VIP_SYS_0	0x0D0
#define REG_DIV_CLK_SRC_VIP_SYS_1	0x0D8
#define REG_DIV_CLK_DISP_SRC_VIP	0x0E0
#define REG_DIV_CLK_AXI_VIDEO_CODEC	0x0E4
#define REG_DIV_CLK_VC_SRC0		0x0EC
#define REG_DIV_CLK_1M			0x0FC
#define REG_DIV_CLK_SPI			0x100
#define REG_DIV_CLK_I2C			0x104
#define REG_DIV_CLK_SRC_VIP_SYS_2	0x110
#define REG_DIV_CLK_AUDSRC		0x118
#define REG_DIV_CLK_PWM_SRC_0		0x120
#define REG_DIV_CLK_AP_DEBUG		0x128
#define REG_DIV_CLK_RTCSYS_SRC_0	0x12C
#define REG_DIV_CLK_C906_0_0		0x130
#define REG_DIV_CLK_C906_0_1		0x134
#define REG_DIV_CLK_C906_1_0		0x138
#define REG_DIV_CLK_C906_1_1		0x13C
#define REG_DIV_CLK_SRC_VIP_SYS_3	0x140
#define REG_DIV_CLK_SRC_VIP_SYS_4	0x144

#endif /* _CLK_SOPHGO_CV1800_H_ */
