/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2020-2023 Intel Corporation
 */

#ifndef __IVPU_HW_40XX_REG_H__
#define __IVPU_HW_40XX_REG_H__

#include <linux/bits.h>

#define VPU_40XX_BUTTRESS_INTERRUPT_STAT				0x00000000u
#define VPU_40XX_BUTTRESS_INTERRUPT_STAT_FREQ_CHANGE_MASK		BIT_MASK(0)
#define VPU_40XX_BUTTRESS_INTERRUPT_STAT_ATS_ERR_MASK			BIT_MASK(1)
#define VPU_40XX_BUTTRESS_INTERRUPT_STAT_CFI0_ERR_MASK			BIT_MASK(2)
#define VPU_40XX_BUTTRESS_INTERRUPT_STAT_CFI1_ERR_MASK			BIT_MASK(3)
#define VPU_40XX_BUTTRESS_INTERRUPT_STAT_IMR0_ERR_MASK			BIT_MASK(4)
#define VPU_40XX_BUTTRESS_INTERRUPT_STAT_IMR1_ERR_MASK			BIT_MASK(5)
#define VPU_40XX_BUTTRESS_INTERRUPT_STAT_SURV_ERR_MASK			BIT_MASK(6)

#define VPU_40XX_BUTTRESS_LOCAL_INT_MASK				0x00000004u
#define VPU_40XX_BUTTRESS_GLOBAL_INT_MASK				0x00000008u

#define VPU_40XX_BUTTRESS_HM_ATS					0x0000000cu

#define VPU_40XX_BUTTRESS_ATS_ERR_LOG1					0x00000010u
#define VPU_40XX_BUTTRESS_ATS_ERR_LOG2					0x00000014u
#define VPU_40XX_BUTTRESS_ATS_ERR_CLEAR					0x00000018u

#define VPU_40XX_BUTTRESS_CFI0_ERR_LOG					0x0000001cu
#define VPU_40XX_BUTTRESS_CFI0_ERR_CLEAR				0x00000020u

#define VPU_40XX_BUTTRESS_PORT_ARBITRATION_WEIGHTS_ATS			0x00000024u

#define VPU_40XX_BUTTRESS_CFI1_ERR_LOG					0x00000040u
#define VPU_40XX_BUTTRESS_CFI1_ERR_CLEAR				0x00000044u

#define VPU_40XX_BUTTRESS_IMR_ERR_CFI0_LOW				0x00000048u
#define VPU_40XX_BUTTRESS_IMR_ERR_CFI0_HIGH				0x0000004cu
#define VPU_40XX_BUTTRESS_IMR_ERR_CFI0_CLEAR				0x00000050u

#define VPU_40XX_BUTTRESS_PORT_ARBITRATION_WEIGHTS			0x00000054u

#define VPU_40XX_BUTTRESS_IMR_ERR_CFI1_LOW				0x00000058u
#define VPU_40XX_BUTTRESS_IMR_ERR_CFI1_HIGH				0x0000005cu
#define VPU_40XX_BUTTRESS_IMR_ERR_CFI1_CLEAR				0x00000060u

#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD0				0x00000130u
#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD0_MIN_RATIO_MASK		GENMASK(15, 0)
#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD0_MAX_RATIO_MASK		GENMASK(31, 16)

#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD1				0x00000134u
#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD1_TARGET_RATIO_MASK		GENMASK(15, 0)
#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD1_EPP_MASK			GENMASK(31, 16)

#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD2				0x00000138u
#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD2_CONFIG_MASK			GENMASK(15, 0)
#define VPU_40XX_BUTTRESS_WP_REQ_PAYLOAD2_CDYN_MASK			GENMASK(31, 16)

#define VPU_40XX_BUTTRESS_WP_REQ_CMD					0x0000013cu
#define VPU_40XX_BUTTRESS_WP_REQ_CMD_SEND_MASK				BIT_MASK(0)

#define VPU_40XX_BUTTRESS_PLL_FREQ					0x00000148u
#define VPU_40XX_BUTTRESS_PLL_FREQ_RATIO_MASK				GENMASK(15, 0)

#define VPU_40XX_BUTTRESS_TILE_FUSE					0x00000150u
#define VPU_40XX_BUTTRESS_TILE_FUSE_VALID_MASK				BIT_MASK(0)
#define VPU_40XX_BUTTRESS_TILE_FUSE_CONFIG_MASK				GENMASK(6, 1)

#define VPU_40XX_BUTTRESS_VPU_STATUS					0x00000154u
#define VPU_40XX_BUTTRESS_VPU_STATUS_READY_MASK				BIT_MASK(0)
#define VPU_40XX_BUTTRESS_VPU_STATUS_IDLE_MASK				BIT_MASK(1)
#define VPU_40XX_BUTTRESS_VPU_STATUS_DUP_IDLE_MASK			BIT_MASK(2)
#define VPU_40XX_BUTTRESS_VPU_STATUS_CLOCK_RESOURCE_OWN_ACK_MASK	BIT_MASK(6)
#define VPU_40XX_BUTTRESS_VPU_STATUS_POWER_RESOURCE_OWN_ACK_MASK	BIT_MASK(7)
#define VPU_40XX_BUTTRESS_VPU_STATUS_PERF_CLK_MASK			BIT_MASK(11)
#define VPU_40XX_BUTTRESS_VPU_STATUS_DISABLE_CLK_RELINQUISH_MASK        BIT_MASK(12)

#define VPU_40XX_BUTTRESS_IP_RESET					0x00000160u
#define VPU_40XX_BUTTRESS_IP_RESET_TRIGGER_MASK				BIT_MASK(0)

#define VPU_40XX_BUTTRESS_D0I3_CONTROL					0x00000164u
#define VPU_40XX_BUTTRESS_D0I3_CONTROL_INPROGRESS_MASK			BIT_MASK(0)
#define VPU_40XX_BUTTRESS_D0I3_CONTROL_I3_MASK				BIT_MASK(2)

#define VPU_40XX_BUTTRESS_VPU_TELEMETRY_OFFSET				0x00000168u
#define VPU_40XX_BUTTRESS_VPU_TELEMETRY_SIZE				0x0000016cu
#define VPU_40XX_BUTTRESS_VPU_TELEMETRY_ENABLE				0x00000170u

#define VPU_40XX_BUTTRESS_FMIN_FUSE					0x00000174u
#define VPU_40XX_BUTTRESS_FMIN_FUSE_MIN_RATIO_MASK			GENMASK(7, 0)
#define VPU_40XX_BUTTRESS_FMIN_FUSE_PN_RATIO_MASK			GENMASK(15, 8)

#define VPU_40XX_BUTTRESS_FMAX_FUSE					0x00000178u
#define VPU_40XX_BUTTRESS_FMAX_FUSE_MAX_RATIO_MASK			GENMASK(7, 0)

#define VPU_40XX_HOST_SS_CPR_CLK_EN					0x00000080u
#define VPU_40XX_HOST_SS_CPR_CLK_EN_TOP_NOC_MASK			BIT_MASK(1)
#define VPU_40XX_HOST_SS_CPR_CLK_EN_DSS_MAS_MASK			BIT_MASK(10)
#define VPU_40XX_HOST_SS_CPR_CLK_EN_CSS_MAS_MASK			BIT_MASK(11)

#define VPU_40XX_HOST_SS_CPR_CLK_SET					0x00000084u
#define VPU_40XX_HOST_SS_CPR_CLK_SET_TOP_NOC_MASK			BIT_MASK(1)
#define VPU_40XX_HOST_SS_CPR_CLK_SET_DSS_MAS_MASK			BIT_MASK(10)
#define VPU_40XX_HOST_SS_CPR_CLK_SET_MSS_MAS_MASK			BIT_MASK(11)

#define VPU_40XX_HOST_SS_CPR_RST_EN					0x00000090u
#define VPU_40XX_HOST_SS_CPR_RST_EN_TOP_NOC_MASK			BIT_MASK(1)
#define VPU_40XX_HOST_SS_CPR_RST_EN_DSS_MAS_MASK			BIT_MASK(10)
#define VPU_40XX_HOST_SS_CPR_RST_EN_CSS_MAS_MASK			BIT_MASK(11)

#define VPU_40XX_HOST_SS_CPR_RST_SET					0x00000094u
#define VPU_40XX_HOST_SS_CPR_RST_SET_TOP_NOC_MASK			BIT_MASK(1)
#define VPU_40XX_HOST_SS_CPR_RST_SET_DSS_MAS_MASK			BIT_MASK(10)
#define VPU_40XX_HOST_SS_CPR_RST_SET_MSS_MAS_MASK			BIT_MASK(11)

#define VPU_40XX_HOST_SS_CPR_RST_CLR					0x00000098u
#define VPU_40XX_HOST_SS_CPR_RST_CLR_TOP_NOC_MASK			BIT_MASK(1)
#define VPU_40XX_HOST_SS_CPR_RST_CLR_DSS_MAS_MASK			BIT_MASK(10)
#define VPU_40XX_HOST_SS_CPR_RST_CLR_MSS_MAS_MASK			BIT_MASK(11)

#define VPU_40XX_HOST_SS_HW_VERSION					0x00000108u
#define VPU_40XX_HOST_SS_HW_VERSION_SOC_REVISION_MASK			GENMASK(7, 0)
#define VPU_40XX_HOST_SS_HW_VERSION_SOC_NUMBER_MASK			GENMASK(15, 8)
#define VPU_40XX_HOST_SS_HW_VERSION_VPU_GENERATION_MASK			GENMASK(23, 16)

#define VPU_40XX_HOST_SS_SW_VERSION					0x0000010cu

#define VPU_40XX_HOST_SS_GEN_CTRL					0x00000118u
#define VPU_40XX_HOST_SS_GEN_CTRL_PS_MASK				GENMASK(31, 29)

#define VPU_40XX_HOST_SS_NOC_QREQN					0x00000154u
#define VPU_40XX_HOST_SS_NOC_QREQN_TOP_SOCMMIO_MASK			BIT_MASK(0)

#define VPU_40XX_HOST_SS_NOC_QACCEPTN					0x00000158u
#define VPU_40XX_HOST_SS_NOC_QACCEPTN_TOP_SOCMMIO_MASK			BIT_MASK(0)

#define VPU_40XX_HOST_SS_NOC_QDENY					0x0000015cu
#define VPU_40XX_HOST_SS_NOC_QDENY_TOP_SOCMMIO_MASK			BIT_MASK(0)

#define VPU_40XX_TOP_NOC_QREQN						0x00000160u
#define VPU_40XX_TOP_NOC_QREQN_CPU_CTRL_MASK				BIT_MASK(0)
#define VPU_40XX_TOP_NOC_QREQN_HOSTIF_L2CACHE_MASK			BIT_MASK(2)

#define VPU_40XX_TOP_NOC_QACCEPTN					0x00000164u
#define VPU_40XX_TOP_NOC_QACCEPTN_CPU_CTRL_MASK				BIT_MASK(0)
#define VPU_40XX_TOP_NOC_QACCEPTN_HOSTIF_L2CACHE_MASK			BIT_MASK(2)

#define VPU_40XX_TOP_NOC_QDENY						0x00000168u
#define VPU_40XX_TOP_NOC_QDENY_CPU_CTRL_MASK				BIT_MASK(0)
#define VPU_40XX_TOP_NOC_QDENY_HOSTIF_L2CACHE_MASK			BIT_MASK(2)

#define VPU_40XX_HOST_SS_FW_SOC_IRQ_EN					0x00000170u
#define VPU_40XX_HOST_SS_FW_SOC_IRQ_EN_CSS_ROM_CMX_MASK			BIT_MASK(0)
#define VPU_40XX_HOST_SS_FW_SOC_IRQ_EN_CSS_DBG_MASK			BIT_MASK(1)
#define VPU_40XX_HOST_SS_FW_SOC_IRQ_EN_CSS_CTRL_MASK			BIT_MASK(2)
#define VPU_40XX_HOST_SS_FW_SOC_IRQ_EN_DEC400_MASK			BIT_MASK(3)
#define VPU_40XX_HOST_SS_FW_SOC_IRQ_EN_MSS_NCE_MASK			BIT_MASK(4)
#define VPU_40XX_HOST_SS_FW_SOC_IRQ_EN_MSS_MBI_MASK			BIT_MASK(5)
#define VPU_40XX_HOST_SS_FW_SOC_IRQ_EN_MSS_MBI_CMX_MASK			BIT_MASK(6)

#define VPU_40XX_HOST_SS_ICB_STATUS_0					0x00010210u
#define VPU_40XX_HOST_SS_ICB_STATUS_0_TIMER_0_INT_MASK			BIT_MASK(0)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_TIMER_1_INT_MASK			BIT_MASK(1)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_TIMER_2_INT_MASK			BIT_MASK(2)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_TIMER_3_INT_MASK			BIT_MASK(3)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_HOST_IPC_FIFO_INT_MASK		BIT_MASK(4)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_MMU_IRQ_0_INT_MASK		BIT_MASK(5)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_MMU_IRQ_1_INT_MASK		BIT_MASK(6)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_MMU_IRQ_2_INT_MASK		BIT_MASK(7)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_NOC_FIREWALL_INT_MASK		BIT_MASK(8)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_CPU_INT_REDIRECT_0_INT_MASK	BIT_MASK(30)
#define VPU_40XX_HOST_SS_ICB_STATUS_0_CPU_INT_REDIRECT_1_INT_MASK	BIT_MASK(31)

#define VPU_40XX_HOST_SS_ICB_STATUS_1					0x00010214u
#define VPU_40XX_HOST_SS_ICB_STATUS_1_CPU_INT_REDIRECT_2_INT_MASK	BIT_MASK(0)
#define VPU_40XX_HOST_SS_ICB_STATUS_1_CPU_INT_REDIRECT_3_INT_MASK	BIT_MASK(1)
#define VPU_40XX_HOST_SS_ICB_STATUS_1_CPU_INT_REDIRECT_4_INT_MASK	BIT_MASK(2)

#define VPU_40XX_HOST_SS_ICB_CLEAR_0					0x00010220u
#define VPU_40XX_HOST_SS_ICB_CLEAR_1					0x00010224u
#define VPU_40XX_HOST_SS_ICB_ENABLE_0					0x00010240u
#define VPU_40XX_HOST_SS_ICB_ENABLE_1					0x00010244u

#define VPU_40XX_HOST_SS_TIM_IPC_FIFO_ATM				0x000200f4u

#define VPU_40XX_HOST_SS_TIM_IPC_FIFO_STAT				0x000200fcu
#define VPU_40XX_HOST_SS_TIM_IPC_FIFO_STAT_FILL_LEVEL_MASK		GENMASK(23, 16)

#define VPU_40XX_HOST_SS_AON_PWR_ISO_EN0				0x00030020u
#define VPU_40XX_HOST_SS_AON_PWR_ISO_EN0_CSS_CPU_MASK			BIT_MASK(3)

#define VPU_40XX_HOST_SS_AON_PWR_ISLAND_EN0				0x00030024u
#define VPU_40XX_HOST_SS_AON_PWR_ISLAND_EN0_CSS_CPU_MASK		BIT_MASK(3)

#define VPU_40XX_HOST_SS_AON_PWR_ISLAND_TRICKLE_EN0			0x00030028u
#define VPU_40XX_HOST_SS_AON_PWR_ISLAND_TRICKLE_EN0_CSS_CPU_MASK	BIT_MASK(3)

#define VPU_40XX_HOST_SS_AON_PWR_ISLAND_STATUS0				0x0003002cu
#define VPU_40XX_HOST_SS_AON_PWR_ISLAND_STATUS0_CSS_CPU_MASK		BIT_MASK(3)

#define VPU_40XX_HOST_SS_AON_IDLE_GEN					0x00030200u
#define VPU_40XX_HOST_SS_AON_IDLE_GEN_EN_MASK				BIT_MASK(0)
#define VPU_40XX_HOST_SS_AON_IDLE_GEN_HW_PG_EN_MASK			BIT_MASK(1)

#define VPU_40XX_HOST_SS_AON_DPU_ACTIVE					0x00030204u
#define VPU_40XX_HOST_SS_AON_DPU_ACTIVE_DPU_ACTIVE_MASK			BIT_MASK(0)

#define VPU_40XX_HOST_SS_VERIFICATION_ADDRESS_LO			0x00040040u
#define VPU_40XX_HOST_SS_VERIFICATION_ADDRESS_LO_DONE_MASK		BIT_MASK(0)
#define VPU_40XX_HOST_SS_VERIFICATION_ADDRESS_LO_IOSF_RS_ID_MASK	GENMASK(2, 1)
#define VPU_40XX_HOST_SS_VERIFICATION_ADDRESS_LO_IMAGE_LOCATION_MASK	GENMASK(31, 3)

#define VPU_40XX_HOST_SS_WORKPOINT_CONFIG_MIRROR			0x00082020u
#define VPU_40XX_HOST_SS_WORKPOINT_CONFIG_MIRROR_FINAL_PLL_FREQ_MASK	GENMASK(15, 0)
#define VPU_40XX_HOST_SS_WORKPOINT_CONFIG_MIRROR_CONFIG_ID_MASK		GENMASK(31, 16)

#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES				0x00360000u
#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES_CACHE_OVERRIDE_EN_MASK	BIT_MASK(0)
#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES_AWCACHE_OVERRIDE_MASK	BIT_MASK(1)
#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES_ARCACHE_OVERRIDE_MASK	BIT_MASK(2)
#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES_SNOOP_OVERRIDE_EN_MASK	BIT_MASK(3)
#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES_AW_SNOOP_OVERRIDE_MASK	BIT_MASK(4)
#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES_AR_SNOOP_OVERRIDE_MASK	BIT_MASK(5)
#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES_PTW_AW_CONTEXT_FLAG_MASK	GENMASK(10, 6)
#define VPU_40XX_HOST_IF_TCU_PTW_OVERRIDES_PTW_AR_CONTEXT_FLAG_MASK	GENMASK(15, 11)

#define VPU_40XX_HOST_IF_TBU_MMUSSIDV					0x00360004u
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU0_AWMMUSSIDV_MASK		BIT_MASK(0)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU0_ARMMUSSIDV_MASK		BIT_MASK(1)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU1_AWMMUSSIDV_MASK		BIT_MASK(2)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU1_ARMMUSSIDV_MASK		BIT_MASK(3)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU2_AWMMUSSIDV_MASK		BIT_MASK(4)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU2_ARMMUSSIDV_MASK		BIT_MASK(5)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU3_AWMMUSSIDV_MASK		BIT_MASK(6)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU3_ARMMUSSIDV_MASK		BIT_MASK(7)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU4_AWMMUSSIDV_MASK		BIT_MASK(8)
#define VPU_40XX_HOST_IF_TBU_MMUSSIDV_TBU4_ARMMUSSIDV_MASK		BIT_MASK(9)

#define VPU_40XX_CPU_SS_DSU_LEON_RT_BASE				0x04000000u
#define VPU_40XX_CPU_SS_DSU_LEON_RT_DSU_CTRL				0x04000000u
#define VPU_40XX_CPU_SS_DSU_LEON_RT_PC_REG				0x04400010u
#define VPU_40XX_CPU_SS_DSU_LEON_RT_NPC_REG				0x04400014u
#define VPU_40XX_CPU_SS_DSU_LEON_RT_DSU_TRAP_REG			0x04400020u

#define VPU_40XX_CPU_SS_TIM_WATCHDOG					0x0102009cu
#define VPU_40XX_CPU_SS_TIM_WDOG_EN					0x010200a4u
#define VPU_40XX_CPU_SS_TIM_SAFE					0x010200a8u

#define VPU_40XX_CPU_SS_TIM_GEN_CONFIG					0x01021008u
#define VPU_40XX_CPU_SS_TIM_GEN_CONFIG_WDOG_TO_INT_CLR_MASK		BIT_MASK(9)

#define VPU_40XX_CPU_SS_CPR_NOC_QREQN					0x01010030u
#define VPU_40XX_CPU_SS_CPR_NOC_QREQN_TOP_MMIO_MASK			BIT_MASK(0)

#define VPU_40XX_CPU_SS_CPR_NOC_QACCEPTN				0x01010034u
#define VPU_40XX_CPU_SS_CPR_NOC_QACCEPTN_TOP_MMIO_MASK			BIT_MASK(0)

#define VPU_40XX_CPU_SS_CPR_NOC_QDENY					0x01010038u
#define VPU_40XX_CPU_SS_CPR_NOC_QDENY_TOP_MMIO_MASK			BIT_MASK(0)

#define VPU_40XX_CPU_SS_TIM_IPC_FIFO					0x010200f0u
#define VPU_40XX_CPU_SS_TIM_PERF_EXT_FREE_CNT				0x01029008u

#define VPU_40XX_CPU_SS_DOORBELL_0					0x01300000u
#define VPU_40XX_CPU_SS_DOORBELL_0_SET_MASK				BIT_MASK(0)

#define VPU_40XX_CPU_SS_DOORBELL_1					0x01301000u

#endif /* __IVPU_HW_40XX_REG_H__ */
