.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH start\-stop\-daemon 8 %RELEASE_DATE% %VERSION% "dpkg suite"
.nh
.SH 名前
start\-stop\-daemon \- システムデーモンプログラムの起動、停止
.
.SH 書式
\fBstart\-stop\-daemon\fP [\fIoption\fP...] \fIcommand\fP
.
.SH 説明
\fBstart\-stop\-daemon\fP はシステムレベルのプロセスの生成や停止を制御するために使用される。また、
適切なオプションを指定することで、実行中のプロセスを確認することができる。
.PP
Note: unless \fB\-\-pid\fP or \fB\-\-pidfile\fP are specified, \fBstart\-stop\-daemon\fP
behaves similar to \fBkillall\fP(1).  \fBstart\-stop\-daemon\fP will scan the
process table looking for any processes which match the process name, parent
pid, uid, and/or gid (if specified). Any matching process will prevent
\fB\-\-start\fP from starting the daemon. All matching processes will be sent the
TERM signal (or the one specified via \fB\-\-signal\fP or \fB\-\-retry\fP) if
\fB\-\-stop\fP is specified. For daemons which have long\-lived children which
need to live through a \fB\-\-stop\fP, you must specify a pidfile.
.
.SH コマンド
.TP 
\fB\-S\fP, \fB\-\-start\fP [\fB\-\-\fP] \fIarguments\fP
指定されたプロセスの存在を確認する。該当するプロセスが存在する場合、 \fBstart\-stop\-daemon\fP は何もせず、エラーステータス 1
を返して終了する (\fB\-\-oknodo\fP が指定された場合は、0 を返す)。該当するプロセスが存在しない場合、 \fB\-\-exec\fP により、もしくは
\fB\-\-startas\fP が指定された場合はこれにより指定される実行ファイルを起動する。コマンドライン上で \fB\-\-\fP
以降に与えられた任意の引数は起動されるプログラムにそのまま引き渡される。
.TP 
\fB\-K\fP, \fB\-\-stop\fP
指定されたプロセスの存在を確認する。該当するプロセスが存在する場合、 \fBstart\-stop\-daemon\fP は \fB\-\-signal\fP
により指定されたシグナルをそのプロセスに送り、エラーステータス 0 を返して終了する。該当するプロセスが存在しない場合、
\fBstart\-stop\-daemon\fP はエラーステータス 1 を返して終了する( \fB\-\-oknodo\fP が指定された場合は 0
を返す)。\fB\-\-retry\fP を指定した場合、\fBstart\-stop\-daemon\fP はそのプロセスが終了したことを確認する。
.TP 
\fB\-T\fP, \fB\-\-status\fP
Check for the existence of a specified process, and returns an exit status
code, according to the LSB Init Script Actions (since version 1.16.1).
.TP 
\fB\-H\fP, \fB\-\-help\fP
使用方法に関する情報を表示し、終了する。
.TP 
\fB\-V\fP, \fB\-\-version\fP
バージョンと著作権に関する情報を表示し、終了する。
.
.SH オプション
.SS "Matching options"
.TP 
\fB\-\-pid\fP \fIpid\fP
Check for a process with the specified \fIpid\fP (since version 1.17.6).  The
\fIpid\fP must be a number greater than 0.
.TP 
\fB\-\-ppid\fP \fIppid\fP
Check for a process with the specified parent pid \fIppid\fP (since version
1.17.7).  The \fIppid\fP must be a number greater than 0.
.TP 
\fB\-p\fP, \fB\-\-pidfile\fP \fIpid\-file\fP
プロセスが \fIpid\-file\fP を作成したかどうかをチェックする。このオプションを単体で使用した場合、以前のプロセスが \fIpid\-file\fP
を削除できないまま終了してしまった際に、意図しないプロセスが動作中であると判断される場合があるため留意すること。
.TP 
\fB\-x\fP, \fB\-\-exec\fP \fIexecutable\fP
プロセスが指定した \fIexecutable\fP のインスタンスであるかどうかをチェックする。\fIexecutable\fP
引数は絶対パス名であること。インタプリタ型のスクリプトに対して指定した場合、executable
はインタプリタ自体を指してしまうため、期待する動作とならない点に留意すること。chroot
内で動作しているプロセスもマッチしてしまうため、これ以外の制約との組み合わせが必要となる点に注意すること。
.TP 
\fB\-n\fP, \fB\-\-name\fP \fIprocess\-name\fP
プロセスが \fIprocess\-name\fP であるかどうかをチェックする。\fIprocess\-name\fP
は通常プロセスのファイル名であるが、プロセス自身によって変更することも可能である。大半のシステムにおいて、この情報はカーネル内の process
comm name から取得されるため、比較的短い名称である必要がある (15 文字を超える名称は移植性がないと判断される)点に留意すること。
.TP 
\fB\-u\fP, \fB\-\-user\fP \fIusername\fP|\fIuid\fP
プロセスが \fIusername\fP もしくは \fIuid\fP
で指定されたユーザの所有となっているかをチェックする。このオプションを単体で用いた場合、指定されたユーザの所有するすべてのプロセスが合致するかをチェックする点に留意すること。
.
.SS "Generic options"
.TP 
\fB\-g\fP, \fB\-\-group\fP \fIgroup\fP|\fIgid\fP
プロセスを開始する時点で、\fIgroup\fP や \fIgid\fP を変更する。
.TP 
\fB\-s\fP, \fB\-\-signal\fP \fIsignal\fP
\fB\-\-stop\fP と同時に指定することで、プロセスを停止するために送信するシグナルを指定する (デフォルトは TERM)。
.TP 
\fB\-R\fP, \fB\-\-retry\fP \fItimeout\fP|\fIschedule\fP
\fB\-\-stop\fP と同時に指定することで、\fBstart\-stop\-daemon\fP
にプロセスの終了を確認させる。これにより、マッチした実行中のプロセスが全て終了するまで繰り返し確認が行われる。プロセスが終了しなければ、スケジュールにより指定されたアクションが実行される。

\fIschedule\fP のかわりに \fItimeout\fP が指定されている場合、
\fIsignal\fP\fB/\fP\fItimeout\fP\fB/KILL/\fP\fItimeout\fP スケジュールが使われる。ここで \fIsignal\fP は
\fB\-\-signal\fP で指定されるシグナルである。

スケジュール \fIschedule\fP は、スラッシュ (\fB/\fP) で区切られた少なくとも 2
つの要素からなるリストである。それぞれの要素は、\fB\-\fP\fIsignal\-number\fP もしくは [\fB\-\fP]\fIsignal\-name\fP
の場合は送るべきシグナル、 \fItimeout\fP の場合はプロセスが終了するのを待つ秒数、 \fBforever\fP の場合は必要な限り、残りの
\fIschedule\fP を繰り返し適用することを意味する。

\fIschedule\fP が終了し、\fBforever\fP が指定されていない場合、 \fBstart\-stop\-daemon\fP はエラー状態 2
で終了する。schedule が指定されている場合、\fB\-\-signal\fP で指定したシグナルは無視される。
.TP 
\fB\-a\fP, \fB\-\-startas\fP \fIpathname\fP
\fB\-\-start\fP と同時に指定することで、\fIpathname\fP により指定されるプロセスを起動する。このオプションが指定されない場合、
\fB\-\-exec\fP に与えられる引数がデフォルトになる。
.TP 
\fB\-t\fP, \fB\-\-test\fP
実行しようとする処理内容を出力し，それに伴い適切な返り値が設定されるが、実際の処理は行わない。
.TP 
\fB\-o\fP, \fB\-\-oknodo\fP
処理が何も行われない (又は、行なわれないと想定される) 場合、終了ステータス 1 のかわりに 0 を返す。
.TP 
\fB\-q\fP, \fB\-\-quiet\fP
情報メッセージを出力しない。エラーメッセージのみ出力する。
.TP 
\fB\-c\fP, \fB\-\-chuid\fP \fIusername\fP|\fIuid\fP[\fB:\fP\fIgroup\fP|\fIgid\fP]
Change to this username/uid before starting the process. You can also
specify a group by appending a \fB:\fP, then the group or gid in the same way
as you would for the \fBchown\fP(1) command (\fIuser\fP\fB:\fP\fIgroup\fP).  If a user
is specified without a group, the primary GID for that user is used.  When
using this option you must realize that the primary and supplemental groups
are set as well, even if the \fB\-\-group\fP option is not specified. The
\fB\-\-group\fP option is only for groups that the user isn't normally a member
of (like adding per process group membership for generic users like
\fBnobody\fP).
.TP 
\fB\-r\fP, \fB\-\-chroot\fP \fIroot\fP
プロセスを起動する前に、\fIroot\fP に対して chdir と chroot を実行する。pidfile は chroot
後に、書き出されることに注意すること。
.TP 
\fB\-d\fP, \fB\-\-chdir\fP \fIpath\fP
Chdir to \fIpath\fP before starting the process. This is done after the chroot
if the \fB\-r\fP|\fB\-\-chroot\fP option is set. When not specified,
\fBstart\-stop\-daemon\fP will chdir to the root directory before starting the
process.
.TP 
\fB\-b\fP, \fB\-\-background\fP
Typically used with programs that don't detach on their own. This option
will force \fBstart\-stop\-daemon\fP to fork before starting the process, and
force it into the background.  \fBWarning: start\-stop\-daemon\fP cannot check
the exit status if the process fails to execute for \fBany\fP reason. This is a
last resort, and is only meant for programs that either make no sense
forking on their own, or where it's not feasible to add the code for them to
do this themselves.
.TP 
\fB\-C\fP, \fB\-\-no\-close\fP
Do not close any file descriptor when forcing the daemon into the background
(since version 1.16.5).  Used for debugging purposes to see the process
output, or to redirect file descriptors to log the process output.  Only
relevant when using \fB\-\-background\fP.
.TP 
\fB\-N\fP, \fB\-\-nicelevel\fP \fIint\fP
プロセスを起動する前にプロセスのプライオリティを変更する。
.TP 
\fB\-P\fP, \fB\-\-procsched\fP \fIpolicy\fP\fB:\fP\fIpriority\fP
This alters the process scheduler policy and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 0. The currently supported policy values are \fBother\fP, \fBfifo\fP and \fBrr\fP.
.TP 
\fB\-I\fP, \fB\-\-iosched\fP \fIclass\fP\fB:\fP\fIpriority\fP
This alters the IO scheduler class and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 4, unless \fIclass\fP is \fBidle\fP, then \fIpriority\fP will always be 7. The
currently supported values for \fIclass\fP are \fBidle\fP, \fBbest\-effort\fP and
\fBreal\-time\fP.
.TP 
\fB\-k\fP, \fB\-\-umask\fP \fImask\fP
This sets the umask of the process before starting it (since version
1.13.22).
.TP 
\fB\-m\fP, \fB\-\-make\-pidfile\fP
Used when starting a program that does not create its own pid file. This
option will make \fBstart\-stop\-daemon\fP create the file referenced with
\fB\-\-pidfile\fP and place the pid into it just before executing the
process. Note, the file will only be removed when stopping the program if
\fB\-\-remove\-pidfile\fP is used.  \fBNote:\fP This feature may not work in all
cases. Most notably when the program being executed forks from its main
process. Because of this, it is usually only useful when combined with the
\fB\-\-background\fP option.
.TP 
\fB\-\-remove\-pidfile\fP
Used when stopping a program that does not remove its own pid file (since
version 1.17.19).  This option will make \fBstart\-stop\-daemon\fP remove the
file referenced with \fB\-\-pidfile\fP after terminating the process.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
詳細な情報を出力する。
.
.SH 終了ステータス
.TP 
\fB0\fP
指定されたアクションが実行された。\fB\-\-oknodo\fP が指定された場合、何も行われなかった場合も意味する。これは、\fB\-\-start\fP
が指定されたがマッチするプロセスが実行されていた場合、\fB\-\-stop\fP が指定されたがマッチするプロセスが存在しなかった場合に発生しうる。
.TP 
\fB1\fP
\fB\-\-oknodo\fP が指定されなかった場合に、何も行われなかった。
.TP 
\fB2\fP
\fB\-\-stop\fP および \fB\-\-retry\fP が指定されたが、規定時間の最後まで到達したにも関わらず、プロセスがまだ実行されている。
.TP 
\fB3\fP
その他のエラー。
.PP
\fB\-\-status\fP コマンドを実行した際には、以下の戻り値が返される:
.TP 
\fB0\fP
プログラムは実行中である。
.TP 
\fB1\fP
プログラムは実行中でないが、pid ファイルが存在している。
.TP 
\fB3\fP
プログラムは実行中でない。
.TP 
\fB4\fP
プログラムの状況を確認できない。
.
.SH 例
既に実行中でない場合に、\fBfood\fP デーモンを (プロセス名 food、実行ユーザ food 、PID 情報を food.pid に格納で)
起動する。
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-startas /usr/sbin/food \e
	\-\-chuid food \-\- \-\-daemon
.fi
.PP
\fBfood\fP に \fBSIGTERM\fP を送信し、停止するまで 5 秒間待機する:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry 5
.fi
.PP
\fBfood\fP 停止のためのカスタムスケジュールのデモ:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry=TERM/30/KILL/5
.fi
.SH 翻訳者
高橋 基信 <monyo@monyo.com>.
喜瀬 浩 <kise@fuyuneko.jp>.
関戸 幸一 <sekido@mbox.kyoto-inet.or.jp>.
鍋谷 栄展 <nabe@debian.or.jp>.
倉澤 望 <nabetaro@debian.or.jp>.
石川 睦 <ishikawa@linux.or.jp>.
鵜飼 文敏 <ukai@debian.or.jp>.
中野 武雄 <nakano@apm.seikei.ac.jp>.
.SH 翻訳校正
Debian JP Documentation ML <debian-doc@debian.or.jp>.
