// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
// ------------------------------------------------------------------------------
// Changes to this file must follow the http://aka.ms/api-review process.
// ------------------------------------------------------------------------------
[assembly: System.Runtime.CompilerServices.CompilationRelaxations(8)]
[assembly: System.Runtime.CompilerServices.RuntimeCompatibility(WrapNonExceptionThrows = true)]
[assembly: System.Diagnostics.Debuggable(System.Diagnostics.DebuggableAttribute.DebuggingModes.IgnoreSymbolStoreSequencePoints)]
[assembly: System.CLSCompliant(true)]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Credentials.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.SolutionRestoreManager.Test, PublicKey=002400000480000094000000060200000024000052534131000400000100010007d1fa57c4aed9f0a32e84aa0faefd0de9e8fd6aec8f87fb03766c834c99921eb23be79ad9d5dcc1dd9ad236132102900b723cf980957fc4e177108fc607774f29e8320e92ea05ece4e821c0a5efe8f1645c4c0c93c1ab99285d622caa652c1dfad63d745d6f2de5f17e5eaf0fc4963d261c8a12436518206dc093344d5ad293")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.VisualStudio.Implementation.Test, PublicKey=002400000480000094000000060200000024000052534131000400000100010007d1fa57c4aed9f0a32e84aa0faefd0de9e8fd6aec8f87fb03766c834c99921eb23be79ad9d5dcc1dd9ad236132102900b723cf980957fc4e177108fc607774f29e8320e92ea05ece4e821c0a5efe8f1645c4c0c93c1ab99285d622caa652c1dfad63d745d6f2de5f17e5eaf0fc4963d261c8a12436518206dc093344d5ad293")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Configuration.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("DynamicProxyGenAssembly2, PublicKey=0024000004800000940000000602000000240000525341310004000001000100c547cac37abd99c8db225ef2f6c8a3602f3b3606cc9891605d02baa56104f4cfc0734aa39b93bf7852f7d9266654753cc297e7d2edfe0bac1cdcf9f717241550e0a7b191195b7667bb4f64bcb8e2121380fd1d9d46ad2d92d2d15605093924cceaf74c4861eff62abf69b9291ed0a340e113be11e6a7d3113e92484cf7045cc7")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.DependencyResolver.Core.Tests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Commands.FuncTest, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Test.Utility, PublicKey=002400000480000094000000060200000024000052534131000400000100010007d1fa57c4aed9f0a32e84aa0faefd0de9e8fd6aec8f87fb03766c834c99921eb23be79ad9d5dcc1dd9ad236132102900b723cf980957fc4e177108fc607774f29e8320e92ea05ece4e821c0a5efe8f1645c4c0c93c1ab99285d622caa652c1dfad63d745d6f2de5f17e5eaf0fc4963d261c8a12436518206dc093344d5ad293")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Commands.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.Versioning.TargetFramework(".NETStandard,Version=v2.0", FrameworkDisplayName = ".NET Standard 2.0")]
[assembly: System.Reflection.AssemblyCompany("Microsoft Corporation")]
[assembly: System.Reflection.AssemblyConfiguration("release")]
[assembly: System.Reflection.AssemblyCopyright("© Microsoft Corporation. All rights reserved.")]
[assembly: System.Reflection.AssemblyDescription("NuGet's configuration settings implementation.")]
[assembly: System.Reflection.AssemblyFileVersion("6.7.0.127")]
[assembly: System.Reflection.AssemblyInformationalVersion("6.7.0+b46f5f64159a81d930ac8cdfde96e76f90796c62.b46f5f64159a81d930ac8cdfde96e76f90796c62")]
[assembly: System.Reflection.AssemblyProduct("NuGet")]
[assembly: System.Reflection.AssemblyTitle("NuGet.Configuration")]
[assembly: System.Reflection.AssemblyMetadata("RepositoryUrl", "https://github.com/NuGet/NuGet.Client")]
[assembly: System.Resources.NeutralResourcesLanguage("en-US")]
[assembly: System.Reflection.AssemblyVersionAttribute("6.7.0.127")]
[assembly: System.Runtime.CompilerServices.ReferenceAssembly]
[assembly: System.Reflection.AssemblyFlagsAttribute((System.Reflection.AssemblyNameFlags)0x70)]
namespace NuGet.Configuration
{
    public partial class AddItem : SettingItem
    {
        public AddItem(string key, string value, System.Collections.Generic.IReadOnlyDictionary<string, string> additionalAttributes) { }

        public AddItem(string key, string value) { }

        public System.Collections.Generic.IReadOnlyDictionary<string, string> AdditionalAttributes { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyCollection<string>> DisallowedValues { get { throw null; } }

        public override string ElementName { get { throw null; } }

        public string Key { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        public virtual string Value { get { throw null; } set { } }

        public void AddOrUpdateAdditionalAttribute(string attributeName, string value) { }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }

        public virtual string GetValueAsPath() { throw null; }
    }

    public sealed partial class AuthorItem : TrustedSignerItem
    {
        public AuthorItem(string name, params CertificateItem[] certificates) : base(default!, default!) { }

        public override string ElementName { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public sealed partial class CertificateItem : SettingItem
    {
        public CertificateItem(string fingerprint, Common.HashAlgorithmName hashAlgorithm, bool allowUntrustedRoot = false) { }

        public bool AllowUntrustedRoot { get { throw null; } set { } }

        public override string ElementName { get { throw null; } }

        public string Fingerprint { get { throw null; } set { } }

        public Common.HashAlgorithmName HashAlgorithm { get { throw null; } set { } }

        protected override System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public sealed partial class ClearItem : SettingItem
    {
        public override string ElementName { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }

        public override bool IsEmpty() { throw null; }
    }

    public partial class ClientCertificateProvider : IClientCertificateProvider
    {
        public ClientCertificateProvider(ISettings settings) { }

        public void AddOrUpdate(ClientCertItem item) { }

        public ClientCertItem GetClientCertificate(string packageSourceName) { throw null; }

        public System.Collections.Generic.IReadOnlyList<ClientCertItem> GetClientCertificates() { throw null; }

        public void Remove(System.Collections.Generic.IReadOnlyList<ClientCertItem> items) { }
    }

    public abstract partial class ClientCertItem : SettingItem
    {
        protected ClientCertItem(string packageSource) { }

        protected override bool CanHaveChildren { get { throw null; } }

        public string PackageSource { get { throw null; } }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }

        public abstract System.Collections.Generic.IEnumerable<System.Security.Cryptography.X509Certificates.X509Certificate> Search();
        protected void SetPackageSource(string value) { }
    }

    public static partial class ConfigurationConstants
    {
        public static readonly string ActivePackageSourceSectionName;
        public static readonly string Add;
        public static readonly string AllowUntrustedRoot;
        public static readonly string ApiKeys;
        public static readonly string Author;
        public static readonly string BeginIgnoreMarker;
        public static readonly string BindingRedirectsSection;
        public static readonly string Certificate;
        public static readonly string Clear;
        public static readonly string ClearTextPasswordAttribute;
        public static readonly string ClearTextPasswordToken;
        public static readonly string ClientCertificates;
        public static readonly string Config;
        public static readonly string Configuration;
        public static readonly string ConfigurationDefaultsFile;
        public static readonly string CredentialsSectionName;
        public static readonly string DefaultPackageManagementFormatKey;
        public static readonly string DefaultPushSource;
        public static readonly string DependencyVersion;
        public static readonly string DisabledPackageSources;
        public static readonly string DoNotShowPackageManagementSelectionKey;
        public static readonly string Enabled;
        public static readonly string EndIgnoreMarker;
        public static readonly string FailOnBindingRedirects;
        public static readonly string FallbackPackageFolders;
        public static readonly string FileCertificate;
        public static readonly string FindByAttribute;
        public static readonly string FindValueAttribute;
        public static readonly string Fingerprint;
        public static readonly string FingerprintAlgorithm;
        public static readonly string GlobalPackagesFolder;
        public static readonly string HashAlgorithm;
        public static readonly string HostKey;
        public static readonly string KeyAttribute;
        public static readonly string MaxHttpRequestsPerSource;
        public static readonly string NameAttribute;
        public static readonly string NoProxy;
        public static readonly string Owners;
        public static readonly string Package;
        public static readonly string PackageManagementSection;
        public static readonly string PackageRestore;
        public static readonly string PackageSourceAttribute;
        public static readonly string PackageSourceMapping;
        public static readonly string PackageSources;
        public static readonly string PasswordAttribute;
        public static readonly string PasswordKey;
        public static readonly string PasswordToken;
        public static readonly string PathAttribute;
        public static readonly string PatternAttribute;
        public static readonly string ProtocolVersionAttribute;
        public static readonly string Repository;
        public static readonly string RepositoryPath;
        public static readonly string ServiceIndex;
        public static readonly string SignatureValidationMode;
        public static readonly string SkipBindingRedirectsKey;
        public static readonly string StoreCertificate;
        public static readonly string StoreLocationAttribute;
        public static readonly string StoreNameAttribute;
        public static readonly string TrustedSigners;
        public static readonly string UpdatePackageLastAccessTime;
        public static readonly string UserKey;
        public static readonly string UsernameToken;
        public static readonly string ValidAuthenticationTypesToken;
        public static readonly string ValueAttribute;
    }

    public partial class ConfigurationDefaults
    {
        internal ConfigurationDefaults() { }

        public string DefaultPackageRestoreConsent { get { throw null; } }

        public System.Collections.Generic.IEnumerable<PackageSource> DefaultPackageSources { get { throw null; } }

        public string DefaultPushSource { get { throw null; } }

        public static ConfigurationDefaults Instance { get { throw null; } }
    }

    public enum CredentialRequestType
    {
        Proxy = 0,
        Unauthorized = 1,
        Forbidden = 2
    }

    public sealed partial class CredentialsItem : SettingItem
    {
        public CredentialsItem(string name, string username, string password, bool isPasswordClearText, string validAuthenticationTypes) { }

        protected override bool CanHaveChildren { get { throw null; } }

        public override string ElementName { get { throw null; } protected set { } }

        public bool IsPasswordClearText { get { throw null; } }

        public string Password { get { throw null; } }

        public string Username { get { throw null; } set { } }

        public string ValidAuthenticationTypes { get { throw null; } set { } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }

        public override bool IsEmpty() { throw null; }

        public void UpdatePassword(string password, bool isPasswordClearText = true) { }
    }

    public static partial class EncryptionUtility
    {
        public static string DecryptString(string encryptedString) { throw null; }

        public static string EncryptString(string value) { throw null; }
    }

    public sealed partial class FileClientCertItem : ClientCertItem
    {
        public FileClientCertItem(string packageSource, string filePath, string password, bool storePasswordInClearText, string settingsFilePath) : base(default!) { }

        protected override System.Collections.Generic.IReadOnlyCollection<string> AllowedAttributes { get { throw null; } }

        public override string ElementName { get { throw null; } }

        public string FilePath { get { throw null; } }

        public bool IsPasswordIsClearText { get { throw null; } }

        public string Password { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public override System.Collections.Generic.IEnumerable<System.Security.Cryptography.X509Certificates.X509Certificate> Search() { throw null; }

        public void Update(string filePath, string password, bool storePasswordInClearText) { }
    }

    public partial interface IClientCertificateProvider
    {
        void AddOrUpdate(ClientCertItem item);
        System.Collections.Generic.IReadOnlyList<ClientCertItem> GetClientCertificates();
        void Remove(System.Collections.Generic.IReadOnlyList<ClientCertItem> items);
    }

    public partial interface ICredentialCache
    {
        void Add(System.Uri uri, System.Net.ICredentials credentials);
        System.Net.ICredentials GetCredentials(System.Uri uri);
    }

    public partial interface ICredentialService
    {
        bool HandlesDefaultCredentials { get; }

        System.Threading.Tasks.Task<System.Net.ICredentials> GetCredentialsAsync(System.Uri uri, System.Net.IWebProxy proxy, CredentialRequestType type, string message, System.Threading.CancellationToken cancellationToken);
        bool TryGetLastKnownGoodCredentialsFromCache(System.Uri uri, bool isProxy, out System.Net.ICredentials credentials);
    }

    public partial interface IExtensionLocator
    {
        System.Collections.Generic.IEnumerable<string> FindCredentialProviders();
        System.Collections.Generic.IEnumerable<string> FindExtensions();
    }

    public partial interface IMachineWideSettings
    {
        ISettings Settings { get; }
    }

    public partial interface IPackageSourceProvider
    {
        string ActivePackageSourceName { get; }

        string DefaultPushSource { get; }

        event System.EventHandler PackageSourcesChanged;
        void AddPackageSource(PackageSource source);
        void DisablePackageSource(string name);
        void EnablePackageSource(string name);
        PackageSource GetPackageSourceByName(string name);
        PackageSource GetPackageSourceBySource(string source);
        bool IsPackageSourceEnabled(string name);
        System.Collections.Generic.IEnumerable<PackageSource> LoadPackageSources();
        void RemovePackageSource(string name);
        void SaveActivePackageSource(PackageSource source);
        void SavePackageSources(System.Collections.Generic.IEnumerable<PackageSource> sources);
        void UpdatePackageSource(PackageSource source, bool updateCredentials, bool updateEnabled);
    }

    [System.Obsolete("https://github.com/NuGet/Home/issues/10098")]
    public partial interface IPackageSourceProvider2 : IPackageSourceProvider
    {
        void SavePackageSources(System.Collections.Generic.IEnumerable<PackageSource> sources, PackageSourceUpdateOptions packageSourceUpdateOptions);
    }

    public partial interface IProxyCache
    {
        void Add(System.Net.IWebProxy proxy);
        System.Net.IWebProxy GetProxy(System.Uri uri);
    }

    public partial interface IProxyCredentialCache : System.Net.ICredentials
    {
        System.Guid Version { get; }

        void UpdateCredential(System.Uri proxyAddress, System.Net.NetworkCredential credentials);
    }

    public partial interface ISettings
    {
        event System.EventHandler SettingsChanged;
        void AddOrUpdate(string sectionName, SettingItem item);
        System.Collections.Generic.IList<string> GetConfigFilePaths();
        System.Collections.Generic.IList<string> GetConfigRoots();
        SettingSection GetSection(string sectionName);
        void Remove(string sectionName, SettingItem item);
        void SaveToDisk();
    }

    public partial class NuGetConfigurationException : System.Exception
    {
        protected NuGetConfigurationException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }

        public NuGetConfigurationException(string message, System.Exception innerException) { }

        public NuGetConfigurationException(string message) { }
    }

    public static partial class NuGetConstants
    {
        public static readonly string DefaultConfigContent;
        public static readonly string DefaultGalleryServerUrl;
        public static readonly string FeedName;
        public static readonly string ManifestExtension;
        public static readonly string ManifestSymbolsExtension;
        public static readonly string NuGetHostName;
        public static readonly string NuGetSolutionSettingsFolder;
        public static readonly string NuGetSymbolHostName;
        public static readonly string PackageExtension;
        public static readonly string PackageReferenceFile;
        public static readonly string PackageSpecFileName;
        public static readonly string ReadmeExtension;
        public static readonly string ReadmeFileName;
        public static readonly string SnupkgExtension;
        public static readonly string SymbolsExtension;
        public static readonly string V1FeedUrl;
        public const string V2FeedUrl = "https://www.nuget.org/api/v2/";
        public static readonly string V2LegacyFeedUrl;
        public static readonly string V2LegacyOfficialPackageSourceUrl;
        public const string V3FeedUrl = "https://api.nuget.org/v3/index.json";
    }

    public partial class NuGetPathContext : Common.INuGetPathContext
    {
        public System.Collections.Generic.IReadOnlyList<string> FallbackPackageFolders { get { throw null; } }

        public string HttpCacheFolder { get { throw null; } }

        public string UserPackageFolder { get { throw null; } }

        public static NuGetPathContext Create(ISettings settings) { throw null; }

        public static NuGetPathContext Create(string settingsRoot) { throw null; }
    }

    public partial class NullSettings : ISettings
    {
        public static NullSettings Instance { get { throw null; } }

        public event System.EventHandler SettingsChanged { add { } remove { } }

        public void AddOrUpdate(string sectionName, SettingItem item) { }

        public System.Collections.Generic.IList<string> GetConfigFilePaths() { throw null; }

        public System.Collections.Generic.IList<string> GetConfigRoots() { throw null; }

        public SettingSection GetSection(string sectionName) { throw null; }

        public void Remove(string sectionName, SettingItem item) { }

        public void SaveToDisk() { }
    }

    public sealed partial class OwnersItem : SettingItem
    {
        public static readonly char OwnersListSeparator;
        public OwnersItem(string owners) { }

        protected override bool CanHaveChildren { get { throw null; } }

        public System.Collections.Generic.IList<string> Content { get { throw null; } }

        public override string ElementName { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public sealed partial class PackagePatternItem : SettingItem
    {
        public PackagePatternItem(string pattern) { }

        public override string ElementName { get { throw null; } }

        public string Pattern { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public partial class PackageSource : System.IEquatable<PackageSource>
    {
        public const int DefaultProtocolVersion = 2;
        public PackageSource(string source, string name, bool isEnabled, bool isOfficial, bool isPersistable = true) { }

        public PackageSource(string source, string name, bool isEnabled) { }

        public PackageSource(string source, string name) { }

        public PackageSource(string source) { }

        public System.Collections.Generic.IReadOnlyList<System.Security.Cryptography.X509Certificates.X509Certificate>? ClientCertificates { get { throw null; } set { } }

        public PackageSourceCredential? Credentials { get { throw null; } set { } }

        public string? Description { get { throw null; } set { } }

        public bool IsEnabled { get { throw null; } set { } }

        public bool IsHttp { get { throw null; } }

        public bool IsHttps { get { throw null; } }

        public bool IsLocal { get { throw null; } }

        public bool IsMachineWide { get { throw null; } set { } }

        public bool IsOfficial { get { throw null; } set { } }

        public bool IsPersistable { get { throw null; } }

        public int MaxHttpRequestsPerSource { get { throw null; } set { } }

        public string Name { get { throw null; } }

        public int ProtocolVersion { get { throw null; } set { } }

        public string Source { get { throw null; } set { } }

        public System.Uri SourceUri { get { throw null; } }

        public System.Uri? TrySourceAsUri { get { throw null; } }

        public SourceItem AsSourceItem() { throw null; }

        public PackageSource Clone() { throw null; }

        public bool Equals(PackageSource? other) { throw null; }

        public override bool Equals(object? obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class PackageSourceCredential : System.IEquatable<PackageSourceCredential>
    {
        public PackageSourceCredential(string source, string username, string passwordText, bool isPasswordClearText, string validAuthenticationTypesText) { }

        public bool IsPasswordClearText { get { throw null; } }

        public string Password { get { throw null; } }

        public string PasswordText { get { throw null; } }

        public string Source { get { throw null; } }

        public string Username { get { throw null; } }

        public System.Collections.Generic.IEnumerable<string> ValidAuthenticationTypes { get { throw null; } }

        public string ValidAuthenticationTypesText { get { throw null; } }

        public CredentialsItem AsCredentialsItem() { throw null; }

        public bool Equals(PackageSourceCredential other) { throw null; }

        public override bool Equals(object other) { throw null; }

        public static PackageSourceCredential FromUserInput(string source, string username, string password, bool storePasswordInClearText, string validAuthenticationTypesText) { throw null; }

        public override int GetHashCode() { throw null; }

        public bool IsValid() { throw null; }

        public System.Net.ICredentials ToICredentials() { throw null; }
    }

    public partial class PackageSourceMapping
    {
        public PackageSourceMapping(System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyList<string>> patterns) { }

        public bool IsEnabled { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<string> GetConfiguredPackageSources(string packageId) { throw null; }

        public static PackageSourceMapping GetPackageSourceMapping(ISettings settings) { throw null; }

        public string SearchForPattern(string packageId) { throw null; }
    }

    public partial class PackageSourceMappingProvider
    {
        public PackageSourceMappingProvider(ISettings settings, bool shouldSkipSave) { }

        public PackageSourceMappingProvider(ISettings settings) { }

        public bool ShouldSkipSave { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<PackageSourceMappingSourceItem> GetPackageSourceMappingItems() { throw null; }

        public void SavePackageSourceMappings(System.Collections.Generic.IReadOnlyList<PackageSourceMappingSourceItem> packageSourceMappingsSourceItems) { }
    }

    public partial class PackageSourceMappingSourceItem : SettingItem
    {
        public PackageSourceMappingSourceItem(string name, System.Collections.Generic.IEnumerable<PackagePatternItem> packagePatternItems) { }

        protected override bool CanHaveChildren { get { throw null; } }

        public override string ElementName { get { throw null; } }

        public virtual string Key { get { throw null; } }

        public System.Collections.Generic.IList<PackagePatternItem> Patterns { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }

        protected void SetKey(string value) { }
    }

    public partial class PackageSourceProvider : IPackageSourceProvider, IPackageSourceProvider2
    {
        [System.Obsolete("https://github.com/NuGet/Home/issues/8479")]
        public PackageSourceProvider(ISettings settings, bool enablePackageSourcesChangedEvent) { }

        [System.Obsolete("https://github.com/NuGet/Home/issues/8479")]
        public PackageSourceProvider(ISettings settings, System.Collections.Generic.IEnumerable<PackageSource> configurationDefaultSources, bool enablePackageSourcesChangedEvent) { }

        public PackageSourceProvider(ISettings settings, System.Collections.Generic.IEnumerable<PackageSource> configurationDefaultSources) { }

        public PackageSourceProvider(ISettings settings) { }

        public string ActivePackageSourceName { get { throw null; } }

        public string DefaultPushSource { get { throw null; } }

        public ISettings Settings { get { throw null; } }

        public event System.EventHandler PackageSourcesChanged { add { } remove { } }

        public void AddPackageSource(PackageSource source) { }

        [System.Obsolete("DisablePackageSource(PackageSource source) is deprecated. Please use DisablePackageSource(string name) instead.")]
        public void DisablePackageSource(PackageSource source) { }

        public void DisablePackageSource(string name) { }

        public void EnablePackageSource(string name) { }

        public PackageSource GetPackageSourceByName(string name) { throw null; }

        public PackageSource GetPackageSourceBySource(string source) { throw null; }

        public System.Collections.Generic.HashSet<string> GetPackageSourceNamesMatchingNamePrefix(string namePrefix) { throw null; }

        [System.Obsolete("IsPackageSourceEnabled(PackageSource source) is deprecated. Please use IsPackageSourceEnabled(string name) instead.")]
        public bool IsPackageSourceEnabled(PackageSource source) { throw null; }

        public bool IsPackageSourceEnabled(string name) { throw null; }

        public System.Collections.Generic.IEnumerable<PackageSource> LoadPackageSources() { throw null; }

        public static System.Collections.Generic.IEnumerable<PackageSource> LoadPackageSources(ISettings settings) { throw null; }

        public void RemovePackageSource(string name) { }

        public void SaveActivePackageSource(PackageSource source) { }

        [System.Obsolete("https://github.com/NuGet/Home/issues/10098")]
        public void SavePackageSources(System.Collections.Generic.IEnumerable<PackageSource> sources, PackageSourceUpdateOptions sourceUpdateSettings) { }

        public void SavePackageSources(System.Collections.Generic.IEnumerable<PackageSource> sources) { }

        public void UpdatePackageSource(PackageSource source, bool updateCredentials, bool updateEnabled) { }
    }

    [System.Obsolete("https://github.com/NuGet/Home/issues/10098")]
    public sealed partial class PackageSourceUpdateOptions
    {
        public static readonly PackageSourceUpdateOptions Default;
        public PackageSourceUpdateOptions(bool updateCredentials, bool updateEnabled) { }

        public bool UpdateCredentials { get { throw null; } }

        public bool UpdateEnabled { get { throw null; } }
    }

    public partial class ProxyCache : IProxyCache, IProxyCredentialCache, System.Net.ICredentials
    {
        public ProxyCache(ISettings settings, Common.IEnvironmentVariableReader environment) { }

        public static ProxyCache Instance { get { throw null; } }

        public System.Guid Version { get { throw null; } }

        [System.Obsolete("Retained for backcompat only. Use UpdateCredential instead")]
        public void Add(System.Net.IWebProxy proxy) { }

        public System.Net.NetworkCredential GetCredential(System.Uri proxyAddress, string authType) { throw null; }

        public System.Net.IWebProxy GetProxy(System.Uri sourceUri) { throw null; }

        public WebProxy GetUserConfiguredProxy() { throw null; }

        public void UpdateCredential(System.Uri proxyAddress, System.Net.NetworkCredential credentials) { }
    }

    public sealed partial class RepositoryItem : TrustedSignerItem
    {
        public RepositoryItem(string name, string serviceIndex, params CertificateItem[] certificates) : base(default!, default!) { }

        public RepositoryItem(string name, string serviceIndex, string owners, params CertificateItem[] certificates) : base(default!, default!) { }

        public override string ElementName { get { throw null; } }

        public new string Name { get { throw null; } set { } }

        public System.Collections.Generic.IList<string> Owners { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        public string ServiceIndex { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public abstract partial class SettingBase
    {
        public abstract SettingBase Clone();
        public abstract bool IsEmpty();
    }

    public abstract partial class SettingElement : SettingBase
    {
        protected SettingElement() { }

        protected SettingElement(System.Collections.Generic.IReadOnlyDictionary<string, string> attributes) { }

        protected virtual System.Collections.Generic.IReadOnlyCollection<string> AllowedAttributes { get { throw null; } }

        protected virtual System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyCollection<string>> AllowedValues { get { throw null; } }

        protected virtual System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyCollection<string>> DisallowedValues { get { throw null; } }

        public virtual string ElementName { get { throw null; } protected set { } }

        protected System.Collections.Generic.Dictionary<string, string> MutableAttributes { get { throw null; } }

        protected virtual System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        protected void AddAttribute(string attributeName, string value) { }

        protected void AddOrUpdateAttribute(string attributeName, string value) { }

        public override bool IsEmpty() { throw null; }
    }

    public enum SettingElementType
    {
        Unknown = 0,
        Configuration = 1,
        ActivePackageSource = 2,
        BindingRedirects = 3,
        Config = 4,
        PackageManagement = 5,
        PackageRestore = 6,
        PackageSourceCredentials = 7,
        PackageSources = 8,
        Add = 9,
        Author = 10,
        Certificate = 11,
        Clear = 12,
        Owners = 13,
        Repository = 14,
        FileCert = 15,
        StoreCert = 16,
        PackageSourceMapping = 17,
        PackageSource = 18,
        Package = 19
    }

    public abstract partial class SettingItem : SettingElement
    {
        protected SettingItem() { }

        protected SettingItem(System.Collections.Generic.IReadOnlyDictionary<string, string> attributes) { }

        protected virtual bool CanHaveChildren { get { throw null; } }
    }

    public partial class Settings : ISettings
    {
        public static readonly string DefaultSettingsFileName;
        public static readonly string[] OrderedSettingsFileNames;
        public static readonly string[] SupportedMachineWideConfigExtension;
        public Settings(string root, string fileName, bool isMachineWide) { }

        public Settings(string root, string fileName) { }

        public Settings(string root) { }

        public event System.EventHandler SettingsChanged { add { } remove { } }

        public void AddOrUpdate(string sectionName, SettingItem item) { }

        public static string ApplyEnvironmentTransform(string value) { throw null; }

        public System.Collections.Generic.IList<string> GetConfigFilePaths() { throw null; }

        public System.Collections.Generic.IList<string> GetConfigRoots() { throw null; }

        public static System.Tuple<string, string> GetFileNameAndItsRoot(string root, string settingsPath) { throw null; }

        public SettingSection GetSection(string sectionName) { throw null; }

        public static ISettings LoadDefaultSettings(string root, string configFileName, IMachineWideSettings machineWideSettings, SettingsLoadingContext settingsLoadingContext) { throw null; }

        public static ISettings LoadDefaultSettings(string root, string configFileName, IMachineWideSettings machineWideSettings) { throw null; }

        public static ISettings LoadDefaultSettings(string root) { throw null; }

        public static ISettings LoadImmutableSettingsGivenConfigPaths(System.Collections.Generic.IList<string> configFilePaths, SettingsLoadingContext settingsLoadingContext) { throw null; }

        public static ISettings LoadMachineWideSettings(string root, params string[] paths) { throw null; }

        public static ISettings LoadSettingsGivenConfigPaths(System.Collections.Generic.IList<string> configFilePaths) { throw null; }

        public static ISettings LoadSpecificSettings(string root, string configFileName) { throw null; }

        public void Remove(string sectionName, SettingItem item) { }

        public void SaveToDisk() { }
    }

    public abstract partial class SettingSection : SettingsGroup<SettingItem>
    {
        protected SettingSection(string name, System.Collections.Generic.IReadOnlyDictionary<string, string> attributes, System.Collections.Generic.IEnumerable<SettingItem> children) { }

        public override string ElementName { get { throw null; } protected set { } }

        public System.Collections.Generic.IReadOnlyCollection<SettingItem> Items { get { throw null; } }

        public override bool Equals(object other) { throw null; }

        public T GetFirstItemWithAttribute<T>(string attributeName, string expectedAttributeValue)
            where T : SettingItem { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public abstract partial class SettingsGroup<T> : SettingElement where T : SettingElement
    {
        protected SettingsGroup() { }

        protected SettingsGroup(System.Collections.Generic.IReadOnlyDictionary<string, string> attributes, System.Collections.Generic.IEnumerable<T> children) { }

        protected virtual bool CanBeCleared { get { throw null; } }

        protected System.Collections.Generic.IList<T> Children { get { throw null; } }

        public override bool IsEmpty() { throw null; }

        protected bool TryGetChild(T expectedChild, out T currentChild) { throw null; }
    }

    public sealed partial class SettingsLoadingContext : System.IDisposable
    {
        public void Dispose() { }
    }

    public static partial class SettingsUtility
    {
        public static readonly string DefaultGlobalPackagesFolderPath;
        public static bool DeleteConfigValue(ISettings settings, string key) { throw null; }

        public static bool DeleteValue(ISettings settings, string section, string attributeKey, string attributeValue) { throw null; }

        public static string GetConfigValue(ISettings settings, string key, bool decrypt = false, bool isPath = false) { throw null; }

        public static string GetDecryptedValueForAddItem(ISettings settings, string section, string key, bool isPath = false) { throw null; }

        public static string GetDefaultPushSource(ISettings settings) { throw null; }

        public static System.Collections.Generic.IEnumerable<PackageSource> GetEnabledSources(ISettings settings) { throw null; }

        public static System.Collections.Generic.IReadOnlyList<string> GetFallbackPackageFolders(ISettings settings) { throw null; }

        public static string GetGlobalPackagesFolder(ISettings settings) { throw null; }

        public static string GetHttpCacheFolder() { throw null; }

        public static int GetMaxHttpRequest(ISettings settings) { throw null; }

        public static string GetPluginsCacheFolder() { throw null; }

        public static string GetRepositoryPath(ISettings settings) { throw null; }

        public static Common.RevocationMode GetRevocationMode(Common.IEnvironmentVariableReader environmentVariableReader = null) { throw null; }

        public static Common.SignatureValidationMode GetSignatureValidationMode(ISettings settings) { throw null; }

        public static bool GetUpdatePackageLastAccessTimeEnabledStatus(ISettings settings) { throw null; }

        public static string GetValueForAddItem(ISettings settings, string section, string key, bool isPath = false) { throw null; }

        public static void SetConfigValue(ISettings settings, string key, string value, bool encrypt = false) { }

        public static void SetEncryptedValueForAddItem(ISettings settings, string section, string key, string value) { }
    }

    public sealed partial class SettingText : SettingBase
    {
        public SettingText(string value) { }

        public string Value { get { throw null; } set { } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }

        public override bool IsEmpty() { throw null; }
    }

    public sealed partial class SourceItem : AddItem
    {
        public SourceItem(string key, string value, string protocolVersion = "") : base(default!, default!) { }

        public string ProtocolVersion { get { throw null; } set { } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public sealed partial class StoreClientCertItem : ClientCertItem
    {
        public StoreClientCertItem(string packageSource, string findValue, System.Security.Cryptography.X509Certificates.StoreLocation? storeLocation = null, System.Security.Cryptography.X509Certificates.StoreName? storeName = null, System.Security.Cryptography.X509Certificates.X509FindType? findBy = null) : base(default!) { }

        protected override System.Collections.Generic.IReadOnlyCollection<string> AllowedAttributes { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyCollection<string>> AllowedValues { get { throw null; } }

        public override string ElementName { get { throw null; } }

        public System.Security.Cryptography.X509Certificates.X509FindType FindType { get { throw null; } }

        public string FindValue { get { throw null; } }

        protected override System.Collections.Generic.IReadOnlyCollection<string> RequiredAttributes { get { throw null; } }

        public System.Security.Cryptography.X509Certificates.StoreLocation StoreLocation { get { throw null; } }

        public System.Security.Cryptography.X509Certificates.StoreName StoreName { get { throw null; } }

        public override SettingBase Clone() { throw null; }

        public static string GetString(System.Security.Cryptography.X509Certificates.StoreLocation storeLocation) { throw null; }

        public static string GetString(System.Security.Cryptography.X509Certificates.StoreName storeName) { throw null; }

        public static string GetString(System.Security.Cryptography.X509Certificates.X509FindType type) { throw null; }

        public override System.Collections.Generic.IEnumerable<System.Security.Cryptography.X509Certificates.X509Certificate> Search() { throw null; }

        public void Update(string findValue, System.Security.Cryptography.X509Certificates.StoreLocation? storeLocation = null, System.Security.Cryptography.X509Certificates.StoreName? storeName = null, System.Security.Cryptography.X509Certificates.X509FindType? findBy = null) { }
    }

    public abstract partial class TrustedSignerItem : SettingItem
    {
        protected TrustedSignerItem(string name, System.Collections.Generic.IEnumerable<CertificateItem> certificates) { }

        protected override bool CanHaveChildren { get { throw null; } }

        public System.Collections.Generic.IList<CertificateItem> Certificates { get { throw null; } }

        public virtual string Name { get { throw null; } }

        protected void SetName(string value) { }
    }

    public sealed partial class UnknownItem : SettingItem
    {
        public UnknownItem(string name, System.Collections.Generic.IReadOnlyDictionary<string, string> attributes, System.Collections.Generic.IEnumerable<SettingBase> children) { }

        public System.Collections.Generic.IReadOnlyDictionary<string, string> Attributes { get { throw null; } }

        protected override bool CanHaveChildren { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<SettingBase> Children { get { throw null; } }

        public override string ElementName { get { throw null; } protected set { } }

        public override SettingBase Clone() { throw null; }

        public override bool Equals(object other) { throw null; }

        public override int GetHashCode() { throw null; }

        public override bool IsEmpty() { throw null; }
    }

    public sealed partial class VirtualSettingSection : SettingSection
    {
        internal VirtualSettingSection() : base(default!, default!, default!) { }

        public override SettingBase Clone() { throw null; }
    }

    public partial class WebProxy : System.Net.IWebProxy
    {
        public WebProxy(string proxyAddress) { }

        public WebProxy(System.Uri proxyAddress) { }

        public System.Collections.Generic.IReadOnlyList<string> BypassList { get { throw null; } set { } }

        public System.Net.ICredentials Credentials { get { throw null; } set { } }

        public System.Uri ProxyAddress { get { throw null; } }

        public System.Uri GetProxy(System.Uri destination) { throw null; }

        public bool IsBypassed(System.Uri uri) { throw null; }
    }

    public partial class XPlatMachineWideSetting : IMachineWideSettings
    {
        public ISettings Settings { get { throw null; } }
    }
}