/*
 * Decompiled with CFR 0.152.
 */
package virtual.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import virtual.tools.IntegerDocument;

public class SliderPanel
extends JPanel {
    JLabel lSliderLabel = new JLabel();
    JTextField tfSliderTextField = new JTextField();
    JSlider slSlider;
    JLabel lUnitLabel = new JLabel();
    private String label;
    private String unit = "";
    private int iminimum;
    private int imaximum;
    private int itminimum;
    private int itmaximum;
    private String strtoolTip = "";
    private int imajorspacing = 1000;
    private int iminorspacing = 0;
    private boolean ignoreStateChange = false;
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public SliderPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SliderPanel(String lab, int min, int max) {
        this.label = lab;
        this.iminimum = min;
        this.imaximum = max;
        this.itminimum = min;
        this.itmaximum = max;
    }

    public SliderPanel(String lab, int min, int max, String u) {
        this.label = lab;
        this.iminimum = min;
        this.imaximum = max;
        this.itminimum = min;
        this.itmaximum = max;
        this.unit = u;
    }

    public void fillPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setToolTip(String tip) {
        this.strtoolTip = tip;
    }

    public void setTextRange(int min, int max) {
        this.itminimum = min;
        this.itmaximum = max;
    }

    public void setTickSpacing(int major, int minor) {
        this.imajorspacing = major;
        this.iminorspacing = minor;
    }

    void jbInit() throws Exception {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(this.gridBagLayout1);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.insets = new Insets(0, 5, 0, 0);
        this.gridBagLayout1.setConstraints(this.lSliderLabel, c);
        this.add(this.lSliderLabel);
        this.lSliderLabel.setText(this.label);
        this.lSliderLabel.setForeground(Color.black);
        this.gridBagLayout1.setConstraints(this.tfSliderTextField, c);
        this.add(this.tfSliderTextField);
        this.tfSliderTextField.setDocument(new IntegerDocument());
        this.tfSliderTextField.setText("" + this.iminimum);
        c.gridwidth = 0;
        this.gridBagLayout1.setConstraints(this.lUnitLabel, c);
        this.add(this.lUnitLabel);
        this.lUnitLabel.setText(" " + this.unit);
        this.lUnitLabel.setForeground(Color.black);
        this.slSlider = new JSlider(0, this.iminimum, this.imaximum, this.iminimum);
        c.weightx = 3.0;
        c.weighty = 0.5;
        this.gridBagLayout1.setConstraints(this.slSlider, c);
        this.add(this.slSlider);
        this.slSlider.setToolTipText(this.strtoolTip);
        this.slSlider.setFont(new Font("Dialog", 0, 10));
        this.slSlider.setPaintLabels(true);
        this.slSlider.setMajorTickSpacing(this.imajorspacing);
        this.slSlider.setValue(this.iminimum);
        this.tfSliderTextField.setText("" + this.slSlider.getValue());
        if (this.iminorspacing > 0) {
            this.slSlider.setMinorTickSpacing(this.iminorspacing);
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.slSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SliderPanel.this.slSlider_stateChanged();
            }
        });
        this.tfSliderTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SliderPanel.this.tfSliderTextField_focusLost();
            }
        });
    }

    void slSlider_stateChanged() {
        int tr = this.slSlider.getValue();
        if (!this.ignoreStateChange) {
            this.tfSliderTextField.setText("" + tr);
        } else {
            this.ignoreStateChange = false;
        }
    }

    void tfSliderTextField_focusLost() {
        int tr;
        this.ignoreStateChange = true;
        try {
            tr = Integer.parseInt(this.tfSliderTextField.getText());
        }
        catch (Exception err) {
            tr = 0;
            Toolkit.getDefaultToolkit().beep();
            this.tfSliderTextField.setText("0");
        }
        if (tr > this.itmaximum) {
            tr = this.itmaximum;
            Toolkit.getDefaultToolkit().beep();
            this.tfSliderTextField.setText("" + tr);
        }
        if (tr < this.itminimum) {
            tr = this.itminimum;
            Toolkit.getDefaultToolkit().beep();
            this.tfSliderTextField.setText("" + tr);
        }
        this.slSlider.setValue(tr);
    }

    public int getValue() {
        return Integer.parseInt(this.tfSliderTextField.getText());
    }

    public void setValue(int ivalue) {
        this.slSlider.setValue(ivalue);
    }

    public JTextField getTextFieldReference() {
        return this.tfSliderTextField;
    }

    public void setSliderMinimum(int min) {
        this.slSlider.getModel().setMinimum(min);
    }

    public void setSliderMaximum(int max) {
        this.slSlider.getModel().setMaximum(max);
    }
}

