/*
 * Decompiled with CFR 0.152.
 */
package virtual.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import virtual.tools.FFTTools;
import virtual.tools.ImagePlus;
import virtual.tools.KSpaceCanvas;

public class KSpaceFrame
extends JFrame {
    private final int FRAME_WIDTH = 272;
    private final int FRAME_HEIGHT = 330;
    private ImagePlus ip;
    private Image magnitudeImage = null;
    private Image phaseImage = null;
    private Image realImage = null;
    private Image imagImage = null;
    JToggleButton tbMagnitudeImage = new JToggleButton();
    JToggleButton tbPhaseImage = new JToggleButton();
    JToggleButton tbFFTReal = new JToggleButton();
    JToggleButton tbFFTImag = new JToggleButton();
    ButtonGroup myButtonGroup = new ButtonGroup();
    KSpaceCanvas myCanvas = new KSpaceCanvas();

    public KSpaceFrame(ImagePlus imgp) {
        super(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspaceframe.title"));
        this.ip = imgp;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Dimension scrRes = this.getToolkit().getScreenSize();
        Dimension fs = this.getSize();
        this.setLocation((scrRes.width - fs.width) / 2, (scrRes.height - fs.height) / 2);
        this.calculateAndDisplayMagnitudeImage();
    }

    public Image convertIntArrayToImage(int[][] source) {
        int[] intArray = FFTTools.convertIntArrayToImage(source);
        Image dest = this.createImage(new MemoryImageSource(256, 256, intArray, 0, 256));
        return dest;
    }

    public void calculateAndDisplayMagnitudeImage() {
        if (this.magnitudeImage == null) {
            float[][] shiftedImgRe = FFTTools.shift(this.ip.getFFTImageReal(), 128, 128);
            float[][] shiftedImgIm = FFTTools.shift(this.ip.getFFTImageImag(), 128, 128);
            float[][] magImage = FFTTools.magnitude(shiftedImgRe, shiftedImgIm);
            float[][] magscaleImage = FFTTools.scaleMagnitude(magImage);
            int[][] windowedImg = FFTTools.autoWindow(magscaleImage);
            this.magnitudeImage = this.convertIntArrayToImage(windowedImg);
        }
        this.myCanvas.setImage(this.magnitudeImage);
        this.myCanvas.repaint();
    }

    public void calculateAndDisplayPhaseImage() {
        if (this.phaseImage == null) {
            float[][] phImage;
            float[][] shiftedImgRe = FFTTools.shift(this.ip.getFFTImageReal(), 128, 128);
            float[][] shiftedImgIm = FFTTools.shift(this.ip.getFFTImageImag(), 128, 128);
            float[][] phscaleImage = phImage = FFTTools.calcPhase(shiftedImgRe, shiftedImgIm);
            int[][] windowedImg = FFTTools.autoWindow(phscaleImage);
            this.phaseImage = this.convertIntArrayToImage(windowedImg);
        }
        this.myCanvas.setImage(this.phaseImage);
        this.myCanvas.repaint();
    }

    public void calculateAndDisplayRealImage() {
        if (this.realImage == null) {
            float[][] shiftedImgRe = FFTTools.shift(this.ip.getFFTImageReal(), 128, 128);
            float[][] magscaleImage = FFTTools.scaleMagnitude(shiftedImgRe);
            int[][] windowedImg = FFTTools.autoWindow(magscaleImage);
            this.realImage = this.convertIntArrayToImage(windowedImg);
        }
        this.myCanvas.setImage(this.realImage);
        this.myCanvas.repaint();
    }

    public void calculateAndDisplayImagImage() {
        if (this.imagImage == null) {
            float[][] shiftedImgIm = FFTTools.shift(this.ip.getFFTImageImag(), 128, 128);
            float[][] magscaleImage = FFTTools.scaleMagnitude(shiftedImgIm);
            int[][] windowedImg = FFTTools.autoWindow(magscaleImage);
            this.imagImage = this.convertIntArrayToImage(windowedImg);
        }
        this.myCanvas.setImage(this.imagImage);
        this.myCanvas.repaint();
    }

    private void jbInit() throws Exception {
        if (System.getSecurityManager() == null) {
            this.setSize(272, 330);
        } else {
            this.setSize(272, 348);
        }
        this.setResizable(false);
        this.tbMagnitudeImage.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspaceframe.btn.magnitude.title"));
        this.tbMagnitudeImage.setSelected(true);
        this.tbMagnitudeImage.setBounds(new Rectangle(5, 275, 59, 25));
        this.tbMagnitudeImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceFrame.this.calculateAndDisplayMagnitudeImage();
            }
        });
        this.tbPhaseImage.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspaceframe.btn.phase.title"));
        this.tbPhaseImage.setBounds(new Rectangle(71, 275, 59, 25));
        this.tbPhaseImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceFrame.this.calculateAndDisplayPhaseImage();
            }
        });
        this.tbFFTReal.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspaceframe.btn.real.title"));
        this.tbFFTReal.setBounds(new Rectangle(136, 275, 59, 25));
        this.tbFFTReal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceFrame.this.calculateAndDisplayRealImage();
            }
        });
        this.tbFFTImag.setText(ResourceBundle.getBundle("virtual/tools/resources/tools_loc").getString("kspaceframe.btn.imag.title"));
        this.tbFFTImag.setMargin(new Insets(2, 2, 2, 2));
        this.tbFFTImag.setBounds(new Rectangle(203, 275, 59, 25));
        this.tbFFTImag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KSpaceFrame.this.calculateAndDisplayImagImage();
            }
        });
        this.myButtonGroup.add(this.tbMagnitudeImage);
        this.myButtonGroup.add(this.tbPhaseImage);
        this.myButtonGroup.add(this.tbFFTReal);
        this.myButtonGroup.add(this.tbFFTImag);
        this.myCanvas.setBackground(new Color(204, 204, 204));
        this.myCanvas.setBounds(new Rectangle(5, 5, 256, 256));
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this.tbMagnitudeImage, null);
        this.getContentPane().add((Component)this.tbPhaseImage, null);
        this.getContentPane().add((Component)this.tbFFTReal, null);
        this.getContentPane().add((Component)this.tbFFTImag, null);
        this.getContentPane().add((Component)this.myCanvas, null);
    }
}

