/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import jigl.image.ComplexImage;
import jigl.image.RealGrayImage;
import virtual.mrt.sequences.Pulsesequence;
import virtual.tools.FFTTools;

public class TurboSpinEcho
extends Pulsesequence {
    final double DELTAB = 1.95E-8;
    final double GYRO = 42.6;
    private int trTime;
    private int teTime;
    private int etl;
    private int ESPTime;

    protected void addSequenceParameterToImage() {
        this.ResultIP.setTR(this.trTime);
        this.ResultIP.setTE(this.teTime);
        this.ResultIP.setETL(this.etl);
        this.ResultIP.setESP(this.ESPTime);
        this.ResultIP.setSequence("TSE");
    }

    public void calculate() {
        int y;
        int x;
        for (int x2 = 0; x2 < this.PDMatrix.length; ++x2) {
            for (int y2 = 0; y2 < this.PDMatrix[0].length; ++y2) {
                if (this.T1Matrix[x2][y2] == 0) {
                    this.T1Matrix[x2][y2] = 1;
                }
                if (this.T2Matrix[x2][y2] != 0) continue;
                this.T2Matrix[x2][y2] = 1;
            }
        }
        RealGrayImage origComImg = new RealGrayImage(256, 256);
        ComplexImage transComImg = new ComplexImage(256, 256);
        ComplexImage finalComImg = new ComplexImage(256, 256);
        ComplexImage refftComImg = new ComplexImage(256, 256);
        ComplexImage shiftedComImg = new ComplexImage(256, 256);
        int diff = 100000;
        int bestecho = 9999;
        for (int i = 0; i < this.etl; ++i) {
            int hlp = Math.abs(this.ESPTime * (i + 1) - this.teTime);
            if (hlp >= diff) continue;
            diff = hlp;
            bestecho = i + 1;
        }
        int[] echolines = new int[this.PDMatrix[0].length];
        boolean echodist = false;
        int uppos = 127;
        int downpos = 128;
        int range = this.PDMatrix.length / (2 * this.etl);
        for (int i = 0; i <= Math.max(bestecho, this.etl - bestecho); ++i) {
            int zeile = 0;
            if (bestecho + i <= this.etl) {
                for (zeile = uppos; zeile > uppos - range; --zeile) {
                    echolines[zeile] = bestecho + i - 1;
                }
                uppos = zeile;
                for (zeile = downpos; zeile < downpos + range; ++zeile) {
                    echolines[zeile] = bestecho + i - 1;
                }
            }
            downpos = zeile;
            if (i == 0 || bestecho - i <= 0) continue;
            for (zeile = uppos; zeile > uppos - range; --zeile) {
                echolines[zeile] = bestecho - i - 1;
            }
            uppos = zeile;
            for (zeile = downpos; zeile < downpos + range; ++zeile) {
                echolines[zeile] = bestecho - i - 1;
            }
            downpos = zeile;
        }
        this.progressBar.setMaximum(this.etl);
        for (int n = 0; n < this.etl; ++n) {
            this.progressBar.setValue(n);
            try {
                TurboSpinEcho.sleep(25L);
            }
            catch (Exception err) {
                // empty catch block
            }
            for (x = 0; x < this.PDMatrix.length; ++x) {
                for (y = 0; y < this.PDMatrix[0].length; ++y) {
                    int hlp = (int)((double)this.PDMatrix[x][y] * Math.exp((double)(-n - 1) * (double)this.ESPTime / (double)this.T2Matrix[x][y]) * (1.0 - Math.exp((double)(-this.trTime) / (double)this.T1Matrix[x][y])));
                    if (hlp < 0) {
                        System.out.println("Warnung: negativer Wert in TSE Matrix!");
                    }
                    origComImg.set(x, y, hlp);
                }
            }
            transComImg = FFTTools.forwardFFT(origComImg);
            for (x = 0; x < 256; ++x) {
                for (y = 0; y < 256; ++y) {
                    if (echolines[y] != n) continue;
                    finalComImg.setReal(x, y, transComImg.getReal(x, y));
                    finalComImg.setImag(x, y, transComImg.getImag(x, y));
                }
            }
        }
        ComplexImage finalFFTImg = new ComplexImage(256, 256);
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 256; ++y) {
                finalFFTImg.setReal(x, y, finalComImg.getReal(x, y));
                finalFFTImg.setImag(x, y, finalComImg.getImag(x, y));
            }
        }
        refftComImg = FFTTools.reverseFFT(finalFFTImg);
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 256; ++y) {
                this.IntensityMatrix[x][y] = (int)Math.sqrt(Math.pow(refftComImg.getReal(x, y), 2.0) + Math.pow(refftComImg.getImag(x, y), 2.0));
            }
        }
        super.calculate();
    }

    public void setTRTime(int tr) {
        this.trTime = tr;
    }

    public void setTETime(int te) {
        this.teTime = te;
    }

    public void setETL(int e) {
        this.etl = e;
    }

    public void setESPTime(int e) {
        this.ESPTime = e;
    }

    public int getTRTime() {
        return this.trTime;
    }
}

