/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import virtual.mrt.sequences.Pulsesequence;

public class SpinEcho
extends Pulsesequence {
    final double DELTAB = 1.95E-8;
    final double GYRO = 42.6;
    private int trTime;
    private int teTime;

    protected void addSequenceParameterToImage() {
        this.ResultIP.setTR(this.trTime);
        this.ResultIP.setTE(this.teTime);
        this.ResultIP.setSequence("SE");
    }

    public void calculate() {
        for (int x = 0; x < this.PDMatrix.length; ++x) {
            this.progressBar.setValue(x);
            try {
                if (x % 10 == 0) {
                    SpinEcho.sleep(5L);
                }
            }
            catch (Exception err) {
                // empty catch block
            }
            try {
                long remainingtime = this.trTime * (256 - x);
                this.myUIClass.displayRemainingTime(remainingtime);
                SpinEcho.sleep((long)((double)this.iTimeFactor / 100.0 * (double)this.trTime));
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int y = 0; y < this.PDMatrix[0].length; ++y) {
                if (this.T1Matrix[x][y] == 0) {
                    this.T1Matrix[x][y] = 1;
                }
                if (this.T2Matrix[x][y] == 0) {
                    this.T2Matrix[x][y] = 1;
                }
                this.IntensityMatrix[x][y] = (int)((double)this.PDMatrix[x][y] * Math.exp((double)(-this.teTime) / (double)this.T2Matrix[x][y]) * (1.0 - Math.exp((double)(-this.trTime) / (double)this.T1Matrix[x][y])));
            }
        }
        super.calculate();
    }

    public void setTRTime(int tr) {
        this.trTime = tr;
    }

    public void setTETime(int te) {
        this.teTime = te;
    }

    public int getTRTime() {
        return this.trTime;
    }
}

