/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import virtual.mrt.sequences.Pulsesequence;

public class SaturationRecovery
extends Pulsesequence {
    final double DELTAB = 1.95E-8;
    final double GYRO = 42.6;
    private int trTime;

    protected void addSequenceParameterToImage() {
        this.ResultIP.setTR(this.trTime);
        this.ResultIP.setSequence("SR");
    }

    public void calculate() {
        for (int x = 0; x < this.PDMatrix.length; ++x) {
            this.progressBar.setValue(x);
            try {
                if (x % 10 == 0) {
                    SaturationRecovery.sleep(5L);
                }
            }
            catch (Exception err) {
                // empty catch block
            }
            try {
                int nex = this.myUIClass.pNEX.getValue();
                long remainingtime = this.trTime * (256 - x) * nex;
                this.myUIClass.displayRemainingTime(remainingtime);
                SaturationRecovery.sleep((long)((double)this.iTimeFactor / 100.0 * (double)this.trTime));
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int y = 0; y < this.PDMatrix[0].length; ++y) {
                if (this.T1Matrix[x][y] == 0) {
                    this.T1Matrix[x][y] = 1;
                }
                this.IntensityMatrix[x][y] = (int)((double)this.PDMatrix[x][y] * (1.0 - Math.exp((double)(-this.trTime) / (double)this.T1Matrix[x][y])));
            }
        }
        super.calculate();
    }

    public void setTRTime(int tr) {
        this.trTime = tr;
    }

    public int getTRTime() {
        return this.trTime;
    }
}

