/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt.sequences;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import virtual.mrt.VMRTFrame;
import virtual.mrt.artefacts.Artefact;
import virtual.mrt.artefacts.ArtefactUI;
import virtual.mrt.sequences.Pulsesequence;
import virtual.tools.LabelTFLabelPanel;
import virtual.tools.ThreeLabelPanel;

public abstract class PulsesequenceUI {
    private static String MINUTE_UNIT = ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.minute.unit");
    private static String SECOND_UNIT = ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.second.unit");
    private static String PIXEL_UNIT = ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.pixelsize.unit");
    JButton pbStart = new JButton();
    JButton pbStop = new JButton();
    JCheckBox tbSettings = new JCheckBox();
    JLabel lCoil = new JLabel();
    JComboBox cbCoil = new JComboBox();
    LabelTFLabelPanel pMatrix = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.matrix.title"), "256", ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.matrix.unit"));
    LabelTFLabelPanel pFOV = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.fov.title"), "256", ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.fov.unit"));
    LabelTFLabelPanel pRect = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.rectfov.title"), "8", ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.rectfov.unit"));
    LabelTFLabelPanel pThickness = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.thickness.title"), "6", ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.thickness.unit"));
    LabelTFLabelPanel pNEX = new LabelTFLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.nex.title"), "1", "");
    JLabel lPhOS = new JLabel();
    JLabel lFreqOS = new JLabel();
    JCheckBox tbPhOS = new JCheckBox();
    JCheckBox tbFreqOS = new JCheckBox();
    ThreeLabelPanel pTotalTime = new ThreeLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.measurementtime.title"), "--", "");
    ThreeLabelPanel pRemainingTime = new ThreeLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.resttime.title"), "--", "");
    ThreeLabelPanel pPixelSize = new ThreeLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.pixelsize.title"), "--", "");
    ThreeLabelPanel pSNRatio = new ThreeLabelPanel(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.sn.title"), "--", "");
    protected JPanel myPanel;
    protected JPanel myInfoPanel;
    protected Artefact artefact;
    protected VMRTFrame mainFrame;
    protected Properties kSpaceManipulator = new Properties();
    private boolean isInitialized = false;
    protected Pulsesequence sequence;

    public void setSettingPanel(JPanel sequencePanel) {
        this.myPanel = sequencePanel;
        this.myPanel.setLayout(null);
    }

    public void setInfoPanel(JPanel sequenceInfoPanel) {
        this.myInfoPanel = sequenceInfoPanel;
    }

    public void setMainFrame(VMRTFrame vmrt) {
        this.mainFrame = vmrt;
    }

    public abstract void getValues();

    public abstract void setValues();

    public void fillPanel() {
        this.lCoil.setText(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.coil.title"));
        this.lCoil.setBounds(270, 7, 100, 20);
        this.myPanel.add(this.lCoil);
        this.cbCoil.setBounds(390, 7, 115, 20);
        if (!this.isInitialized) {
            this.cbCoil.addItem(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.coil.organ"));
            this.cbCoil.addItem(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.coil.body"));
        }
        this.myPanel.add(this.cbCoil);
        this.pMatrix.setBounds(270, 31, 220, 20);
        this.pMatrix.setRange(256, 256);
        this.pMatrix.getTextFieldReference().setEnabled(false);
        this.myPanel.add(this.pMatrix);
        this.pFOV.setBounds(270, 55, 220, 20);
        this.pFOV.setRange(32, 256);
        this.myPanel.add(this.pFOV);
        this.pRect.setBounds(270, 79, 220, 20);
        this.pRect.setRange(4, 8);
        this.myPanel.add(this.pRect);
        this.pThickness.setBounds(270, 103, 220, 20);
        this.pThickness.setRange(1, 20);
        this.myPanel.add(this.pThickness);
        this.pNEX.setBounds(270, 127, 220, 20);
        this.pNEX.setRange(1, 16);
        this.myPanel.add(this.pNEX);
        this.lPhOS.setBounds(270, 151, 220, 20);
        this.lPhOS.setText(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.oversampling.phase.title"));
        this.myPanel.add(this.lPhOS);
        this.tbPhOS.setBounds(390, 151, 55, 20);
        this.tbPhOS.setSelected(false);
        this.myPanel.add(this.tbPhOS);
        this.lFreqOS.setBounds(270, 175, 220, 20);
        this.lFreqOS.setText(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.label.oversampling.frequency.title"));
        this.myPanel.add(this.lFreqOS);
        this.tbFreqOS.setBounds(390, 175, 55, 20);
        this.tbFreqOS.setSelected(false);
        this.myPanel.add(this.tbFreqOS);
        this.tbSettings.setText(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.checkbox.parametert.title"));
        this.tbSettings.setBounds(new Rectangle(10, 7, 220, 20));
        if (this.myPanel.isShowing()) {
            this.tbSettings.setSelected(true);
        } else {
            this.tbSettings.setSelected(false);
        }
        this.pTotalTime.setBounds(10, 55, 220, 20);
        this.myInfoPanel.add(this.pTotalTime);
        this.pTotalTime.setValue("?? " + MINUTE_UNIT + " ?? " + SECOND_UNIT);
        this.pRemainingTime.setBounds(10, 79, 220, 20);
        this.myInfoPanel.add(this.pRemainingTime);
        this.displayRemainingTime(0L);
        this.pPixelSize.setBounds(10, 103, 220, 20);
        this.myInfoPanel.add(this.pPixelSize);
        this.displayPixelSize();
        this.pSNRatio.setBounds(10, 127, 220, 20);
        this.myInfoPanel.add(this.pSNRatio);
        this.pbStart.setText(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.btn.start.title"));
        this.pbStart.setBounds(new Rectangle(10, 185, 100, 25));
        this.pbStop.setText(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.btn.stop.title"));
        this.pbStop.setBounds(new Rectangle(125, 185, 100, 25));
        this.pbStop.setEnabled(false);
        if (!this.isInitialized) {
            this.pbStart.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PulsesequenceUI.this.pbStart_actionPerformed(e);
                }
            });
            this.pbStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PulsesequenceUI.this.pbStop_actionPerformed(e);
                }
            });
            this.tbSettings.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PulsesequenceUI.this.tbSettings_actionPerformed(e);
                }
            });
            this.tbPhOS.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PulsesequenceUI.this.updateTotalTime();
                    PulsesequenceUI.this.displaySNRatio();
                }
            });
            this.tbFreqOS.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PulsesequenceUI.this.displaySNRatio();
                }
            });
            this.pFOV.getTextFieldReference().addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    PulsesequenceUI.this.displayPixelSize();
                }
            });
            this.pRect.getTextFieldReference().addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    PulsesequenceUI.this.updateTotalTime();
                }
            });
            this.pThickness.getTextFieldReference().addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    PulsesequenceUI.this.displayPixelSize();
                }
            });
            this.pNEX.getTextFieldReference().addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    PulsesequenceUI.this.updateTotalTime();
                    PulsesequenceUI.this.displaySNRatio();
                }
            });
            this.isInitialized = true;
        }
        this.myInfoPanel.add((Component)this.tbSettings, null);
        this.myInfoPanel.add((Component)this.pbStart, null);
        this.myInfoPanel.add((Component)this.pbStop, null);
        this.displayPixelSize();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
    }

    public void enableStartButton(boolean flag) {
        this.pbStart.setEnabled(flag);
    }

    public void enableStopButton(boolean flag) {
        this.pbStop.setEnabled(flag);
    }

    void pbStart_actionPerformed(ActionEvent e) {
        this.pbStart.setEnabled(false);
        this.pbStop.setEnabled(true);
        this.mainFrame.setStatusBar(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.statusbar.note.calculation"));
        ArtefactUI aftUI = this.mainFrame.getSelectedArtefactUI();
        if (aftUI != null) {
            this.artefact = aftUI.createManipulator();
        }
    }

    void pbStop_actionPerformed(ActionEvent e) {
        this.pbStart.setEnabled(true);
        this.pbStop.setEnabled(false);
        this.pRemainingTime.setValue("0 " + MINUTE_UNIT + " 0 " + SECOND_UNIT);
        this.mainFrame.getProgressBar().setValue(0);
        this.mainFrame.setStatusBar(ResourceBundle.getBundle("virtual/mrt/sequences/resources/sequences_loc").getString("pulssequenceui.statusbar.note.aborted"));
    }

    void tbSettings_actionPerformed(ActionEvent e) {
        if (this.tbSettings.isSelected()) {
            this.myPanel.setVisible(true);
        } else {
            this.myPanel.setVisible(false);
        }
        this.mainFrame.repaint();
    }

    void displayTotalTime(long totaltime) {
        long ttimeS = totaltime / 1000L % 60L;
        long ttimeM = totaltime / 1000L / 60L;
        this.pTotalTime.setValue(ttimeM + " " + MINUTE_UNIT + " " + ttimeS + " " + SECOND_UNIT);
    }

    void updateTotalTime() {
    }

    void displayRemainingTime(long remainingtime) {
        long ttimeS = remainingtime / 1000L % 60L;
        long ttimeM = remainingtime / 1000L / 60L % 60L;
        this.pRemainingTime.setValue(ttimeM + " " + MINUTE_UNIT + " " + ttimeS + " " + SECOND_UNIT);
    }

    public int getCoil() {
        return this.cbCoil.getSelectedIndex();
    }

    public void displayPixelSize() {
        String ps = "";
        DecimalFormat form = new DecimalFormat("0.00");
        try {
            double size = (double)this.pFOV.getValue() / (double)this.pMatrix.getValue();
            ps = form.format(size);
            this.pPixelSize.setValue(ps + " " + PIXEL_UNIT);
            this.displaySNRatio();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void displaySNRatio() {
        double sn = this.getSNRatio();
        String snr = "";
        DecimalFormat form = new DecimalFormat("0.000");
        try {
            snr = form.format(sn);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pSNRatio.setValue(snr);
    }

    public double getSNRatio() {
        int ny = 256;
        double GYRO = 42.6;
        double GRAD = 10.0;
        double sn = 0.0;
        double factor = 3.44;
        try {
            int nex = this.pNEX.getValue();
            if (this.tbPhOS.isSelected()) {
                ny *= 2;
                if (nex > 1) {
                    nex /= 2;
                }
            }
            double fov = this.pFOV.getValue();
            double pixsize = fov / (double)this.pMatrix.getValue();
            double vol = Math.pow(pixsize, 2.0) * (double)this.pThickness.getValue();
            if (this.tbFreqOS.isSelected()) {
                fov *= 2.0;
            }
            double bw = GYRO * GRAD * fov;
            sn = 3.44 * vol * Math.sqrt((double)(ny * nex) / bw);
        }
        catch (Exception err) {
            // empty catch block
        }
        return sn;
    }

    public void addProperty(String className, String methodName) {
        this.kSpaceManipulator.put(className, methodName);
    }

    public String getProperty(String className) {
        return (String)this.kSpaceManipulator.get(className);
    }

    public String getArtefactMethod() {
        if (this.artefact != null) {
            String artName = this.artefact.getClass().getName();
            artName = artName.substring(artName.lastIndexOf(46) + 1, artName.length());
            return this.getProperty(artName);
        }
        return null;
    }

    public Artefact getArtefact() {
        return this.artefact;
    }
}

