/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import virtual.mrt.VMRTFrame;
import virtual.mrt.sequences.PulsesequenceUI;

public class SequenceCombo
extends JComboBox {
    ResourceBundle artefactsRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_artefacts");
    ResourceBundle sequencesRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_sequences");
    ResourceBundle frameRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_frame");
    private Vector sequenceClasses;
    private VMRTFrame mainFrame;
    private JPanel pSequenceSettingPanel;
    private JPanel pSequenceInfoPanel;
    private int oldindex;

    public SequenceCombo(VMRTFrame frame, JPanel seqSetPanel, JPanel seqInfoPanel) {
        this.mainFrame = frame;
        this.pSequenceSettingPanel = seqSetPanel;
        this.pSequenceInfoPanel = seqInfoPanel;
        this.sequenceClasses = new Vector(10, 5);
    }

    public void getSequences() {
        String[] kSpaceManipulators = new String[20];
        int inumManipulators = 0;
        int i = 0;
        for (i = 1; i <= 20; ++i) {
            try {
                String hlp = this.artefactsRsrc.getString("Manipulator_Class_" + i);
                hlp = hlp.replace('\"', ' ');
                kSpaceManipulators[i - 1] = hlp = hlp.trim();
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        inumManipulators = i;
        for (i = 1; i <= 20; ++i) {
            String s = "Sequence_Class_" + i;
            String w = null;
            String seqName = null;
            try {
                w = this.sequencesRsrc.getString(s);
                w = w.replace('\"', ' ');
                w = w.trim();
                try {
                    seqName = this.sequencesRsrc.getString("Sequence_Name_" + i);
                }
                catch (Exception e) {
                    seqName = w;
                }
                seqName = seqName.replace('\"', ' ');
                seqName = seqName.trim();
                String strSequenceUI = "virtual.mrt.sequences." + w + "UI";
                Object mySequence = null;
                Class<?> seq = null;
                try {
                    seq = Class.forName(strSequenceUI);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    mySequence = seq.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PulsesequenceUI sequence = mySequence;
                sequence.setMainFrame(this.mainFrame);
                sequence.setSettingPanel(this.pSequenceSettingPanel);
                sequence.setInfoPanel(this.pSequenceInfoPanel);
                String methodName = null;
                for (int x = 0; x < inumManipulators; ++x) {
                    try {
                        methodName = this.sequencesRsrc.getString(kSpaceManipulators[x] + "_" + i);
                    }
                    catch (Exception e) {
                        break;
                    }
                    methodName = methodName.replace('\"', ' ').trim();
                    sequence.addProperty(kSpaceManipulators[x], methodName);
                }
                this.mainFrame.repaint();
                this.sequenceClasses.addElement(sequence);
            }
            catch (Exception e) {
                break;
            }
            this.addItem(seqName);
        }
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SequenceCombo.this.cb_itemStateChanged(e);
            }
        });
        PulsesequenceUI seq = (PulsesequenceUI)this.sequenceClasses.firstElement();
        seq.fillPanel();
        this.oldindex = 0;
    }

    private void cb_itemStateChanged(ItemEvent e) {
        int index;
        PulsesequenceUI seq = (PulsesequenceUI)this.sequenceClasses.elementAt(this.oldindex);
        seq.setValues();
        this.pSequenceSettingPanel.removeAll();
        this.pSequenceSettingPanel.repaint();
        this.pSequenceInfoPanel.removeAll();
        this.pSequenceInfoPanel.repaint();
        this.oldindex = index = this.getSelectedIndex();
        seq = (PulsesequenceUI)this.sequenceClasses.elementAt(index);
        seq.fillPanel();
        seq.getValues();
        this.mainFrame.setStatusBar(this.frameRsrc.getString("statusbar.note.start"));
        this.mainFrame.setStatusBar(this.mainFrame.getStatusText() + " ");
    }
}

