/*
 * Decompiled with CFR 0.152.
 */
package virtual.mrt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import virtual.mrt.VMRTFrame;
import virtual.tools.DcmImage;
import virtual.tools.ImagePanel;
import virtual.tools.ImagePlus;
import virtual.tools.ImageStack;

public class MRTPanel
extends ImagePanel {
    ResourceBundle frameRsrc = PropertyResourceBundle.getBundle("virtual/mrt/resources/vmrt_frame");
    private int iNumImages = 1;
    private int iActiveImage = -1;
    private ImageStack is;
    VMRTFrame myVMRTFrame;

    public MRTPanel() {
    }

    public MRTPanel(VMRTFrame backReference) {
        this.myVMRTFrame = backReference;
        this.is = new ImageStack();
    }

    public void setOneImage() {
        this.iNumImages = 1;
        this.updateScrollbar();
    }

    public void setFourImages() {
        this.iNumImages = 4;
        this.updateScrollbar();
    }

    public void updateScrollbar() {
        int num = this.is.getStackSize();
        if (this.myVMRTFrame.rb1Image.isSelected()) {
            this.myVMRTFrame.sbVerScrollbar.setMinimum(0);
            this.myVMRTFrame.sbVerScrollbar.setMaximum(num * 512 + 512);
            this.myVMRTFrame.sbVerScrollbar.setBlockIncrement(512);
            this.myVMRTFrame.sbVerScrollbar.setUnitIncrement(512);
            this.myVMRTFrame.sbVerScrollbar.setVisibleAmount(511);
        } else {
            int max = 512;
            if (num > 0) {
                max = num / 2 * 256 + 256;
            }
            this.myVMRTFrame.sbVerScrollbar.setMinimum(0);
            this.myVMRTFrame.sbVerScrollbar.setMaximum(max);
            this.myVMRTFrame.sbVerScrollbar.setBlockIncrement(512);
            this.myVMRTFrame.sbVerScrollbar.setUnitIncrement(256);
            this.myVMRTFrame.sbVerScrollbar.setVisibleAmount(511);
        }
    }

    private int getSBOffset() {
        int off = 0;
        off = this.iNumImages == 4 ? this.myVMRTFrame.sbVerScrollbar.getValue() / 256 : this.myVMRTFrame.sbVerScrollbar.getValue() / 512;
        return off;
    }

    public int getNumImages() {
        return this.iNumImages;
    }

    public void setActiveImage(int activeImage) {
        this.iActiveImage = activeImage;
    }

    public int getActiveImage() {
        return this.iActiveImage;
    }

    public ImageStack getImageStack() {
        return this.is;
    }

    public ImagePlus createNewImage(DcmImage dcmimg) {
        if (this.is == null) {
            this.is = new ImageStack();
        }
        this.iActiveImage = this.iActiveImage == -1 ? 1 : this.iActiveImage;
        int pos = 0;
        if (this.myVMRTFrame.rbNextImageAtSelection.isSelected()) {
            pos = this.iActiveImage;
        } else {
            pos = this.is.getNextFreePosition();
            if (pos == 0) {
                ++pos;
            }
        }
        ImagePlus ip = this.is.createPictureAtPos(pos, dcmimg);
        this.updateScrollbar();
        if (this.myVMRTFrame.chbActivateNewImg.isSelected()) {
            this.setActiveImage(pos);
            if (this.iNumImages == 4) {
                this.myVMRTFrame.sbVerScrollbar.setValue((pos - 1) / 2 * 256);
            } else {
                this.myVMRTFrame.sbVerScrollbar.setValue((pos - 1) * 512);
            }
        }
        return ip;
    }

    public int createNewImage(ImagePlus myip) {
        if (this.is == null) {
            this.is = new ImageStack();
        }
        this.iActiveImage = this.iActiveImage == -1 ? 1 : this.iActiveImage;
        int pos = 0;
        if (this.myVMRTFrame.rbNextImageAtSelection.isSelected()) {
            pos = this.iActiveImage;
        } else {
            pos = this.is.getNextFreePosition();
            if (pos == 0) {
                ++pos;
            }
        }
        this.is.setPictureAtPos(pos, myip);
        this.updateScrollbar();
        if (this.myVMRTFrame.chbActivateNewImg.isSelected()) {
            this.setActiveImage(pos);
            if (this.iNumImages == 4) {
                this.myVMRTFrame.sbVerScrollbar.setValue((pos - 1) / 2 * 256);
            } else {
                this.myVMRTFrame.sbVerScrollbar.setValue((pos - 1) * 512);
            }
        }
        return pos;
    }

    public void paint(Graphics g) {
        block34: {
            String[] commentsSE;
            int stringWidth;
            String[] commentsNE;
            String[] commentsSW;
            int j;
            ImagePlus ip;
            block35: {
                int off;
                g.clearRect(0, 0, 511, 511);
                ip = null;
                if (this.iNumImages == 4) {
                    off = this.getSBOffset();
                    for (int i = 0; i < 4; ++i) {
                        ip = this.is.getPictureAtPos(2 * off + i + 1);
                        if (ip == null) continue;
                        g.drawImage(ip.getAWTImage(), i % 2 * 256, i / 2 * 256, 256, 256, this);
                    }
                } else {
                    off = this.getSBOffset();
                    ip = this.is.getPictureAtPos(off + 1);
                    if (ip != null) {
                        g.drawImage(ip.getAWTImage(), 0, 0, 512, 512, this);
                    }
                }
                g.setColor(Color.white);
                g.drawRect(0, 0, 511, 511);
                switch (this.iNumImages) {
                    case 4: {
                        g.drawLine(255, 0, 255, 511);
                        g.drawLine(0, 255, 511, 255);
                        break;
                    }
                }
                g.setColor(Color.red);
                if (this.iActiveImage != -1) {
                    if (this.iNumImages == 1) {
                        off = this.getSBOffset();
                        if (this.iActiveImage == off + 1) {
                            g.drawRect(0, 0, 511, 511);
                        }
                    } else {
                        off = this.getSBOffset();
                        if (this.iActiveImage > off * 2 && this.iActiveImage <= off * 2 + 4) {
                            int num = this.iActiveImage - off * 2;
                            int startx = 0;
                            int starty = 0;
                            switch (num) {
                                case 1: {
                                    startx = 0;
                                    starty = 0;
                                    break;
                                }
                                case 3: {
                                    startx = 0;
                                    starty = 255;
                                    break;
                                }
                                case 2: {
                                    startx = 255;
                                    starty = 0;
                                    break;
                                }
                                case 4: {
                                    startx = 255;
                                    starty = 255;
                                }
                            }
                            g.drawRect(startx, starty, 255, 255);
                        }
                    }
                }
                g.setColor(Color.green);
                if (!this.myVMRTFrame.tbImageText.isSelected()) break block34;
                if (this.iNumImages != 4) break block35;
                g.setFont(new Font("Arial", 0, 10));
                FontMetrics myFontMetrics = g.getFontMetrics();
                int lHeight = myFontMetrics.getHeight();
                int lSpacing = 0;
                int margin = 5;
                for (int i = 0; i < 4; ++i) {
                    String[] commentsSE2;
                    int stringWidth2;
                    String[] commentsNE2;
                    String[] commentsSW2;
                    int j2;
                    int off2 = this.getSBOffset();
                    ip = this.is.getPictureAtPos(2 * off2 + 1 + i);
                    if (ip == null) continue;
                    String[] commentsNW = ip.getTextNW();
                    g.drawString(this.frameRsrc.getString("mrtpanel.text.nw.image") + " " + (off2 + 1), margin, lHeight + lSpacing);
                    if (commentsNW != null) {
                        for (j2 = 0; j2 < commentsNW.length; ++j2) {
                            g.drawString(commentsNW[j2], i % 2 * 256 + margin, i / 2 * 256 + (lHeight + lSpacing) * (j2 + 2));
                        }
                    }
                    if ((commentsSW2 = ip.getTextSW()) != null) {
                        for (j2 = commentsSW2.length - 1; j2 >= 0; --j2) {
                            g.drawString(commentsSW2[j2], i % 2 * 256 + margin, i / 2 * 256 + 256 - margin - (lHeight + lSpacing) * j2);
                        }
                    }
                    if ((commentsNE2 = ip.getTextNE()) != null) {
                        for (j2 = 0; j2 < commentsNE2.length; ++j2) {
                            stringWidth2 = (int)myFontMetrics.getStringBounds(commentsNE2[j2], g).getWidth();
                            g.drawString(commentsNE2[j2], i % 2 * 256 + 256 - margin - stringWidth2, i / 2 * 256 + (lHeight + lSpacing) * (j2 + 1));
                        }
                    }
                    if ((commentsSE2 = ip.getTextSE()) == null) continue;
                    for (j2 = commentsSE2.length - 1; j2 >= 0; --j2) {
                        stringWidth2 = (int)myFontMetrics.getStringBounds(commentsSE2[j2], g).getWidth();
                        g.drawString(commentsSE2[j2], i % 2 * 256 + 256 - margin - stringWidth2, i / 2 * 256 + 256 - margin - (lHeight + lSpacing) * j2);
                    }
                }
                break block34;
            }
            g.setFont(new Font("Arial", 0, 12));
            FontMetrics myFontMetrics = g.getFontMetrics();
            int lHeight = myFontMetrics.getHeight();
            int lSpacing = 1;
            int margin = 5;
            int off = this.getSBOffset();
            ip = this.is.getPictureAtPos(off + 1);
            if (ip == null) break block34;
            String[] commentsNW = ip.getTextNW();
            g.drawString(this.frameRsrc.getString("mrtpanel.text.nw.image") + " " + (off + 1), margin, lHeight + lSpacing);
            if (commentsNW != null) {
                for (j = 0; j < commentsNW.length; ++j) {
                    g.drawString(commentsNW[j], margin, (lHeight + lSpacing) * (j + 2));
                }
            }
            if ((commentsSW = ip.getTextSW()) != null) {
                for (j = commentsSW.length - 1; j >= 0; --j) {
                    g.drawString(commentsSW[j], margin, 512 - margin - (lHeight + lSpacing) * j);
                }
            }
            if ((commentsNE = ip.getTextNE()) != null) {
                for (j = 0; j < commentsNE.length; ++j) {
                    stringWidth = (int)myFontMetrics.getStringBounds(commentsNE[j], g).getWidth();
                    g.drawString(commentsNE[j], 512 - margin - stringWidth, (lHeight + lSpacing) * (j + 1));
                }
            }
            if ((commentsSE = ip.getTextSE()) != null) {
                for (j = commentsSE.length - 1; j >= 0; --j) {
                    stringWidth = (int)myFontMetrics.getStringBounds(commentsSE[j], g).getWidth();
                    g.drawString(commentsSE[j], 512 - margin - stringWidth, 512 - margin - (lHeight + lSpacing) * j);
                }
            }
        }
    }
}

