/*
 * Decompiled with CFR 0.152.
 */
package virtual.dv;

import rad.dicom.dcm.DcmDataObject;
import rad.dicom.ima.SecondaryCaptureIOD;

public class ViewerReferenceSeries {
    private short[] pixel16Background;
    private int nRows;
    private int nColumns;
    private int bits;

    public ViewerReferenceSeries(int nRow, int nCol, int b) {
        this.nRows = nRow;
        this.nColumns = nCol;
        this.bits = b;
        this.pixel16Background = new short[this.nRows * this.nColumns];
        this.fillRect(0, 0, 256, 2, 1500, this.pixel16Background);
        this.fillRect(0, 254, 256, 2, 1500, this.pixel16Background);
        this.fillRect(0, 0, 2, 256, 1500, this.pixel16Background);
        this.fillRect(254, 0, 2, 256, 1500, this.pixel16Background);
        for (int r = 0; r < this.nRows; ++r) {
            int c;
            for (c = 230; c < 240; ++c) {
                this.pixel16Background[r * this.nColumns + c] = (short)(255 - r);
            }
            for (c = 242; c < 252; ++c) {
                this.pixel16Background[r * this.nColumns + c] = (short)(4095 - r * 16);
            }
        }
        this.fillRect(8, 8, 104, 104, 4095, this.pixel16Background);
        this.fillRect(120, 8, 104, 104, 1250, this.pixel16Background);
        this.createStripes(8, 120, 4095, this.pixel16Background);
        this.createStripes(8, 216, 4095, this.pixel16Background);
        this.createStripes(192, 120, 4095, this.pixel16Background);
        this.createStripes(192, 216, 4095, this.pixel16Background);
        this.fillRect(64, 132, 48, 48, 1952, this.pixel16Background);
        this.fillRect(120, 132, 48, 48, 2016, this.pixel16Background);
        this.fillRect(64, 188, 48, 48, 2080, this.pixel16Background);
        this.fillRect(120, 188, 48, 48, 2144, this.pixel16Background);
        this.fillRect(76, 144, 24, 24, 1968, this.pixel16Background);
        this.fillRect(132, 200, 24, 24, 2096, this.pixel16Background);
    }

    public short[] getImage(int zPosition) {
        short[] pixel16 = (short[])this.pixel16Background.clone();
        this.fillRect(10 + zPosition / 4 * 3, 8, 6, 104, 0, pixel16);
        this.fillRect(60, 104 - zPosition / 4 * 3, 52, 6, 0, pixel16);
        this.fillRect(148 + zPosition / 4 * 3, 36 + zPosition / 4 * 3, 4, 4, 4095, pixel16);
        this.fillRect(196 - zPosition / 4 * 3, 36 + zPosition / 4 * 3, 4, 4, 4095, pixel16);
        return pixel16;
    }

    public DcmDataObject getDDO(int zPosition, int imaNumber) {
        SecondaryCaptureIOD scIOD = new SecondaryCaptureIOD();
        scIOD.imageNumber = String.valueOf(imaNumber);
        scIOD.set16UBitGrayImage(this.getImage(zPosition), this.nRows, this.nColumns, this.bits);
        scIOD.setVOILUTModule((int)Math.pow(2.0, this.bits - 1), (int)Math.pow(2.0, this.bits));
        DcmDataObject ddo = scIOD.getDDO(1, 8, 64);
        String zPositionStr = Double.toString(zPosition);
        ddo.setString(486, "2.0\\2.0");
        ddo.setString(456, "1\\0\\0\\0\\1\\0");
        ddo.setString(455, Double.toString(2.0 * (double)this.nColumns) + "\\" + Double.toString(2.0 * (double)this.nRows) + "\\" + zPositionStr);
        ddo.setString(162, "4.0");
        ddo.setString(467, zPositionStr);
        return ddo;
    }

    private void createStripes(int x, int y, int val, short[] pix) {
        int ix;
        int iy;
        int iy2;
        short sv;
        int ix2;
        for (ix2 = x; ix2 < x + 16; ++ix2) {
            sv = ix2 % 2 >= 1 ? (short)val : (short)0;
            for (iy2 = y; iy2 < y + 16; ++iy2) {
                pix[iy2 * this.nColumns + ix2] = sv;
            }
        }
        for (iy = y; iy < y + 16; ++iy) {
            sv = iy % 2 >= 1 ? (short)val : (short)0;
            for (ix = x + 16; ix < x + 32; ++ix) {
                pix[iy * this.nColumns + ix] = sv;
            }
        }
        for (iy = y + 16; iy < y + 32; iy += 2) {
            sv = iy % 4 >= 2 ? (short)val : (short)0;
            for (ix = x; ix < x + 16; ++ix) {
                pix[iy * this.nColumns + ix] = sv;
                pix[(iy + 1) * this.nColumns + ix] = sv;
            }
        }
        for (ix2 = x + 16; ix2 < x + 32; ix2 += 2) {
            sv = ix2 % 4 >= 2 ? (short)val : (short)0;
            for (iy2 = y + 16; iy2 < y + 32; ++iy2) {
                pix[iy2 * this.nColumns + ix2] = sv;
                pix[iy2 * this.nColumns + ix2 + 1] = sv;
            }
        }
    }

    private void fillRect(int x, int y, int w, int h, int val, short[] pix) {
        short sv = (short)val;
        for (int ix = x; ix < x + w; ++ix) {
            for (int iy = y; iy < y + h; ++iy) {
                pix[iy * this.nColumns + ix] = sv;
            }
        }
    }
}

